/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.bali.ewt.worker.AbstractWorker;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.Worker;
import oracle.bali.share.collection.CompoundEnumeration;

public abstract class DelegatingWorker
extends AbstractWorker {
    private Worker _delegatedWorker = null;
    private transient PropertyResender _propertyResender = null;
    private static final Object _NULL_OBJECT = new Object();

    protected DelegatingWorker() {
    }

    public Object getValue(Object object) {
        Object object2 = super.getValue(object);
        if (object2 != null) {
            return this._fixObject(object2);
        }
        if (this._delegatedWorker != null) {
            return this._delegatedWorker.getValue(object);
        }
        return null;
    }

    public Object putValue(Object object, Object object2) {
        if (object2 == null) {
            object2 = _NULL_OBJECT;
        }
        return this._fixObject(super.putValue(object, object2));
    }

    public Enumeration getValueKeys() {
        Enumeration enumeration = super.getValueKeys();
        if (this._delegatedWorker != null) {
            enumeration = new CompoundEnumeration(this._delegatedWorker.getValueKeys(), enumeration);
        }
        return enumeration;
    }

    public Object getDefaultParameterValue(Object object) {
        Object object2 = super.getDefaultParameterValue(object);
        if (this._delegatedWorker != null && object2 == InvocationContext.UNDEFINED) {
            object2 = this._delegatedWorker.getDefaultParameterValue(object);
        }
        return object2;
    }

    public boolean isEnabled() {
        boolean bl = false;
        if (this._delegatedWorker != null) {
            bl = this._delegatedWorker.isEnabled();
        }
        return bl && super.isEnabled();
    }

    protected Object runWorker(InvocationContext invocationContext) throws Throwable {
        if (this._delegatedWorker != null) {
            return this._delegatedWorker.run(invocationContext);
        }
        return null;
    }

    protected void firePropertyChange(Object object, Object object2, Object object3) {
        super.firePropertyChange(object, this._fixObject(object2), this._fixObject(object3));
    }

    protected final Worker getDelegatedWorker() {
        return this._delegatedWorker;
    }

    protected final void setDelegatedWorker(Worker worker) {
        boolean bl = this.isEnabled();
        Worker worker2 = this._delegatedWorker;
        if (this._propertyResender == null) {
            this._propertyResender = new PropertyResender();
        }
        DelegatingWorker delegatingWorker = this;
        synchronized (delegatingWorker) {
            if (worker2 != worker) {
                if (worker2 != null) {
                    worker2.removePropertyChangeListener(this._propertyResender);
                }
                if (worker != null) {
                    worker.addPropertyChangeListener(this._propertyResender);
                }
                this._delegatedWorker = worker;
            }
        }
        this._fireChangeEvents(worker2, worker);
        this.fireEnabledPropertyChange(bl);
    }

    private void _fireChangeEvents(Worker worker, Worker worker2) {
        Object object;
        Enumeration<Object> enumeration;
        Enumeration enumeration2 = worker2 != null ? worker2.getValueKeys() : null;
        Hashtable<Enumeration<Object>, Object> hashtable = new Hashtable<Enumeration<Object>, Object>();
        if (enumeration2 != null) {
            while (enumeration2.hasMoreElements()) {
                enumeration = enumeration2.nextElement();
                hashtable.put(enumeration, worker2.getValue(enumeration));
            }
        }
        if (worker != null && (enumeration = worker.getValueKeys()) != null) {
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (super.getValue(object) != null) continue;
                Object v = hashtable.remove(object);
                this.firePropertyChange(object, worker.getValue(object), v);
            }
        }
        if ((enumeration = hashtable.keys()) != null) {
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (super.getValue(object) != null) continue;
                this.firePropertyChange(object, null, hashtable.get(object));
            }
        }
    }

    private Object _fixObject(Object object) {
        if (object == _NULL_OBJECT) {
            return null;
        }
        return object;
    }

    private Object _getValueFromSuperclass(String string) {
        return super.getValue(string);
    }

    private class PropertyResender
    implements PropertyChangeListener {
        private PropertyResender() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (DelegatingWorker.this._getValueFromSuperclass(string) == null) {
                DelegatingWorker.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }
}

