/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.text;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import oracle.bali.ewt.graphics.FontUtils;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.ewt.text.LabelGeometry;
import oracle.bali.ewt.text.LineInfo;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.ewt.text.NoWrapper;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.LocaleUtils;

public class MultiLineLabel
extends ScrollableComponent
implements Accessible {
    public static final int NOT_SET = -1;
    public static final int ALIGNMENT_DEFAULT = 0;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_CENTER = 3;
    public static final String PROPERTY_TEXT = "text";
    public static final float ASPECTRATIO_NONE = 0.0f;
    private boolean _useFullJustification;
    private float _preferredAspectRatio;
    private LabelGeometry _geometry;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private int _preferredRows = -1;
    private int _preferredColumns = -1;
    private boolean _foregroundDefaulted = true;
    private int _maximumColumns = -1;
    private int _maximumRows = -1;
    private int _minimumColumns = -1;
    private int _minimumRows = -1;
    private Dimension _originalPreferredSize;
    private Dimension _currentPreferredSize;
    private boolean _isVerticalShrinking = true;
    private boolean _forceFit;
    private static final String _ELLIPSIS = "...";

    public MultiLineLabel() {
        this("");
    }

    public MultiLineLabel(String string) {
        this(NoWrapper.getTextWrapper(), string);
    }

    public MultiLineLabel(TextWrapper textWrapper, String string) {
        if (string == null) {
            string = "";
        }
        if (textWrapper == null) {
            textWrapper = NoWrapper.getTextWrapper();
        }
        this._geometry = new LabelGeometry(this, textWrapper, string);
        this._preferredAspectRatio = 4.0f;
        this.setOpaque(false);
        this.updateUI();
    }

    public void setText(String string) {
        String string2;
        String string3;
        if (string == null) {
            string = "";
        }
        String string4 = null;
        if (this.accessibleContext != null) {
            string4 = this.accessibleContext.getAccessibleName();
        }
        if (string != (string3 = this.getText())) {
            this._originalPreferredSize = null;
        }
        this._geometry._setText(string);
        this.firePropertyChange(PROPERTY_TEXT, string3, string);
        if (this.accessibleContext != null && (string2 = this.accessibleContext.getAccessibleName()) != string4) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string4, string2);
        }
    }

    public String getText() {
        return this._geometry._getText();
    }

    public void setTextWrapper(TextWrapper textWrapper) {
        if (textWrapper == null) {
            textWrapper = NoWrapper.getTextWrapper();
        }
        if (textWrapper != this.getTextWrapper()) {
            this._originalPreferredSize = null;
        }
        this._geometry._setTextWrapper(textWrapper);
        this.repaint();
    }

    public TextWrapper getTextWrapper() {
        return this._geometry._getTextWrapper();
    }

    public int getMaximumColumns() {
        return this._maximumColumns;
    }

    public void setMaximumColumns(int n) {
        if (n != this._maximumColumns) {
            this._maximumColumns = n;
            this.invalidateCanvas();
        }
    }

    public int getMaximumRows() {
        return this._maximumRows;
    }

    public void setMaximumRows(int n) {
        if (n != this._maximumRows) {
            this._maximumRows = n;
            this.invalidateCanvas();
        }
    }

    public Dimension getMaximumSize() {
        return this._computeSize(super.getMaximumSize(), this._maximumRows, this._maximumColumns);
    }

    public void setMaximumSize(Dimension dimension) {
        if (dimension != null) {
            this._maximumRows = -1;
            this._maximumColumns = -1;
        }
        super.setMaximumSize(dimension);
    }

    public int getMinimumColumns() {
        return this._minimumColumns;
    }

    public void setMinimumColumns(int n) {
        if (n != this._minimumColumns) {
            this._minimumColumns = n;
            this.invalidateCanvas();
        }
    }

    public void setMinimumSize(Dimension dimension) {
        if (dimension != null) {
            this._minimumRows = -1;
            this._minimumColumns = -1;
        }
        super.setMinimumSize(dimension);
    }

    public int getMinimumRows() {
        return this._minimumRows;
    }

    public void setMinimumRows(int n) {
        if (n != this._minimumRows) {
            this._minimumRows = n;
            this.invalidateCanvas();
        }
    }

    public void setPreferredColumns(int n) {
        if (n == this._preferredColumns) {
            return;
        }
        this._preferredColumns = n;
        this._originalPreferredSize = null;
        this.invalidateMultiLineLabelCanvas();
    }

    public int getPreferredColumns() {
        return this._preferredColumns;
    }

    public void setPreferredRows(int n) {
        if (n == this._preferredRows) {
            return;
        }
        this._preferredRows = n;
        this._originalPreferredSize = null;
        this.invalidateMultiLineLabelCanvas();
    }

    public int getPreferredRows() {
        return this._preferredRows;
    }

    public void setFullJustification(boolean bl) {
        if (this._useFullJustification != bl) {
            this._useFullJustification = bl;
            this.repaint();
        }
    }

    public boolean isFullyJustified() {
        return this._useFullJustification;
    }

    public void setPreferredAspectRatio(float f) {
        if (this._preferredAspectRatio != f) {
            this._preferredAspectRatio = f;
            this._originalPreferredSize = null;
            this.invalidateMultiLineLabelCanvas();
        }
    }

    public float getPreferredAspectRatio() {
        return this._preferredAspectRatio;
    }

    public void setVerticalShrinking(boolean bl) {
        if (this._isVerticalShrinking != bl) {
            this._isVerticalShrinking = bl;
            this.invalidateMultiLineLabelCanvas();
        }
    }

    public boolean isVerticalShrinking() {
        return this._isVerticalShrinking;
    }

    public void setForceWrapping(boolean bl) {
        if (bl != this._forceFit) {
            this._forceFit = bl;
            this._originalPreferredSize = null;
            this.invalidateMultiLineLabelCanvas();
        }
    }

    public boolean isForceWrapping() {
        return this._forceFit;
    }

    public Color getForeground() {
        if (this._foregroundDefaulted) {
            return this.getPaintContext().getPaintUIDefaults().getColor("Label.foreground");
        }
        return super.getForeground();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this._foregroundDefaulted = false;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._originalPreferredSize = null;
        this._geometry._setFontMetrics(((Component)this).getFontMetrics(this.getFont()));
    }

    public void setLocale(Locale locale) {
        if (locale != LocaleUtils.getDefaultableLocale(this)) {
            super.setLocale(locale);
            this.invalidate();
        }
    }

    public JToolTip createToolTip() {
        return new MultiLineToolTip();
    }

    public void updateUI() {
        super.updateUI();
        boolean bl = this._foregroundDefaulted;
        LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
        this._foregroundDefaulted = bl;
    }

    public void doLayout() {
        this._geometry._validate();
        super.doLayout();
    }

    public boolean isHScrollable() {
        return true;
    }

    public boolean isVScrollable() {
        return true;
    }

    protected int getVMaximum() {
        return this._geometry.getLineCount();
    }

    protected int getVOffsetOfValue(int n) {
        return -this._geometry.getFontMetrics().getHeight() * n;
    }

    protected int getVValueOfOffset(int n) {
        return -n / this._geometry.getFontMetrics().getHeight();
    }

    protected Dimension layoutCanvas() {
        if (this.getViewport() != null) {
            FontMetrics fontMetrics = this._geometry.getFontMetrics();
            int n = 0;
            if (fontMetrics != null) {
                n = this._geometry.getLineCount() * fontMetrics.getHeight();
            }
            return new Dimension(Math.max(this.getInnerWidth(), this._geometry.getMaxPixelWidth()), n);
        }
        return new Dimension(this._getPreferredInnerSize());
    }

    public void addNotify() {
        super.addNotify();
        this._originalPreferredSize = null;
        this._geometry._setFontMetrics(((Component)this).getFontMetrics(this.getFont()));
    }

    protected void paintCanvasInterior(Graphics graphics) {
        this._setWrapWidthOnGeometry();
        if (!this.isEnabled()) {
            UIDefaults uIDefaults = this.getUIDefaults();
            graphics.setColor(uIDefaults.getColor("controlLtHighlight"));
            graphics.translate(1, 1);
            this._paintCanvasInterior(graphics);
            graphics.setColor(uIDefaults.getColor("controlInactiveText"));
            graphics.translate(-1, -1);
        }
        this._paintCanvasInterior(graphics);
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this._getPreferredInnerSize();
        dimension = this.convertInnerToOuterSize(dimension.width, dimension.height);
        return dimension;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (!(this.getTextWrapper() instanceof NoWrapper)) {
            return true;
        }
        return super.getScrollableTracksViewportWidth();
    }

    public Dimension getMinimumSize() {
        if (!this.isMinimumSizeSet() && this._minimumRows == -1 && this._minimumColumns == -1) {
            return this.getPreferredSize();
        }
        return this._computeSize(super.getMinimumSize(), this._minimumRows, this._minimumColumns);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultiLineLabel();
        }
        return this.accessibleContext;
    }

    void invalidateMultiLineLabelCanvas() {
        this._currentPreferredSize = null;
        this.invalidateCanvas();
    }

    private Dimension _computeSize(Dimension dimension, int n, int n2) {
        if (n != -1 || n2 != -1) {
            dimension = new Dimension(dimension);
            ImmInsets immInsets = this.getBorderInsets();
            FontMetrics fontMetrics = this._geometry.getFontMetrics();
            if (fontMetrics != null) {
                if (n != -1) {
                    dimension.height = fontMetrics.getHeight() * n + (immInsets.top + immInsets.bottom);
                }
                if (n2 != -1) {
                    dimension.width = FontUtils.getAverageWidth(this.getFont()) * n2 + (immInsets.left + immInsets.right);
                }
            }
        }
        return dimension;
    }

    private void _paintCanvasInterior(Graphics graphics) {
        LabelGeometry labelGeometry = this._geometry;
        FontMetrics fontMetrics = labelGeometry.getFontMetrics();
        int n = fontMetrics.getHeight();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        int n2 = rectangle.y / n;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2 * n + fontMetrics.getAscent() + fontMetrics.getLeading();
        int n4 = labelGeometry.getLineCount();
        int n5 = labelGeometry.getWrapWidth();
        int n6 = rectangle.y + rectangle.height;
        int n7 = this.getActualAlignment();
        LineInfo lineInfo = new LineInfo();
        int n8 = fontMetrics.getDescent();
        ImmInsets immInsets = this.getBorderInsets();
        int n9 = this.getHeight();
        n9 = Math.max(0, n9 - (immInsets.top + immInsets.bottom));
        int n10 = this.getWidth();
        n10 = Math.max(0, n10 - (immInsets.left + immInsets.right));
        while (n2 < n4) {
            int n11;
            if (n3 + n8 > n9 && n2 != 0) break;
            if ((lineInfo = labelGeometry.getLineInfo(n2, lineInfo)) == null) {
                return;
            }
            String string = lineInfo.text;
            if (n3 + n8 + n > n9 && n2 != n4 - 1 || lineInfo.pixelWidth > n10) {
                if (string == null) {
                    string = "";
                }
                if ((n11 = lineInfo.pixelWidth + fontMetrics.stringWidth(_ELLIPSIS) - n5) > 0) {
                    if (lineInfo.pixelWidth > n11) {
                        int n12 = string.length() - 1;
                        while (n12 >= 0 && n11 > 0) {
                            n11 -= fontMetrics.charWidth(string.charAt(n12));
                            --n12;
                        }
                        string = string.substring(0, n12 + 1) + _ELLIPSIS;
                    } else {
                        string = _ELLIPSIS;
                    }
                } else {
                    string = string + _ELLIPSIS;
                }
                lineInfo.text = string;
                lineInfo.pixelWidth = fontMetrics.stringWidth(string);
            }
            if (string != null) {
                if (this._useFullJustification && !lineInfo.isNotWrapped) {
                    this._paintFullJustified(graphics, 0, n3, lineInfo);
                } else {
                    n11 = 0;
                    if (n7 != 1) {
                        n11 = n5 - lineInfo.pixelWidth;
                        if (n7 == 3) {
                            n11 >>= 1;
                        }
                    }
                    GraphicUtils.drawString(graphics, string, n11, n3);
                }
            }
            if (n3 > n6) break;
            n3 += n;
            ++n2;
        }
    }

    private void _setWrapWidthOnGeometry() {
        boolean bl = this.getPreferredRows() == -1 && this.getPreferredColumns() == -1 && this.getPreferredAspectRatio() == 0.0f ? true : this.isVerticalShrinking();
        int n = bl ? this.getInnerWidth() : Math.min(this.getInnerWidth(), this._getOriginalPreferredSize().width);
        this._geometry._setWrapWidth(n);
    }

    private Dimension _getOriginalPreferredSize() {
        if (this._originalPreferredSize == null) {
            FontMetrics fontMetrics;
            Dimension dimension = new Dimension(0, 0);
            Font font = this.getFont();
            FontMetrics fontMetrics2 = fontMetrics = font == null ? null : ((Component)this).getFontMetrics(font);
            if (fontMetrics != null) {
                int n;
                int n2 = fontMetrics.stringWidth(this.getText());
                int n3 = fontMetrics.getHeight();
                int n4 = 0;
                int n5 = FontUtils.getAverageWidth(fontMetrics);
                int n6 = this._preferredColumns;
                if (n6 == -1 && this._preferredRows == -1) {
                    float f = this.getPreferredAspectRatio();
                    n = this.getInnerWidth();
                    if (f == 0.0f && n == 0) {
                        f = 4.0f;
                    }
                    n4 = f != 0.0f ? (int)Math.sqrt((float)n2 * (float)n3 * f) + 1 : n;
                } else {
                    if (n6 != -1) {
                        n4 = n5 * n6;
                    }
                    if (this._preferredRows != -1) {
                        dimension.height = this._preferredRows * n3;
                        if (n6 == -1) {
                            int n7 = 0;
                            n = 0;
                            while ((n = this.getText().indexOf(10, n) + 1) > 0) {
                                ++n7;
                            }
                            if (n7 + 1 >= this._preferredRows) {
                                n6 = n4 = Integer.MAX_VALUE;
                            } else {
                                n4 = n2 / this._preferredRows * 21 / 20;
                            }
                        }
                    }
                }
                boolean bl = false;
                do {
                    LabelGeometry labelGeometry = new LabelGeometry(this, this.getTextWrapper(), this.getText(), fontMetrics, n4, true);
                    dimension.width = labelGeometry.getMaxPixelWidth();
                    n = labelGeometry.getLineCount();
                    if (n6 != -1 || this._preferredRows == -1) break;
                    if (this._preferredRows < n) {
                        n4 += n5;
                        bl = true;
                        continue;
                    }
                    if (this._preferredRows <= n || bl) break;
                    n4 -= n5;
                } while (n4 > 0);
                dimension.height = Math.max(dimension.height, n * n3);
            }
            this._originalPreferredSize = dimension;
        }
        return this._originalPreferredSize;
    }

    private Dimension _getPreferredInnerSize() {
        if (this._currentPreferredSize == null) {
            boolean bl;
            FontMetrics fontMetrics;
            Dimension dimension = new Dimension(0, 0);
            boolean bl2 = this._originalPreferredSize == null;
            Dimension dimension2 = this._getOriginalPreferredSize();
            int n = this.getInnerWidth();
            Font font = this.getFont();
            FontMetrics fontMetrics2 = fontMetrics = font == null ? null : ((Component)this).getFontMetrics(font);
            boolean bl3 = bl2 ? false : (bl = this.getPreferredRows() == -1 && this.getPreferredColumns() == -1 && this.getPreferredAspectRatio() == 0.0f || n > dimension2.width && this.isVerticalShrinking());
            if (bl && fontMetrics != null && n != 0) {
                LabelGeometry labelGeometry = new LabelGeometry(this, this.getTextWrapper(), this.getText(), fontMetrics, n, true);
                dimension.width = labelGeometry.getMaxPixelWidth();
                dimension.height = labelGeometry.getLineCount() * fontMetrics.getHeight();
            } else {
                dimension.width = dimension2.width;
                dimension.height = dimension2.height;
            }
            this._currentPreferredSize = dimension;
        }
        return this._currentPreferredSize;
    }

    private static int _getWhiteSpacePixels(FontMetrics fontMetrics, char[] cArray, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        while (n3 <= n2) {
            char c = cArray[n3];
            if (Character.isWhitespace(c)) {
                n4 += fontMetrics.charWidth(c);
            }
            ++n3;
        }
        return n4;
    }

    private static int _getFirstNonWhiteSpaceIndex(char[] cArray) {
        int n = 0;
        int n2 = cArray.length;
        while (n < n2 && Character.isWhitespace(cArray[n])) {
            ++n;
        }
        return n;
    }

    private int _getLastNonWhiteSpaceIndex(char[] cArray) {
        int n = cArray.length - 1;
        while (n >= 0 && Character.isWhitespace(cArray[n])) {
            --n;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private void _paintFullJustified(Graphics var1_1, int var2_2, int var3_3, LineInfo var4_4) {
        block12: {
            block11: {
                var5_5 = this._geometry;
                var6_6 = var4_4.text;
                var7_7 = var6_6.toCharArray();
                var8_8 = var7_7.length;
                var9_9 = MultiLineLabel._getFirstNonWhiteSpaceIndex(var7_7);
                if (var9_9 == var8_8) {
                    return;
                }
                var10_10 = this._getLastNonWhiteSpaceIndex(var7_7);
                var11_11 = var5_5.getWrapWidth() - var4_4.pixelWidth;
                if (var11_11 != 0 || var9_9 != 0 || var10_10 != var8_8 - 1) break block11;
                GraphicUtils.drawString(var1_1, var6_6, var2_2, var3_3);
                break block12;
            }
            var12_12 = var5_5.getFontMetrics();
            if (var9_9 != 0) {
                var13_13 = var12_12.charsWidth(var7_7, 0, var9_9);
                if (var4_4.isNewParagraph) {
                    var2_2 += var13_13;
                } else {
                    var11_11 += var13_13;
                }
            }
            if (var10_10 != var8_8 - 1) {
                var11_11 += var12_12.charsWidth(var7_7, var10_10 + 1, var8_8 - (var10_10 + 1));
            }
            if ((var14_14 = (float)var11_11 / (float)(var13_13 = MultiLineLabel._getWhiteSpacePixels(var12_12, var7_7, var9_9, var10_10)) + 1.0f) < 0.0f) {
                var14_14 = 0.0f;
            }
            var13_13 += var11_11;
            var15_15 = 0.0f;
            var16_16 = false;
            var17_17 = var9_9;
            var18_18 = var9_9;
            var19_19 = var9_9;
            while (var17_17 <= var10_10) {
                block13: {
                    if (!var16_16) ** GOTO lbl51
                    while (Character.isWhitespace(var7_7[var18_18])) {
                        if (++var18_18 <= var10_10) continue;
                        var1_1.drawChars(var7_7, var19_19, var18_18 - var19_19, var2_2 += var13_13, var3_3);
                        return;
                    }
                    var20_20 = var12_12.charsWidth(var7_7, var17_17, var18_18 - var17_17);
                    if (var20_20 != (var22_22 = (int)(var21_21 = (float)var20_20 * var14_14 + var15_15))) {
                        if (var19_19 != var17_17) {
                            var1_1.drawChars(var7_7, var19_19, var17_17 - var19_19, var2_2, var3_3);
                            var2_2 += var12_12.charsWidth(var7_7, var19_19, var17_17 - var19_19);
                        }
                        var2_2 += var22_22;
                        var17_17 = var18_18;
                        var19_19 = var18_18;
                    }
                    var13_13 -= var22_22;
                    var15_15 = var21_21 - (float)var22_22;
                    break block13;
lbl-1000:
                    // 1 sources

                    {
                        if (++var18_18 <= var10_10) continue;
                        var1_1.drawChars(var7_7, var19_19, var18_18 - var19_19, var2_2 += var13_13, var3_3);
                        return;
lbl51:
                        // 2 sources

                        ** while (!Character.isWhitespace((char)var7_7[var18_18]))
                    }
lbl52:
                    // 1 sources

                    var17_17 = var18_18;
                }
                v0 = var16_16 = var16_16 == false;
            }
        }
    }

    private class AccessibleMultiLineLabel
    extends JComponent.AccessibleJComponent {
        private AccessibleMultiLineLabel() {
            super(MultiLineLabel.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (MultiLineLabel.this.getText() == null) {
                return super.getAccessibleName();
            }
            return MultiLineLabel.this.getText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

