/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.selection;

import java.util.Enumeration;
import java.util.Vector;
import oracle.bali.share.collection.Range;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.util.IntegerUtils;

public class OneDSelection
implements Cloneable {
    private Range[] _ranges;
    private static RangeComparator _rangeComparator;
    private static OneDSelection _emptySelection;

    public OneDSelection() {
    }

    public OneDSelection(Range range) {
        Range[] rangeArray = new Range[]{range};
        this._setRanges(rangeArray);
    }

    public OneDSelection(int n, int n2) {
        Range[] rangeArray = new Range[]{OneDSelection._newRange(n, n2)};
        this._setRanges(rangeArray);
    }

    public OneDSelection(int n) {
        Range[] rangeArray = new Range[]{OneDSelection._newRange(n, n)};
        this._setRanges(rangeArray);
    }

    public OneDSelection(Range[] rangeArray) {
        Object[] objectArray = null;
        if (rangeArray != null && rangeArray.length > 0) {
            objectArray = this._duplicateRangeArray(rangeArray);
            Sort.qSort((Object[])objectArray, (int)objectArray.length, (Comparator)OneDSelection._getRangeComparator());
        }
        this._setRanges((Range[])objectArray);
    }

    public Enumeration getIndexes() {
        return new Enumerator(this);
    }

    public Object clone() throws CloneNotSupportedException {
        return new OneDSelection(this.getRanges());
    }

    public Range[] getRanges() {
        return this._ranges;
    }

    private void _setRanges(Range[] rangeArray) {
        this._ranges = rangeArray;
    }

    public int getSingleItem() {
        Range[] rangeArray = this.getRanges();
        if (rangeArray != null && rangeArray.length > 0) {
            return rangeArray[0].getLowerLimit();
        }
        return -1;
    }

    public final OneDSelection add(OneDSelection oneDSelection) {
        return this.add(oneDSelection.getRanges());
    }

    public final OneDSelection add(int n) {
        Range[] rangeArray = new Range[]{new Range(n, n)};
        return new OneDSelection(Range.addRanges((Range[])this.getRanges(), (Range[])rangeArray));
    }

    public OneDSelection add(Range[] rangeArray) {
        return new OneDSelection(Range.addRanges((Range[])this.getRanges(), (Range[])rangeArray));
    }

    public final OneDSelection subtract(OneDSelection oneDSelection) {
        return this.subtract(oneDSelection.getRanges());
    }

    public final OneDSelection subtract(int n) {
        Range[] rangeArray = new Range[]{new Range(n, n)};
        return this.subtract(rangeArray);
    }

    public OneDSelection subtract(Range[] rangeArray) {
        Range[] rangeArray2 = Range.subtractRanges((Range[])this.getRanges(), (Range[])rangeArray);
        return new OneDSelection(rangeArray2);
    }

    public OneDSelection addItems(int n, int n2) {
        Range[] rangeArray = this.getRanges();
        Object[] objectArray = null;
        if (rangeArray != null && rangeArray.length > 0) {
            Vector<Range> vector = new Vector<Range>();
            int n3 = 0;
            while (n3 < rangeArray.length) {
                int n4 = rangeArray[n3].getLowerLimit();
                int n5 = rangeArray[n3].getUpperLimit();
                if (n <= n4) {
                    vector.addElement(new Range(n4 + n2, n5 + n2));
                } else if (n > n5) {
                    vector.addElement(new Range(n4, n5));
                } else {
                    vector.addElement(new Range(n4, n - 1));
                    vector.addElement(new Range(n + n2, n5 + n2));
                }
                ++n3;
            }
            objectArray = new Range[vector.size()];
            vector.copyInto(objectArray);
        }
        return new OneDSelection((Range[])objectArray);
    }

    public OneDSelection removeItems(int n, int n2) {
        Range[] rangeArray = this.getRanges();
        Object[] objectArray = null;
        if (rangeArray != null && rangeArray.length > 0) {
            Vector<Range> vector = new Vector<Range>();
            int n3 = 0;
            while (n3 < rangeArray.length) {
                int n4 = rangeArray[n3].getLowerLimit();
                int n5 = rangeArray[n3].getUpperLimit();
                if (n + n2 <= n4) {
                    vector.addElement(new Range(n4 - n2, n5 - n2));
                } else if (n > n5) {
                    vector.addElement(new Range(n4, n5));
                } else if (n > n4 || n + n2 - 1 < n5) {
                    if (n > n4 && n + n2 - 1 < n5) {
                        vector.addElement(new Range(n4, n - 1));
                        vector.addElement(new Range(n, n5 - n2));
                    } else if (n > n4) {
                        vector.addElement(new Range(n4, n - 1));
                    } else if (n + n2 - 1 < n5) {
                        vector.addElement(new Range(n, n5 - n2));
                    }
                }
                ++n3;
            }
            objectArray = new Range[vector.size()];
            vector.copyInto(objectArray);
        }
        return new OneDSelection((Range[])objectArray);
    }

    public boolean contains(int n) {
        return Range.rangesContain((Range[])this.getRanges(), (int)n);
    }

    public boolean contains(OneDSelection oneDSelection) {
        return Range.rangesContain((Range[])this.getRanges(), (Range[])oneDSelection.getRanges());
    }

    public boolean isEmpty() {
        return this._ranges == null || this._ranges.length == 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OneDSelection)) {
            return false;
        }
        OneDSelection oneDSelection = this.subtract((OneDSelection)object);
        OneDSelection oneDSelection2 = ((OneDSelection)object).subtract(this);
        return oneDSelection.isEmpty() && oneDSelection2.isEmpty();
    }

    public int getSelectedItemCount() {
        Range[] rangeArray = this.getRanges();
        if (rangeArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < rangeArray.length) {
            int n3 = rangeArray[n2].getUpperLimit();
            int n4 = rangeArray[n2].getLowerLimit();
            n += n3 - n4 + 1;
            ++n2;
        }
        return n;
    }

    public int getSelectedItemAtIndex(int n) {
        Range[] rangeArray = this.getRanges();
        if (rangeArray == null) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < rangeArray.length) {
            int n4;
            int n5 = rangeArray[n3].getUpperLimit();
            if ((n2 += n5 - (n4 = rangeArray[n3].getLowerLimit()) + 1) >= n + 1) {
                return n5 - (n2 - (n + 1));
            }
            ++n3;
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        boolean bl = false;
        Range[] rangeArray = this.getRanges();
        if (rangeArray != null && rangeArray.length > 0) {
            bl = true;
            int n = 0;
            while (n < rangeArray.length) {
                Range range = rangeArray[n];
                stringBuffer.append("[" + range.getLowerLimit() + ", " + range.getUpperLimit() + "]");
                if (n != rangeArray.length - 1) {
                    stringBuffer.append(",");
                }
                ++n;
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static OneDSelection getEmptySelection() {
        if (_emptySelection == null) {
            _emptySelection = new OneDSelection();
        }
        return _emptySelection;
    }

    private static Range _newRange(int n, int n2) {
        if (n <= n2) {
            return new Range(n, n2);
        }
        return new Range(n2, n);
    }

    private static Comparator _getRangeComparator() {
        if (_rangeComparator == null) {
            _rangeComparator = new RangeComparator();
        }
        return _rangeComparator;
    }

    private Range[] _duplicateRangeArray(Range[] rangeArray) {
        if (rangeArray == null) {
            return null;
        }
        Range[] rangeArray2 = new Range[rangeArray.length];
        int n = 0;
        while (n < rangeArray.length) {
            try {
                if (rangeArray[n] instanceof Range) {
                    rangeArray2[n] = (Range)rangeArray[n].clone();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            ++n;
        }
        return rangeArray2;
    }

    private static class RangeComparator
    implements Comparator {
        private RangeComparator() {
        }

        public int compare(Object object, Object object2) {
            Range range = (Range)object;
            Range range2 = (Range)object2;
            if (range.getLowerLimit() < range2.getLowerLimit()) {
                return -1;
            }
            if (range.getLowerLimit() > range2.getLowerLimit()) {
                return 1;
            }
            return 0;
        }
    }

    private static class Enumerator
    implements Enumeration {
        private OneDSelection _source;
        private int _indexa;
        private int _indexb;

        public Enumerator(OneDSelection oneDSelection) {
            this._source = oneDSelection;
            this._indexa = 0;
            this._indexb = -1;
        }

        public boolean hasMoreElements() {
            Range[] rangeArray = this._source.getRanges();
            return this._indexa < rangeArray.length && this._indexb == -1;
        }

        public Object nextElement() {
            Range[] rangeArray = this._source.getRanges();
            if (this._indexa < rangeArray.length) {
                if (this._indexb == -1) {
                    this._indexb = rangeArray[this._indexa].getLowerLimit();
                    return IntegerUtils.getInteger((int)this._indexb);
                }
                int n = rangeArray[this._indexa].getUpperLimit();
                ++this._indexb;
                if (this._indexb > n) {
                    ++this._indexa;
                    if (this._indexa < rangeArray.length) {
                        this._indexb = rangeArray[this._indexa].getLowerLimit();
                        return IntegerUtils.getInteger((int)this._indexb);
                    }
                    return null;
                }
                return IntegerUtils.getInteger((int)this._indexb);
            }
            return null;
        }
    }
}

