/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.BigCellPainter;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.WrappingTextPainter;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.ImmInsets;

public class PivotHeaderPainter
extends AbstractWrappingPainter {
    PivotHeader _header;
    private Painter _painter;
    private boolean _outline;

    public PivotHeaderPainter(PivotHeader pivotHeader) {
        this(pivotHeader, null);
    }

    public PivotHeaderPainter(PivotHeader pivotHeader, Painter painter) {
        super(new BorderLessBigCellPainter());
        this._painter = painter;
        this._header = pivotHeader;
        this._getBigCellPainter().setPainter(new TotalP());
    }

    public void setCellBorderVisible(boolean bl) {
        this._getBigCellPainter().setCellBorderVisible(bl);
        this._getBigCellPainter().setHorizontalSeparatorsVisible(bl);
        this._getBigCellPainter().setVerticalSeparatorsVisible(bl);
    }

    public boolean isCellBorderVisible() {
        return this._getBigCellPainter().isCellBorderVisible();
    }

    public void dispose() {
        if (this._header == null) {
            return;
        }
        this._getBigCellPainter().setPainter(null);
        this._painter = null;
        this._header = null;
    }

    public Painter getPainter() {
        if (this._painter == null) {
            this._painter = new WrappingTextPainter();
        }
        return this._painter;
    }

    public void setPainter(Painter painter) {
        if (this._painter != painter) {
            this._painter = painter;
            this._header.repaint();
        }
    }

    public void setOutline(boolean bl) {
        if (this._outline != bl) {
            this._outline = bl;
            this._header.repaint();
        }
    }

    public boolean isOutline() {
        return this._outline;
    }

    public void setKeepHeaderCellsVisible(boolean bl) {
        if (this.getKeepHeaderCellsVisible() != bl) {
            this._getBigCellPainter().setKeepCellsVisible(bl);
            this._header.repaint();
        }
    }

    public boolean getKeepHeaderCellsVisible() {
        return this._getBigCellPainter().isKeepCellsVisible();
    }

    private BorderLessBigCellPainter _getBigCellPainter() {
        return (BorderLessBigCellPainter)this.getWrappedPainter(null);
    }

    private static class BorderLessBigCellPainter
    extends BigCellPainter {
        private boolean _borderVisible = true;

        private BorderLessBigCellPainter() {
        }

        public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!this._borderVisible) {
                Appearance appearance = (Appearance)paintContext.getPaintData("Appearance");
                BorderPainter borderPainter = appearance.getBorderPainter();
                appearance.setBorderPainter(null);
                super.paint(paintContext, graphics, n, n2, n3, n4);
                appearance.setBorderPainter(borderPainter);
            } else {
                super.paint(paintContext, graphics, n, n2, n3, n4);
            }
        }

        public void setCellBorderVisible(boolean bl) {
            this._borderVisible = bl;
        }

        public boolean isCellBorderVisible() {
            return this._borderVisible;
        }
    }

    private class TotalP
    extends AbstractPainter {
        private ImmInsets _insets;
        private ImageP _imagePainter = new ImageP();

        public TotalP() {
            this._insets = new ImmInsets(0, 1, 0, 1);
        }

        public Dimension getMinimumSize(PaintContext paintContext) {
            return PivotHeaderPainter.this.getPainter().getMinimumSize(paintContext);
        }

        public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            Object object;
            int n5;
            int n6;
            Serializable serializable;
            Object object2;
            Cell cell = (Cell)paintContext.getPaintData("Cell");
            Image image = PivotHeaderPainter.this._header.getDrillImage(cell.column, cell.row);
            if (image != null && PivotHeaderPainter.this._header.getDrillImagesDisplayed()) {
                FontMetrics fontMetrics;
                this._imagePainter.setImage(image);
                object2 = this._imagePainter.getPreferredSize(paintContext);
                int n7 = n2;
                float f = paintContext.getInteriorAlignmentY();
                serializable = paintContext.getPaintFont();
                n6 = 0;
                if (serializable == null) {
                    serializable = PivotHeaderPainter.this._header.getFont();
                }
                if (serializable != null && (fontMetrics = paintContext.getFontMetrics((Font)serializable)) != null) {
                    n6 = fontMetrics.getHeight();
                }
                n5 = n4;
                if (n4 < n6) {
                    n5 = n6;
                }
                n2 = (int)((float)n2 + (float)(n5 - n6) * f + (float)((n6 - ((Dimension)object2).height) / 2));
                this._imagePainter.paint(paintContext, graphics, n, n2, ((Dimension)object2).width, n4);
                n2 = n7;
                n += ((Dimension)object2).width;
                n3 -= ((Dimension)object2).width;
            }
            n += this._insets.left;
            n2 += this._insets.top;
            n3 -= this._insets.left + this._insets.right;
            n4 -= this._insets.top + this._insets.bottom;
            if (PivotHeaderPainter.this.isOutline() && (object = (object2 = (TwoDModel)paintContext.getPaintData("Model")).getData(cell.column, cell.row)) instanceof AbstractPivotHeaderCell) {
                AbstractPivotHeaderCell abstractPivotHeaderCell = (AbstractPivotHeaderCell)object;
                serializable = (Grid)paintContext.getPaintData("Grid");
                n6 = abstractPivotHeaderCell.getIndent();
                int n8 = 0;
                while (n8 < n6) {
                    n5 = ((Grid)serializable).getColumnWidth(n8);
                    n += n5;
                    n3 -= n5;
                    ++n8;
                }
            }
            PivotHeaderPainter.this.getPainter().paint(paintContext, graphics, n, n2, n3, n4);
        }
    }

    private static class ImageP
    extends ImagePainter {
        private Image _image;

        public ImageP() {
            super(0);
        }

        public void setImage(Image image) {
            this._image = image;
        }

        protected Image getImageData(PaintContext paintContext) {
            return this._image;
        }
    }
}

