/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.TwoDSelection;

public class PivotHeaderGridSelectionManager
extends GeneralGridSelectionManager {
    private Grid _grid;
    private boolean _isHorizontal;
    private int _cellConstraint;

    public PivotHeaderGridSelectionManager(Grid grid, boolean bl) {
        this(grid, 1, 1, bl);
    }

    public PivotHeaderGridSelectionManager(Grid grid, int n, int n2, boolean bl) {
        super(bl ? 0 : n2, bl ? n2 : 0, n);
        this._isHorizontal = bl;
        this._cellConstraint = n;
        this._grid = grid;
    }

    public Grid getGrid() {
        return this._grid;
    }

    public TwoDSelection getRepaintSelection(TwoDSelection twoDSelection, TwoDSelection twoDSelection2) {
        TwoDSelection twoDSelection3 = super.getRepaintSelection(twoDSelection, twoDSelection2);
        if (!twoDSelection3.getRowSelection().isEmpty() || !twoDSelection3.getColumnSelection().isEmpty()) {
            Grid grid = this.getGrid();
            int n = grid.getNextVisibleColumn(-1);
            int n2 = grid.getPreviousVisibleColumn(grid.getColumnCount());
            int n3 = grid.getNextVisibleRow(-1);
            int n4 = grid.getPreviousVisibleRow(grid.getRowCount());
            twoDSelection3 = new TwoDSelection(null, null, n, n3, n2, n4);
        }
        return twoDSelection3;
    }

    protected TwoDSelection constrain(TwoDSelection twoDSelection) {
        CellRange cellRange;
        CellRange[] cellRangeArray;
        if (this._cellConstraint == 1 && (cellRangeArray = twoDSelection.getCellRanges()) != null && cellRangeArray.length > 0 && (cellRange = this._getSingleCellRange(cellRangeArray)) != null) {
            twoDSelection = new TwoDSelection(twoDSelection.getColumnSelection(), twoDSelection.getRowSelection(), cellRange);
        }
        twoDSelection = super.constrain(twoDSelection);
        return new TwoDSelection(twoDSelection.getColumnSelection(), twoDSelection.getRowSelection(), this._constrainBigCellRange(twoDSelection.getCellRanges(), true));
    }

    protected boolean meetsConstraints(TwoDSelection twoDSelection) {
        twoDSelection = new TwoDSelection(twoDSelection.getColumnSelection(), twoDSelection.getRowSelection(), this._constrainBigCellRange(twoDSelection.getCellRanges(), false));
        return super.meetsConstraints(twoDSelection);
    }

    private CellRange _getSingleCellRange(CellRange[] cellRangeArray) {
        Object object;
        Grid grid = this.getGrid();
        Object object2 = null;
        int n = 0;
        while (n < cellRangeArray.length) {
            AbstractBigCell abstractBigCell;
            object = cellRangeArray[n].getLowerLimit();
            if (object2 == null) {
                object2 = object;
            } else if (this._isHorizontal) {
                if (((Cell)object).row < ((Cell)object2).row || ((Cell)object).row == ((Cell)object2).row && ((Cell)object).column < ((Cell)object2).column) {
                    object2 = object;
                }
            } else if (((Cell)object).column < ((Cell)object2).column || ((Cell)object).column == ((Cell)object2).column && ((Cell)object).row < ((Cell)object2).row) {
                object2 = object;
            }
            if (object2 != null && (abstractBigCell = AbstractBigCell.getBigCell(grid, ((Cell)object2).column, ((Cell)object2).row)) != null) {
                int n2;
                int n3 = abstractBigCell.getColumn();
                if (CellRange.cellRangesContain(cellRangeArray, n3, n2 = abstractBigCell.getRow())) {
                    ((Cell)object2).column = n3;
                    ((Cell)object2).row = n2;
                } else {
                    object2 = null;
                }
            }
            ++n;
        }
        if (object2 == null) {
            object2 = cellRangeArray[0].getLowerLimit();
            object = AbstractBigCell.getBigCell(grid, ((Cell)object2).column, ((Cell)object2).row);
            if (object != null) {
                ((Cell)object2).column = ((AbstractBigCell)object).getColumn();
                ((Cell)object2).row = ((AbstractBigCell)object).getRow();
            }
        }
        if (object2 != null) {
            return new CellRange((Cell)object2);
        }
        return null;
    }

    private CellRange[] _constrainBigCellRange(CellRange[] cellRangeArray, boolean bl) {
        if (cellRangeArray != null && cellRangeArray.length > 0) {
            CellRange[] cellRangeArray2 = null;
            Grid grid = this.getGrid();
            int n = 0;
            while (n < cellRangeArray.length) {
                Cell cell = cellRangeArray[n].getLowerLimit();
                Cell cell2 = cellRangeArray[n].getUpperLimit();
                int n2 = cell.column;
                while (n2 <= cell2.column) {
                    int n3 = cell.row;
                    while (n3 <= cell2.row) {
                        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, n2, n3);
                        if (abstractBigCell != null) {
                            int n4;
                            int n5 = abstractBigCell.getColumn();
                            if (CellRange.cellRangesContain(cellRangeArray, n5, n4 = abstractBigCell.getRow())) {
                                CellRange[] cellRangeArray3 = new CellRange[]{bl ? new CellRange(n5, n4, n5 + abstractBigCell.getColumnCount() - 1, n4 + abstractBigCell.getRowCount() - 1) : new CellRange(n5, n4)};
                                cellRangeArray2 = CellRange.addCellRanges(cellRangeArray2, cellRangeArray3);
                            }
                        } else {
                            CellRange[] cellRangeArray4 = new CellRange[]{new CellRange(n2, n3)};
                            cellRangeArray2 = CellRange.addCellRanges(cellRangeArray2, cellRangeArray4);
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            cellRangeArray = cellRangeArray2;
        }
        return cellRangeArray;
    }
}

