/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyVetoException;
import java.io.IOException;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.elaf.EWTPivotTableUI;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.share.datatransfer.TransferUtils;

class PivotCorner
extends LWComponent
implements DropTargetListener {
    private DropTarget _dropTarget;
    private PivotTable _pivotTable;
    private PivotHeader _pivotHeader;

    public PivotCorner(PivotTable pivotTable) {
        this._pivotTable = pivotTable;
        this._dropTarget = new DropTarget(this, this);
        this.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
    }

    public void dispose() {
        this._dropTarget.setComponent(null);
        this._dropTarget.removeDropTargetListener(this);
        this._dropTarget = null;
        this._pivotHeader = null;
        this._pivotTable = null;
    }

    public void paint(Graphics graphics) {
        EWTPivotTableUI eWTPivotTableUI = this._pivotTable.getPivotTableUI();
        Painter painter = eWTPivotTableUI.getCornerPainter(this._pivotTable, 3);
        painter.paint(this.getPaintContext(), graphics, 0, 0, this.getWidth(), this.getHeight());
    }

    public Object getPaintData(Object object) {
        return this._pivotTable.getPaintData(object);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._acceptDrag(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        this._updateFeedback(dropTargetDragEvent.getDropTargetContext().getComponent(), dropTargetDragEvent.getLocation());
    }

    public void dragScroll(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this._updatePivotHeader(null, null);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(1);
        this._updatePivotHeader(null, null);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        Object object = null;
        try {
            object = transferable.getTransferData(PivotTransfer.DATA_FLAVOR);
        }
        catch (IOException iOException) {
            object = null;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            object = null;
        }
        boolean bl = false;
        if (object != null && object instanceof PivotTransfer) {
            PivotTransfer pivotTransfer = (PivotTransfer)object;
            Object object2 = pivotTransfer.getSource();
            int n = pivotTransfer.getIndex();
            Point point = dropTargetDropEvent.getLocation();
            PivotHeader pivotHeader = this._getPivotHeader(dropTargetDropEvent.getDropTargetContext().getComponent(), point);
            int n2 = this._getIndex(pivotHeader, point);
            PivotTable pivotTable = this._pivotTable;
            boolean bl2 = true;
            if (object2 == pivotHeader) {
                if (n < n2) {
                    --n2;
                }
                if (n == n2) {
                    bl2 = false;
                }
            }
            if (bl2) {
                try {
                    pivotTable.deselectAll();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                pivotTable.firePivotEvent(object2, n, pivotHeader, n2);
            }
            bl = true;
        }
        dropTargetDropEvent.dropComplete(bl);
    }

    private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._pivotTable.isEnabled()) {
            return false;
        }
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (dataFlavorArray == null) {
            return false;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)PivotTransfer.DATA_FLAVOR)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private PivotHeader _getPivotHeader(Component component, Point point) {
        PivotHeader pivotHeader = null;
        pivotHeader = point.x >= point.y ? this._getHorizontalHeader() : this._getVerticalHeader();
        return pivotHeader;
    }

    private void _updateFeedback(Component component, Point point) {
        PivotHeader pivotHeader = this._getPivotHeader(component, point);
        this._updatePivotHeader(pivotHeader, point);
    }

    private void _updatePivotHeader(PivotHeader pivotHeader, Point point) {
        if (this._pivotHeader != pivotHeader && this._pivotHeader != null) {
            this._pivotHeader.setDropLocation(-1, false);
        }
        this._pivotHeader = pivotHeader;
        if (this._pivotHeader != null) {
            int n = this._getIndex(pivotHeader, point);
            this._pivotHeader.setDropLocation(n, false);
        }
    }

    private int _getIndex(PivotHeader pivotHeader, Point point) {
        int n = -1;
        n = pivotHeader.getOrientation() == 0 ? pivotHeader.getRowHeader().getItemAt(1, point.y) : pivotHeader.getColumnHeader().getItemAt(point.x, 1);
        return n;
    }

    private PivotHeader _getHorizontalHeader() {
        return this._pivotTable.getColumnPivotHeader();
    }

    private PivotHeader _getVerticalHeader() {
        return this._pivotTable.getRowPivotHeader();
    }
}

