/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.olaf.OracleCaret;
import oracle.bali.ewt.olaf.OracleTextFieldUI;
import oracle.bali.ewt.olaf.OracleUIUtils;

public class OracleTextAreaUI
extends BasicTextAreaUI {
    private static Key _sKey = new Key();

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleTextAreaUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(true);
        OracleTextFieldUI.__initializeBackground(jComponent);
        OracleUIUtils.putPaintContext(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OracleUIUtils.removePaintContext(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            OracleUIUtils.fillBackground(graphics, jComponent);
        }
        this.paint(graphics, jComponent);
    }

    protected void paintBackground(Graphics graphics) {
    }

    protected void installListeners() {
        super.installListeners();
        this.getComponent().addKeyListener(_sKey);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeKeyListener(_sKey);
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        OracleTextFieldUI.__fixBackground(propertyChangeEvent, "TextArea.background");
    }

    protected Caret createCaret() {
        return new OracleCaret();
    }

    private OracleTextAreaUI() {
    }

    private static class Key
    extends KeyAdapter {
        private Key() {
        }

        private void _forceCaretOn(KeyEvent keyEvent) {
            if (keyEvent.getComponent() instanceof JTextComponent) {
                ((JTextComponent)keyEvent.getComponent()).getCaret().setVisible(true);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            this._forceCaretOn(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this._forceCaretOn(keyEvent);
        }
    }
}

