/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SeparatorUI;
import oracle.bali.ewt.olaf.OracleSeparatorPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.PainterUI;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class OracleSeparatorUI
extends SeparatorUI
implements PainterUI {
    private static Painter _sPopupMenuPainter;
    private static final OracleSeparatorUI _sInstance;

    public static ComponentUI createUI(JComponent jComponent) {
        return _sInstance;
    }

    public Painter getPainter(JComponent jComponent) {
        if (jComponent.getParent() instanceof JPopupMenu) {
            if (_sPopupMenuPainter == null) {
                _sPopupMenuPainter = new PopupMenuPainter();
            }
            return _sPopupMenuPainter;
        }
        boolean bl = ((JSeparator)jComponent).getOrientation() == 0;
        return OracleSeparatorPainter.getPainter(bl);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        OracleUIUtils.putPaintContext(jComponent);
        jComponent.setOpaque(false);
        LookAndFeel.installColors(jComponent, "Separator.background", "Separator.foreground");
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OracleUIUtils.removePaintContext(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return OracleUIUtils.getPreferredSize(this, jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return OracleUIUtils.getMinimumSize(this, jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        OracleUIUtils.paint(this, graphics, jComponent);
    }

    public boolean contains(JComponent jComponent, int n, int n2) {
        return OracleUIUtils.contains(this, jComponent, n, n2);
    }

    protected OracleSeparatorUI() {
    }

    static {
        _sInstance = new OracleSeparatorUI();
    }

    private static class PopupMenuPainter
    extends AbstractPainter {
        private PopupMenuPainter() {
        }

        public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
            graphics.setColor(uIDefaults.getColor("PopupMenuSeparator.foreground"));
            graphics.drawLine(n, n2, n3, n2);
            graphics.setColor(uIDefaults.getColor("PopupMenuSeparator.background"));
            graphics.drawLine(n, n2 + 1, n3, n2 + 1);
        }

        public Dimension getMinimumSize(PaintContext paintContext) {
            return new Dimension(2, 2);
        }
    }
}

