/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.olaf.OracleThumbPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.PainterButton;
import oracle.bali.ewt.painter.ImageSetPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class OracleScrollBarUI
extends BasicScrollBarUI
implements PropertyChangeListener {
    private Tracker _tracker;
    private static final int _IMAGE_MASK = 7;
    private static Painter _hThumbPainter = new OracleThumbPainter(true);
    private static Painter _vThumbPainter = new OracleThumbPainter(false);

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleScrollBarUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        OracleUIUtils.putPaintContext(jComponent, this.createPaintContext(jComponent));
        LookAndFeel.installColors(jComponent, "ScrollBar.background", "ScrollBar.foreground");
        jComponent.setOpaque(false);
        jComponent.addPropertyChangeListener(this);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OracleUIUtils.removePaintContext(jComponent);
        jComponent.removePropertyChangeListener(this);
    }

    public PaintContext createPaintContext(JComponent jComponent) {
        return new PaintCtxt(jComponent);
    }

    public boolean contains(JComponent jComponent, int n, int n2) {
        if (OracleUIUtils.pointIsInChild(jComponent, n, n2)) {
            return true;
        }
        return this.getTrackBounds().contains(n, n2);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this.scrollbar.getOrientation() == 1) {
            dimension.width = this.incrButton.getPreferredSize().width;
        } else {
            dimension.height = this.incrButton.getPreferredSize().height;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = super.getMaximumSize(jComponent);
        if (this.scrollbar.getOrientation() == 1) {
            dimension.width = this.incrButton.getMaximumSize().width;
        } else {
            dimension.height = this.incrButton.getMaximumSize().height;
        }
        return dimension;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("orientation")) {
            if ((Integer)propertyChangeEvent.getNewValue() == 0) {
                this._updateButtonPainter(this.incrButton, 3);
                this._updateButtonPainter(this.decrButton, 7);
            } else {
                this._updateButtonPainter(this.incrButton, 5);
                this._updateButtonPainter(this.decrButton, 1);
            }
        }
    }

    protected JButton createDecreaseButton(int n) {
        return this._getArrowButton(n);
    }

    protected JButton createIncreaseButton(int n) {
        return this._getArrowButton(n);
    }

    protected void installListeners() {
        super.installListeners();
        this._tracker = new Tracker();
        this.scrollbar.addMouseListener(this._tracker);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.scrollbar.removeMouseListener(this._tracker);
        this._tracker = null;
    }

    private JButton _getArrowButton(int n) {
        Object object = this._getPainterKey(n);
        Object object2 = UIManager.getDefaults().get(object);
        PainterButton painterButton = new PainterButton((Painter)object2);
        painterButton.setFocusable(false);
        return painterButton;
    }

    private Object _getPainterKey(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "UpScrollPainter";
                break;
            }
            case 5: {
                string = "DownScrollPainter";
                break;
            }
            case 7: {
                string = "LeftScrollPainter";
                break;
            }
            default: {
                string = "RightScrollPainter";
            }
        }
        return string;
    }

    private void _updateButtonPainter(JButton jButton, int n) {
        Object object = this._getPainterKey(n);
        UIDefaults uIDefaults = OracleUIUtils.getUIDefaults(jButton);
        Object object2 = uIDefaults.get(object);
        ((PainterButton)jButton).setPainter((Painter)object2);
    }

    protected Dimension getMinimumThumbSize() {
        return this._getThumbPainter().getMinimumSize(this._getPaintContext());
    }

    protected Dimension getMaximumThumbSize() {
        return this._getThumbPainter().getMaximumSize(this._getPaintContext());
    }

    protected void installDefaults() {
        super.installDefaults();
        this.scrollbar.setOpaque(false);
    }

    protected Rectangle getDecreaseBounds() {
        Insets insets = this.scrollbar.getInsets();
        Rectangle rectangle = this.getThumbBounds();
        if (this.scrollbar.getOrientation() == 1) {
            int n = this.decrButton.getY() + this.decrButton.getHeight();
            return new Rectangle(insets.left, n, this.scrollbar.getWidth() - (insets.left + insets.right), rectangle.y - n);
        }
        int n = this.decrButton.getX() + this.decrButton.getWidth();
        return new Rectangle(n, insets.top, rectangle.x - n, this.scrollbar.getHeight() - (insets.top + insets.bottom));
    }

    protected Rectangle getIncreaseBounds() {
        Insets insets = this.scrollbar.getInsets();
        Rectangle rectangle = this.getThumbBounds();
        if (this.scrollbar.getOrientation() == 1) {
            int n = rectangle.y + rectangle.height;
            return new Rectangle(insets.left, n, this.scrollbar.getWidth() - (insets.left + insets.right), this.incrButton.getY() - n);
        }
        int n = rectangle.x + rectangle.width;
        return new Rectangle(n, insets.top, this.incrButton.getX() - n, this.scrollbar.getHeight() - (insets.top + insets.bottom));
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle object) {
        Object object2;
        if (((Rectangle)object).isEmpty()) {
            object2 = this.getTrackBounds();
            if (((Rectangle)object2).isEmpty()) {
                return;
            }
            object = object2;
        }
        object2 = this._getThumbPainter();
        object2.paint(this._getPaintContext(), graphics, ((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        Object object2 = null;
        if (object.equals("UpScrollPainter")) {
            object2 = uIDefaults.get("UpScrollSet");
        } else if (object.equals("UpScrollSet")) {
            object2 = uIDefaults.get("UpScrollStrip");
        } else if (object.equals("DownScrollPainter")) {
            object2 = uIDefaults.get("DownScrollSet");
        } else if (object.equals("DownScrollSet")) {
            object2 = uIDefaults.get("DownScrollStrip");
        } else if (object.equals("RightScrollPainter")) {
            object2 = uIDefaults.get("RightScrollSet");
        } else if (object.equals("RightScrollSet")) {
            object2 = uIDefaults.get("RightScrollStrip");
        } else if (object.equals("LeftScrollPainter")) {
            object2 = uIDefaults.get("LeftScrollSet");
        } else if (object.equals("LeftScrollSet")) {
            object2 = uIDefaults.get("LeftScrollStrip");
        }
        if (object2 instanceof ImageSet) {
            return new ImageSetPainter((ImageSet)object2);
        }
        if (object2 instanceof Image) {
            return new ImageStrip((Image)object2, 7);
        }
        return null;
    }

    boolean isArmed() {
        return this.isDragging;
    }

    void repaintThumb() {
        if (!this.scrollbar.isEnabled()) {
            return;
        }
        Rectangle rectangle = this.getThumbBounds();
        this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private Painter _getThumbPainter() {
        if (this.scrollbar.getOrientation() == 1) {
            return _vThumbPainter;
        }
        return _hThumbPainter;
    }

    private PaintContext _getPaintContext() {
        return OracleUIUtils.getPaintContext(this.scrollbar);
    }

    private class PaintCtxt
    extends JPaintContext {
        public PaintCtxt(JComponent jComponent) {
            super(jComponent);
        }

        public Color getSurroundingColor() {
            return this.getPaintBackground();
        }

        public int getPaintState() {
            int n = super.getPaintState();
            if (OracleScrollBarUI.this.isArmed()) {
                n |= 2;
            }
            return n;
        }
    }

    private class Tracker
    extends MouseAdapter {
        private Tracker() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            OracleScrollBarUI.this.repaintThumb();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            OracleScrollBarUI.this.repaintThumb();
        }
    }
}

