/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

class OracleRaisedBorderPainter
extends AbstractBorderPainter {
    private static OracleRaisedBorderPainter _sPainter;
    private static final ImmInsets[] _sInsetsArr;

    public static BorderPainter getPainter() {
        if (_sPainter == null) {
            _sPainter = new OracleRaisedBorderPainter();
        }
        return _sPainter;
    }

    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        int n = 0;
        if (this._getVScrollBarWidth(paintContext) > 0) {
            n += 2;
        }
        if (this._getHScrollBarHeight(paintContext) > 0) {
            ++n;
        }
        return _sInsetsArr[n];
    }

    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color = graphics.getColor();
        int n5 = n2 + n4 - 1;
        int n6 = n + n3 - 1;
        graphics.setColor(paintContext.getPaintBackground());
        graphics.drawLine(n + 3, n2 + 1, n6 - 4, n2 + 1);
        graphics.drawLine(n + 1, n2 + 3, n + 1, n5 - 3);
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW));
        graphics.drawLine(n + 3, n2, n6 - 4, n2);
        graphics.drawLine(n, n2 + 3, n, n5 - 3);
        graphics.drawLine(n + 2, n5 - 1, n6 - 4, n5 - 1);
        graphics.drawLine(n6 - 1, n2 + 3, n6 - 1, n5 - 3);
        graphics.drawLine(n + 1, n2 + 1, n + 2, n2 + 1);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 2);
        graphics.drawLine(n + 1, n5 - 2, n + 1, n5 - 1);
        graphics.drawLine(n + 1, n5 - 1, n + 2, n5 - 1);
        graphics.drawLine(n6 - 3, n5 - 2, n6 - 2, n5 - 2);
        graphics.drawLine(n6 - 2, n5 - 2, n6 - 2, n5 - 3);
        graphics.drawLine(n6 - 3, n2 + 1, n6 - 2, n2 + 1);
        graphics.drawLine(n6 - 2, n2 + 2, n6 - 2, n2 + 1);
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_TEXT));
        graphics.drawLine(n + 4, n5, n6 - 4, n5);
        graphics.drawLine(n6, n2 + 5, n6, n5 - 4);
        graphics.drawLine(n6 - 3, n5 - 1, n6 - 2, n5 - 1);
        graphics.drawLine(n6 - 1, n5 - 2, n6 - 1, n5 - 3);
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW));
        graphics.drawLine(n6 - 3, n5, n6 - 3, n5);
        graphics.drawLine(n6 - 1, n5 - 1, n6 - 1, n5 - 1);
        graphics.drawLine(n6, n5 - 3, n6, n5 - 3);
        graphics.setColor(color);
    }

    protected boolean isBorderTransparent(PaintContext paintContext) {
        return true;
    }

    private OracleRaisedBorderPainter() {
    }

    private int _getHScrollBarHeight(PaintContext paintContext) {
        Object object = paintContext.getPaintData("HorizontalScrollBarHeight");
        return object == null ? 0 : (Integer)object;
    }

    private int _getVScrollBarWidth(PaintContext paintContext) {
        Object object = paintContext.getPaintData("VerticalScrollBarWidth");
        return object == null ? 0 : (Integer)object;
    }

    static {
        _sInsetsArr = new ImmInsets[]{new ImmInsets(2, 2, 2, 2), new ImmInsets(2, 2, 1, 2), new ImmInsets(2, 2, 2, 1), new ImmInsets(2, 2, 1, 1)};
    }
}

