/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.IndexColorModel;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.graphics.SpacingIcon;
import oracle.bali.ewt.olaf.ClassInstantiator;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.GrayFilter;
import oracle.bali.ewt.olaf.MultiUIDefaults;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.plaf.StringInstantiator;
import oracle.bali.share.util.IntegerUtils;

public class OracleLookAndFeel
extends BasicLookAndFeel {
    private static final String _DARK_DEFAULTS = "UIDefaults.dark";
    private static final String _LIGHT_DEFAULTS = "UIDefaults.light";
    private static final String _PACKAGE_NAME = "oracle.bali.ewt.olaf.";
    private static final String _UIUTILS_NAME = "oracle.bali.ewt.olaf.OracleUIUtils";
    private static final String _DEF_IMAGE_INSTANT = "oracle.bali.ewt.olaf.OracleUIUtils#imageInst|";
    private static final String _DEF_CIMAGE_INSTANT = "oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|";
    private static final String _DEF_CICON_INSTANT = "oracle.bali.ewt.olaf.OracleUIUtils#cIconInst|";
    private static final int _DEFAULT_SCHEME_INDEX = 6;
    private static final boolean _USE_HIGH_COLOR;
    private static final ColorScheme _sDefaultScheme;
    private static ColorScheme[] _sAvailableSchemes;
    private static ColorScheme _sCurrentScheme;

    public String getName() {
        return "Oracle Look and Feel";
    }

    public String getID() {
        return "Oracle";
    }

    public String getDescription() {
        return "The Oracle Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public static ColorScheme getColorScheme() {
        return _sCurrentScheme;
    }

    public static void setColorScheme(Color color) {
        _sCurrentScheme = OracleLookAndFeel.__getColorScheme(OracleLookAndFeel._getAvailableSchemes(), color);
    }

    public static void setColorScheme(String string) {
        ColorScheme colorScheme = OracleLookAndFeel.__getColorScheme(OracleLookAndFeel._getAvailableSchemes(), string);
        _sCurrentScheme = colorScheme == null ? _sDefaultScheme : colorScheme;
    }

    public static ColorScheme[] getAvailableColorSchemes() {
        return (ColorScheme[])OracleLookAndFeel._getAvailableSchemes().clone();
    }

    public static void setAppletsAlwaysActive(boolean bl) {
        JPaintContext.setAppletsAlwaysActive(bl);
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if (object.equals(_DARK_DEFAULTS)) {
            MultiUIDefaults multiUIDefaults = new MultiUIDefaults(new UIDefaults[]{uIDefaults});
            OracleLookAndFeel.getColorScheme()._installDarkColors(multiUIDefaults);
            OracleLookAndFeel._initDarkComponentDefaults(multiUIDefaults);
            return multiUIDefaults;
        }
        if (_LIGHT_DEFAULTS.equals(object)) {
            MultiUIDefaults multiUIDefaults = new MultiUIDefaults(new UIDefaults[]{uIDefaults});
            OracleLookAndFeel._initLightComponentDefaults(multiUIDefaults);
            return multiUIDefaults;
        }
        return null;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        Object[] objectArray = new String[]{"ButtonUI", "oracle.bali.ewt.olaf.OracleButtonUI", "CheckBoxUI", "oracle.bali.ewt.olaf.OracleCheckBoxUI", "CheckBoxMenuItemUI", "oracle.bali.ewt.olaf.OracleCheckBoxMenuItemUI", "ComboBoxUI", "oracle.bali.ewt.olaf.OracleComboBoxUI", "FileChooserUI", "oracle.bali.ewt.olaf.OracleFileChooserUI", "LabelUI", "oracle.bali.ewt.olaf.OracleLabelUI", "ListUI", "oracle.bali.ewt.olaf.OracleListUI", "MenuUI", "oracle.bali.ewt.olaf.OracleMenuUI", "MenuItemUI", "oracle.bali.ewt.olaf.OracleMenuItemUI", "OptionPaneUI", "oracle.bali.ewt.olaf.OracleOptionPaneUI", "PopupMenuUI", "oracle.bali.ewt.olaf.OraclePopupMenuUI", "PasswordFieldUI", "oracle.bali.ewt.olaf.OraclePasswordFieldUI", "PopupMenuSeparatorUI", "oracle.bali.ewt.olaf.OraclePopupMenuSeparatorUI", "ProgressBarUI", "oracle.bali.ewt.olaf.OracleProgressBarUI", "RadioButtonUI", "oracle.bali.ewt.olaf.OracleRadioButtonUI", "RadioButtonMenuItemUI", "oracle.bali.ewt.olaf.OracleRadioButtonMenuItemUI", "ScrollBarUI", "oracle.bali.ewt.olaf.OracleScrollBarUI", "ScrollPaneUI", "oracle.bali.ewt.olaf.OracleScrollPaneUI", "SeparatorUI", "oracle.bali.ewt.olaf.OracleSeparatorUI", "SliderUI", "oracle.bali.ewt.olaf.OracleSliderUI", "SplitPaneUI", "oracle.bali.ewt.olaf.OracleSplitPaneUI", "TabbedPaneUI", "oracle.bali.ewt.olaf.OracleTabbedPaneUI", "TextAreaUI", "oracle.bali.ewt.olaf.OracleTextAreaUI", "TextFieldUI", "oracle.bali.ewt.olaf.OracleTextFieldUI", "ToggleButtonUI", "oracle.bali.ewt.olaf.OracleButtonUI", "ToolBarUI", "oracle.bali.ewt.olaf.OracleToolBarUI", "ToolBarSeparatorUI", "oracle.bali.ewt.olaf.OracleToolBarSeparatorUI", "ToolTipUI", "oracle.bali.ewt.olaf.OracleToolTipUI", "TreeUI", "oracle.bali.ewt.olaf.OracleTreeUI", "InternalFrameUI", "oracle.bali.ewt.olaf.OracleInternalFrameUI", "DesktopIconUI", "oracle.bali.ewt.olaf.OracleDesktopIconUI", "PanelUI", "oracle.bali.ewt.olaf.OraclePanelUI", "EditorPaneUI", "oracle.bali.ewt.olaf.OracleEditorPaneUI", "TableUI", "oracle.bali.ewt.olaf.OracleTableUI"};
        uIDefaults.putDefaults(objectArray);
        ClassInstantiator.putInstantiators(uIDefaults, (String[])objectArray);
        uIDefaults.put("UIBorderFactory", new StringInstantiator("oracle.bali.ewt.olaf.OracleBorderFactory"));
        uIDefaults.put(_DARK_DEFAULTS, new StringInstantiator("oracle.bali.ewt.olaf.OracleLookAndFeel", _DARK_DEFAULTS));
        uIDefaults.put(_LIGHT_DEFAULTS, new StringInstantiator("oracle.bali.ewt.olaf.OracleLookAndFeel", _LIGHT_DEFAULTS));
        uIDefaults.put("LookAndFeel.requiresActiveChangeRepaint", Boolean.TRUE);
        UIDefaults.ActiveValue activeValue = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return new GrayFilter(true);
            }
        };
        uIDefaults.put("disablingFilter", activeValue);
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        super.initSystemColorDefaults(uIDefaults);
        this.loadSystemColors(uIDefaults, this.getSystemColors(), false);
        this.installColors(uIDefaults);
    }

    protected void installColors(UIDefaults uIDefaults) {
        OracleLookAndFeel.getColorScheme()._installCommonColors(uIDefaults);
        OracleLookAndFeel.getColorScheme()._installLightColors(uIDefaults);
    }

    protected String[] getSystemColors() {
        String[] stringArray = new String[]{"textHighlight", "#0000FF", "selectedFocus", "#FFFFFF", "windowBorder", "#000000", "info", "#FFFFCC", "desktop", "#666666"};
        return stringArray;
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        FontUIResource fontUIResource = new FontUIResource("Dialog", 0, 12);
        FontUIResource fontUIResource2 = new FontUIResource("SansSerif", 0, 12);
        FontUIResource fontUIResource3 = new FontUIResource("Monospaced", 0, 12);
        FontUIResource fontUIResource4 = new FontUIResource("SansSerif", 0, 9);
        Integer n = new Integer(500);
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        Border border = OracleUIUtils.getWideInsetBorder();
        Border border2 = OracleUIUtils.getNarrowInsetBorder();
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(border, marginBorder);
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource2 = new BorderUIResource.CompoundBorderUIResource(border2, marginBorder);
        InsetsUIResource insetsUIResource = new InsetsUIResource(1, 1, 1, 1);
        InsetsUIResource insetsUIResource2 = new InsetsUIResource(0, 0, 0, 0);
        Object[] objectArray = new Object[]{"ctrl C", "copy-to-clipboard", "ctrl INSERT", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "shift INSERT", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "shift DELETE", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"};
        UIDefaults.LazyInputMap lazyInputMap = new UIDefaults.LazyInputMap(objectArray);
        Object[] objectArray2 = new Object[]{"ctrl C", "copy-to-clipboard", "ctrl INSERT", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "shift INSERT", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "shift DELETE", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"};
        UIDefaults.LazyInputMap lazyInputMap2 = new UIDefaults.LazyInputMap(objectArray2);
        IconUIResource iconUIResource = new IconUIResource(new SpacingIcon(14, 14));
        Object[] objectArray3 = this.getColorComponentDefaults(uIDefaults);
        uIDefaults.putDefaults(objectArray3);
        Object[] objectArray4 = new Object[]{"Panel.font", null, "Button.border", new StringInstantiator("oracle.bali.ewt.olaf.OracleButtonUI", "Button.border"), "Button.margin", new InsetsUIResource(0, 2, 0, 2), "Button.font", fontUIResource, "ToggleButton.border", new StringInstantiator("oracle.bali.ewt.olaf.OracleButtonUI", "ToggleButton.border"), "ToggleButton.font", fontUIResource, "RadioButton.icon", new StringInstantiator("oracle.bali.ewt.olaf.OracleRadioButtonUI", "RadioButton.icon"), "RadioButton.margin", insetsUIResource2, "CheckBox.icon", new StringInstantiator("oracle.bali.ewt.olaf.OracleCheckBoxUI", "CheckBox.icon"), "CheckBox.margin", insetsUIResource2, "MenuBar.border", null, "Menu.selectedWindowInputMapBindings", new Object[]{"ESCAPE", "cancel", "alt pressed ALT", "oracle.bali.ewt.olaf.MenuClearAction", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"}, "MenuItem.checkIcon", iconUIResource, "Menu.checkIcon", iconUIResource, "PopupMenu.border", null, "PopupMenu.selectedWindowInputMapBindings", new Object[]{"ESCAPE", "cancel", "alt pressed ALT", "oracle.bali.ewt.olaf.MenuClearAction", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"}, "Label.font", fontUIResource, "List.focusCellHighlightBorder", new StringInstantiator("oracle.bali.ewt.plaf.GridFocusPainter"), "List.font", fontUIResource, "List.border", null, "ComboBox.font", fontUIResource, "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "ENTER", "enterPressed", "SPACE", "spacePopup"}), "InternalFrame.border", null, "DesktopIcon.border", null, "InternalFrame.maximizeIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleInternalFrameUI", "InternalFrame.maximizeIcon"), "InternalFrame.minimizeIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleInternalFrameUI", "InternalFrame.minimizeIcon"), "InternalFrame.iconifyIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleInternalFrameUI", "InternalFrame.iconifyIcon"), "InternalFrame.closeIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleInternalFrameUI", "InternalFrame.closeIcon"), "Window.closeStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#imageInst|closeStrip.gif"), "Window.maximizeStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#imageInst|maximizeStrip.gif"), "Window.iconifyStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#imageInst|minimizeStrip.gif"), "Window.minimizeStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#imageInst|restoreStrip.gif"), "TextField.caretBlinkRate", n, "TextField.margin", insetsUIResource, "TextField.font", fontUIResource2, "TextField.border", compoundBorderUIResource2, "PasswordField.caretBlinkRate", n, "PasswordField.margin", insetsUIResource, "PasswordField.font", fontUIResource3, "PasswordField.border", compoundBorderUIResource2, "TextArea.caretBlinkRate", n, "TextArea.margin", insetsUIResource, "TextArea.font", fontUIResource2, "TextArea.border", compoundBorderUIResource, "TextPane.font", fontUIResource2, "TextPane.border", compoundBorderUIResource, "TextPane.margin", insetsUIResource, "EditorPane.font", fontUIResource2, "EditorPane.border", compoundBorderUIResource, "EditorPane.margin", insetsUIResource, "TextField.focusInputMap", lazyInputMap, "PasswordField.focusInputMap", lazyInputMap, "TextArea.focusInputMap", lazyInputMap2, "TextPane.focusInputMap", lazyInputMap2, "EditorPane.focusInputMap", lazyInputMap2, "TextField.keyBindings", lazyInputMap, "PasswordField.keyBindings", lazyInputMap, "TextArea.keyBindings", lazyInputMap2, "TextPane.keyBindings", lazyInputMap2, "EditorPane.keyBindings", lazyInputMap2, "ScrollBar.border", null, "TitledBorder.font", fontUIResource, "TitledBorder.border", new StringInstantiator("oracle.bali.ewt.olaf.OracleGroupBoxPainter", "TitledBorder.border"), "ToolBar.border", new StringInstantiator("oracle.bali.ewt.olaf.OracleToolBarUI", "ToolBar.border"), "ToolBar.separatorSize", new DimensionUIResource(12, 12), "ToolTip.font", fontUIResource2, "ToolTip.border", new StringInstantiator("oracle.bali.ewt.olaf.OracleToolTipUI", "ToolTip.border"), "ScrollPane.border", border, "ScrollPane.viewportBorder", null, "SplitPane.dividerSize", IntegerUtils.getInteger((int)12), "InternalFrame.icon", null, "Tree.rowHeight", IntegerUtils.getInteger((int)0), "Tree.openIcon", null, "Tree.closedIcon", null, "Tree.leafIcon", null, "Tree.font", fontUIResource, "ProgressBar.font", fontUIResource, "ProgressBar.border", border2, "ProgressBar.cellLength", IntegerUtils.getInteger((int)1), "ProgressBar.cellSpacing", IntegerUtils.getInteger((int)0), "OptionPane.questionIcon", javax.swing.LookAndFeel.makeIcon(this.getClass(), "icons/Question.gif"), "OptionPane.errorIcon", javax.swing.LookAndFeel.makeIcon(this.getClass(), "icons/Error.gif"), "OptionPane.informationIcon", javax.swing.LookAndFeel.makeIcon(this.getClass(), "icons/Inform.gif"), "OptionPane.warningIcon", javax.swing.LookAndFeel.makeIcon(this.getClass(), "icons/Warn.gif"), "Table.focusCellHighlightBorder", new StringInstantiator("oracle.bali.ewt.plaf.GridFocusPainter"), "Table.scrollPaneBorder", border, "TableHeader.cellBorder", new StringInstantiator("oracle.bali.ewt.olaf.OracleHeaderItemPainter"), "EWTGrayPane.border", new StringInstantiator("oracle.bali.ewt.olaf.OracleGrayPaneBorder"), "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "FileView.directoryIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "5"), "FileView.fileIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "9"), "FileView.computerIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "7"), "FileView.hardDriveIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "10"), "FileView.floppyDriveIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "13"), "FileChooser.newFolderIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "2"), "FileChooser.upFolderIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "0"), "FileChooser.homeFolderIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "1"), "FileChooser.detailsViewIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "4"), "FileChooser.listViewIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "3")};
        uIDefaults.putDefaults(objectArray4);
        OracleLookAndFeel._initColorizedComponentDefaults(uIDefaults);
    }

    protected Object[] getColorComponentDefaults(UIDefaults uIDefaults) {
        Object object = uIDefaults.get(ColorScheme.NORMAL_INTENSITY);
        ColorUIResource colorUIResource = new ColorUIResource(Color.white);
        Object object2 = uIDefaults.get(ColorScheme.DARK_LOOK);
        Object[] objectArray = new Object[]{"Panel.background", uIDefaults.get("lightLook"), "Button.background", uIDefaults.get("control"), "Button.foreground", uIDefaults.get("controlText"), "Button.lightBorder", colorUIResource, "Button.darkBorder", uIDefaults.get(LookAndFeel.CONTROL_DK_SHADOW), "ToggleButton.background", uIDefaults.get("control"), "ToggleButton.foreground", uIDefaults.get("controlText"), "ToggleButton.lightBorder", colorUIResource, "ToggleButton.darkBorder", uIDefaults.get(LookAndFeel.CONTROL_DK_SHADOW), "RadioButton.background", null, "CheckBox.background", null, "MenuBar.background", null, "Menu.foreground", uIDefaults.get("controlText"), "Menu.background", null, "MenuItem.background", null, "Label.background", null, "Label.foreground", uIDefaults.get("controlText"), "List.selectionBackground", uIDefaults.get("textHighlight"), "List.selectionForeground", uIDefaults.get("textHighlightText"), "List.background", uIDefaults.get("text"), "List.foreground", uIDefaults.get("textText"), "ComboBox.background", uIDefaults.get("control"), "ComboBox.foreground", uIDefaults.get("controlText"), "ComboBox.selectedBackground", uIDefaults.get("textHighlight"), "ComboBox.selectedForeground", uIDefaults.get("textHighlightText"), "ComboBox.disabledBackground", uIDefaults.get("control"), "ComboBox.disabledForeground", uIDefaults.get("textInactiveText"), "InternalFrame.background", uIDefaults.get("control"), "DesktopIcon.background", uIDefaults.get("control"), "InternalFrame.activeTitleBackground", uIDefaults.get("activeCaption"), "InternalFrame.activeTitleForeground", uIDefaults.get("activeCaptionText"), "InternalFrame.inactiveTitleBackground", uIDefaults.get("inactiveCaption"), "InternalFrame.inactiveTitleForeground", uIDefaults.get("inactiveCaptionText"), "FileChooser.background", object2, "TextField.caretForeground", uIDefaults.get("textText"), "TextField.inactiveForeground", uIDefaults.get("textInactiveText"), "TextField.selectionBackground", uIDefaults.get("textHighlight"), "TextField.selectionForeground", uIDefaults.get("textHighlightText"), "TextField.background", uIDefaults.get("text"), "TextField.foreground", uIDefaults.get("textText"), "PasswordField.caretForeground", uIDefaults.get("textText"), "PasswordField.inactiveForeground", uIDefaults.get("textInactiveText"), "PasswordField.selectionBackground", uIDefaults.get("textHighlight"), "PasswordField.selectionForeground", uIDefaults.get("textHighlightText"), "PasswordField.background", uIDefaults.get("text"), "PasswordField.foreground", uIDefaults.get("textText"), "TextArea.caretForeground", uIDefaults.get("textText"), "TextArea.inactiveForeground", uIDefaults.get("textInactiveText"), "TextArea.selectionBackground", uIDefaults.get("textHighlight"), "TextArea.selectionForeground", uIDefaults.get("textHighlightText"), "TextArea.background", uIDefaults.get("text"), "TextArea.foreground", uIDefaults.get("textText"), "TextPane.caretForeground", uIDefaults.get("textText"), "TextPane.inactiveForeground", uIDefaults.get("textInactiveText"), "TextPane.selectionBackground", uIDefaults.get("textHighlight"), "TextPane.selectionForeground", uIDefaults.get("textHighlightText"), "TextPane.background", uIDefaults.get("text"), "TextPane.foreground", uIDefaults.get("textText"), "EditorPane.caretForeground", uIDefaults.get("textText"), "EditorPane.inactiveForeground", uIDefaults.get("textInactiveText"), "EditorPane.selectionBackground", uIDefaults.get("textHighlight"), "EditorPane.selectionForeground", uIDefaults.get("textHighlightText"), "EditorPane.background", uIDefaults.get("text"), "EditorPane.foreground", uIDefaults.get("textText"), "ScrollBar.background", uIDefaults.get("scrollbar"), "ScrollBar.foreground", uIDefaults.get("controlDkShadow"), "ScrollBar.track", uIDefaults.get("scrollbar"), "ScrollBar.trackHighlight", uIDefaults.get("controlDkShadow"), "ScrollBar.thumb", uIDefaults.get("control"), "ScrollBar.thumbHighlight", uIDefaults.get("controlHighlight"), "ScrollBar.thumbDarkShadow", uIDefaults.get("controlDkShadow"), "ScrollBar.thumbLightShadow", uIDefaults.get("controlShadow"), "TitledBorder.titleColor", uIDefaults.get("controlText"), "TitledBorder.lineColor", uIDefaults.get("controlShadowDark"), "ToolBar.background", uIDefaults.get("control"), "ToolBar.foreground", uIDefaults.get("controlText"), "ToolBar.dockingColor", uIDefaults.get("control"), "ToolBar.floatingColor", uIDefaults.get("control"), "ToolBar.lightBorder", colorUIResource, "ToolTip.background", uIDefaults.get("info"), "ToolTip.foreground", uIDefaults.get("infoText"), "ScrollPane.background", null, "SplitPane.background", null, "Slider.foreground", uIDefaults.get("controlText"), "Slider.sliderColor", uIDefaults.get(ColorScheme.LIGHT_INTENSITY), "Tree.background", uIDefaults.get("text"), "Tree.hash", uIDefaults.get("controlShadow"), "Tree.textSelectionColor", uIDefaults.get("textHighlightText"), "Tree.textNonSelectionColor", uIDefaults.get("textText"), "Tree.borderSelectionColor", uIDefaults.get("textText"), "Tree.backgroundSelectionColor", uIDefaults.get("textHighlight"), "Tree.backgroundNonSelectionColor", null, "ProgressBar.foreground", uIDefaults.get("textHighlight"), "ProgressBar.background", uIDefaults.get("text"), "ProgressBar.textSelectionColor", uIDefaults.get("textHighlightText"), "ProgressBar.textNonSelectionColor", uIDefaults.get("textText"), "TabbedPane.lightHighlight", colorUIResource, "TabbedPane.shadow", object, "TabbedPane.darkShadow", uIDefaults.get("controlDkShadow"), "TabbedPane.notSelectedColor", object, "TabbedPane.inactiveSelectedColor", uIDefaults.get("control"), "TabbedPane.selectedColor", uIDefaults.get("control"), "TabbedPane.lightBorder", colorUIResource, "TabbedPane.normalColor", uIDefaults.getColor("normalIntensity"), "TabbedPane.selectedTextColor", uIDefaults.get("textText"), "TabbedPane.changeCornerColor", Boolean.TRUE, "TabbedPane.cornerPixel", colorUIResource, "OptionPane.background", uIDefaults.get("darkIntensity"), "Table.background", uIDefaults.get("text"), "Table.gridColor", uIDefaults.get("controlShadow"), "Table.focusCellBackground", uIDefaults.get("text"), "Table.focusCellForeground", uIDefaults.get("controlText"), "Table.selectionBackground", uIDefaults.get("textHighlight"), "Table.inactiveSelectionBackground", uIDefaults.get(ColorScheme.DARK_INTENSITY), "Table.focusCellHighlightBorder", new StringInstantiator("oracle.bali.ewt.plaf.GridFocusPainter"), "Separator.background", null, "Separator.foreground", uIDefaults.get("controlShadowDark"), "PopupMenuSeparator.background", colorUIResource, "PopupMenuSeparator.foreground", object, "Window.lightBorder", colorUIResource, "EWTGrayPane.background", uIDefaults.get("lightLook"), "EWTGrayPane.foreground", null, "EWTGrayPane.lightBorder", colorUIResource, "EWTDialog.background", uIDefaults.get("darkLook")};
        return objectArray;
    }

    private static void _initDarkComponentDefaults(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{"Label.foreground", uIDefaults.get("controlText"), "checkboxStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|dkCheckboxStrip.gif"), "checkboxSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleCheckBoxUI", "checkboxSet"), "radioButtonStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|dkRadioButtonStrip.gif"), "radioButtonSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleRadioButtonUI", "radioButtonSet")};
        uIDefaults.putDefaults(objectArray);
    }

    private static void _initLightComponentDefaults(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{"checkboxStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|ltCheckboxStrip.gif"), "checkboxSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleCheckBoxUI", "checkboxSet"), "radioButtonStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|ltRadioButtonStrip.gif"), "radioButtonSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleRadioButtonUI", "radioButtonSet")};
        uIDefaults.putDefaults(objectArray);
    }

    private static void _initColorizedComponentDefaults(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{"checkboxStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|checkboxStrip.gif"), "checkboxSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleCheckBoxUI", "checkboxSet"), "radioButtonStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|radioButtonStrip.gif"), "radioButtonSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleRadioButtonUI", "radioButtonSet"), "UpScrollPainter", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "UpScrollPainter"), "DownScrollPainter", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "DownScrollPainter"), "LeftScrollPainter", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "LeftScrollPainter"), "RightScrollPainter", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "RightScrollPainter"), "UpScrollSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "UpScrollSet"), "DownScrollSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "DownScrollSet"), "LeftScrollSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "LeftScrollSet"), "RightScrollSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "RightScrollSet"), "UpScrollStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|upScrollStrip.gif"), "DownScrollStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|downScrollStrip.gif"), "LeftScrollStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|leftScrollStrip.gif"), "RightScrollStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|rightScrollStrip.gif"), "TabbedPane.scrollLeft", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cIconInst|tableft.gif"), "TabbedPane.scrollRight", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cIconInst|tabright.gif"), "TabbedPane.scrollBoth", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cIconInst|tabboth.gif"), "CheckBoxMenuItem.checkIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleCheckBoxMenuItemUI", "CheckBoxMenuItem.checkIcon"), "RadioButtonMenuItem.checkIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleRadioButtonMenuItemUI", "RadioButtonMenuItem.checkIcon"), "ComboBox.arrowSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleComboBoxUI", "ComboBox.arrowSet"), "Slider.horzThumbStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|sliderHorzThumbStrip.gif"), "Slider.horzThumbSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleSliderUI", "Slider.horzThumbSet"), "Slider.horzThumbPainter", new StringInstantiator("oracle.bali.ewt.olaf.OracleSliderUI", "Slider.horzThumbPainter"), "Slider.vertThumbStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|sliderVertThumbStrip.gif"), "Slider.vertThumbSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleSliderUI", "Slider.vertThumbSet"), "Slider.vertThumbPainter", new StringInstantiator("oracle.bali.ewt.olaf.OracleSliderUI", "Slider.vertThumbPainter"), "TabbedPane.visibleSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleTabbedPaneUI", "TabbedPane.visibleSet"), "Tree.expandedImage", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cIconInst|TreeOpen.gif"), "Tree.collapsedImage", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cIconInst|TreeClosed.gif"), "Tree.expandedIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleTreeUI", "Tree.expandedIcon"), "Tree.collapsedIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleTreeUI", "Tree.collapsedIcon")};
        uIDefaults.putDefaults(objectArray);
    }

    static ColorScheme __getColorScheme(ColorScheme[] colorSchemeArray, String string) {
        int n = 0;
        while (n < colorSchemeArray.length) {
            ColorScheme colorScheme = colorSchemeArray[n];
            if (colorScheme.getName().equals(string)) {
                return colorScheme;
            }
            ++n;
        }
        return null;
    }

    static ColorScheme __getColorScheme(ColorScheme[] colorSchemeArray, Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        ColorScheme colorScheme = null;
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        while (n5 < colorSchemeArray.length) {
            ColorScheme colorScheme2 = colorSchemeArray[n5];
            if (!colorScheme2._isDerived()) {
                int n6;
                int n7;
                Color color2 = colorScheme2.getDefiningColor();
                int n8 = n - color2.getRed();
                int n9 = n8 * n8 + (n7 = n2 - color2.getGreen()) * n7 + (n6 = n3 - color2.getBlue()) * n6;
                if (n9 == 0) {
                    return colorScheme2;
                }
                if (n9 < n4) {
                    n4 = n9;
                    colorScheme = colorScheme2;
                }
            }
            ++n5;
        }
        return colorScheme;
    }

    private static ColorScheme[] _getAvailableSchemes() {
        if (_sAvailableSchemes == null) {
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            int[] nArray4;
            int[] nArray5;
            int[] nArray6;
            ColorScheme[] colorSchemeArray = new ColorScheme[8];
            if (_USE_HIGH_COLOR) {
                int[] nArray7 = new int[9];
                nArray7[0] = -1;
                nArray7[1] = -858993460;
                nArray7[2] = -1718246217;
                nArray7[3] = 1717532051;
                nArray7[4] = 858339404;
                nArray7[5] = 0;
                nArray7[6] = 255;
                nArray7[7] = 14674679;
                nArray6 = nArray7;
                nArray7[8] = 11849708;
            } else {
                int[] nArray8 = new int[9];
                nArray8[0] = -1;
                nArray8[1] = -858993460;
                nArray8[2] = -1721329204;
                nArray8[3] = 0x66336699;
                nArray8[4] = 0x33000033;
                nArray8[5] = 0;
                nArray8[6] = 255;
                nArray8[7] = 0x99CCFF;
                nArray6 = nArray8;
                nArray8[8] = 0x6699FF;
            }
            colorSchemeArray[0] = new ColorScheme("Blue", "Oracle Blue Color Scheme", nArray6, 0);
            if (_USE_HIGH_COLOR) {
                int[] nArray9 = new int[9];
                nArray9[0] = -1;
                nArray9[1] = -858993460;
                nArray9[2] = -1716210791;
                nArray9[3] = 1720552570;
                nArray9[4] = 860634894;
                nArray9[5] = 0;
                nArray9[6] = 255;
                nArray9[7] = 16316383;
                nArray5 = nArray9;
                nArray9[8] = 0xEEEBB2;
            } else {
                int[] nArray10 = new int[9];
                nArray10[0] = -1;
                nArray10[1] = -858993460;
                nArray10[2] = -1714631527;
                nArray10[3] = 0x66999966;
                nArray10[4] = 0x33666600;
                nArray10[5] = 0;
                nArray10[6] = 255;
                nArray10[7] = 0xCCCC99;
                nArray5 = nArray10;
                nArray10[8] = 0xCCCC00;
            }
            colorSchemeArray[1] = new ColorScheme("Khaki", "Oracle Khaki Color Scheme", nArray5, 1);
            if (_USE_HIGH_COLOR) {
                int[] nArray11 = new int[9];
                nArray11[0] = -1;
                nArray11[1] = -858993460;
                nArray11[2] = -1717130082;
                nArray11[3] = 1718317666;
                nArray11[4] = 859981372;
                nArray11[5] = 0;
                nArray11[6] = 255;
                nArray11[7] = 15661279;
                nArray4 = nArray11;
                nArray11[8] = 14020274;
            } else {
                int[] nArray12 = new int[9];
                nArray12[0] = -1;
                nArray12[1] = -858993460;
                nArray12[2] = -1717986970;
                nArray12[3] = 0x66666633;
                nArray12[4] = 0x33003300;
                nArray12[5] = 0;
                nArray12[6] = 255;
                nArray12[7] = 0xCCCC99;
                nArray4 = nArray12;
                nArray12[8] = 0x999900;
            }
            colorSchemeArray[2] = new ColorScheme("Olive", "Oracle Green Color Scheme", nArray4, 2);
            if (_USE_HIGH_COLOR) {
                int[] nArray13 = new int[9];
                nArray13[0] = -1;
                nArray13[1] = -858993460;
                nArray13[2] = -1716145981;
                nArray13[3] = 1719169422;
                nArray13[4] = 859057482;
                nArray13[5] = 0;
                nArray13[6] = 255;
                nArray13[7] = 15065080;
                nArray3 = nArray13;
                nArray13[8] = 12628718;
            } else {
                int[] nArray14 = new int[9];
                nArray14[0] = -1;
                nArray14[1] = -858993460;
                nArray14[2] = -1717986868;
                nArray14[3] = 0x66666699;
                nArray14[4] = 0x33330033;
                nArray14[5] = 0;
                nArray14[6] = 255;
                nArray14[7] = 0xCCCCFF;
                nArray3 = nArray14;
                nArray14[8] = 0x9999FF;
            }
            colorSchemeArray[3] = new ColorScheme("Purple", "Oracle Purple Color Scheme", nArray3, 3);
            if (_USE_HIGH_COLOR) {
                int[] nArray15 = new int[9];
                nArray15[0] = -1;
                nArray15[1] = -858993460;
                nArray15[2] = -1714770265;
                nArray15[3] = 1721598072;
                nArray15[4] = 860629799;
                nArray15[5] = 0;
                nArray15[6] = 255;
                nArray15[7] = 16311775;
                nArray2 = nArray15;
                nArray15[8] = 15646898;
            } else {
                int[] nArray16 = new int[9];
                nArray16[0] = -1;
                nArray16[1] = -858993460;
                nArray16[2] = -1714644583;
                nArray16[3] = 0x66996666;
                nArray16[4] = 0x33660000;
                nArray16[5] = 0;
                nArray16[6] = 255;
                nArray16[7] = 0xFFCCCC;
                nArray2 = nArray16;
                nArray16[8] = 0xFF9999;
            }
            colorSchemeArray[4] = new ColorScheme("Red", "Oracle Red Color Scheme", nArray2, 4);
            if (_USE_HIGH_COLOR) {
                int[] nArray17 = new int[9];
                nArray17[0] = -1;
                nArray17[1] = -858993460;
                nArray17[2] = -1720141126;
                nArray17[3] = 1718783887;
                nArray17[4] = 859196492;
                nArray17[5] = 0;
                nArray17[6] = 255;
                nArray17[7] = 14678255;
                nArray = nArray17;
                nArray17[8] = 11726551;
            } else {
                int[] nArray18 = new int[9];
                nArray18[0] = -1;
                nArray18[1] = -858993460;
                nArray18[2] = -1721329255;
                nArray18[3] = 0x66336666;
                nArray18[4] = 0x33003333;
                nArray18[5] = 0;
                nArray18[6] = 255;
                nArray18[7] = 0x99FFFF;
                nArray = nArray18;
                nArray18[8] = 52428;
            }
            colorSchemeArray[5] = new ColorScheme("Teal", "Oracle Teal Color Scheme", nArray, 5);
            colorSchemeArray[6] = _sDefaultScheme;
            colorSchemeArray[7] = new ColorScheme("System", "System Hue and Saturation", SystemColor.control, SystemColor.textHighlight, false, 7);
            _sAvailableSchemes = colorSchemeArray;
        }
        return _sAvailableSchemes;
    }

    static {
        int[] nArray;
        boolean bl = _USE_HIGH_COLOR = !(Toolkit.getDefaultToolkit().getColorModel() instanceof IndexColorModel);
        if (_USE_HIGH_COLOR) {
            int[] nArray2 = new int[9];
            nArray2[0] = -1;
            nArray2[1] = -858993460;
            nArray2[2] = -1717986919;
            nArray2[3] = 0x66666666;
            nArray2[4] = 0x33333333;
            nArray2[5] = 0;
            nArray2[6] = 255;
            nArray2[7] = 14678255;
            nArray = nArray2;
            nArray2[8] = 11726551;
        } else {
            int[] nArray3 = new int[9];
            nArray3[0] = -1;
            nArray3[1] = -858993460;
            nArray3[2] = -1717986919;
            nArray3[3] = 0x66666666;
            nArray3[4] = 0x33333333;
            nArray3[5] = 0;
            nArray3[6] = 255;
            nArray3[7] = 0x99FFFF;
            nArray = nArray3;
            nArray3[8] = 52428;
        }
        _sCurrentScheme = _sDefaultScheme = new ColorScheme("Titanium", "Oracle Titanium Color Scheme", nArray, 6);
    }
}

