/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.image.ImageFilter;
import java.util.Locale;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.graphics.ColorizingFilter;

public class ColorScheme {
    public static final Object CONTROL_INACTIVE_TEXT = LookAndFeel.CONTROL_INACTIVE_TEXT;
    public static final Object LIGHT_INTENSITY = LookAndFeel.LIGHT_INTENSITY;
    public static final Object NORMAL_INTENSITY = LookAndFeel.NORMAL_INTENSITY;
    public static final Object DARK_INTENSITY = LookAndFeel.DARK_INTENSITY;
    public static final Object VERY_DARK_INTENSITY = LookAndFeel.VERY_DARK_INTENSITY;
    public static final Object CONTROL_SHADOW_DARK = "controlShadowDark";
    public static final Object CONTROL_SHADOW_DARK_LIGHT = "controlShadowDarkLight";
    public static final Object CONTROL_SHADOW_VERY_LIGHT = "controlShadowVeryLight";
    public static final Object SECONDARY_TEXT_HIGHLIGHT = LookAndFeel.SECONDARY_TEXT_HIGHLIGHT;
    public static final Object TEXT_HIGHLIGHT_TEXT = LookAndFeel.TEXT_HIGHLIGHT_TEXT;
    public static final Object TEXT_INACTIVE_TEXT = LookAndFeel.TEXT_INACTIVE_TEXT;
    public static final Object TEXT_TEXT = LookAndFeel.TEXT_TEXT;
    public static final Object LIGHT_LOOK = LookAndFeel.LIGHT_LOOK;
    public static final Object DARK_LOOK = LookAndFeel.DARK_LOOK;
    public static final Object VERY_DARK_LOOK = LookAndFeel.VERY_DARK_LOOK;
    private static final int _DEFINING_INDEX = 2;
    private static final Color _sBlack;
    static Color __sControlText;
    private static final int _NUM_COLORS = 9;
    private String _name;
    private String _description;
    private int[] _intRamp;
    private Color[] _colorRamp;
    private int[] _mappingTable;
    private int _schemeIndex;
    private boolean _isDerived;

    ColorScheme(String string, String string2, Color color, Color color2, boolean bl, int n) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        float[] fArray = Color.RGBtoHSB(n2, n3, n4, null);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = 0.8f;
        int n5 = -872415232;
        int[] nArray = new int[9];
        nArray[0] = -1;
        nArray[5] = 0;
        int n6 = 1;
        while (n6 < 5) {
            int n7 = Color.HSBtoRGB(f, f2, f3);
            nArray[n6] = (n7 &= 0xFFFFFF) & 0xFFFFFF | n5;
            f3 -= 0.2f;
            n5 -= 0x33000000;
            ++n6;
        }
        if (bl) {
            nArray[1] = -858993460;
        }
        nArray[6] = color2.getRGB();
        if (n2 == n3 && n3 == n4) {
            nArray[7] = 14678255;
            nArray[8] = 11726551;
        } else {
            nArray[7] = (n3 << 15) + 0x800000 | (n4 << 7) + 32768 | (n2 >> 1) + 128;
            nArray[8] = (n4 << 15) + 0x800000 | (n2 << 7) + 32768 | (n3 >> 1) + 128;
        }
        this._init(string, string2, nArray, n);
        this._isDerived = true;
    }

    ColorScheme(String string, String string2, int[] nArray, int n) {
        this._init(string, string2, nArray, n);
        this._isDerived = false;
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public String getDescription(Locale locale) {
        return this._description;
    }

    public Color getDefiningColor() {
        return this._getColorRamp()[2];
    }

    public ImageFilter createColorizingFilter() {
        return new ColorizingFilter(this.getColorMappingTable());
    }

    int _getSchemeIndex() {
        return this._schemeIndex;
    }

    boolean _isDerived() {
        return this._isDerived;
    }

    void _installCommonColors(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{"activeCaption", "#4", "activeCaptionText", "#0", "inactiveCaption", "#2", "inactiveCaptionText", "#1", "menu", "#1", "control", "#1", "scrollbar", "#2", "text", "#0", "textText", "#5", "textInactiveText", "#3", "textHighlightText", "#0", "infoText", "#5", SECONDARY_TEXT_HIGHLIGHT, "#6", LIGHT_INTENSITY, "#1", NORMAL_INTENSITY, "#2", DARK_INTENSITY, "#3", VERY_DARK_INTENSITY, "#4", LIGHT_LOOK, "#1", DARK_LOOK, "#3", VERY_DARK_LOOK, "#4"};
        this._initializeColors(uIDefaults, objectArray);
    }

    void _installLightColors(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{"window", "#1", "controlText", "#5", "controlHighlight", "#1", "controlLtHighlight", "#0", "controlShadow", "#2", "controlDkShadow", "#3", CONTROL_INACTIVE_TEXT, "#3", CONTROL_SHADOW_DARK, "#2", CONTROL_SHADOW_VERY_LIGHT, "#2", CONTROL_SHADOW_DARK_LIGHT, "#3"};
        this._initializeColors(uIDefaults, objectArray);
        __sControlText = uIDefaults.getColor("controlText");
    }

    void _installDarkColors(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{"window", "#3", "controlText", "#0", "controlHighlight", "#2", "controlLtHighlight", "#1", "controlShadow", "#3", "controlDkShadow", "#4", CONTROL_INACTIVE_TEXT, "#4", CONTROL_SHADOW_DARK, "#4", CONTROL_SHADOW_VERY_LIGHT, "#0", CONTROL_SHADOW_DARK_LIGHT, "#2"};
        this._initializeColors(uIDefaults, objectArray);
    }

    private void _initializeColors(UIDefaults uIDefaults, Object[] objectArray) {
        Color[] colorArray = this._getColorRamp();
        int n = 0;
        while (n < objectArray.length) {
            Color color = _sBlack;
            try {
                color = colorArray[Integer.decode((String)objectArray[n + 1])];
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            uIDefaults.put(objectArray[n], color);
            n += 2;
        }
    }

    int[] getColorMappingTable() {
        if (this._mappingTable == null) {
            int[] nArray = new int[256];
            int[] nArray2 = this._intRamp;
            int n = 0;
            int n2 = nArray2[0] >> 24 & 0xFF;
            int n3 = 255;
            while (n3 >= 0) {
                if (n3 == n2) {
                    nArray[n3] = nArray2[n] | 0xFF000000;
                    n2 = nArray2[++n] >> 24 & 0xFF;
                } else {
                    nArray[n3] = 0xFF000000 | (n3 << 16 | n3 << 8 | n3);
                }
                --n3;
            }
            this._mappingTable = nArray;
        }
        return this._mappingTable;
    }

    private Color[] _getColorRamp() {
        if (this._colorRamp == null) {
            int[] nArray = this._intRamp;
            int n = nArray.length;
            Color[] colorArray = new Color[n];
            int n2 = 0;
            while (n2 < n) {
                colorArray[n2] = new ColorUIResource(nArray[n2] | 0xFF000000);
                ++n2;
            }
            this._colorRamp = colorArray;
        }
        return this._colorRamp;
    }

    private void _remapColors(UIDefaults uIDefaults, Object[] objectArray) {
        Color[] colorArray = this._getColorRamp();
        int n = 0;
        while (n < objectArray.length) {
            Color color = _sBlack;
            try {
                color = colorArray[Integer.decode((String)objectArray[n + 1])];
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            uIDefaults.put(objectArray[n], color);
            n += 2;
        }
    }

    private void _init(String string, String string2, int[] nArray, int n) {
        this._name = string;
        this._description = string2;
        this._intRamp = nArray;
        this._schemeIndex = n;
    }

    void __setIntRamp(int[] nArray) {
        this._intRamp = nArray;
    }

    static {
        __sControlText = _sBlack = new ColorUIResource(Color.black);
    }
}

