/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public final class PreferredGridLayout
implements LayoutManager2 {
    public static final int UNLIMITED_COUNT = 0;
    public static final int NO_STRETCH = -1;
    private static final int _CALC_TYPE_PREFERRED = 0;
    private static final int _CALC_TYPE_MINIMUM = 1;
    private static final int _CALC_TYPE_MAXIMUM = 2;
    private Container _target;
    private int _hGap;
    private int _vGap;
    private int _numRows;
    private int _numColumns;
    private int _stretchRow;
    private int _stretchColumn;
    private transient int[] _preferredWidths;
    private transient int[] _preferredHeights;
    private transient Dimension _preferredSize;
    private transient Dimension _minimumSize;
    private transient Dimension _maximumSize;

    public PreferredGridLayout(Container container) {
        this(container, 1, 0);
    }

    public PreferredGridLayout(Container container, int n, int n2) {
        this(container, n, n2, 0, 0);
    }

    public PreferredGridLayout(Container container, int n, int n2, int n3, int n4) {
        this(container, n, n2, n3, n4, -1, -1);
    }

    public PreferredGridLayout(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        if (container == null) {
            throw new IllegalArgumentException();
        }
        this._checkCountException(n, n2);
        this._target = container;
        this._numRows = n;
        this._numColumns = n2;
        this._hGap = n3;
        this._vGap = n4;
        this._stretchRow = n5;
        this._stretchColumn = n6;
    }

    public void setRowCount(int n) {
        if (this._numRows != n) {
            this._checkCountException(n, this._numColumns);
            this._numRows = n;
            this._target.invalidate();
        }
    }

    public int getRowCount() {
        return this._numRows;
    }

    public void setColumnCount(int n) {
        if (this._numColumns != n) {
            this._checkCountException(this._numRows, n);
            this._numColumns = n;
            this._target.invalidate();
        }
    }

    public int getColumnCount() {
        return this._numColumns;
    }

    public void setHGap(int n) {
        if (this._hGap != n) {
            this._hGap = n;
            this._target.invalidate();
        }
    }

    public int getHGap() {
        return this._hGap;
    }

    public void setVGap(int n) {
        if (this._vGap != n) {
            this._vGap = n;
            this._target.invalidate();
        }
    }

    public int getVGap() {
        return this._vGap;
    }

    public float getLayoutAlignmentX(Container container) {
        this._checkTargetException(container);
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        this._checkTargetException(container);
        return 0.0f;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public Dimension preferredLayoutSize(Container container) {
        this._checkTargetException(container);
        if (this._preferredSize == null) {
            this._preferredSize = this._calculateSize(container, 0);
        }
        return new Dimension(this._preferredSize);
    }

    public Dimension minimumLayoutSize(Container container) {
        this._checkTargetException(container);
        if (this._minimumSize == null) {
            this._minimumSize = this._calculateSize(container, 1);
        }
        return new Dimension(this._minimumSize);
    }

    public Dimension maximumLayoutSize(Container container) {
        this._checkTargetException(container);
        if (this._maximumSize == null) {
            this._maximumSize = this._calculateSize(container, 2);
        }
        return new Dimension(this._maximumSize);
    }

    public void layoutContainer(Container container) {
        this._checkTargetException(container);
        Dimension dimension = this.preferredLayoutSize(container);
        Dimension dimension2 = container.getSize();
        int n = dimension2.width - dimension.width;
        int n2 = dimension2.height - dimension.height;
        int n3 = container.getComponentCount();
        int n4 = this._getNumRows(n3, this._numColumns);
        int n5 = this._getNumColumns(n3, this._numRows);
        int n6 = this._getStretchRow(n4);
        int n7 = this._getStretchColumn(n5);
        int[] nArray = this._preferredWidths;
        int[] nArray2 = this._preferredHeights;
        int n8 = this._hGap;
        int n9 = this._vGap;
        Insets insets = container.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int n10 = 0;
        int n11 = insets.top;
        int n12 = 0;
        while (n12 < n4) {
            int n13 = insets.left;
            int n14 = nArray2[n12];
            if (n12 == n6 && (n14 += n2) < 0) {
                n14 = 0;
            }
            int n15 = 0;
            while (n15 < n5) {
                n10 = this._getComponentIndex(n15, n12, n5);
                if (n10 < n3) {
                    int n16 = nArray[n15];
                    if (n15 == n7 && (n16 += n) < 0) {
                        n16 = 0;
                    }
                    container.getComponent(n10).setBounds(n13, n11, n16, n14);
                    n13 += n16 + n8;
                }
                ++n15;
            }
            n11 += n14 + n9;
            ++n12;
        }
    }

    public void invalidateLayout(Container container) {
        this._checkTargetException(container);
        this._preferredWidths = null;
        this._preferredHeights = null;
        this._preferredSize = null;
        this._minimumSize = null;
        this._maximumSize = null;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this._hGap + ",vgap=" + this._vGap + ",rows=" + this._numRows + ",cols=" + this._numColumns + "]";
    }

    private Dimension _calculateSize(Container container, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = container.getComponentCount();
        int n7 = this._getNumRows(n6, this._numColumns);
        int n8 = this._getNumColumns(n6, this._numRows);
        boolean bl = n == 0;
        boolean bl2 = n != 2;
        Dimension[] dimensionArray = new Dimension[n6];
        int n9 = 0;
        while (n9 < n6) {
            Component component = container.getComponent(n9);
            dimensionArray[n9] = component.getPreferredSize();
            ++n9;
        }
        this._preferredWidths = new int[n8];
        this._preferredHeights = new int[n7];
        int n10 = this._getStretchRow(n7);
        long l = 0L;
        int n11 = 0;
        while (n11 < n7) {
            n5 = !bl && n11 == n10 ? 1 : 0;
            int n12 = 0;
            int n13 = 0;
            while (n13 < n8) {
                n4 = this._getComponentIndex(n13, n11, n8);
                if (n4 < n6) {
                    n3 = dimensionArray[n4].height;
                    if (n5 != 0) {
                        Component component = container.getComponent(n4);
                        n3 = (bl2 ? component.getMinimumSize() : component.getMaximumSize()).height;
                    }
                    if (bl2) {
                        if (n12 < n3) {
                            n12 = n3;
                        }
                    } else if (n12 > n3) {
                        n12 = n3;
                    }
                }
                ++n13;
            }
            l += (long)n12;
            if (bl) {
                this._preferredHeights[n11] = n12;
            }
            ++n11;
        }
        n5 = this._getStretchColumn(n8);
        long l2 = 0L;
        n4 = 0;
        while (n4 < n8) {
            n3 = !bl && n4 == n5 ? 1 : 0;
            int n14 = 0;
            n2 = 0;
            while (n2 < n7) {
                int n15 = this._getComponentIndex(n4, n2, n8);
                if (n15 < n6) {
                    int n16 = dimensionArray[n15].width;
                    if (n3 != 0) {
                        Component component = container.getComponent(n15);
                        n16 = (bl2 ? component.getMinimumSize() : component.getMaximumSize()).width;
                    }
                    if (bl2) {
                        if (n14 < n16) {
                            n14 = n16;
                        }
                    } else if (n14 > n16) {
                        n14 = n16;
                    }
                }
                ++n2;
            }
            if (bl) {
                this._preferredWidths[n4] = n14;
            }
            l2 += (long)n14;
            ++n4;
        }
        Insets insets = container.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int n17 = (l2 += (long)(insets.left + insets.right + (n8 - 1) * this._hGap)) < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
        n2 = l < Integer.MAX_VALUE ? (int)(l += (long)(insets.top + insets.bottom + (n7 - 1) * this._vGap)) : Integer.MAX_VALUE;
        return new Dimension(n17, n2);
    }

    private void _checkTargetException(Container container) {
        if (this._target != container) {
            throw new IllegalStateException(this.getClass().getName() + " instances cannot be shared across containers");
        }
    }

    private void _checkCountException(int n, int n2) {
        String string = null;
        if (n == 0 && n2 == 0) {
            string = "number of rows and number of columns cannot both be unlimited";
        } else if (n < 0) {
            string = "number of rows cannot be negative";
        } else if (n2 < 0) {
            string = "number of columns cannot be negative";
        }
        if (string != null) {
            throw new IllegalArgumentException(string);
        }
    }

    private int _getComponentIndex(int n, int n2, int n3) {
        return n2 * n3 + n;
    }

    private int _getNumColumns(int n, int n2) {
        int n3 = this._numColumns;
        if (n3 == 0) {
            n3 = (n + this._numRows - 1) / this._numRows;
        }
        return n3;
    }

    private int _getNumRows(int n, int n2) {
        int n3 = this._numRows;
        if (this._numRows == 0) {
            n3 = (n + n2 - 1) / n2;
        }
        return n3;
    }

    private int _getStretchRow(int n) {
        int n2 = this._stretchRow;
        if (n2 >= n) {
            n2 = -1;
        }
        return n2;
    }

    private int _getStretchColumn(int n) {
        int n2 = this._stretchColumn;
        if (n2 >= n) {
            n2 = -1;
        }
        return n2;
    }
}

