/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import oracle.bali.ewt.grid.AbstractGridSelectionManager;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.collection.Range;

public class GeneralGridSelectionManager
extends AbstractGridSelectionManager {
    public static final int NONE = 0;
    public static final int SINGLE = 1;
    public static final int MULTIPLE = 2;
    protected static final int REPLACE = 0;
    protected static final int SUBTRACT = 1;
    protected static final int ADD = 2;
    private TwoDSelection _selection;
    private int _cellConstraint;
    private int _rowConstraint;
    private int _columnConstraint;
    private static GridSelectionManager _nullSelectionManager;

    public GeneralGridSelectionManager() {
        this(1, 1, 1);
    }

    public GeneralGridSelectionManager(int n, int n2, int n3) {
        this._columnConstraint = n;
        this._rowConstraint = n2;
        this._cellConstraint = n3;
    }

    public TwoDSelection getSelection() {
        if (this._selection == null) {
            this._selection = TwoDSelection.getEmptySelection();
        }
        return this._selection;
    }

    public void addSelection(TwoDSelection twoDSelection) throws PropertyVetoException {
        TwoDSelection twoDSelection2 = this._promote(twoDSelection);
        this._changeSelection(twoDSelection2, 2, false);
    }

    public void removeSelection(TwoDSelection twoDSelection) throws PropertyVetoException {
        TwoDSelection twoDSelection2 = this._promote(twoDSelection);
        this._changeSelection(twoDSelection2, 1, false);
    }

    public final void setSelection(TwoDSelection twoDSelection) throws PropertyVetoException {
        this.setSelection(twoDSelection, null);
    }

    public void setSelection(TwoDSelection twoDSelection, Cell cell) throws PropertyVetoException {
        if (twoDSelection == null) {
            twoDSelection = TwoDSelection.getEmptySelection();
        }
        TwoDSelection twoDSelection2 = this._promote(twoDSelection);
        if (cell == null || this.meetsConstraints(twoDSelection2)) {
            this._changeSelection(twoDSelection2, 0, false);
        } else {
            this._changeSelection(this._promote(new TwoDSelection(cell)), 0, false);
        }
    }

    public static GridSelectionManager createSingleColumnSelectionManager() {
        return new GeneralGridSelectionManager(1, 0, 0);
    }

    public static GridSelectionManager createSingleRowSelectionManager() {
        return new GeneralGridSelectionManager(0, 1, 0);
    }

    public static GridSelectionManager createSingleCellSelectionManager() {
        return new GeneralGridSelectionManager(0, 0, 1);
    }

    public static GridSelectionManager createMultipleColumnSelectionManager() {
        return new GeneralGridSelectionManager(2, 0, 0);
    }

    public static GridSelectionManager createMultipleRowSelectionManager() {
        return new GeneralGridSelectionManager(0, 2, 0);
    }

    public static GridSelectionManager createMultipleCellSelectionManager() {
        return new GeneralGridSelectionManager(0, 0, 2);
    }

    public static GridSelectionManager getNullGridSelectionManager() {
        if (_nullSelectionManager == null) {
            _nullSelectionManager = new GeneralGridSelectionManager(0, 0, 0){

                public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }

                public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }

                public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
                }

                public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
                }
            };
        }
        return _nullSelectionManager;
    }

    protected TwoDSelection modifySelection(TwoDSelection twoDSelection, TwoDSelection twoDSelection2, int n) {
        TwoDSelection twoDSelection3;
        twoDSelection2 = this.constrain(twoDSelection2);
        switch (n) {
            case 1: {
                twoDSelection3 = twoDSelection.subtract(twoDSelection2);
                break;
            }
            case 2: {
                twoDSelection3 = this._add(twoDSelection, twoDSelection2);
                break;
            }
            case 0: {
                if (this.meetsConstraints(twoDSelection2)) {
                    twoDSelection3 = twoDSelection2;
                    break;
                }
                twoDSelection3 = twoDSelection;
                break;
            }
            default: {
                twoDSelection3 = new TwoDSelection();
            }
        }
        return twoDSelection3;
    }

    protected void rowsAdded(int n, int n2) {
        TwoDSelection twoDSelection;
        TwoDSelection twoDSelection2 = this.getSelection();
        if (!twoDSelection2.equals(twoDSelection = twoDSelection2.addRows(n, n2))) {
            try {
                this._changeSelection(twoDSelection, 0, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    protected void rowsRemoved(int n, int n2) {
        TwoDSelection twoDSelection;
        TwoDSelection twoDSelection2 = this.getSelection();
        if (!twoDSelection2.equals(twoDSelection = twoDSelection2.removeRows(n, n2))) {
            try {
                this._changeSelection(twoDSelection, 0, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    protected void columnsAdded(int n, int n2) {
        TwoDSelection twoDSelection;
        TwoDSelection twoDSelection2 = this.getSelection();
        if (!twoDSelection2.equals(twoDSelection = twoDSelection2.addColumns(n, n2))) {
            try {
                this._changeSelection(twoDSelection, 0, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    protected void columnsRemoved(int n, int n2) {
        TwoDSelection twoDSelection;
        TwoDSelection twoDSelection2 = this.getSelection();
        if (!twoDSelection2.equals(twoDSelection = twoDSelection2.removeColumns(n, n2))) {
            try {
                this._changeSelection(twoDSelection, 0, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private TwoDSelection _promote(TwoDSelection twoDSelection) {
        CellRange[] cellRangeArray = twoDSelection.getCellRanges();
        if (this._cellConstraint == 0 && cellRangeArray != null && cellRangeArray.length > 0) {
            OneDSelection oneDSelection = null;
            OneDSelection oneDSelection2 = null;
            if (this._rowConstraint != 0) {
                oneDSelection = new OneDSelection(CellRange.rowRangesFromCellRanges(cellRangeArray));
            } else if (this._columnConstraint != 0) {
                oneDSelection2 = new OneDSelection(CellRange.columnRangesFromCellRanges(cellRangeArray));
            }
            if (oneDSelection != null) {
                return new TwoDSelection(null, oneDSelection);
            }
            if (oneDSelection2 != null) {
                return new TwoDSelection(oneDSelection2, null);
            }
            return twoDSelection;
        }
        return twoDSelection;
    }

    protected TwoDSelection constrain(TwoDSelection twoDSelection) {
        if (this.meetsConstraints(twoDSelection)) {
            return twoDSelection;
        }
        CellRange[] cellRangeArray = twoDSelection.getCellRanges();
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        OneDSelection oneDSelection2 = twoDSelection.getColumnSelection();
        if (this._cellConstraint == 0) {
            cellRangeArray = null;
        } else if (this._cellConstraint == 1) {
            if (cellRangeArray != null && cellRangeArray.length > 0) {
                CellRange[] cellRangeArray2 = new CellRange[]{new CellRange(cellRangeArray[0].getLowerLimit())};
                cellRangeArray = cellRangeArray2;
            } else {
                cellRangeArray = null;
            }
        }
        if (this._rowConstraint == 0 || oneDSelection.isEmpty()) {
            oneDSelection = null;
        } else if (this._rowConstraint == 1) {
            oneDSelection = new OneDSelection(oneDSelection.getSingleItem());
        }
        if (this._columnConstraint == 0 || oneDSelection2.isEmpty()) {
            oneDSelection2 = null;
        } else if (this._columnConstraint == 1) {
            oneDSelection2 = new OneDSelection(oneDSelection2.getSingleItem());
        }
        return new TwoDSelection(oneDSelection2, oneDSelection, cellRangeArray);
    }

    private void _changeSelection(TwoDSelection twoDSelection, int n, boolean bl) throws PropertyVetoException {
        TwoDSelection twoDSelection2;
        TwoDSelection twoDSelection3 = this.getSelection();
        if (twoDSelection3.equals(twoDSelection2 = this.modifySelection(twoDSelection3, twoDSelection, n))) {
            return;
        }
        if (!bl) {
            this.fireVetoableChange("selection", twoDSelection3, twoDSelection2);
        }
        this._selection = twoDSelection2;
        this.firePropertyChange("selection", twoDSelection3, twoDSelection2);
    }

    private TwoDSelection _add(TwoDSelection twoDSelection, TwoDSelection twoDSelection2) {
        CellRange[] cellRangeArray = null;
        Range[] rangeArray = null;
        Range[] rangeArray2 = null;
        CellRange[] cellRangeArray2 = twoDSelection2.getCellRanges();
        Range[] rangeArray3 = twoDSelection2.getColumnSelection().getRanges();
        Range[] rangeArray4 = twoDSelection2.getRowSelection().getRanges();
        if (cellRangeArray2 != null && cellRangeArray2.length > 0) {
            cellRangeArray = this._addCellRanges(twoDSelection, twoDSelection2);
        } else if (rangeArray3 != null && rangeArray3.length > 0) {
            rangeArray = this._addColumnRanges(twoDSelection, twoDSelection2);
        } else if (rangeArray4 != null && rangeArray4.length > 0) {
            rangeArray2 = this._addRowRanges(twoDSelection, twoDSelection2);
        }
        OneDSelection oneDSelection = null;
        OneDSelection oneDSelection2 = null;
        if (rangeArray != null && rangeArray.length > 0) {
            oneDSelection = new OneDSelection(rangeArray);
        }
        if (rangeArray2 != null && rangeArray2.length > 0) {
            oneDSelection2 = new OneDSelection(rangeArray2);
        }
        return new TwoDSelection(oneDSelection, oneDSelection2, cellRangeArray);
    }

    private CellRange[] _addCellRanges(TwoDSelection twoDSelection, TwoDSelection twoDSelection2) {
        if (this._cellConstraint != 0) {
            CellRange[] cellRangeArray = twoDSelection2.getCellRanges();
            CellRange[] cellRangeArray2 = twoDSelection.getCellRanges();
            if (cellRangeArray != null && cellRangeArray.length > 0) {
                if (this._cellConstraint == 1) {
                    CellRange[] cellRangeArray3 = new CellRange[]{cellRangeArray[0]};
                    return cellRangeArray3;
                }
                if (this._cellConstraint == 2) {
                    return CellRange.addCellRanges(cellRangeArray2, cellRangeArray);
                }
            } else if (cellRangeArray2 != null && cellRangeArray2.length > 0) {
                return cellRangeArray2;
            }
        }
        return null;
    }

    private Range[] _addColumnRanges(TwoDSelection twoDSelection, TwoDSelection twoDSelection2) {
        if (this._columnConstraint != 0) {
            Range[] rangeArray = twoDSelection2.getColumnSelection().getRanges();
            Range[] rangeArray2 = null;
            Range[] rangeArray3 = twoDSelection.getColumnSelection().getRanges();
            if (rangeArray != null && rangeArray.length > 0) {
                if (this._columnConstraint == 1) {
                    rangeArray2 = new Range[]{rangeArray[0]};
                    return rangeArray2;
                }
                if (this._columnConstraint == 2) {
                    return Range.addRanges((Range[])rangeArray3, (Range[])rangeArray);
                }
            } else if (rangeArray3 != null && rangeArray3.length > 0) {
                return rangeArray3;
            }
        }
        return null;
    }

    private Range[] _addRowRanges(TwoDSelection twoDSelection, TwoDSelection twoDSelection2) {
        if (this._rowConstraint != 0) {
            Range[] rangeArray = twoDSelection2.getRowSelection().getRanges();
            Range[] rangeArray2 = twoDSelection.getRowSelection().getRanges();
            if (rangeArray != null && rangeArray.length > 0) {
                if (this._rowConstraint == 1) {
                    Range[] rangeArray3 = new Range[]{rangeArray[0]};
                    return rangeArray3;
                }
                if (this._rowConstraint == 2) {
                    return Range.addRanges((Range[])rangeArray2, (Range[])rangeArray);
                }
            } else if (rangeArray2 != null && rangeArray2.length > 0) {
                return rangeArray2;
            }
        }
        return null;
    }

    protected boolean meetsConstraints(TwoDSelection twoDSelection) {
        CellRange[] cellRangeArray = twoDSelection.getCellRanges();
        Range[] rangeArray = twoDSelection.getColumnSelection().getRanges();
        Range[] rangeArray2 = twoDSelection.getRowSelection().getRanges();
        int n = cellRangeArray == null || cellRangeArray.length == 0 ? 0 : (cellRangeArray.length > 1 ? 2 : (cellRangeArray[0].getUpperLimit().equals(cellRangeArray[0].getLowerLimit()) ? 1 : 2));
        int n2 = rangeArray == null || rangeArray.length == 0 ? 0 : (rangeArray.length > 1 ? 2 : (rangeArray[0].getUpperLimit() == rangeArray[0].getLowerLimit() ? 1 : 2));
        int n3 = rangeArray2 == null || rangeArray2.length == 0 ? 0 : (rangeArray2.length > 1 ? 2 : (rangeArray2[0].getUpperLimit() == rangeArray2[0].getLowerLimit() ? 1 : 2));
        return n <= this._cellConstraint && n2 <= this._columnConstraint && n3 <= this._rowConstraint;
    }
}

