/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.Cell;

public class ComboBoxInputHandler
extends CellInputHandler {
    private static JComboBox _combobox;
    static boolean _dirty;
    private Object[] _items;
    private boolean _editable;

    public ComboBoxInputHandler() {
        this(null, false);
    }

    public ComboBoxInputHandler(boolean bl) {
        this(null, bl);
    }

    public ComboBoxInputHandler(Object[] objectArray) {
        this(objectArray, false);
    }

    public ComboBoxInputHandler(Object[] objectArray, boolean bl) {
        this.setItems(objectArray);
        this.setEditable(bl);
    }

    public void setItems(Object[] objectArray) {
        if (this._items != null) {
            int n = 0;
            while (n < this._items.length) {
                this._items[n] = null;
                ++n;
            }
        }
        this._items = null;
        if (objectArray != null) {
            this._items = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, this._items, 0, objectArray.length);
        }
    }

    public Object[] getItems() {
        if (this._items == null) {
            return null;
        }
        Object[] objectArray = new Object[this._items.length];
        System.arraycopy(this._items, 0, objectArray, 0, this._items.length);
        return objectArray;
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void updateUI() {
        if (_combobox != null) {
            SwingUtilities.updateComponentTreeUI(_combobox);
        }
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        super.mousePressed(mouseEvent, grid, n, n2);
        Cell cell = grid.getFocusCell();
        if (cell != null && cell.column == n && cell.row == n2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            grid.startCellEdit(n, n2);
        }
    }

    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
        if (aWTEvent instanceof MouseEvent) {
            grid.startCellEdit(n, n2);
        }
    }

    public synchronized Component getEditControl(Grid grid, int n, int n2) {
        if (_combobox == null) {
            _combobox = new CBIHJComboBox();
            _combobox.addItemListener(new Dirty());
        }
        _combobox.setEditable(this.isEditable());
        return _combobox;
    }

    public boolean isDirty(Grid grid, int n, int n2) {
        return _dirty;
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
        JComboBox jComboBox = (JComboBox)this.getEditControl(grid, n, n2);
        if (jComboBox.getItemCount() > 0) {
            jComboBox.removeAllItems();
        }
        if (this._items != null) {
            int n3 = 0;
            while (n3 < this._items.length) {
                jComboBox.addItem(this._items[n3]);
                ++n3;
            }
        } else if (object != null) {
            jComboBox.addItem(object);
        }
        if (object != null) {
            jComboBox.setSelectedItem(object);
            _dirty = false;
        } else if (!this.isEditable()) {
            _dirty = true;
        } else {
            jComboBox.setSelectedItem(null);
            _dirty = false;
        }
    }

    public synchronized Object commitEdit(Grid grid, int n, int n2) {
        JComboBox jComboBox = (JComboBox)this.getEditControl(grid, n, n2);
        Object object = jComboBox.getSelectedItem();
        return object;
    }

    public Component[] getFocusableComponents(Grid grid, int n, int n2) {
        Component[] componentArray = super.getFocusableComponents(grid, n, n2);
        JComboBox jComboBox = (JComboBox)this.getEditControl(grid, n, n2);
        Component component = null;
        Vector<Component> vector = new Vector<Component>(2);
        int n3 = jComboBox.getComponentCount();
        int n4 = 0;
        while (n4 < n3) {
            component = jComboBox.getComponent(n4);
            if (component instanceof JComponent && ((JComponent)component).isRequestFocusEnabled()) {
                vector.addElement(component);
            }
            ++n4;
        }
        if (vector.size() == 0) {
            return componentArray;
        }
        Component[] componentArray2 = new Component[componentArray.length + vector.size()];
        System.arraycopy(componentArray, 0, componentArray2, 0, componentArray.length);
        int n5 = 0;
        while (n5 < vector.size()) {
            componentArray2[componentArray.length + n5] = (Component)vector.elementAt(n5);
            ++n5;
        }
        return componentArray2;
    }

    private static class Dirty
    implements ItemListener {
        private Dirty() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            _dirty = true;
        }
    }

    public static class CBIHJComboBox
    extends JComboBox {
        public void requestFocus() {
            int n = this.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = this.getComponent(n2);
                if (component instanceof JComponent && ((JComponent)component).isRequestFocusEnabled()) {
                    component.requestFocus();
                    return;
                }
                ++n2;
            }
            super.requestFocus();
        }
    }
}

