/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageLoader;
import oracle.bali.ewt.graphics.TransparencyFilter;

public class ImageUtils {
    private static final String _NOLOAD_DATA = "GIF89a\u000e\u0000\u0010\u0000\u00b3\u0000\u0000\u0000\u0000\u0000\u0080\u0000\u0000\u0000\u0080\u0000\u0080\u0080\u0000\u0000\u0000\u0080\u0080\u0000\u0080\u0000\u0080\u0080\u00c0\u00c0\u00c0\u0080\u0080\u0080\u00ff\u0000\u0000\u0000\u00ff\u0000\u00ff\u00ff\u0000\u0000\u0000\u00ff\u00ff\u0000\u00ff\u0000\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u000f\u0000,\u0000\u0000\u0000\u0000\u000e\u0000\u0010\u0000\u0000\u0004I\u0010\u00c8I\u00d1\u00bb\u00e0\u00ea\u008d\u00ec\u00cbG(\u0086\u0096\u0005\u0086\u0082 z\u00c8)(\u0002\u0010Rn*\u008b\u00dfyH\u00e3\u0091?\u00bd\u0003c\u0098\u0091\u0000\u0013#\u0086\u0083Q\u00045\u0090\u00a1!\u00a1\tl<g\u0093\u00df\u00c1z\u001dii^c0\u009c\u00d9\u00981\u00b4\u00f4$\u0002\u0000;";
    private static Image _sNotLoadedImage;

    public static Image createImage(Icon icon, Component component) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        Image image = component.createImage(n, n2);
        Color color = new Color(252, 1, 253);
        Graphics graphics = image.getGraphics();
        try {
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            int[] nArray = new int[1];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, nArray, 0, n);
            try {
                pixelGrabber.grabPixels();
                color = new Color(nArray[0]);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            icon.paintIcon(component, graphics, 0, 0);
            Object var11_10 = null;
            graphics.dispose();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            graphics.dispose();
            throw throwable;
        }
        return ImageUtils.createFilteredImage(image, new TransparencyFilter(color));
    }

    public static Image createFilteredImage(Image image, ImageFilter imageFilter) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static Image createDisabledImage(Image image) {
        Object object = UIManager.get("disablingFilter");
        ImageFilter imageFilter = object instanceof ImageFilter ? (ImageFilter)object : null;
        Image image2 = null;
        image2 = imageFilter != null ? ImageUtils.createFilteredImage(image, imageFilter) : GrayFilter.createDisabledImage(image);
        ImageUtils.loadImage(image2);
        return image2;
    }

    public static Image getImageResource(Class clazz, String string) {
        Image image = ImageUtils._getImageResource(clazz, string);
        if (image == null) {
            image = ImageUtils.getNotLoadedImage();
        }
        return image;
    }

    public static Image getNotLoadedImage() {
        if (_sNotLoadedImage == null) {
            _sNotLoadedImage = ImageUtils._createImage(_NOLOAD_DATA);
        }
        return _sNotLoadedImage;
    }

    public static boolean isImageLoaded(Image image) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = toolkit.checkImage(image, -1, -1, null);
        return (n & 0x30) != 0;
    }

    public static boolean loadImage(Image image) {
        if (!ImageUtils.isImageLoaded(image)) {
            ImageLoader imageLoader = new ImageLoader(image);
            imageLoader.start();
            return imageLoader.waitFor();
        }
        return true;
    }

    public static boolean loadImages(Image[] imageArray) {
        boolean bl = true;
        ImageLoader[] imageLoaderArray = new ImageLoader[imageArray.length];
        int n = 0;
        while (n < imageArray.length) {
            imageLoaderArray[n] = new ImageLoader(imageArray[n]);
            imageLoaderArray[n].start();
            ++n;
        }
        int n2 = 0;
        while (n2 < imageArray.length) {
            bl = bl && imageLoaderArray[n2].waitFor();
            ++n2;
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    private static Image _getImageResource(Class clazz, String string) {
        Object object;
        Object object2;
        byte[] byArray;
        Image image;
        block20: {
            image = null;
            byArray = null;
            InputStream inputStream = clazz.getResourceAsStream(string);
            if (inputStream != null) {
                int n;
                object2 = new BufferedInputStream(inputStream);
                object = new ByteArrayOutputStream(1024);
                byArray = new byte[1024];
                while ((n = ((FilterInputStream)object2).read(byArray)) > 0) {
                    ((ByteArrayOutputStream)object).write(byArray, 0, n);
                }
                ((OutputStream)object).flush();
                byArray = ((ByteArrayOutputStream)object).toByteArray();
                Object var9_11 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                break block20;
                {
                    catch (IOException iOException) {
                        Object var9_12 = null;
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (byArray != null && !ImageUtils.loadImage(image = Toolkit.getDefaultToolkit().createImage(byArray))) {
            image = null;
        }
        if (image != null) {
            return image;
        }
        object2 = clazz.getResource(string);
        if (object2 != null) {
            try {
                object = ((URL)object2).getContent();
                if (object instanceof ImageProducer) {
                    ImageProducer imageProducer = (ImageProducer)object;
                    image = Toolkit.getDefaultToolkit().createImage(imageProducer);
                } else if (object instanceof Image) {
                    image = (Image)object;
                }
                if (image != null) {
                    if (ImageUtils.loadImage(image)) {
                        return image;
                    }
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private ImageUtils() {
    }

    private static Image _createImage(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)string.charAt(n2);
            ++n2;
        }
        return Toolkit.getDefaultToolkit().createImage(byArray);
    }
}

