/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.elaf.EWTHeaderUI;
import oracle.bali.ewt.elaf.EWTTableUI;
import oracle.bali.ewt.elaf.basic.BasicEWTTableUI;
import oracle.bali.ewt.elaf.windows.WindowsCornerComponentPainter;
import oracle.bali.ewt.elaf.windows.WindowsInsetBorderPainter;
import oracle.bali.ewt.elaf.windows.WindowsTableGeometryHelper;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.table.SpreadTable;

public class WindowsEWTTableUI
extends BasicEWTTableUI {
    private static final Border _BORDER = new BorderAdapter(new WindowsInsetBorderPainter(false));
    private static Painter[] _sCornerPainters = new Painter[4];
    private static WindowsEWTTableUI _sInstance;

    protected WindowsEWTTableUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (_sInstance == null) {
            _sInstance = new WindowsEWTTableUI();
        }
        return _sInstance;
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("EWTTable.border".equals(object)) {
            return _BORDER;
        }
        if ("EWTTable.scrollPaneBorder".equals(object)) {
            return _BORDER;
        }
        return null;
    }

    public Painter getCornerPainter(JComponent jComponent, int n) {
        Painter painter = null;
        if (n >= 0 && n <= 3) {
            painter = _sCornerPainters[n];
            if (painter == null) {
                painter = new WindowsCornerComponentPainter(EWTTableUI.KEY_DRAW_RAISED, true, n);
            }
            WindowsEWTTableUI._sCornerPainters[n] = painter;
        }
        if (painter == null) {
            painter = NullPainter.getPainter();
        }
        return painter;
    }

    public void updateGeometry(JComponent jComponent) {
        SpreadTable spreadTable = (SpreadTable)jComponent;
        BorderPainter borderPainter = null;
        if (spreadTable.isRowHeaderVisible()) {
            Header header = spreadTable.getRowHeader();
            borderPainter = ((EWTHeaderUI)UIManager.getUI(header)).getHeaderItemBorderPainter(header);
        }
        WindowsTableGeometryHelper.updateGeometry((SpreadTable)jComponent, borderPainter);
    }

    public int getDefaultColumnHeaderHeight(JComponent jComponent) {
        SpreadTable spreadTable = (SpreadTable)jComponent;
        if (spreadTable.isRowHeaderVisible()) {
            return spreadTable.getGrid().getDefaultRowHeight();
        }
        return spreadTable.getGrid().getDefaultRowHeight() + 2 + 2;
    }
}

