/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.elaf.basic.BasicEWTSpinButtonUI;
import oracle.bali.ewt.graphics.ImageSetIcon;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.graphics.ImageUtils;

public class WindowsEWTSpinButtonUI
extends BasicEWTSpinButtonUI {
    private static Insets _sMargin = new Insets(0, 0, 0, 0);
    private static final Icon[] _sSpinIcons = new Icon[2];

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsEWTSpinButtonUI();
    }

    protected AbstractButton createIncrementButton(JComponent jComponent) {
        return this._createButton(true);
    }

    protected AbstractButton createDecrementButton(JComponent jComponent) {
        return this._createButton(false);
    }

    private AbstractButton _createButton(boolean bl) {
        Button button = new Button();
        button.setIcon(this._getCachedIcon(bl));
        button.setBorder(UIManager.getBorder("Button.border"));
        button.setMargin(_sMargin);
        button.setDefaultCapable(false);
        return button;
    }

    private Icon _getCachedIcon(boolean bl) {
        Icon icon;
        int n = 0;
        if (bl) {
            ++n;
        }
        if ((icon = _sSpinIcons[n]) == null) {
            String string = bl ? "icons/spinUpStrip.gif" : "icons/spinDownStrip.gif";
            WindowsEWTSpinButtonUI._sSpinIcons[n] = icon = new ImageSetIcon(new ImageStrip(ImageUtils.getImageResource(this.getClass(), string), 3));
        }
        return icon;
    }

    private WindowsEWTSpinButtonUI() {
    }

    private static class Button
    extends JButton {
        private Button() {
        }

        public void requestFocus() {
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

