/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.elaf.basic.BasicEWTArrowBoxUI;
import oracle.bali.ewt.elaf.basic.BasicUIUtils;
import oracle.bali.ewt.elaf.windows.WindowsInsetBorderPainter;
import oracle.bali.ewt.graphics.ImageSetIcon;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.scrolling.ArrowBox;

public class WindowsEWTArrowBoxUI
extends BasicEWTArrowBoxUI {
    private static final Border _BORDER = new BorderUIResource(new BorderAdapter(new WindowsInsetBorderPainter(false)));
    private static WindowsEWTArrowBoxUI _sInstance;
    private static Insets _sMargin;
    private static final Icon[] _sIcons;

    public static ComponentUI createUI(JComponent jComponent) {
        if (_sInstance == null) {
            _sInstance = new WindowsEWTArrowBoxUI();
        }
        return _sInstance;
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("EWTArrowBox.border".equals(object)) {
            return _BORDER;
        }
        return null;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Color color = graphics.getColor();
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(jComponent.getX(), jComponent.getY(), jComponent.getWidth(), jComponent.getHeight());
        graphics.setColor(color);
    }

    public AbstractButton getIncrementButton(JComponent jComponent) {
        return this._createButton(jComponent, true);
    }

    public AbstractButton getDecrementButton(JComponent jComponent) {
        return this._createButton(jComponent, false);
    }

    protected Insets getButtonMargin() {
        return _sMargin;
    }

    protected WindowsEWTArrowBoxUI() {
    }

    private AbstractButton _createButton(JComponent jComponent, boolean bl) {
        ArrowBox arrowBox = (ArrowBox)jComponent;
        boolean bl2 = arrowBox.getOrientation() == 0;
        Button button = new Button();
        button.setIcon(this._getCachedIcon(bl, bl2));
        button.setBorder(UIManager.getBorder("Button.border"));
        button.setMargin(this.getButtonMargin());
        return button;
    }

    private Icon _getCachedIcon(boolean bl, boolean bl2) {
        Icon icon;
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl2) {
            n += 2;
        }
        if ((icon = _sIcons[n]) == null) {
            int n2 = bl ? (bl2 ? 4 : 3) : (bl2 ? 2 : 1);
            WindowsEWTArrowBoxUI._sIcons[n] = icon = new ImageSetIcon(new ImageStrip(BasicUIUtils.getArrowStrip(n2), 1));
        }
        return icon;
    }

    static {
        _sMargin = new Insets(0, 0, 0, 0);
        _sIcons = new Icon[4];
    }

    private static class Button
    extends JButton {
        private Button() {
        }

        public void requestFocus() {
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

