/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.elaf.EWTPivotTableUI;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotTable;

class OraclePivotCornerPainter
extends AbstractPainter {
    public static final int UPPER_LEFT = 3;
    public static final int UPPER_RIGHT = 1;
    private static Painter _sUpperLeft;
    private static Painter _sUpperRight;
    private int _corner;

    private OraclePivotCornerPainter(int n) {
        this._corner = n;
    }

    public static Painter getPainter() {
        return OraclePivotCornerPainter.getPainter(3);
    }

    public static Painter getPainter(int n) {
        Painter painter = null;
        switch (n) {
            case 3: {
                if (_sUpperLeft == null) {
                    _sUpperLeft = new OraclePivotCornerPainter(3);
                }
                painter = _sUpperLeft;
                break;
            }
            case 1: {
                if (_sUpperRight == null) {
                    _sUpperRight = new OraclePivotCornerPainter(1);
                }
                painter = _sUpperRight;
            }
        }
        return painter;
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        return new Dimension(0, 0);
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return 128;
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        switch (this._corner) {
            case 3: {
                this._paintUpperLeft(paintContext, graphics, n, n2, n3, n4);
                break;
            }
            case 1: {
                this._paintUpperRight(paintContext, graphics, n, n2, n3, n4);
            }
        }
        if (color != null) {
            graphics.setColor(color);
        }
    }

    private void _paintUpperLeft(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        int n5 = n2 + n4 - 1;
        int n6 = n + n3 - 1;
        Color color = null;
        int n7 = paintContext.getPaintState();
        if ((n7 & 1) == 0 && (object = paintContext.getPaintData(PivotTable.KEY_CORNER_BORDER_COLOR)) instanceof Color) {
            color = (Color)object;
        }
        if (color == null) {
            color = uIDefaults.getColor("EWTPivot.darkShadow");
        }
        object = paintContext.getPaintData(EWTPivotTableUI.HORIZONTAL_KEY);
        boolean bl = Boolean.TRUE.equals(object);
        Object object2 = paintContext.getPaintData(EWTPivotTableUI.VERTICAL_KEY);
        boolean bl2 = Boolean.TRUE.equals(object2);
        graphics.setColor(paintContext.getPaintBackground());
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(color);
        if (bl) {
            graphics.drawLine(n, n5, n6, n5);
        }
        if (bl2) {
            graphics.drawLine(n6, n2, n6, n5);
        }
    }

    private void _paintUpperRight(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        int n5 = n2 + n4 - 1;
        int n6 = n + n3 - 1;
        Color color = uIDefaults.getColor("EWTPivot.darkShadow");
        Object object = paintContext.getPaintData(EWTPivotTableUI.HORIZONTAL_KEY);
        boolean bl = Boolean.TRUE.equals(object);
        Object object2 = paintContext.getPaintData(EWTPivotTableUI.VERTICAL_KEY);
        boolean bl2 = Boolean.TRUE.equals(object2);
        graphics.setColor(paintContext.getPaintBackground());
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(color);
        if (bl2) {
            graphics.drawLine(n, n2, n, n5);
        }
        if (bl) {
            graphics.drawLine(n, n5, n6, n5);
        }
    }
}

