/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.print.PrinterGraphics;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class PivotGrippyPainter
extends AbstractPainter {
    private static final int _GRIPPY_SIZE = 3;
    private static final int _GRIPPY_GAP = 4;
    private static final int _GRIPPY_STRIDE = 7;
    private static final int _MIN_GRIPPIES = 3;
    private static final int _MIN_PERP_GRIPPY_SIZE = 7;
    private static final int _MIN_ORIENT_GRIPPY_SIZE = 17;
    private boolean _isHorizontal;
    private boolean _ignoreActive;
    private static Painter _sVerticalPainter;
    private static Painter _sHorizontalPainter;
    private static Painter _sIgnoreActiveVerticalPainter;
    private static Painter _sIgnoreActiveHorizontalPainter;

    public static Painter getPainter(boolean bl) {
        return PivotGrippyPainter.getPainter(bl, false);
    }

    public static Painter getPainter(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                if (_sIgnoreActiveHorizontalPainter == null) {
                    _sIgnoreActiveHorizontalPainter = new PivotGrippyPainter(true, true);
                }
                return _sIgnoreActiveHorizontalPainter;
            }
            if (_sHorizontalPainter == null) {
                _sHorizontalPainter = new PivotGrippyPainter(true, false);
            }
            return _sHorizontalPainter;
        }
        if (bl2) {
            if (_sIgnoreActiveVerticalPainter == null) {
                _sIgnoreActiveVerticalPainter = new PivotGrippyPainter(false, true);
            }
            return _sIgnoreActiveVerticalPainter;
        }
        if (_sVerticalPainter == null) {
            _sVerticalPainter = new PivotGrippyPainter(false, false);
        }
        return _sVerticalPainter;
    }

    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        if (this._isHorizontal) {
            if (n > 17) {
                n = 17;
            }
            if (n2 > 7) {
                n2 = 7;
            }
        } else {
            if (n > 7) {
                n = 7;
            }
            if (n2 > 17) {
                n2 = 17;
            }
        }
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        if (this._isHorizontal) {
            return new Dimension(17, 7);
        }
        return new Dimension(7, 17);
    }

    public int getRepaintFlags(PaintContext paintContext) {
        int n = 131;
        if (!this._ignoreActive) {
            n |= 4;
        }
        return n;
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2;
        int n5;
        boolean bl3;
        Color color = graphics.getColor();
        boolean bl4 = bl3 = graphics instanceof PrintGraphics || graphics instanceof PrinterGraphics;
        if (!bl3) {
            Color color2 = UIManager.getColor("EWTPivotPivotGrippy.background");
            graphics.setColor(color2);
            graphics.fillRect(n, n2, n3, n4);
            color2 = UIManager.getColor("EWTPivotPivotGrippy.border");
            graphics.setColor(color2);
            graphics.drawRect(n, n2, n3, n4);
        }
        boolean bl5 = ((n5 = paintContext.getPaintState()) & 1) == 0;
        boolean bl6 = bl2 = (n5 & 4) == 0;
        if (this._ignoreActive) {
            bl2 = true;
        }
        boolean bl7 = bl3 ? false : (bl = bl5 && bl2);
        if (bl) {
            int n6 = 3;
            if (this._isHorizontal) {
                n6 = 4;
            }
            int n7 = n6 * 3 + (n6 - 1) * 4;
            int n8 = 3;
            int n9 = 3;
            int n10 = 0;
            int n11 = 0;
            if (this._isHorizontal) {
                n8 = n7;
                n10 = 7;
            } else {
                n9 = n7;
                n11 = 7;
            }
            int n12 = n + (n3 - n8) / 2;
            int n13 = n2 + (n4 - n9) / 2;
            UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
            Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
            Color color4 = uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW);
            Color color5 = uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
            Color color6 = Color.black;
            boolean bl8 = (n5 & 2) != 0;
            while (n6 > 0) {
                if (this._isHorizontal) {
                    PivotGrippyPainter.__drawHorizontalGrippy(graphics, n12, n13, color3, color5, color6, bl8);
                } else {
                    PivotGrippyPainter.__drawVerticalGrippy(graphics, n12, n13, color3, color5, color6, bl8);
                }
                --n6;
                n12 += n10;
                n13 += n11;
            }
        }
        graphics.setColor(color);
    }

    static void __drawHorizontalGrippy(Graphics graphics, int n, int n2, Color color, Color color2, Color color3, boolean bl) {
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2 + 2, n + 2, n2 + 1);
        if (bl) {
            graphics.setColor(color);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
            graphics.setColor(color3);
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
        } else {
            graphics.setColor(color3);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
            graphics.setColor(color);
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
        }
    }

    static void __drawVerticalGrippy(Graphics graphics, int n, int n2, Color color, Color color2, Color color3, boolean bl) {
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2 + 1, n + 2, n2 + 2);
        if (bl) {
            graphics.setColor(color3);
            graphics.drawLine(n + 2, n2 + 1, n + 2, n2 + 1);
            graphics.setColor(color);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 2);
        } else {
            graphics.setColor(color);
            graphics.drawLine(n + 2, n2 + 1, n + 2, n2 + 1);
            graphics.setColor(color3);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 2);
        }
    }

    private PivotGrippyPainter(boolean bl, boolean bl2) {
        this._isHorizontal = bl;
        this._ignoreActive = bl2;
    }
}

