/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dnd;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import oracle.bali.ewt.dnd.DnDUtils;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceContext;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetContext;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;

class DragTracker
extends MouseAdapter
implements MouseMotionListener,
KeyListener {
    private DragSourceContext _dragContext;
    private DropTargetContext _dropContext;
    private DropTarget _target;
    private Point _localPoint;
    private int _gestureModifiers;
    private Component _topmostParent;
    private Point _dragOverPoint;
    private boolean _dropOccurred;
    private Component _keyComponent;
    private Image _dragImage;
    private Point _offset;
    private static DragTracker _sDragTracker;

    public DragTracker(DragSourceContext dragSourceContext, Image image, Point point) {
        this._dragContext = dragSourceContext;
        this._dragImage = image;
        if (point != null) {
            this._offset = new Point(point);
        }
    }

    public void init(InputEvent inputEvent) {
        if (inputEvent instanceof MouseEvent) {
            this.mouseDragged((MouseEvent)inputEvent);
        } else {
            this._gestureModifiers = inputEvent.getModifiers();
        }
        this._keyComponent = null;
        if (this._keyComponent == null) {
            this._keyComponent = this._dragContext.getComponent();
            this._keyComponent.requestFocus();
        }
        if (this._keyComponent != null) {
            this._keyComponent.addKeyListener(this);
        }
        _sDragTracker = this;
    }

    public void setDragImage(Image image) {
        this._dragImage = image;
    }

    public Image getDragImage() {
        return this._dragImage;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        DropTarget dropTarget = this._target;
        this.eraseHighlight();
        this._topmostParent = null;
        if (dropTarget != null && dropTarget.isActive()) {
            dropTarget.drop(new DropTargetDropEvent(dropTarget.getDropTargetContext(), this._localPoint, this._getDropAction(), this._dragContext.getSourceActions(), true));
            this._dropOccurred = true;
        }
        this.terminateDrag(false);
        mouseEvent.consume();
        _sDragTracker = null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this._dragContext.cancelDrag();
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point;
        this.eraseHighlight();
        Component component = (Component)mouseEvent.getSource();
        this._localPoint = point = new Point(mouseEvent.getX(), mouseEvent.getY());
        this._updateModifiers(mouseEvent);
        Component component2 = DnDUtils.getTargetComponentOutside(component, point);
        DropTarget dropTarget = DnDUtils.getEWTDropTarget(component2);
        if (dropTarget != null && !dropTarget.isActive()) {
            dropTarget = null;
        }
        DropTarget dropTarget2 = this._target;
        DragSourceContext dragSourceContext = this._dragContext;
        DragSource dragSource = dragSourceContext.getDragSource();
        if (dropTarget2 != dropTarget) {
            try {
                if (dropTarget2 != null) {
                    dropTarget2.dragExit(new DropTargetEvent(this._dropContext));
                    dragSourceContext.dragExit(new DragSourceEvent(dragSourceContext));
                    this._dropContext = null;
                }
                if (dropTarget != null) {
                    this._dropContext = dropTarget.getDropTargetContext();
                    dropTarget.dragEnter(this._createDropTargetDragEvent(point));
                    dropTarget.dragOver(this._createDropTargetDragEvent(point));
                    dragSourceContext.dragEnter(this._createDragSourceDragEvent());
                }
                this._target = dropTarget;
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                throw throwable;
            }
        } else if (dropTarget != null) {
            dropTarget.dragOver(this._createDropTargetDragEvent(point));
            dragSourceContext.dragOver(this._createDragSourceDragEvent());
        }
        this._dragOverPoint = new Point(point);
        this._topmostParent = DnDUtils.getTopmostParent(component2, this._dragOverPoint);
        Point point2 = this._offset;
        if (point2 != null) {
            this._dragOverPoint.x += point2.x;
            this._dragOverPoint.y += point2.y;
        }
        this.drawHighlight();
        mouseEvent.consume();
    }

    public void eraseHighlight() {
        Component component = this._topmostParent;
        if (component == null) {
            return;
        }
        Point point = this._dragOverPoint;
        if (point == null) {
            return;
        }
        Image image = this._dragImage;
        if (image != null) {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            DnDUtils.paintImmediate(component, point.x, point.y, n, n2);
        }
    }

    public void drawHighlight() {
        Component component = this._topmostParent;
        if (component == null) {
            return;
        }
        Point point = this._dragOverPoint;
        if (point == null) {
            return;
        }
        Image image = this._dragImage;
        if (image != null) {
            Graphics graphics = component.getGraphics();
            graphics.drawImage(image, point.x, point.y, null);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this._dragContext.cancelDrag();
            keyEvent.consume();
            return;
        }
        this._updateModifiers(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this._updateModifiers(keyEvent);
    }

    public void terminateDrag(boolean bl) {
        DragSourceContext dragSourceContext = this._dragContext;
        this.eraseHighlight();
        if (this._dropContext != null) {
            if (bl) {
                this._target.dragExit(this._createDropTargetDragEvent(this._localPoint));
            }
            this._target = null;
            this._dropContext = null;
        }
        Component component = dragSourceContext.getComponent();
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        if (this._keyComponent != null) {
            this._keyComponent.removeKeyListener(this);
        }
        DragSourceDropEvent dragSourceDropEvent = this._dropOccurred ? new DragSourceDropEvent(dragSourceContext, dragSourceContext.getDragOperation(), dragSourceContext.getDragSucceded()) : new DragSourceDropEvent(dragSourceContext);
        dragSourceContext.dragDropEnd(dragSourceDropEvent);
        DragSource.setCurrentDragSourceContext(null);
    }

    static void eraseFeedback() {
        DragTracker dragTracker = _sDragTracker;
        if (dragTracker != null) {
            dragTracker.eraseHighlight();
        }
    }

    static void drawFeedback() {
        DragTracker dragTracker = _sDragTracker;
        if (dragTracker != null) {
            dragTracker.drawHighlight();
        }
    }

    private DropTargetDragEvent _createDropTargetDragEvent(Point point) {
        return new DropTargetDragEvent(this._dropContext, new Point(point), this._getDropAction(), this._dragContext.getSourceActions());
    }

    private DragSourceDragEvent _createDragSourceDragEvent() {
        return new DragSourceDragEvent(this._dragContext, this._getDropAction(), this._getTargetActions(), this._gestureModifiers, true);
    }

    private int _getTargetActions() {
        return this._dropContext == null ? 0 : this._dropContext.getTargetActions() & this._dragContext.getSourceActions();
    }

    private void _updateModifiers(InputEvent inputEvent) {
        int n = inputEvent.getModifiers();
        if (n != this._gestureModifiers) {
            this._gestureModifiers = n;
            this._dragContext.dropActionChanged(this._createDragSourceDragEvent());
            DropTarget dropTarget = this._target;
            if (dropTarget != null) {
                dropTarget.dropActionChanged(this._createDropTargetDragEvent(this._localPoint));
            }
        }
    }

    private int _getUserActions() {
        return DnDUtils.getDefaultActions(this._gestureModifiers);
    }

    private int _getDropAction() {
        int n = this._getUserActions();
        int n2 = this._dragContext.getSourceActions();
        int n3 = this._dropContext != null ? this._dropContext.getTargetActions() : 0;
        int n4 = n2 & n3;
        if ((n4 &= 0x40000003) != 0) {
            if ((n4 & n) != 0) {
                n4 &= n;
            }
            if (n4 != 1 & n4 != 2 & n4 != 0x40000000) {
                int n5 = 2;
                int n6 = 1;
                n4 = (n4 & n5) != 0 ? n5 : ((n4 & n6) != 0 ? n6 : 0x40000000);
            }
        }
        return n4;
    }
}

