/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import oracle.bali.ewt.dTree.DTreeItem;

public class DTreeRange {
    private DTreeItem _parent;
    private int _start;
    private int _count;

    public DTreeRange(DTreeItem dTreeItem, int n, int n2) {
        this._parent = dTreeItem;
        this._start = n;
        this._count = n2;
    }

    public boolean contains(DTreeItem dTreeItem, int n) {
        return dTreeItem == this._parent && n >= this._start && n < this._start + this._count;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTreeRange)) {
            return false;
        }
        DTreeRange dTreeRange = (DTreeRange)object;
        return dTreeRange.getParent() == this.getParent() && dTreeRange.getStartIndex() == this.getStartIndex() && dTreeRange.getCount() == this.getCount();
    }

    public DTreeItem getParent() {
        return this._parent;
    }

    public int getStartIndex() {
        return this._start;
    }

    public int getCount() {
        return this._count;
    }

    public final boolean isItemDescendent(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = this.getParent();
        while (dTreeItem != null && dTreeItem.getParent() != dTreeItem2) {
            dTreeItem = dTreeItem.getParent();
        }
        if (dTreeItem == null) {
            return false;
        }
        return this.contains(dTreeItem.getParent(), dTreeItem.getIndex());
    }
}

