/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDropTarget;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.JFCSupport;

public class DTreeDropSupport {
    private DTree _tree;
    static final int __DROP_OFFSET = 5;
    static final int __INTO_INDEX = -1;

    public DTreeDropSupport(DTree dTree) {
        this._tree = dTree;
        new DropTarget(dTree, new Dropper());
    }

    public DTree getTree() {
        return this._tree;
    }

    public boolean isEnabled() {
        DTree dTree = this.getTree();
        DropTarget dropTarget = JFCSupport.getEWTDropTarget(dTree);
        return dropTarget.isActive();
    }

    public void setEnabled(boolean bl) {
        DTree dTree = this.getTree();
        DropTarget dropTarget = JFCSupport.getEWTDropTarget(dTree);
        dropTarget.setActive(bl);
    }

    protected DTreeDropTarget getDTreeDropTarget(DTreeItem dTreeItem) {
        return dTreeItem.getDropTarget();
    }

    private class Dropper
    implements DropTargetListener {
        private Dropper() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this._handleDrag(dropTargetDragEvent);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            this._handleDrag(dropTargetDragEvent);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            this._handleDrag(dropTargetDragEvent);
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            DTree dTree = DTreeDropSupport.this.getTree();
            dTree.setDropHighlightItem(null);
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            DTree dTree = DTreeDropSupport.this.getTree();
            dTree.setDropHighlightItem(null);
            Point point = dropTargetDropEvent.getLocation();
            DTreeItem dTreeItem = this._getItemAt(point);
            if (dTreeItem != null) {
                Point point2;
                int n;
                int n2;
                DTreeItem dTreeItem2;
                DTreeDropTarget dTreeDropTarget;
                DataFlavor[] dataFlavorArray = dropTargetDropEvent.getCurrentDataFlavors();
                int n3 = dropTargetDropEvent.getSourceActions();
                int n4 = dropTargetDropEvent.getDropAction();
                int n5 = this._getDropStyle(dTreeItem, point, dataFlavorArray, n4, n3);
                if (n5 != 0 && (dTreeDropTarget = DTreeDropSupport.this.getDTreeDropTarget(dTreeItem2 = this._getDropItem(dTreeItem, n5))) != null && ((n2 = dTreeDropTarget.getTargetAction(dTreeItem2, n = this._getDropIndex(dTreeItem, n5), point2 = this._convertOuterToItem(dTreeItem2, point), dataFlavorArray, n4, n3)) & n3) != 0) {
                    dropTargetDropEvent.acceptDrop(n2);
                    boolean bl = dTreeDropTarget.handleDrop(dTreeItem2, n, point2, dropTargetDropEvent.getTransferable(), n2);
                    dropTargetDropEvent.getDropTargetContext().dropComplete(bl);
                    return;
                }
            }
            dropTargetDropEvent.rejectDrop();
        }

        private void _checkTargetAction(int n, int n2) {
        }

        private int _getDropStyle(DTreeItem dTreeItem, Point point, DataFlavor[] dataFlavorArray, int n, int n2) {
            int n3;
            int n4 = 0;
            DTree dTree = DTreeDropSupport.this.getTree();
            Point point2 = dTree.convertOuterToCanvas(point.x, point.y);
            Point point3 = new Point(point2.x - dTreeItem.getX(), point2.y - dTreeItem.getY());
            DTreeDropTarget dTreeDropTarget = DTreeDropSupport.this.getDTreeDropTarget(dTreeItem);
            if (dTreeDropTarget != null && (n3 = dTreeDropTarget.getTargetAction(dTreeItem, -1, point3, dataFlavorArray, n, n2)) != 0) {
                n4 = 1;
            }
            if ((n3 = this._isDropBefore(dTreeItem, point3)) != 0 || this._isDropAfter(dTreeItem, point3) || n4 == 0) {
                Point point4;
                int n5;
                int n6 = dTreeItem.getIndex();
                int n7 = n3 != 0 ? n6 : n6 + 1;
                DTreeItem dTreeItem2 = dTreeItem.getParent();
                DTreeDropTarget dTreeDropTarget2 = DTreeDropSupport.this.getDTreeDropTarget(dTreeItem2);
                if (dTreeDropTarget2 != null && (n5 = dTreeDropTarget2.getTargetAction(dTreeItem2, n7, point4 = new Point(point2.x - dTreeItem2.getX(), point2.y - dTreeItem2.getY()), dataFlavorArray, n, n2)) != 0) {
                    int n8 = n4 = n3 != 0 ? 2 : 3;
                }
            }
            if (n4 != 0) {
                DTreeItem dTreeItem3 = n4 == 1 ? dTreeItem : dTreeItem.getParent();
                DTreeSelection dTreeSelection = (DTreeSelection)dTree.getClientProperty("_ewtDTreeDragItems");
                if (dTreeSelection != null && dTreeSelection.isItemDescendent(dTreeItem3)) {
                    return 0;
                }
            }
            return n4;
        }

        private DTreeItem _getItemAt(Point point) {
            DTree dTree = DTreeDropSupport.this.getTree();
            Point point2 = dTree.convertOuterToCanvas(point.x, point.y);
            DTreeItem dTreeItem = dTree.getItemAt(point2.x, point2.y);
            if (dTreeItem != null) {
                return dTreeItem;
            }
            return null;
        }

        private void _handleDrag(DropTargetDragEvent dropTargetDragEvent) {
            Point point;
            int n;
            int n2;
            DTreeItem dTreeItem;
            DTreeDropTarget dTreeDropTarget;
            int n3;
            int n4;
            DataFlavor[] dataFlavorArray;
            int n5;
            DTree dTree = DTreeDropSupport.this.getTree();
            Point point2 = dropTargetDragEvent.getLocation();
            DTreeItem dTreeItem2 = this._getItemAt(point2);
            if (dTreeItem2 != null && (n5 = this._getDropStyle(dTreeItem2, point2, dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors(), n4 = dropTargetDragEvent.getDropAction(), n3 = dropTargetDragEvent.getSourceActions())) != 0 && (dTreeDropTarget = DTreeDropSupport.this.getDTreeDropTarget(dTreeItem = this._getDropItem(dTreeItem2, n5))) != null && ((n2 = dTreeDropTarget.getTargetAction(dTreeItem, n = this._getDropIndex(dTreeItem2, n5), point = this._convertOuterToItem(dTreeItem, point2), dataFlavorArray, n4, n3)) & n3) != 0) {
                dropTargetDragEvent.acceptDrag(n2);
                dTree.setDropHighlightStyle(n5);
                dTree.setDropHighlightItem(dTreeItem2);
                return;
            }
            dropTargetDragEvent.rejectDrag();
            dTree.setDropHighlightItem(null);
        }

        private boolean _isDropBefore(DTreeItem dTreeItem, Point point) {
            return point.y >= 0 && point.y < 5;
        }

        private boolean _isDropAfter(DTreeItem dTreeItem, Point point) {
            Dimension dimension = dTreeItem.getSize();
            return point.y > dimension.height - 5 && point.y < dimension.height;
        }

        private int _getDropIndex(DTreeItem dTreeItem, int n) {
            switch (n) {
                case 1: {
                    return -1;
                }
                case 2: {
                    return dTreeItem.getIndex();
                }
                case 3: {
                    return dTreeItem.getIndex() + 1;
                }
            }
            return -1;
        }

        private DTreeItem _getDropItem(DTreeItem dTreeItem, int n) {
            return n == 1 ? dTreeItem : dTreeItem.getParent();
        }

        private Point _convertOuterToItem(DTreeItem dTreeItem, Point point) {
            DTree dTree = DTreeDropSupport.this.getTree();
            Point point2 = dTree.convertOuterToCanvas(point.x, point.y);
            return new Point(point2.x - dTreeItem.getX(), point2.y - dTreeItem.getY());
        }
    }
}

