/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeChildManager;
import oracle.bali.ewt.dTree.DTreeDeferredChild;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeExpansionListener;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.DTreeItemValidateEvent;
import oracle.bali.ewt.dTree.DTreeSparseChildManager;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.model.EmptyOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;

public abstract class DTreeDeferredParent
extends DTreeDeferredChild
implements DTreeDeferringParent,
OneDModelListener {
    private OneDModel _datasrc;
    private DTreeChildManager _childmgr;
    private boolean _expanded;

    protected DTreeDeferredParent(OneDModel oneDModel) {
        if (oneDModel == null) {
            oneDModel = EmptyOneDModel.getOneDModel();
        }
        this._datasrc = oneDModel;
        this._datasrc.addModelListener(this);
    }

    public void childExpansionChanged(DTreeItem dTreeItem) {
        this._childmgr.childExpansionChanged(this, dTreeItem);
    }

    public Object getChildData(int n) {
        return this._datasrc.getData(n);
    }

    public int getChildHeight() {
        DTree dTree = this.getTree();
        EWTTreeUI eWTTreeUI = dTree.getUI();
        return eWTTreeUI.getDeferredChildHeight(dTree, this.getPaintContext(), this, this.getChildIconHeight());
    }

    public int getChildX(int n) {
        return this._childmgr.getChildX(this, n);
    }

    public int getChildY(int n) {
        return this._childmgr.getChildY(this, n);
    }

    public OneDModel getModel() {
        return this._datasrc;
    }

    public DTreeItem getItem(int n) {
        if (this._childmgr == null) {
            this._childmgr = this.createChildManager();
        }
        return this._childmgr.getItem(this, n);
    }

    public DTreeItem getItemAt(int n, int n2) {
        return this._childmgr.getItemAt(this, n, n2);
    }

    public int getItemCount() {
        return this._datasrc.getItemCount();
    }

    public abstract DTreeItemFactory getItemFactory();

    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        return this._childmgr.getNextExpandedChild(this, dTreeItem);
    }

    public DTreeItem getNextInstantiatedChild(DTreeItem dTreeItem) {
        if (this._childmgr == null) {
            return null;
        }
        return this._childmgr.getNextInstantiatedChild(this, dTreeItem);
    }

    public int getSubTreeHeight() {
        if (this.isExpanded()) {
            return this._childmgr.getSubTreeHeight(this);
        }
        return this.getSize().height;
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void layout(int n, int n2) {
        this._childmgr.layout(this, n, n2);
    }

    public void setModel(OneDModel oneDModel) {
        if (oneDModel == null) {
            oneDModel = EmptyOneDModel.getOneDModel();
        }
        OneDModel oneDModel2 = this.getModel();
        int n = this.getItemCount();
        if (n > 0) {
            this.itemsRemoved(new OneDModelEvent(oneDModel2, 2002, 0, n));
        }
        oneDModel2.removeModelListener(this);
        this._datasrc = oneDModel;
        int n2 = oneDModel.getItemCount();
        if (n2 > 0) {
            this.itemsAdded(new OneDModelEvent(oneDModel, 2001, 0, n2));
        }
        oneDModel.addModelListener(this);
    }

    public void setExpanded(boolean bl) {
        if (bl == this.isExpanded()) {
            return;
        }
        DTree dTree = this.getTree();
        if (!DTreeDeferredParent.__fireExpansionChanging(dTree, bl, this)) {
            this._expanded = bl;
            if (bl && this._childmgr == null) {
                this._childmgr = this.createChildManager();
            }
            DTreeDeferredParent.__fireExpansionChanged(dTree, bl, this);
        }
    }

    public void itemsAdded(OneDModelEvent oneDModelEvent) {
        DTree dTree;
        int n = oneDModelEvent.getStartIndex();
        int n2 = oneDModelEvent.getItemCount();
        if (this._childmgr != null) {
            this._childmgr.itemsAdded(this, n, n2);
        }
        if ((dTree = this.getTree()) != null) {
            dTree.itemsAdded(this, n, n2);
        }
    }

    public void itemsRemoved(OneDModelEvent oneDModelEvent) {
        DTree dTree;
        int n = oneDModelEvent.getStartIndex();
        int n2 = oneDModelEvent.getItemCount();
        if (this._childmgr != null) {
            this._childmgr.itemsRemoved(this, n, n2);
        }
        if ((dTree = this.getTree()) != null) {
            dTree.itemsRemoved(this, n, n2);
        }
    }

    public void invalidateItems(OneDModelEvent oneDModelEvent) {
        int n = oneDModelEvent.getStartIndex();
        int n2 = oneDModelEvent.getItemCount();
        DTree dTree = this.getTree();
        if (dTree != null) {
            dTree.itemsInvalidated(this, n, n2);
        }
    }

    protected DTreeChildManager createChildManager() {
        return new DTreeSparseChildManager();
    }

    protected int getChildIconHeight() {
        return 18;
    }

    static boolean __fireExpansionChanging(DTree dTree, boolean bl, DTreeDeferringParent dTreeDeferringParent) {
        OneDModel oneDModel;
        int n = bl ? 2000 : 2002;
        DTreeItemValidateEvent dTreeItemValidateEvent = new DTreeItemValidateEvent(dTree, n, dTreeDeferringParent);
        if (dTree != null) {
            dTree.dispatchEvent(dTreeItemValidateEvent);
            if (dTreeItemValidateEvent.isCancelled()) {
                return true;
            }
        }
        if ((oneDModel = dTreeDeferringParent.getModel()) instanceof DTreeExpansionListener) {
            DTreeExpansionListener dTreeExpansionListener = (DTreeExpansionListener)((Object)oneDModel);
            if (bl) {
                dTreeExpansionListener.dTreeItemExpanding(dTreeItemValidateEvent);
            } else {
                dTreeExpansionListener.dTreeItemCollapsing(dTreeItemValidateEvent);
            }
            return dTreeItemValidateEvent.isCancelled();
        }
        return false;
    }

    static void __fireExpansionChanged(DTree dTree, boolean bl, DTreeDeferringParent dTreeDeferringParent) {
        DTreeItem dTreeItem = dTreeDeferringParent.getParent();
        if (dTreeItem instanceof DTreeDeferringParent) {
            ((DTreeDeferringParent)dTreeItem).childExpansionChanged(dTreeDeferringParent);
        }
        int n = bl ? 2001 : 2003;
        DTreeItemEvent dTreeItemEvent = new DTreeItemEvent(dTree, n, dTreeDeferringParent);
        OneDModel oneDModel = dTreeDeferringParent.getModel();
        if (oneDModel instanceof DTreeExpansionListener) {
            DTreeExpansionListener dTreeExpansionListener = (DTreeExpansionListener)((Object)oneDModel);
            if (bl) {
                dTreeExpansionListener.dTreeItemExpanded(dTreeItemEvent);
            } else {
                dTreeExpansionListener.dTreeItemCollapsed(dTreeItemEvent);
            }
        }
        if (dTree != null) {
            dTree.dispatchEvent(dTreeItemEvent);
        }
    }
}

