/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import oracle.ias.cache.BitMap;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.GroupView;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.GcommSerializable;
import oracle.ias.cache.groupv2.MemberID;

class View
extends GcommSerializable
implements Cloneable,
GroupView {
    private static final int NOT_FOUND = -1;
    private long vId_ = 0L;
    private int coordinatorIndex_;
    private Hashtable memberIDIndexTable_ = new Hashtable();
    private Hashtable distributorIDIndexTable_ = new Hashtable();
    private Hashtable distributorAddressTable_;
    private Hashtable memberDistribution_ = new Hashtable();
    private HashSet inDistributorMembers_;
    private HashMap userDefinedIds_;
    private HashMap memberTags_;
    private Hashtable tagIndexTable_;
    private transient Address[] addressByIndexList_;
    private transient MemberID[] memberByIndexList_;
    private transient MemberID[] distributorByIndexList_;
    private transient boolean[] memberIndexMap_;
    private transient String[] tagByIndexList_;

    public boolean equals(Object object) {
        if (object instanceof View) {
            return this.vId_ == ((View)object).getViewID();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.vId_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\r\nView ID: ");
        stringBuffer.append(this.vId_);
        stringBuffer.append("\r\nCoordinator index: ");
        stringBuffer.append(this.coordinatorIndex_);
        stringBuffer.append("\r\nCoordinator ID: ");
        if (this.distributorByIndexList_ != null && this.coordinatorIndex_ < this.distributorByIndexList_.length && this.distributorByIndexList_.length > 0) {
            stringBuffer.append(this.distributorByIndexList_[this.coordinatorIndex_]);
        } else {
            stringBuffer.append("unknown");
        }
        if (this.memberIndexMap_ != null) {
            stringBuffer.append("\r\nMember Position BitMap: ");
            for (int i = 0; i < this.memberIndexMap_.length; ++i) {
                if (this.memberIndexMap_[i]) {
                    stringBuffer.append("1");
                    continue;
                }
                stringBuffer.append("0");
            }
        }
        stringBuffer.append("\r\nMember Index:");
        stringBuffer.append(View.hashTableToString(this.memberIDIndexTable_));
        stringBuffer.append("\r\nDistributor Index:");
        stringBuffer.append(View.hashTableToString(this.distributorIDIndexTable_));
        stringBuffer.append("\r\nDistributor Addresses:");
        stringBuffer.append(View.hashTableToString(this.distributorAddressTable_));
        stringBuffer.append("\r\nMember Distribution:");
        stringBuffer.append(View.hashTableToString(this.memberDistribution_));
        stringBuffer.append("\r\nMembers in distributor's JVM:");
        stringBuffer.append(View.hashSetToString(this.inDistributorMembers_));
        stringBuffer.append("\r\nUser Defined IDs:");
        stringBuffer.append(View.hashMapToString(this.userDefinedIds_));
        stringBuffer.append("\r\nMember's tag:");
        stringBuffer.append(View.hashMapToString(this.memberTags_));
        stringBuffer.append("\r\nTag Index::");
        stringBuffer.append(View.hashTableToString(this.tagIndexTable_));
        return stringBuffer.toString();
    }

    public byte[] toBytes() throws GroupException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GcommSerializable.writeTo(byteArrayOutputStream, this.vId_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.coordinatorIndex_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.memberIDIndexTable_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.distributorIDIndexTable_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.distributorAddressTable_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.memberDistribution_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.inDistributorMembers_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.userDefinedIds_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.memberTags_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.tagIndexTable_);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    private void parseFrom(byte[] byArray) throws GroupException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.vId_ = GcommSerializable.readLongFrom(byteArrayInputStream);
        this.coordinatorIndex_ = GcommSerializable.readIntFrom(byteArrayInputStream);
        this.memberIDIndexTable_ = GcommSerializable.readIDIndexTableFrom(byteArrayInputStream);
        this.distributorIDIndexTable_ = GcommSerializable.readIDIndexTableFrom(byteArrayInputStream);
        this.distributorAddressTable_ = GcommSerializable.readDistributorTableFrom(byteArrayInputStream);
        this.memberDistribution_ = GcommSerializable.readIndexMapFrom(byteArrayInputStream);
        int[] nArray = GcommSerializable.readIntsFrom(byteArrayInputStream);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.inDistributorMembers_.add(new Integer(nArray[i]));
            }
        }
        this.userDefinedIds_ = GcommSerializable.readHashMapFrom(byteArrayInputStream);
        this.memberTags_ = GcommSerializable.readMemberTagsFrom(byteArrayInputStream);
        this.tagIndexTable_ = GcommSerializable.readTagTableFrom(byteArrayInputStream);
        this.buildLookupList();
        try {
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static View parse(byte[] byArray) throws GroupException {
        View view = new View();
        view.parseFrom(byArray);
        return view;
    }

    static View addDistributorTo(View view, Address address, MemberID memberID) throws GroupException {
        View view2 = null;
        try {
            view2 = (View)view.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new GcommException(GcommException.CREATEVIEW, (Throwable)cloneNotSupportedException);
        }
        view2.incrementViewID();
        if (view.contains(address)) {
            MemberID memberID2 = view.getDistributorIDByAddress(address);
            view2.replaceDistributor(memberID2, memberID);
        } else {
            view2.addDistributor(memberID, address);
        }
        view2.buildLookupList();
        return view2;
    }

    static View addMemeberTo(View view, MemberID memberID, MemberID memberID2, boolean bl, String string, String string2) throws GroupException {
        View view2 = null;
        try {
            view2 = (View)view.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new GcommException(GcommException.CREATEVIEW, (Throwable)cloneNotSupportedException);
        }
        view2.incrementViewID();
        view2.addMember(memberID, memberID2, bl, string, string2);
        view2.buildLookupList();
        return view2;
    }

    static View removeMemeberFrom(View view, MemberID memberID) throws GroupException {
        View view2 = null;
        try {
            view2 = (View)view.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new GcommException(GcommException.CREATEVIEW, (Throwable)cloneNotSupportedException);
        }
        view2.incrementViewID();
        view2.removeMember(memberID);
        view2.buildLookupList();
        return view2;
    }

    static View removeDistributorFrom(View view, MemberID memberID) throws GroupException {
        View view2 = null;
        try {
            view2 = (View)view.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new GcommException(GcommException.CREATEVIEW, (Throwable)cloneNotSupportedException);
        }
        view2.incrementViewID();
        Address[] addressArray = view2.getDistributorAddresses(memberID);
        view2.removeDistributor(memberID);
        if (addressArray != null && addressArray.length > 1) {
            Address address = view2.getCoordinatorAddress();
            int n = address.getNetworkId();
            for (int i = 0; i < addressArray.length; ++i) {
                MemberID[] memberIDArray;
                int n2 = addressArray[i].getNetworkId();
                if (n == n2 || (memberIDArray = view2.getDistributorsOn(n2)) == null) continue;
                for (int j = 0; j < memberIDArray.length; ++j) {
                    view2.removeDistributor(memberIDArray[j]);
                }
            }
        }
        view2.buildLookupList();
        return view2;
    }

    static View replaceDistributorFrom(View view, MemberID memberID, MemberID memberID2) throws GroupException {
        View view2 = null;
        try {
            view2 = (View)view.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new GcommException(GcommException.CREATEVIEW, (Throwable)cloneNotSupportedException);
        }
        view2.incrementViewID();
        view2.replaceDistributor(memberID, memberID2);
        view2.buildLookupList();
        return view2;
    }

    static View replaceCoordinatorFrom(View view, MemberID memberID) throws GroupException {
        View view2 = null;
        try {
            view2 = (View)view.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new GcommException(GcommException.CREATEVIEW, (Throwable)cloneNotSupportedException);
        }
        view2.incrementViewID();
        view2.setCoordinator(memberID);
        view2.buildLookupList();
        return view2;
    }

    static View merge(View[] viewArray, MemberID memberID) throws GroupException {
        View view = null;
        try {
            view = (View)viewArray[0].clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new GcommException(GcommException.CREATEVIEW, (Throwable)cloneNotSupportedException);
        }
        for (int i = 1; i < viewArray.length; ++i) {
            int n;
            view.incrementViewID();
            MemberID[] memberIDArray = viewArray[i].getDistributorIDs();
            for (int j = 0; j < memberIDArray.length; ++j) {
                n = (Integer)viewArray[i].distributorIDIndexTable_.get(memberIDArray[j]);
                view.addDistributor(memberIDArray[j], viewArray[i].getDistributorAddressByIndex(n));
            }
            MemberID[] memberIDArray2 = viewArray[i].getMemberIDs();
            for (n = 0; n < memberIDArray2.length; ++n) {
                Integer n2 = (Integer)viewArray[i].memberIDIndexTable_.get(memberIDArray2[n]);
                int n3 = (Integer)viewArray[i].memberDistribution_.get(n2);
                boolean bl = viewArray[i].inDistributorMembers_.contains(n2);
                String string = (String)viewArray[i].userDefinedIds_.get(n2);
                String string2 = (String)viewArray[i].memberTags_.get(n2);
                view.addMember(memberIDArray2[n], viewArray[i].distributorByIndexList_[n3], bl, string, string2);
            }
            view.buildLookupList();
        }
        view.setCoordinator(memberID);
        return view;
    }

    View() {
        this.distributorAddressTable_ = new Hashtable();
        this.inDistributorMembers_ = new HashSet();
        this.userDefinedIds_ = new HashMap();
        this.memberTags_ = new HashMap();
        this.tagIndexTable_ = new Hashtable();
    }

    public Object clone() throws CloneNotSupportedException {
        return (View)super.clone();
    }

    View(Address[] addressArray, MemberID memberID) {
        this();
        Integer n = this.getNewIndex(this.getDistributorIndexMap());
        this.distributorIDIndexTable_.put(memberID, n);
        if (this.distributorAddressTable_ != null) {
            for (int i = 0; i < addressArray.length; ++i) {
                this.distributorAddressTable_.put(addressArray[i], n);
            }
        }
        this.coordinatorIndex_ = n;
        this.buildLookupList();
    }

    long getViewID() {
        return this.vId_;
    }

    Hashtable getIndexTable() {
        return this.memberIDIndexTable_;
    }

    Address getCoordinatorAddress() {
        if (this.coordinatorIndex_ >= 0 && this.coordinatorIndex_ < this.addressByIndexList_.length) {
            return this.addressByIndexList_[this.coordinatorIndex_];
        }
        return null;
    }

    MemberID getCoordinatorID() {
        if (this.coordinatorIndex_ < 0 || this.coordinatorIndex_ >= this.distributorByIndexList_.length) {
            return null;
        }
        return this.distributorByIndexList_[this.coordinatorIndex_];
    }

    void setCoordinator(MemberID memberID) {
        this.coordinatorIndex_ = this.indexOfDistributor(memberID);
    }

    Address[] getDistributorAddresses() {
        Set set = this.distributorAddressTable_.keySet();
        Address[] addressArray = new Address[set.size()];
        set.toArray(addressArray);
        return addressArray;
    }

    Address[] getDistributorAddresses(MemberID memberID) {
        Address[] addressArray = null;
        Vector<Address> vector = new Vector<Address>();
        int n = this.indexOfDistributor(memberID);
        Set set = this.distributorAddressTable_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Address address = (Address)iterator.next();
            Integer n2 = (Integer)this.distributorAddressTable_.get(address);
            if (n2 == null || n != n2) continue;
            vector.addElement(address);
        }
        if (vector.size() > 0) {
            addressArray = new Address[vector.size()];
            vector.toArray(addressArray);
        }
        return addressArray;
    }

    Address[] getDistributorAddresses(int n) {
        Set set = this.distributorAddressTable_.keySet();
        Vector vector = new Vector(set);
        for (int i = 0; i < vector.size(); ++i) {
            Address address = (Address)vector.elementAt(i);
            if (address.getNetworkId() == n) continue;
            vector.remove(i--);
        }
        Address[] addressArray = new Address[vector.size()];
        vector.toArray(addressArray);
        return addressArray;
    }

    MemberID getDistributorIDByAddress(Address address) {
        int n;
        MemberID memberID = null;
        Integer n2 = (Integer)this.distributorAddressTable_.get(address);
        if (n2 != null && (n = n2.intValue()) >= 0 && n < this.distributorByIndexList_.length) {
            memberID = this.distributorByIndexList_[n];
        }
        return memberID;
    }

    MemberID getDistributorOfMember(MemberID memberID) {
        int n;
        Object v;
        MemberID memberID2 = null;
        int n2 = this.indexOfMember(memberID);
        if (n2 >= 0 && (v = this.memberDistribution_.get(new Integer(n2))) != null && (n = ((Integer)v).intValue()) >= 0 && n < this.distributorByIndexList_.length) {
            memberID2 = this.distributorByIndexList_[n];
        }
        return memberID2;
    }

    MemberID[] getDistributorIDs() {
        Set set = this.distributorIDIndexTable_.keySet();
        MemberID[] memberIDArray = new MemberID[set.size()];
        set.toArray(memberIDArray);
        return memberIDArray;
    }

    MemberID[] getMemberIDs() {
        Set set = this.memberIDIndexTable_.keySet();
        MemberID[] memberIDArray = new MemberID[set.size()];
        set.toArray(memberIDArray);
        return memberIDArray;
    }

    int getSize() {
        Set set = this.memberIDIndexTable_.keySet();
        return set.size();
    }

    private void incrementViewID() {
        ++this.vId_;
    }

    private Integer addDistributor(MemberID memberID, Address address) {
        Integer n = null;
        if (!this.distributorIDIndexTable_.containsKey(memberID)) {
            n = this.getNewIndex(this.getDistributorIndexMap());
            this.distributorIDIndexTable_.put(memberID, n);
            this.distributorAddressTable_.put(address, n);
        } else {
            n = (Integer)this.distributorIDIndexTable_.get(memberID);
            this.distributorAddressTable_.put(address, n);
        }
        return n;
    }

    private Integer addMember(MemberID memberID, MemberID memberID2, boolean bl, String string, String string2) {
        Integer n = null;
        Integer n2 = null;
        if (!this.memberIDIndexTable_.containsKey(memberID)) {
            n = this.getNewIndex(this.getMemberIndexMap());
            this.memberIDIndexTable_.put(memberID, n);
            this.memberDistribution_.put(n, this.distributorIDIndexTable_.get(memberID2));
            if (bl) {
                this.inDistributorMembers_.add(n);
            }
            this.userDefinedIds_.put(n, string);
            if (string2 != null) {
                if (!this.tagIndexTable_.containsKey(string2)) {
                    n2 = this.getNewIndex(this.getTagIndexMap());
                    this.tagIndexTable_.put(string2, n2);
                } else {
                    n2 = (Integer)this.tagIndexTable_.get(string2);
                }
                this.memberTags_.put(n, n2);
            }
        } else {
            n = (Integer)this.memberIDIndexTable_.get(memberID);
            if (bl && !this.inDistributorMembers_.contains(n)) {
                this.inDistributorMembers_.add(n);
            } else if (!bl && this.inDistributorMembers_.contains(n)) {
                this.inDistributorMembers_.remove(n);
            }
        }
        return n;
    }

    private void removeMember(MemberID memberID) {
        if (memberID == null || !this.memberIDIndexTable_.containsKey(memberID)) {
            return;
        }
        Object v = this.memberIDIndexTable_.remove(memberID);
        if (v != null) {
            this.memberDistribution_.remove(v);
            this.inDistributorMembers_.remove(v);
            this.userDefinedIds_.remove(v);
            Integer n = (Integer)this.memberTags_.remove(v);
            if (n == null || n == null || !this.memberTags_.containsValue(n)) {
                // empty if block
            }
        }
    }

    private void removeDistributor(MemberID memberID) {
        Comparable comparable;
        if (memberID == null || !this.distributorIDIndexTable_.containsKey(memberID)) {
            return;
        }
        MemberID[] memberIDArray = this.getAllMembersOf(memberID);
        if (memberIDArray != null) {
            for (int i = 0; i < memberIDArray.length; ++i) {
                this.removeMember(memberIDArray[i]);
            }
        }
        Integer n = (Integer)this.distributorIDIndexTable_.get(memberID);
        this.distributorIDIndexTable_.remove(memberID);
        Enumeration enumeration = this.distributorAddressTable_.keys();
        while (enumeration != null && enumeration.hasMoreElements()) {
            comparable = (Address)enumeration.nextElement();
            if (comparable == null || !this.distributorAddressTable_.get(comparable).equals(n)) continue;
            this.distributorAddressTable_.remove(comparable);
        }
        enumeration = this.memberDistribution_.keys();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Integer n2;
            comparable = (Integer)enumeration.nextElement();
            if (comparable == null || (n2 = (Integer)this.memberDistribution_.get(comparable)) == null || !n2.equals(n)) continue;
            this.memberDistribution_.remove(comparable);
        }
        if (this.coordinatorIndex_ == n) {
            this.coordinatorIndex_ = -1;
        }
    }

    private void replaceDistributor(MemberID memberID, MemberID memberID2) {
        if (memberID == null || !this.distributorIDIndexTable_.containsKey(memberID)) {
            return;
        }
        Integer n = (Integer)this.distributorIDIndexTable_.get(memberID);
        this.distributorIDIndexTable_.remove(memberID);
        this.distributorIDIndexTable_.put(memberID2, n);
        int[] nArray = this.getAllMemberIndexOf(memberID2);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (!this.inDistributorMembers_.contains(new Integer(nArray[i]))) continue;
                this.removeMember(this.getMemberByIndex(nArray[i]));
            }
        }
    }

    boolean contains(MemberID memberID) {
        return this.memberIDIndexTable_.containsKey(memberID) || this.distributorIDIndexTable_.containsKey(memberID);
    }

    boolean contains(Address address) {
        return this.distributorAddressTable_.containsKey(address);
    }

    boolean hasAnyMembersFrom(MemberID memberID, boolean bl) {
        int[] nArray = this.getAllMemberIndexOf(memberID);
        if (nArray != null && nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                boolean bl2 = this.inDistributorMembers_.contains(new Integer(nArray[i]));
                if (bl ^ bl2) continue;
                return true;
            }
        }
        return false;
    }

    int indexOfMember(MemberID memberID) {
        int n = -1;
        Object v = this.memberIDIndexTable_.get(memberID);
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        return n;
    }

    int indexOfDistributor(MemberID memberID) {
        int n = -1;
        Object v = this.distributorIDIndexTable_.get(memberID);
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        return n;
    }

    boolean[] getMemberMap() {
        return this.memberIndexMap_;
    }

    boolean[] getMemberMap(MemberID[] memberIDArray, MemberID[] memberIDArray2) {
        if (this.memberIndexMap_ == null) {
            return null;
        }
        if (memberIDArray == null && memberIDArray2 == null) {
            return this.memberIndexMap_;
        }
        boolean[] blArray = this.getMemberMapOf(this.memberIndexMap_, memberIDArray);
        if (memberIDArray2 != null) {
            for (int i = 0; i < memberIDArray2.length; ++i) {
                MemberID[] memberIDArray3;
                MemberID memberID = memberIDArray2[i];
                if (memberID == null || (memberIDArray3 = this.getAllMembersOf(memberID)) == null) continue;
                blArray = this.getMemberMapOf(blArray, memberIDArray3);
            }
        }
        return blArray;
    }

    private boolean[] getMemberMapOf(boolean[] blArray, MemberID[] memberIDArray) {
        if (blArray == null) {
            return null;
        }
        boolean[] blArray2 = (boolean[])blArray.clone();
        if (memberIDArray == null) {
            return blArray2;
        }
        for (int i = 0; i < memberIDArray.length; ++i) {
            int n;
            Integer n2;
            MemberID memberID = memberIDArray[i];
            if (memberID == null || (n2 = (Integer)this.memberIDIndexTable_.get(memberID)) == null || (n = n2.intValue()) < 0 || n >= blArray2.length) continue;
            blArray2[n] = false;
        }
        return blArray2;
    }

    int[] getAllMemberIndexOf(MemberID memberID) {
        Integer n = new Integer(this.indexOfDistributor(memberID));
        Enumeration enumeration = this.memberDistribution_.keys();
        Vector<Integer> vector = new Vector<Integer>();
        int[] nArray = null;
        while (enumeration != null && enumeration.hasMoreElements()) {
            Object v;
            Integer n2 = (Integer)enumeration.nextElement();
            if (n2 == null || (v = this.memberDistribution_.get(n2)) == null || !v.equals(n)) continue;
            vector.addElement(n2);
        }
        if (vector != null && vector.size() > 0) {
            nArray = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                nArray[i] = (Integer)vector.elementAt(i);
            }
        }
        return nArray;
    }

    MemberID[] getAllMembersOf(MemberID memberID) {
        MemberID[] memberIDArray = null;
        int[] nArray = this.getAllMemberIndexOf(memberID);
        if (nArray == null) {
            return null;
        }
        memberIDArray = new MemberID[nArray.length];
        for (int i = 0; i < memberIDArray.length; ++i) {
            memberIDArray[i] = this.memberByIndexList_[nArray[i]];
        }
        return memberIDArray;
    }

    private MemberID[] getDistributorsOn(int n) {
        MemberID[] memberIDArray = null;
        Vector<MemberID> vector = new Vector<MemberID>();
        Address[] addressArray = this.addressByIndexList_;
        for (int i = 0; i < addressArray.length; ++i) {
            if (addressArray[i].getNetworkId() != n) continue;
            vector.addElement(this.distributorByIndexList_[i]);
        }
        if (vector.size() > 0) {
            memberIDArray = new MemberID[vector.size()];
            vector.toArray(memberIDArray);
        }
        return memberIDArray;
    }

    MemberID getMemberByIndex(int n) {
        if (n < 0 && n >= this.memberByIndexList_.length) {
            return null;
        }
        return this.memberByIndexList_[n];
    }

    Address getDistributorAddressByIndex(int n) {
        if (n < 0 && n >= this.addressByIndexList_.length) {
            return null;
        }
        return this.addressByIndexList_[n];
    }

    String getTagByIndex(int n) {
        if (n < 0 && n >= this.tagByIndexList_.length) {
            return null;
        }
        return this.tagByIndexList_[n];
    }

    MemberID[] getNonExistMembersOf(View view) {
        MemberID[] memberIDArray = null;
        Vector<MemberID> vector = new Vector<MemberID>(0);
        MemberID[] memberIDArray2 = view.getMemberIDs();
        if (memberIDArray2 == null || memberIDArray2.length <= 0) {
            return this.getMemberIDs();
        }
        MemberID[] memberIDArray3 = this.getMemberIDs();
        for (int i = 0; i < memberIDArray3.length; ++i) {
            if (view.contains(memberIDArray3[i])) continue;
            vector.addElement(memberIDArray3[i]);
        }
        if (vector.size() > 0) {
            memberIDArray = new MemberID[vector.size()];
            vector.toArray(memberIDArray);
        }
        return memberIDArray;
    }

    private BitSet getMemberIndexMap() {
        return View.getIndexMap(this.memberIDIndexTable_);
    }

    private BitSet getDistributorIndexMap() {
        return View.getIndexMap(this.distributorIDIndexTable_);
    }

    private BitSet getTagIndexMap() {
        return View.getIndexMap(this.tagIndexTable_);
    }

    private static BitSet getIndexMap(Hashtable hashtable) {
        BitSet bitSet = new BitSet(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Integer n = (Integer)hashtable.get(k);
            bitSet.set(n);
        }
        return bitSet;
    }

    private Integer getNewIndex(BitSet bitSet) {
        int n = 0;
        if (bitSet != null) {
            n = bitSet.nextClearBit(0);
        }
        return new Integer(n);
    }

    private void buildLookupList() {
        Integer n;
        Object k;
        Enumeration enumeration;
        int n2;
        Enumeration enumeration2;
        if (this.memberIDIndexTable_.size() > 0) {
            enumeration2 = new TreeSet(this.memberIDIndexTable_.values());
            n2 = (Integer)((TreeSet)((Object)enumeration2)).last() + 1;
            this.memberByIndexList_ = new MemberID[n2];
            this.memberIndexMap_ = new boolean[n2];
            enumeration = this.memberIDIndexTable_.keys();
            while (enumeration.hasMoreElements()) {
                k = enumeration.nextElement();
                n = (Integer)this.memberIDIndexTable_.get(k);
                this.memberByIndexList_[n.intValue()] = (MemberID)k;
                this.memberIndexMap_[n.intValue()] = true;
            }
        }
        if (this.distributorIDIndexTable_ != null && this.distributorIDIndexTable_.size() > 0) {
            enumeration2 = new TreeSet(this.distributorIDIndexTable_.values());
            n2 = (Integer)((TreeSet)((Object)enumeration2)).last() + 1;
            this.distributorByIndexList_ = new MemberID[n2];
            enumeration = this.distributorIDIndexTable_.keys();
            while (enumeration.hasMoreElements()) {
                k = enumeration.nextElement();
                n = (Integer)this.distributorIDIndexTable_.get(k);
                this.distributorByIndexList_[n.intValue()] = (MemberID)k;
            }
            this.addressByIndexList_ = new Address[n2];
            enumeration = this.distributorAddressTable_.keys();
            while (enumeration.hasMoreElements()) {
                k = enumeration.nextElement();
                n = (Integer)this.distributorAddressTable_.get(k);
                this.addressByIndexList_[n.intValue()] = (Address)k;
            }
        }
        if (this.tagIndexTable_ != null) {
            this.tagByIndexList_ = new String[this.tagIndexTable_.size()];
            enumeration2 = this.tagIndexTable_.keys();
            if (enumeration2 != null) {
                n2 = 0;
                while (enumeration2.hasMoreElements()) {
                    enumeration = (String)enumeration2.nextElement();
                    this.tagByIndexList_[n2++] = new String((String)((Object)enumeration));
                }
            }
        }
    }

    private static String hashTableToString(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = hashtable.keys();
        int n = 0;
        while (enumeration != null && enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            stringBuffer.append("\r\n#");
            stringBuffer.append(++n);
            stringBuffer.append(". ");
            stringBuffer.append(k);
            stringBuffer.append(", ");
            stringBuffer.append(v);
        }
        return stringBuffer.toString();
    }

    private static String hashSetToString(HashSet hashSet) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = hashSet.iterator();
        int n = 0;
        while (iterator != null && iterator.hasNext()) {
            Object e = iterator.next();
            stringBuffer.append("\r\n#");
            stringBuffer.append(++n);
            stringBuffer.append(". ");
            stringBuffer.append(e);
        }
        return stringBuffer.toString();
    }

    private static String hashMapToString(HashMap hashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = hashMap.keySet().iterator();
        int n = 0;
        while (iterator != null && iterator.hasNext()) {
            ++n;
            Object k = iterator.next();
            Object v = hashMap.get(k);
            if (v == null) continue;
            stringBuffer.append("\r\n#");
            stringBuffer.append(n);
            stringBuffer.append(". ");
            stringBuffer.append(k);
            stringBuffer.append(", ");
            stringBuffer.append(v);
        }
        return stringBuffer.toString();
    }

    public int getVid() {
        return (int)this.vId_;
    }

    public Vector getMembers() {
        boolean[] blArray = this.getMemberMap();
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            try {
                Object object;
                Integer n = (Integer)this.memberTags_.get(new Integer(i));
                byte[] byArray = null;
                if (n != null && (object = this.getTagByIndex(n)) != null) {
                    byArray = ((String)object).getBytes("UTF-8");
                }
                object = new Address(this.getMemberByIndex(i), i, (String)this.userDefinedIds_.get(new Integer(i)), (Serializable)byArray);
                vector.addElement(object);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector;
    }

    public int size() {
        return this.getSize();
    }

    public BitMap getBitMap() {
        BitMap bitMap = new BitMap(this.memberIndexMap_.length);
        for (int i = 0; i < this.memberIndexMap_.length; ++i) {
            if (!this.memberIndexMap_[i]) continue;
            bitMap.setBit(i);
        }
        return bitMap;
    }

    public int getCoordinatorPosition() {
        return this.coordinatorIndex_;
    }

    public boolean containsTag(String string) {
        return this.tagIndexTable_.containsKey(string);
    }

    public boolean hasTag(String string, Object object) {
        Integer n;
        Integer n2;
        boolean bl = false;
        if (string == null || object == null || !(object instanceof MemberID)) {
            return false;
        }
        MemberID memberID = (MemberID)object;
        int n3 = this.indexOfMember(memberID);
        if (n3 != -1 && (n2 = (Integer)this.tagIndexTable_.get(string)) != null && (n = (Integer)this.memberTags_.get(new Integer(n3))) != null) {
            bl = n2.equals(n);
        }
        return bl;
    }
}

