/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.GcommException;

class RWLock {
    static int counter = 0;
    private int waitingWriters_ = 0;
    private int activeWriters_ = 0;
    private int waitingReaders_ = 0;
    private int activeReaders_ = 0;
    private int id_ = counter++;
    private boolean enabled_ = true;

    RWLock() {
    }

    synchronized void acquireReadLock() throws GroupException {
        ++this.waitingReaders_;
        while (!this.allowReader() && this.enabled_) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                --this.waitingReaders_;
                throw new GcommException(GcommException.LOCKINTERRUPT, (Throwable)interruptedException);
            }
        }
        --this.waitingReaders_;
        ++this.activeReaders_;
    }

    synchronized void releaseReadLock() {
        if (!this.enabled_) {
            return;
        }
        --this.activeReaders_;
        this.notifyAll();
    }

    synchronized void acquireWriteLock() throws GroupException {
        ++this.waitingWriters_;
        while (!this.allowWriter() && this.enabled_) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                --this.waitingWriters_;
                throw new GcommException(GcommException.LOCKINTERRUPT, (Throwable)interruptedException);
            }
        }
        --this.waitingWriters_;
        ++this.activeWriters_;
    }

    synchronized void releaseWriteLock() {
        if (!this.enabled_) {
            return;
        }
        --this.activeWriters_;
        this.notifyAll();
    }

    synchronized void disable() {
        this.enabled_ = false;
        this.waitingWriters_ = 0;
        this.activeWriters_ = 0;
        this.waitingReaders_ = 0;
        this.activeReaders_ = 0;
        this.notifyAll();
    }

    private boolean allowReader() {
        return this.waitingWriters_ == 0 && this.activeWriters_ == 0;
    }

    private boolean allowWriter() {
        return this.activeReaders_ == 0 && this.activeWriters_ == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RWLock-");
        stringBuffer.append(this.id_);
        stringBuffer.append(", R=");
        stringBuffer.append(this.activeReaders_);
        stringBuffer.append(", W=");
        stringBuffer.append(this.activeWriters_);
        stringBuffer.append(", R-Waiter=");
        stringBuffer.append(this.waitingReaders_);
        stringBuffer.append(", W-Waiter=");
        stringBuffer.append(this.waitingWriters_);
        return stringBuffer.toString();
    }
}

