/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.MemberID;

abstract class GcommSerializable {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int BOOLEAN_LEN = 1;
    public static final int UNSIGNEDINT_LEN = 4;
    public static final int UNSIGNEDLONG_LEN = 8;

    GcommSerializable() {
    }

    abstract byte[] toBytes() throws GroupException;

    static byte[] unsignedIntToBytes(int n) {
        return GcommSerializable.unsignedIntToBytes(n, 4);
    }

    static byte[] unsignedIntToBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[n2 - 1 - i] = (byte)((n >> 8 * i) % 256);
        }
        return byArray;
    }

    static int bytesToUnsignedInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = byArray[n + n2 - 1 - i];
            if (n4 < 0) {
                n4 += 256;
            }
            n3 += n4 << 8 * i;
        }
        return n3;
    }

    static boolean bytesToBoolean(byte[] byArray, int n, int n2) {
        boolean bl = false;
        if (byArray[0] != 0) {
            bl = true;
        }
        return bl;
    }

    static byte[] booleanToByte(boolean bl) {
        byte[] byArray = new byte[1];
        if (bl) {
            byArray[0] = 1;
        }
        return byArray;
    }

    static void writeUnsignedIntTo(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(GcommSerializable.unsignedIntToBytes(n2, n3), 0, byArray, n, n3);
    }

    static byte[] unsignedLongToBytes(long l) {
        return GcommSerializable.unsignedLongToBytes(l, 8);
    }

    static byte[] unsignedLongToBytes(long l, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[n - 1 - i] = (byte)((l >> 8 * i) % 256L);
        }
        return byArray;
    }

    static long bytesToUnsignedLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[n + n2 - 1 - i];
            if (n3 < 0) {
                n3 += 256;
            }
            l += (long)(n3 << 8 * i);
        }
        return l;
    }

    static String bytesToString(byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    static void writeUnsignedLongTo(byte[] byArray, int n, long l, int n2) {
        System.arraycopy(GcommSerializable.unsignedLongToBytes(l, n2), 0, byArray, n, n2);
    }

    static void writeTo(ByteArrayOutputStream byteArrayOutputStream, Object object) throws GroupException {
        if (object == null) {
            GcommSerializable.writeTo(byteArrayOutputStream, 0);
        } else if (object instanceof String) {
            GcommSerializable.writeTo(byteArrayOutputStream, (String)object);
        } else if (object instanceof Integer) {
            GcommSerializable.writeTo(byteArrayOutputStream, (Integer)object);
        } else if (object instanceof GcommSerializable) {
            GcommSerializable.writeTo(byteArrayOutputStream, (GcommSerializable)object);
        } else if (object instanceof GcommSerializable[]) {
            GcommSerializable.writeTo(byteArrayOutputStream, (GcommSerializable[])object);
        } else {
            throw new GcommException(GcommException.NOTSERIALIZABLE + ": " + object.getClass());
        }
    }

    static void writeTo(ByteArrayOutputStream byteArrayOutputStream, int n) throws GroupException {
        try {
            byteArrayOutputStream.write(GcommSerializable.unsignedIntToBytes(n));
        }
        catch (IOException iOException) {
            throw new GcommException(GcommException.NOTSERIALIZABLE, (Throwable)iOException);
        }
    }

    static void writeTo(ByteArrayOutputStream byteArrayOutputStream, long l) throws GroupException {
        try {
            byteArrayOutputStream.write(GcommSerializable.unsignedLongToBytes(l));
        }
        catch (IOException iOException) {
            throw new GcommException(GcommException.NOTSERIALIZABLE, (Throwable)iOException);
        }
    }

    static void writeTo(ByteArrayOutputStream byteArrayOutputStream, boolean bl) throws GroupException {
        try {
            byteArrayOutputStream.write(GcommSerializable.booleanToByte(bl));
        }
        catch (IOException iOException) {
            throw new GcommException(GcommException.NOTSERIALIZABLE, (Throwable)iOException);
        }
    }

    static void writeTo(ByteArrayOutputStream byteArrayOutputStream, boolean[] blArray) throws GroupException {
        if (blArray == null) {
            GcommSerializable.writeTo(byteArrayOutputStream, 0);
            return;
        }
        int n = blArray.length;
        GcommSerializable.writeTo(byteArrayOutputStream, n);
        for (int i = 0; i < n; ++i) {
            GcommSerializable.writeTo(byteArrayOutputStream, blArray[i]);
        }
    }

    static void writeTo(ByteArrayOutputStream byteArrayOutputStream, String string) throws GroupException {
        try {
            if (string == null) {
                byteArrayOutputStream.write(GcommSerializable.unsignedIntToBytes(0));
                return;
            }
            byte[] byArray = string.getBytes(DEFAULT_ENCODING);
            byteArrayOutputStream.write(GcommSerializable.unsignedIntToBytes(byArray.length));
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new GcommException(GcommException.NOTSERIALIZABLE, (Throwable)iOException);
        }
    }

    static void writeTo(ByteArrayOutputStream byteArrayOutputStream, GcommSerializable gcommSerializable) throws GroupException {
        try {
            if (gcommSerializable == null) {
                byteArrayOutputStream.write(GcommSerializable.unsignedIntToBytes(0));
                return;
            }
            byte[] byArray = gcommSerializable.toBytes();
            byteArrayOutputStream.write(GcommSerializable.unsignedIntToBytes(byArray.length));
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new GcommException(GcommException.NOTSERIALIZABLE, (Throwable)iOException);
        }
    }

    static void writeTo(ByteArrayOutputStream byteArrayOutputStream, GcommSerializable[] gcommSerializableArray) throws GroupException {
        if (gcommSerializableArray == null) {
            GcommSerializable.writeTo(byteArrayOutputStream, 0);
            return;
        }
        int n = gcommSerializableArray.length;
        GcommSerializable.writeTo(byteArrayOutputStream, n);
        for (int i = 0; i < n; ++i) {
            GcommSerializable.writeTo(byteArrayOutputStream, gcommSerializableArray[i]);
        }
    }

    static void writeTo(ByteArrayOutputStream byteArrayOutputStream, Hashtable hashtable) throws GroupException {
        Enumeration enumeration = hashtable.keys();
        GcommSerializable.writeTo(byteArrayOutputStream, hashtable.size());
        if (hashtable.size() > 0) {
            while (enumeration != null && enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                GcommSerializable.writeTo(byteArrayOutputStream, k);
                GcommSerializable.writeTo(byteArrayOutputStream, hashtable.get(k));
            }
        }
    }

    static void writeTo(ByteArrayOutputStream byteArrayOutputStream, HashMap hashMap) throws GroupException {
        GcommSerializable.writeTo(byteArrayOutputStream, hashMap.size());
        if (hashMap.size() > 0) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator != null && iterator.hasNext()) {
                Object k = iterator.next();
                GcommSerializable.writeTo(byteArrayOutputStream, k);
                Object v = hashMap.get(k);
                GcommSerializable.writeTo(byteArrayOutputStream, v);
            }
        }
    }

    static void writeTo(ByteArrayOutputStream byteArrayOutputStream, HashSet hashSet) throws GroupException {
        Iterator iterator = hashSet.iterator();
        if (iterator == null) {
            GcommSerializable.writeTo(byteArrayOutputStream, 0);
            return;
        }
        GcommSerializable.writeTo(byteArrayOutputStream, hashSet.size());
        if (hashSet.size() > 0) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                GcommSerializable.writeTo(byteArrayOutputStream, e);
            }
        }
    }

    static boolean readBooleanFrom(ByteArrayInputStream byteArrayInputStream) {
        byte[] byArray = new byte[1];
        byteArrayInputStream.read(byArray, 0, 1);
        return GcommSerializable.bytesToBoolean(byArray, 0, 1);
    }

    static boolean[] readBooleanArrayFrom(ByteArrayInputStream byteArrayInputStream) throws GroupException {
        int n = GcommSerializable.readIntFrom(byteArrayInputStream);
        if (n <= 0) {
            return null;
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = GcommSerializable.readBooleanFrom(byteArrayInputStream);
        }
        return blArray;
    }

    static int readIntFrom(ByteArrayInputStream byteArrayInputStream) {
        byte[] byArray = new byte[4];
        byteArrayInputStream.read(byArray, 0, 4);
        return GcommSerializable.bytesToUnsignedInt(byArray, 0, 4);
    }

    static long readLongFrom(ByteArrayInputStream byteArrayInputStream) {
        byte[] byArray = new byte[8];
        byteArrayInputStream.read(byArray, 0, 8);
        return GcommSerializable.bytesToUnsignedLong(byArray, 0, 8);
    }

    static Address readAddressFrom(ByteArrayInputStream byteArrayInputStream) throws GroupException {
        int n = GcommSerializable.readIntFrom(byteArrayInputStream);
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        byteArrayInputStream.read(byArray, 0, n);
        return Address.parse(byArray);
    }

    static MemberID readMemberIDFrom(ByteArrayInputStream byteArrayInputStream) throws GroupException {
        int n = GcommSerializable.readIntFrom(byteArrayInputStream);
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        byteArrayInputStream.read(byArray, 0, n);
        return MemberID.parse(byArray);
    }

    static String readStringFrom(ByteArrayInputStream byteArrayInputStream) throws GroupException {
        int n = GcommSerializable.readIntFrom(byteArrayInputStream);
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        byteArrayInputStream.read(byArray, 0, n);
        String string = null;
        try {
            string = new String(byArray, 0, n, DEFAULT_ENCODING);
        }
        catch (Exception exception) {
            throw new GcommException(GcommException.NOTSERIALIZABLE, (Throwable)exception);
        }
        return string;
    }

    static int[] readIntsFrom(ByteArrayInputStream byteArrayInputStream) throws GroupException {
        int n = GcommSerializable.readIntFrom(byteArrayInputStream);
        if (n <= 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = GcommSerializable.readIntFrom(byteArrayInputStream);
        }
        return nArray;
    }

    static Address[] readAddressesFrom(ByteArrayInputStream byteArrayInputStream) throws GroupException {
        int n = GcommSerializable.readIntFrom(byteArrayInputStream);
        if (n <= 0) {
            return null;
        }
        Address[] addressArray = new Address[n];
        for (int i = 0; i < n; ++i) {
            addressArray[i] = GcommSerializable.readAddressFrom(byteArrayInputStream);
        }
        return addressArray;
    }

    static Hashtable readIDIndexTableFrom(ByteArrayInputStream byteArrayInputStream) throws GroupException {
        int n = GcommSerializable.readIntFrom(byteArrayInputStream);
        Hashtable<MemberID, Integer> hashtable = new Hashtable<MemberID, Integer>(n);
        for (int i = 0; i < n; ++i) {
            MemberID memberID = GcommSerializable.readMemberIDFrom(byteArrayInputStream);
            int n2 = GcommSerializable.readIntFrom(byteArrayInputStream);
            hashtable.put(memberID, new Integer(n2));
        }
        return hashtable;
    }

    static Hashtable readIndexMapFrom(ByteArrayInputStream byteArrayInputStream) throws GroupException {
        int n = GcommSerializable.readIntFrom(byteArrayInputStream);
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>(n);
        for (int i = 0; i < n; ++i) {
            int n2 = GcommSerializable.readIntFrom(byteArrayInputStream);
            int n3 = GcommSerializable.readIntFrom(byteArrayInputStream);
            hashtable.put(new Integer(n2), new Integer(n3));
        }
        return hashtable;
    }

    static Hashtable readDistributorTableFrom(ByteArrayInputStream byteArrayInputStream) throws GroupException {
        int n = GcommSerializable.readIntFrom(byteArrayInputStream);
        Hashtable<Address, Integer> hashtable = new Hashtable<Address, Integer>(n);
        for (int i = 0; i < n; ++i) {
            Address address = GcommSerializable.readAddressFrom(byteArrayInputStream);
            int n2 = GcommSerializable.readIntFrom(byteArrayInputStream);
            hashtable.put(address, new Integer(n2));
        }
        return hashtable;
    }

    static Hashtable readTagTableFrom(ByteArrayInputStream byteArrayInputStream) throws GroupException {
        int n = GcommSerializable.readIntFrom(byteArrayInputStream);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(n);
        for (int i = 0; i < n; ++i) {
            String string = GcommSerializable.readStringFrom(byteArrayInputStream);
            int n2 = GcommSerializable.readIntFrom(byteArrayInputStream);
            hashtable.put(string, new Integer(n2));
        }
        return hashtable;
    }

    static HashMap readHashMapFrom(ByteArrayInputStream byteArrayInputStream) throws GroupException {
        int n = GcommSerializable.readIntFrom(byteArrayInputStream);
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (int i = 0; i < n; ++i) {
            int n2 = GcommSerializable.readIntFrom(byteArrayInputStream);
            String string = GcommSerializable.readStringFrom(byteArrayInputStream);
            hashMap.put(new Integer(n2), string);
        }
        return hashMap;
    }

    static HashMap readMemberTagsFrom(ByteArrayInputStream byteArrayInputStream) throws GroupException {
        int n = GcommSerializable.readIntFrom(byteArrayInputStream);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < n; ++i) {
            int n2 = GcommSerializable.readIntFrom(byteArrayInputStream);
            int n3 = GcommSerializable.readIntFrom(byteArrayInputStream);
            hashMap.put(new Integer(n2), new Integer(n3));
        }
        return hashMap;
    }
}

