/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.ReceiptHolder;

class DistributorReceiptHolder
extends ReceiptHolder {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.DistributorReceiptHolder";
    private static int UNKNOWN_ID_INDEX = -1;
    private Hashtable distributorIDTable_ = null;
    private MemberID[] ids_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.DistributorReceiptHolder");

    DistributorReceiptHolder(ConnectionOwner connectionOwner, Packet packet, Hashtable hashtable) throws GroupException, CloneNotSupportedException {
        super(connectionOwner, packet);
        this.distributorIDTable_ = hashtable;
        int n = hashtable.size();
        this.ids_ = new MemberID[n];
        hashtable.keySet().toArray(this.ids_);
        this.bs_ = new boolean[this.ids_.length];
        Arrays.fill(this.bs_, true);
        this.totalExpected_ = super.getTotalPending();
    }

    synchronized int addReceipt(Packet packet) {
        int n = 0;
        MemberID memberID = MemberID.parse(packet.getOrigin());
        int n2 = this.indexOf(memberID);
        if (n2 < 0 || n2 >= this.bs_.length) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Unknown recipient " + packet.toString(true));
            }
            n = this.getTotalPending();
            return n;
        }
        ++this.totalArrival_;
        if (!this.bs_[n2] && this.logger_.isLoggable(Level.SEVERE)) {
            this.logger_.log(Level.SEVERE, "Receipt already clear " + packet.toString(true));
        }
        this.bs_[n2] = false;
        n = this.getTotalPending();
        if (n == 0) {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got all receipts for ack=" + packet.getAck());
            }
            this.notifyAll();
        } else if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Clear receipt for " + memberID + ", ack=" + packet.getAck() + ", total=" + n);
        }
        return n;
    }

    synchronized void removeMember(MemberID memberID) {
        this.removeDistributor(memberID);
    }

    synchronized int removeDistributor(MemberID memberID) {
        int n = this.getTotalPending();
        int n2 = this.indexOf(memberID);
        if (n2 == UNKNOWN_ID_INDEX) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Unknown distributor " + memberID);
            }
            return n;
        }
        this.bs_[n2] = false;
        n = this.getTotalPending();
        if (n == 0) {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got all receipts for ack=" + this.tag_);
            }
            super.notifyAll();
            if (this.totalArrival_ <= this.totalExpected_) {
                this.notifyWaiters();
            }
        } else if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Remove receipts of distributor for sq=" + this.tag_ + ", pending=" + n);
        }
        return n;
    }

    synchronized MemberID[] getPendingMembers() {
        MemberID[] memberIDArray = null;
        Vector<MemberID> vector = new Vector<MemberID>();
        for (int i = 0; i < this.bs_.length; ++i) {
            if (!this.bs_[i]) continue;
            vector.addElement(this.ids_[i]);
        }
        if (vector.size() > 0) {
            memberIDArray = new MemberID[vector.size()];
            vector.toArray(memberIDArray);
        }
        return memberIDArray;
    }

    synchronized void logExpiredRecipients() {
        for (int i = 0; i < this.bs_.length; ++i) {
            if (!this.bs_[i] || !this.logger_.isLoggable(Level.SEVERE)) continue;
            this.logger_.log(Level.SEVERE, "Expired recipient " + this.ids_[i] + " of " + this.terminatorPacket_);
        }
    }

    private int indexOf(MemberID memberID) {
        for (int i = 0; i < this.ids_.length; ++i) {
            if (!this.ids_[i].equals(memberID)) continue;
            return i;
        }
        return UNKNOWN_ID_INDEX;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Distributor ReceiptHolder ");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

