/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.Configuration;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.CoordinatorBroadcaster;
import oracle.ias.cache.groupv2.CoordinatorResolver;
import oracle.ias.cache.groupv2.DistributorRole;
import oracle.ias.cache.groupv2.EndPointConnection;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.GroupMember;
import oracle.ias.cache.groupv2.Listener;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.PacketHolder;
import oracle.ias.cache.groupv2.PacketProcessorFactory;
import oracle.ias.cache.groupv2.RegistrationInfo;
import oracle.ias.cache.groupv2.Sender;
import oracle.ias.cache.groupv2.SequenceToken;
import oracle.ias.cache.groupv2.View;
import oracle.ias.cache.groupv2.ViewMonitor;

class Distributor
extends ConnectionOwner {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.Client";
    private DistributorRole role_;
    private Vector clientEps_;
    private Vector distributorEps_;
    private Hashtable distributorsTable_;
    private Hashtable distributorIDTable_;
    private Listener[] listeners_;
    private boolean isInitialized_;
    private EndPointConnection coordinatorEp_;
    private Object distributorLock_;
    private GroupMember parent_;
    private Hashtable clientsTable_;
    private Vector membersToBeRemoved_;
    private Vector membersToBeAdded_;
    private Vector distributorsToBeRemoved_;
    private ViewMonitor vMon_;
    private CoordinatorBroadcaster broadcaster_;
    private CoordinatorResolver resolver_;
    private boolean terminated_;
    private Address[] discoverAddresses_;
    private HashSet networkIds_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.Client");

    Distributor(GroupMember groupMember, Configuration configuration) throws GroupException {
        super(configuration, "DI");
        this.parent_ = groupMember;
        this.distributorLock_ = new Object();
        this.clientEps_ = new Vector();
        this.distributorEps_ = new Vector();
        this.clientsTable_ = new Hashtable();
        this.distributorsTable_ = new Hashtable();
        this.distributorIDTable_ = new Hashtable();
        this.distributorEps_ = new Vector();
        this.membersToBeAdded_ = new Vector();
        this.membersToBeRemoved_ = new Vector();
        this.distributorsToBeRemoved_ = new Vector();
        this.role_ = new DistributorRole();
        if (configuration.isRouter()) {
            this.setRole(1, true);
        }
    }

    void init(boolean bl, View view, MemberID memberID, SequenceToken sequenceToken) throws GroupException {
        this.bindListeners();
        this.identifyMyPublicAddresses();
        this.setID(MemberID.generate(this.listeners_[0].getServerSocket().getLocalPort()));
        this.buildDiscoverList();
        if (bl && sequenceToken != null) {
            try {
                this.setSequenceToken(sequenceToken);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new GroupException("Unable to restore sequence token", cloneNotSupportedException);
            }
        }
        this.packetProcessor_ = PacketProcessorFactory.createAPacketProcessorOf(this);
        this.packetProcessor_.start();
        this.createViewManager();
        this.startAcceptingRequest();
        if (bl) {
            this.recoverFrom(view, memberID);
        } else {
            this.findOrBecomeCoordinator(true);
        }
        this.vMon_ = new ViewMonitor(this);
        this.vMon_.start();
        if (!this.isACoordinator() && this.getConfig().isDedicatedCoordinator()) {
            this.setAsDedicatedCoordinator();
        }
        this.isInitialized_ = true;
    }

    private void bindListeners() throws GroupException {
        Address[] addressArray = this.getConfig().getListenerAddresses();
        if (addressArray == null) {
            throw new GroupException("No listener defined");
        }
        this.listeners_ = new Listener[addressArray.length];
        for (int i = 0; i < addressArray.length; ++i) {
            this.listeners_[i] = new Listener(addressArray[i], this.getConfig().getBacklog(), this);
        }
    }

    private void identifyMyPublicAddresses() throws GroupException {
        Vector vector = this.getConfig().getDiscoverAddresses();
        for (int i = 0; i < vector.size(); ++i) {
            Address address = (Address)vector.elementAt(i);
            if (!this.amIListeningAt(address)) continue;
            this.addPublicAddress(address);
        }
    }

    private void findOrBecomeCoordinator(boolean bl) throws GroupException {
        int n = 0;
        Address address = null;
        while (n++ < this.getConfig().getMaxSystemInitRetry()) {
            if (!this.isARouter()) {
                if (this.resolver_ != null) {
                    address = this.resolver_.getConfirmedNormineeAddress();
                }
                if (address == null && this.discoverAddresses_ != null) {
                    address = this.discoverCoordinator(this.getPrimaryNetworkID());
                }
                if (address != null) {
                    this.connectToCoordinator(address);
                    return;
                }
            } else {
                Iterator iterator = this.networkIds_.iterator();
                Vector<Object> vector = new Vector<Object>();
                View[] viewArray = new View[this.networkIds_.size()];
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    Integer n2 = (Integer)iterator.next();
                    address = this.discoverCoordinator(n2);
                    if (address == null) continue;
                    this.connectToCoordinator(address);
                    try {
                        vector.addElement(this.getViewManager().getCurrentView().clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                }
                int n3 = vector.size();
                viewArray = new View[n3];
                vector.toArray(viewArray);
                if (n3 == 1) {
                    this.setAsDedicatedCoordinator();
                    return;
                }
                if (n3 > 1) {
                    this.mergeView(viewArray);
                    return;
                }
            }
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.INFO, "Unable to locate the coordinator");
            }
            if (!this.beACoordinator(bl)) {
                try {
                    if (this.resolver_.getConfirmedNormineeAddress() == null) {
                        Thread.sleep(this.getConfig().getResolutionTimeout());
                        continue;
                    }
                    Thread.sleep(this.getConfig().getResolutionInterval());
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return;
        }
        if (n >= this.getConfig().getMaxSystemInitRetry()) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Unable to find or become a group coordinator after reaching retry limit:" + n);
            }
            throw new GcommException(GcommException.INITRETRY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address discoverCoordinator(int n) throws GroupException {
        Object object;
        Address address = null;
        Address[] addressArray = this.getDiscoverList();
        if (addressArray == null || addressArray.length < 1) {
            return null;
        }
        Packet packet = new Packet(4, this.getID());
        packet.setBlockReceiver();
        packet.setData(this.getMyAddressOn(n).toBytes());
        Hashtable<Address, Object> hashtable = new Hashtable<Address, Object>(addressArray.length);
        Vector vector = new Vector(addressArray.length);
        for (int i = 0; i < addressArray.length; ++i) {
            if (addressArray[i].getNetworkId() != n) continue;
            object = new Sender(this, addressArray[i], packet, this.getConfig().getConnectTimeout(), vector, hashtable, i, false, 0);
            hashtable.put(addressArray[i], object);
            ((Thread)object).start();
        }
        while (hashtable.size() > 0 || vector.size() > 0) {
            while (vector.size() > 0) {
                Sender sender = (Sender)vector.firstElement();
                vector.removeElement(sender);
                object = sender.getReply();
                if (object == null || ((Packet)object).getFlag().contains(5) || ((Packet)object).getData() == null) continue;
                address = Address.parse(((Packet)object).getData());
                if (this.logger_.isLoggable(Level.INFO)) {
                    this.logger_.log(Level.INFO, "Found coordinator at " + address);
                }
                Hashtable<Address, Object> hashtable2 = hashtable;
                synchronized (hashtable2) {
                    if (hashtable.size() > 0) {
                        Enumeration enumeration = hashtable.keys();
                        while (enumeration.hasMoreElements()) {
                            Object k = enumeration.nextElement();
                            Sender sender2 = (Sender)hashtable.get(k);
                            if (sender2 == null) continue;
                            sender2.shutdown();
                        }
                    }
                }
                return address;
            }
            Vector vector2 = vector;
            synchronized (vector2) {
                try {
                    vector.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return address;
    }

    private void buildDiscoverList() {
        this.networkIds_ = new HashSet();
        Vector vector = (Vector)this.getConfig().getDiscoverAddresses().clone();
        if (vector == null || vector.size() <= 0) {
            this.discoverAddresses_ = null;
            return;
        }
        Address[] addressArray = this.getMyPublicAddresses();
        for (int i = 0; i < addressArray.length; ++i) {
            vector.removeElement(addressArray[i]);
        }
        if (vector.size() == 0) {
            this.discoverAddresses_ = null;
            return;
        }
        TreeSet treeSet = new TreeSet(vector);
        this.discoverAddresses_ = new Address[treeSet.size()];
        treeSet.toArray(this.discoverAddresses_);
        for (int i = 0; i < this.discoverAddresses_.length; ++i) {
            int n = this.discoverAddresses_[i].getNetworkId();
            if (n == 0) continue;
            this.networkIds_.add(new Integer(n));
        }
    }

    private Address[] getDiscoverList() {
        return this.discoverAddresses_;
    }

    private int getTotalDiscoverNetwork() {
        return this.networkIds_.size();
    }

    private int getPrimaryNetworkID() {
        return this.discoverAddresses_[0].getNetworkId();
    }

    private boolean amIListeningAt(Address address) {
        boolean bl = false;
        for (int i = 0; i < this.listeners_.length; ++i) {
            if (!address.isListenedBy(this.listeners_[i].getServerSocket())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void connectToCoordinator(Address address) throws GroupException {
        long l = System.currentTimeMillis();
        this.coordinatorEp_ = this.connect(address, this.getConfig().getConnectTimeout(), this.getConfig().getConnectRetry());
        Packet packet = new Packet(12, this.getID());
        packet.getFlag().setAsDistributor();
        RegistrationInfo registrationInfo = RegistrationInfo.wrap(null, this.getID(), this.getMyAddressOn(address.getNetworkId()), false, Distributor.getVMId(), this.getConfig().getCacheName(), null);
        packet.setData(registrationInfo.toBytes());
        packet.setBlockReceiver();
        try {
            this.coordinatorEp_.send(packet);
            Packet packet2 = null;
            while ((packet2 = this.coordinatorEp_.read()).getType() != 1) {
                if (this.logger_.isLoggable(Level.FINE)) {
                    this.logger_.log(Level.FINE, "Expect reply of " + packet + ", got " + packet2.toString(true));
                }
                if (System.currentTimeMillis() - l <= (long)this.getConfig().getConnectTimeout()) continue;
                this.coordinatorEp_.close();
                this.coordinatorEp_ = null;
                throw new GcommException(GcommException.REGISTRATION);
            }
            MemberID memberID = MemberID.parse(packet2.getOrigin());
            this.coordinatorEp_.setType(0);
            this.addDistributor(address, memberID, this.coordinatorEp_);
            if (this.logger_.isLoggable(Level.INFO)) {
                this.logger_.log(Level.INFO, "Connected to coordinator " + memberID);
            }
            this.coordinatorEp_.start();
            View view = View.parse(packet2.getData());
            this.getViewManager().addView(view);
            this.getViewManager().updateToLatest(true);
            this.asynclinkToOtherDistributors(view.getDistributorAddresses(address.getNetworkId()));
        }
        catch (Exception exception) {
            if (this.coordinatorEp_ != null) {
                this.coordinatorEp_.close();
                this.coordinatorEp_ = null;
            }
            throw new GcommException(GcommException.REGISTRATION, (Throwable)exception);
        }
    }

    EndPointConnection connect(Address address, int n, int n2) {
        String string = address.getHostName();
        int n3 = address.getPort();
        Socket socket = null;
        EndPointConnection endPointConnection = null;
        int n4 = 0;
        while (endPointConnection == null && n4++ <= n2) {
            block9: {
                try {
                    socket = this.getConfig().isSSLEnabled() ? this.getSSLManager().createSSLSocket() : new Socket();
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n3);
                    socket.connect(inetSocketAddress, n);
                    socket.setSoTimeout(n);
                    if (this.logger_.isLoggable(Level.FINE)) {
                        this.logger_.log(Level.FINE, "Connected to distributor at " + inetSocketAddress);
                    }
                    endPointConnection = new EndPointConnection(super.getEpThreadGroup(), socket, address.getNetworkId(), this);
                    endPointConnection.setType(1);
                    endPointConnection.setRemoteAddress(address);
                }
                catch (Exception exception) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!this.logger_.isLoggable(Level.FINE)) break block9;
                    this.logger_.log(Level.FINE, "Unable to connect to " + address + ", retry=" + n4 + " " + exception);
                }
            }
            if (endPointConnection != null || n4 > n2) continue;
            try {
                Thread.sleep(this.getConfig().getConnectRetryDelay());
            }
            catch (InterruptedException interruptedException) {}
        }
        return endPointConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asynclinkToOtherDistributors(Address[] addressArray) throws GroupException {
        Object object;
        if (addressArray == null || addressArray.length < 1) {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "No other distributors to be linked");
            }
            return;
        }
        int n = addressArray[0].getNetworkId();
        Packet packet = new Packet(8, this.getID());
        packet.setData(this.getMyAddressOn(n).toBytes());
        packet.setBlockReceiver();
        Hashtable<Address, Object> hashtable = new Hashtable<Address, Object>(addressArray.length);
        Vector vector = new Vector(addressArray.length);
        for (int i = 0; i < addressArray.length; ++i) {
            if (addressArray[i].equals(this.getMyAddressOn(1)) || this.distributorsTable_.containsKey(addressArray[i])) continue;
            object = new Sender(this, addressArray[i], packet, this.getConfig().getConnectTimeout(), vector, hashtable, i, true, this.getConfig().getConnectRetry());
            hashtable.put(addressArray[i], object);
            ((Thread)object).start();
        }
        while (hashtable.size() > 0 || vector.size() > 0) {
            while (vector.size() > 0) {
                Sender sender = (Sender)vector.firstElement();
                vector.removeElement(sender);
                object = sender.getReply();
                if (object == null) continue;
                EndPointConnection endPointConnection = sender.getEndPoint();
                if (((Packet)object).getType() != 8 && !((Packet)object).isAReply()) {
                    if (!this.logger_.isLoggable(Level.SEVERE)) continue;
                    this.logger_.log(Level.SEVERE, "Expect reply of " + packet + ", got " + object);
                    continue;
                }
                if (((Packet)object).getFlag().contains(5)) {
                    endPointConnection.setTightlyBound(false);
                    endPointConnection.close();
                    continue;
                }
                MemberID memberID = MemberID.parse(((Packet)object).getOrigin());
                try {
                    boolean bl = this.addDistributor(sender.getDestination(), memberID, endPointConnection);
                    if (!bl) {
                        if (!this.logger_.isLoggable(Level.SEVERE)) continue;
                        this.logger_.log(Level.SEVERE, "Unhandled duplicated EndPoint " + endPointConnection);
                        continue;
                    }
                    if (((Packet)object).getFlag().contains(3)) {
                        this.setCoordinatorEp(endPointConnection);
                        if (this.logger_.isLoggable(Level.INFO)) {
                            this.logger_.log(Level.INFO, "Connected to coordinator " + memberID);
                        }
                    } else if (this.logger_.isLoggable(Level.INFO)) {
                        this.logger_.log(Level.INFO, "Connected to distributor " + memberID);
                    }
                    endPointConnection.start();
                }
                catch (IOException iOException) {
                    if (!this.logger_.isLoggable(Level.SEVERE)) continue;
                    this.logger_.log(Level.SEVERE, "Unable to add distributor", iOException);
                }
            }
            Vector vector2 = vector;
            synchronized (vector2) {
                try {
                    vector.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean beACoordinator(boolean bl) throws GroupException {
        boolean bl2 = false;
        Address[] addressArray = this.getDiscoverList();
        if (this.isACoordinator()) {
            return true;
        }
        if (addressArray == null) {
            this.setRole(0, true);
            if (!bl) {
                this.replaceCoordinator(false);
            }
            return true;
        }
        if (this.broadcaster_ != null) {
            this.broadcaster_.shutdown();
        }
        if (this.resolver_ != null) {
            this.resolver_.shutdown();
        }
        if (this.getConfig().isUseMulticastResolution()) {
            this.broadcaster_ = new CoordinatorBroadcaster(this, false, false);
            this.resolver_ = new CoordinatorResolver(this, this.broadcaster_.getMulticastSocket(), !bl, this.getConfig().getResolutionTimeout(), addressArray.length);
        } else {
            this.broadcaster_ = new CoordinatorBroadcaster(this, addressArray, false, !bl);
            int n = 0;
            n = bl ? addressArray.length : this.distributorIDTable_.size();
            this.resolver_ = new CoordinatorResolver(this, !bl, this.getConfig().getResolutionTimeout(), n);
        }
        this.broadcaster_.start();
        this.resolver_.start();
        long l = System.currentTimeMillis();
        try {
            this.resolver_.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.resolver_.canBeCoordinator()) {
            if (!bl) {
                this.replaceCoordinator(true);
            }
            this.setRole(0, true);
            this.broadcaster_.confirmNominee();
            if (!bl) {
                this.broadcaster_.setToConnectedMembersOnly(false);
            }
            this.resolver_.shutdown();
            this.broadcaster_.shutdown(this.getConfig().getResolutionTimeout() * 2L);
            if (this.logger_.isLoggable(Level.INFO)) {
                this.logger_.log(Level.INFO, "Won coordinator election");
            }
            bl2 = true;
        } else {
            this.resolver_.shutdown();
            this.broadcaster_.shutdown();
            if (this.logger_.isLoggable(Level.INFO)) {
                this.logger_.log(Level.INFO, "Lost coordinator election");
            }
        }
        return bl2;
    }

    private void replaceCoordinator(boolean bl) {
        try {
            this.getViewManager().replaceCoordinator(this.getID(), bl);
        }
        catch (Exception exception) {
            this.logger_.log(Level.SEVERE, "Unable to replace current coordinator", exception);
        }
    }

    private void recoverFrom(View view, MemberID memberID) throws GroupException {
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "Recover from view ID=" + view.getViewID());
        }
        if (view.getDistributorAddresses().length == 1) {
            this.promoteToCoordinator(view, true, memberID);
            return;
        }
        Address address = view.getCoordinatorAddress();
        try {
            if (address != null && !this.getMyAddressOn(1).equals(address)) {
                this.connectToCoordinator(address);
            }
        }
        catch (GroupException groupException) {
            // empty catch block
        }
        while (this.coordinatorEp_ == null && !this.isACoordinator()) {
            this.findOrBecomeCoordinator(true);
        }
        if (this.isACoordinator()) {
            this.promoteToCoordinator(view, false, memberID);
            return;
        }
        Packet packet = new Packet(15, this.getID());
        packet.setData(this.getMyAddressOn(1).toBytes());
        packet.setBlockReceiver();
        boolean bl = false;
        boolean bl2 = false;
        MemberID memberID2 = this.getViewManager().getCurrentView().getCoordinatorID();
        while (!bl2 && !this.isTerminating()) {
            try {
                View view2;
                if (!bl) {
                    this.forwardToCoordinator(packet);
                    bl = true;
                }
                if ((view2 = this.getViewManager().getCurrentView()).contains(this.getID())) {
                    bl2 = true;
                } else if (!memberID2.equals(view2.getCoordinatorID())) {
                    bl = false;
                    memberID2 = view2.getCoordinatorID();
                }
            }
            catch (Exception exception) {
                this.logger_.log(Level.SEVERE, "Unable to ask coordinator to recover the distributor", exception);
            }
            try {
                Thread.sleep(this.getConfig().getResolutionTimeout());
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    private void promoteToCoordinator(View view, boolean bl, MemberID memberID) throws GroupException {
        Address[] addressArray;
        this.logger_.log(Level.INFO, "Promoting to coordinator");
        View view2 = View.replaceDistributorFrom(view, memberID, this.getID());
        view2.setCoordinator(this.getID());
        this.createViewManager(view2);
        this.setRole(0, true);
        if (bl && (addressArray = this.getDiscoverList()) != null) {
            if (this.broadcaster_ != null) {
                this.broadcaster_.shutdown();
            }
            this.broadcaster_ = new CoordinatorBroadcaster(this, addressArray, true, false);
            this.broadcaster_.start();
            this.broadcaster_.shutdown(this.getConfig().getResolutionTimeout() * 2L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void shutdown(boolean bl) throws GroupException {
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "Shutting down " + this.role_);
        }
        if (this.resolver_ != null) {
            this.resolver_.shutdown();
        }
        if (this.broadcaster_ != null) {
            this.broadcaster_.shutdown();
        }
        for (int i = 0; i < this.listeners_.length; ++i) {
            if (this.listeners_[i] == null) continue;
            this.listeners_[i].shutdown();
        }
        super.shutdown();
        this.markAsClosing(this.clientEps_, null);
        this.markAsClosing(this.distributorEps_, null);
        this.waitForEmptyQueue(1, this.getConfig().getDisconnectTimeout());
        this.waitForEmptyQueue(0, this.getConfig().getDisconnectTimeout());
        if (bl) {
            Packet packet = new Packet(2, this.getID());
            packet.setBlockReceiver();
            packet.setData(this.getID().toBytes());
            Vector vector = this.clientEps_;
            synchronized (vector) {
                for (int i = 0; i < this.clientEps_.size(); ++i) {
                    EndPointConnection endPointConnection = (EndPointConnection)this.clientEps_.elementAt(i);
                    try {
                        if (endPointConnection == null) continue;
                        this.sendPacketTo(endPointConnection, packet);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            if (this.packetProcessor_ != null) {
                this.packetProcessor_.shutdown();
                this.packetProcessor_.join(this.getConfig().getDisconnectTimeout());
            }
        }
        catch (InterruptedException interruptedException) {
            this.logger_.log(Level.WARNING, "PacketProcessor shutdown is interrupted:", interruptedException);
        }
        if (this.clientEps_ != null) {
            this.close(this.clientEps_, null);
        }
        if (this.clientsTable_ != null) {
            this.clientsTable_.clear();
        }
        if (this.distributorEps_ != null) {
            this.close(this.distributorEps_, this.coordinatorEp_);
        }
        if (this.distributorsTable_ != null) {
            this.distributorsTable_.clear();
        }
        if (this.coordinatorEp_ != null) {
            this.coordinatorEp_.close();
            this.coordinatorEp_ = null;
        }
        this.membersToBeAdded_.clear();
        if (this.vMon_ != null) {
            this.vMon_.shutdown();
        }
        super.cleanup();
        this.terminated_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addDistributor(Address address, MemberID memberID, EndPointConnection endPointConnection) throws GroupException, IOException {
        Object object = this.distributorLock_;
        synchronized (object) {
            if (this.distributorIDTable_.containsKey(memberID)) {
                if (this.logger_.isLoggable(Level.SEVERE)) {
                    this.logger_.log(Level.SEVERE, "Encountered duplicated distributor " + memberID);
                }
                return false;
            }
            endPointConnection.setTightlyBound(true);
            endPointConnection.setRemoteMemberID(memberID);
            endPointConnection.setRemoteAddress(address);
            endPointConnection.setNetworkId(address.getNetworkId());
            this.distributorEps_.addElement(endPointConnection);
            this.distributorsTable_.put(address, endPointConnection);
            this.distributorIDTable_.put(memberID, endPointConnection);
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Add EndPoint " + EndPointConnection.TYPE[endPointConnection.getType()] + " " + memberID);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClient(MemberID memberID, EndPointConnection endPointConnection) throws GroupException {
        Object object = this.distributorLock_;
        synchronized (object) {
            if (this.clientsTable_.containsKey(memberID)) {
                if (this.logger_.isLoggable(Level.SEVERE)) {
                    this.logger_.log(Level.SEVERE, "Encountered duplicated client " + memberID);
                }
                return;
            }
            endPointConnection.setTightlyBound(true);
            endPointConnection.setRemoteMemberID(memberID);
            this.clientsTable_.put(memberID, endPointConnection);
            if (!this.clientEps_.contains(endPointConnection)) {
                this.clientEps_.addElement(endPointConnection);
            }
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, "Add client " + memberID);
            }
        }
    }

    void sendToClient(byte[] byArray, Packet packet) throws IOException, GroupException {
        EndPointConnection endPointConnection = (EndPointConnection)this.clientsTable_.get(MemberID.parse(byArray));
        if (endPointConnection != null) {
            this.sendPacketTo(endPointConnection, packet);
        } else if (this.logger_.isLoggable(Level.SEVERE)) {
            this.logger_.log(Level.SEVERE, "No connection to client: " + MemberID.parse(byArray));
        }
    }

    long forwardToCoordinator(Packet packet) throws GroupException, IOException {
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Forward to coordinator " + packet);
        }
        this.sendPacketTo(this.coordinatorEp_, packet);
        return packet.getSequence();
    }

    void sendTo(View view, Packet packet, HashSet hashSet, HashSet hashSet2) throws IOException, GroupException, CloneNotSupportedException {
        if (this.logger_.isLoggable(Level.FINER)) {
            this.logger_.log(Level.FINER, "Forward " + packet + " to Vid:" + view.getViewID());
        }
        this.sendToClients(packet, view, hashSet);
        this.sendToDistributors(packet, view, hashSet2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendToClients(Packet packet, View view, HashSet hashSet) throws GroupException {
        MemberID[] memberIDArray = view.getAllMembersOf(this.getID());
        if (memberIDArray == null) {
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, "No clients for " + this.getID());
            }
            return;
        }
        Hashtable hashtable = this.clientsTable_;
        synchronized (hashtable) {
            for (int i = 0; i < memberIDArray.length; ++i) {
                EndPointConnection endPointConnection;
                if (hashSet != null && hashSet.contains(memberIDArray[i]) || (endPointConnection = (EndPointConnection)this.clientsTable_.get(memberIDArray[i])) == null) continue;
                try {
                    this.sendPacketTo(endPointConnection, packet);
                    continue;
                }
                catch (IOException iOException) {
                    if (!this.logger_.isLoggable(Level.WARNING)) continue;
                    this.logger_.log(Level.WARNING, "Unable to send " + packet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendToClient(MemberID memberID, Packet packet) throws GroupException {
        Hashtable hashtable = this.clientsTable_;
        synchronized (hashtable) {
            block6: {
                EndPointConnection endPointConnection = (EndPointConnection)this.clientsTable_.get(memberID);
                if (endPointConnection != null) {
                    try {
                        this.sendPacketTo(endPointConnection, packet);
                    }
                    catch (IOException iOException) {
                        if (!this.logger_.isLoggable(Level.WARNING)) break block6;
                        this.logger_.log(Level.WARNING, "Unable to send " + packet);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendToDistributors(Packet packet, View view, HashSet hashSet) throws GroupException {
        MemberID[] memberIDArray = view.getDistributorIDs();
        Hashtable hashtable = this.distributorIDTable_;
        synchronized (hashtable) {
            for (int i = 0; i < memberIDArray.length; ++i) {
                EndPointConnection endPointConnection;
                if (this.getID().equals(memberIDArray[i]) || hashSet != null && hashSet.contains(memberIDArray[i]) || (endPointConnection = (EndPointConnection)this.distributorIDTable_.get(memberIDArray[i])) == null) continue;
                try {
                    this.sendPacketTo(endPointConnection, packet);
                    continue;
                }
                catch (IOException iOException) {
                    if (!this.logger_.isLoggable(Level.WARNING)) continue;
                    this.logger_.log(Level.WARNING, "Unable to send " + packet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendToDistributor(MemberID memberID, Packet packet) throws GroupException {
        Hashtable hashtable = this.distributorIDTable_;
        synchronized (hashtable) {
            block6: {
                EndPointConnection endPointConnection = (EndPointConnection)this.distributorIDTable_.get(memberID);
                if (endPointConnection != null) {
                    try {
                        this.sendPacketTo(endPointConnection, packet);
                    }
                    catch (IOException iOException) {
                        if (!this.logger_.isLoggable(Level.WARNING)) break block6;
                        this.logger_.log(Level.WARNING, "Unable to send " + packet);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendToDistributors(Packet packet) {
        int n = 0;
        Hashtable hashtable = this.distributorIDTable_;
        synchronized (hashtable) {
            if (this.distributorIDTable_.size() <= 0) {
                return 0;
            }
            Enumeration enumeration = this.distributorIDTable_.keys();
            while (enumeration.hasMoreElements()) {
                EndPointConnection endPointConnection;
                Object k = enumeration.nextElement();
                if (this.getID().equals(k) || (endPointConnection = (EndPointConnection)this.distributorIDTable_.get(k)) == null) continue;
                try {
                    this.sendPacketTo(endPointConnection, packet);
                    ++n;
                }
                catch (Exception exception) {
                    if (!this.logger_.isLoggable(Level.WARNING)) continue;
                    this.logger_.log(Level.WARNING, "Unable to send " + packet);
                }
            }
        }
        return n;
    }

    void replyToSender(EndPointConnection endPointConnection, Packet packet) throws GroupException, IOException {
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Reply to sender directly " + packet);
        }
        byte[] byArray = packet.getOrigin();
        packet.setDestination(byArray);
        packet.setOrigin(this.getID());
        packet.setAsReply();
        packet.setAck(packet.getSequence());
        this.sendPacketTo(endPointConnection, packet);
    }

    void sendPacketTo(EndPointConnection[] endPointConnectionArray, Packet packet, boolean bl) {
        for (int i = 0; i < endPointConnectionArray.length; ++i) {
            try {
                if (endPointConnectionArray[i] == null) continue;
                this.sendPacketTo(endPointConnectionArray[i], packet);
                continue;
            }
            catch (Exception exception) {
                if (!this.logger_.isLoggable(Level.SEVERE)) continue;
                this.logger_.log(Level.SEVERE, "Unable to send " + packet + " to " + endPointConnectionArray[i], exception);
            }
        }
    }

    void sendPacketTo(EndPointConnection endPointConnection, Packet packet) throws IOException, GroupException {
        packet.getFlag().setAsDistributor();
        if (this.isACoordinator()) {
            packet.getFlag().setAsCoordinator();
        }
        if (this.isARouter()) {
            packet.getFlag().setAsRouter();
        }
        this.enqueue(0, PacketHolder.wrap(packet, endPointConnection));
    }

    Address getCoordinatorAddress() {
        if (this.coordinatorEp_ != null) {
            return this.coordinatorEp_.getRemoteAddress();
        }
        return null;
    }

    void setCoordinatorEp(EndPointConnection endPointConnection) {
        endPointConnection.setType(0);
        this.coordinatorEp_ = endPointConnection;
    }

    void startAcceptingRequest() {
        for (int i = 0; i < this.listeners_.length; ++i) {
            if (this.listeners_[i].isAlive()) continue;
            this.listeners_[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForInitCompleted(long l) throws GroupException {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 < l) {
            try {
                Object object = this.distributorLock_;
                synchronized (object) {
                    if (this.isInitialized_) {
                        break;
                    }
                    this.distributorLock_.wait(500L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (System.currentTimeMillis() - l2 >= l) {
            throw new GcommException(GcommException.DISTRIBUTORINITTIMEOUT);
        }
    }

    boolean isAlreadyConnectedTo(Address address) {
        return this.distributorsTable_.containsKey(address);
    }

    private void doClientTermination(EndPointConnection endPointConnection) throws GroupException, CloneNotSupportedException, IOException {
        this.clientEps_.remove(endPointConnection);
        MemberID memberID = endPointConnection.getRemoteMemberID();
        if (memberID == null) {
            this.removeDistributorEp(endPointConnection);
            this.doDistributorTermination(endPointConnection);
        } else {
            this.doClientTermination(memberID, endPointConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClientTermination(MemberID memberID, EndPointConnection endPointConnection) throws GroupException, CloneNotSupportedException, IOException {
        Cloneable cloneable = this.clientsTable_;
        synchronized (cloneable) {
            this.clientsTable_.remove(memberID);
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, "Removed connection for member: " + memberID);
            }
        }
        this.getViewManager().lock(0, 0);
        try {
            cloneable = this.getViewManager().getCurrentView();
            if (!((View)cloneable).contains(memberID)) {
                if (this.logger_.isLoggable(Level.FINEST)) {
                    this.logger_.log(Level.FINEST, "Already removed: " + memberID);
                }
                return;
            }
        }
        finally {
            this.getViewManager().unlock(0, 0);
        }
        boolean bl = false;
        Object object = this.getViewManager().getCurrentView().getCoordinatorID();
        while (!this.isTerminating()) {
            Object object2;
            block21: {
                if (this.isACoordinator()) {
                    object2 = this.membersToBeRemoved_;
                    synchronized (object2) {
                        if (!this.membersToBeRemoved_.contains(memberID)) {
                            this.membersToBeRemoved_.addElement(memberID);
                        }
                    }
                    this.getViewManager().removeMembers(this.membersToBeRemoved_, this.distributorsToBeRemoved_, this.getQueue(1));
                    break;
                }
                if (!bl) {
                    object2 = new Packet(2, this.getID());
                    ((Packet)object2).setData(memberID.toBytes());
                    try {
                        this.forwardToCoordinator((Packet)object2);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        if (!this.logger_.isLoggable(Level.INFO)) break block21;
                        this.logger_.log(Level.INFO, "Retry notifying coordinator for a  disconnected member: " + this.getID());
                    }
                }
            }
            try {
                EndPointConnection.sleep(this.getConfig().getResolutionTimeout());
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            if (!this.getViewManager().viewContains(0, memberID)) break;
            object2 = this.getViewManager().getCurrentView().getCoordinatorID();
            if (((MemberID)object).equals(object2)) continue;
            object = object2;
            bl = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EndPointConnection getEndPointConnectionOf(MemberID memberID, boolean bl) {
        EndPointConnection endPointConnection = null;
        if (memberID == null) {
            return endPointConnection;
        }
        if (bl) {
            Hashtable hashtable = this.clientsTable_;
            synchronized (hashtable) {
                endPointConnection = (EndPointConnection)this.clientsTable_.get(memberID);
            }
        }
        Hashtable hashtable = this.distributorIDTable_;
        synchronized (hashtable) {
            endPointConnection = (EndPointConnection)this.distributorIDTable_.get(memberID);
        }
        return endPointConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDistributorEp(EndPointConnection endPointConnection) throws GroupException {
        Address address = endPointConnection.getRemoteAddress();
        MemberID memberID = endPointConnection.getRemoteMemberID();
        if (address == null) {
            return;
        }
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "Lost connection " + endPointConnection);
        }
        Cloneable cloneable = this.distributorIDTable_;
        synchronized (cloneable) {
            Object var5_5 = null;
            Enumeration enumeration = this.distributorIDTable_.keys();
            while (enumeration.hasMoreElements()) {
                var5_5 = enumeration.nextElement();
                EndPointConnection endPointConnection2 = (EndPointConnection)this.distributorIDTable_.get(var5_5);
                if (endPointConnection2 != endPointConnection) continue;
                this.distributorIDTable_.remove(var5_5);
                break;
            }
        }
        cloneable = this.distributorsToBeRemoved_;
        synchronized (cloneable) {
            this.distributorsToBeRemoved_.addElement(memberID);
        }
        this.distributorEps_.remove(endPointConnection);
        if (address != null) {
            this.distributorsTable_.remove(address);
        }
        if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, "Removed distributor connection " + memberID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDistributorTermination(EndPointConnection endPointConnection) throws GroupException, CloneNotSupportedException, IOException {
        Address address = endPointConnection.getRemoteAddress();
        MemberID memberID = endPointConnection.getRemoteMemberID();
        if (address == null) {
            return;
        }
        boolean bl = false;
        while (!bl && !this.isTerminating()) {
            if (this.isACoordinator()) {
                this.removeDistributorFromView(memberID);
                bl = true;
            } else {
                bl = !this.getViewManager().viewContains(0, memberID);
            }
            try {
                EndPointConnection endPointConnection2 = endPointConnection;
                synchronized (endPointConnection2) {
                    endPointConnection.wait(this.getConfig().getResolutionInterval());
                }
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    private void doCoordinatorTermination(EndPointConnection endPointConnection) throws GroupException, IOException, CloneNotSupportedException {
        this.coordinatorEp_ = null;
        MemberID memberID = endPointConnection.getRemoteMemberID();
        this.removeDistributorEp(endPointConnection);
        boolean bl = false;
        while (!bl && !this.isTerminating()) {
            if (this.beACoordinator(false)) {
                this.removeDistributorFromView(memberID);
                bl = true;
                continue;
            }
            try {
                Thread.sleep(this.getConfig().getResolutionTimeout());
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            bl = !this.getViewManager().viewContains(0, memberID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDistributorFromView(MemberID memberID) throws GroupException, IOException, CloneNotSupportedException {
        View view = this.getViewManager().getCurrentView();
        if (view.hasAnyMembersFrom(memberID, false)) {
            long l = System.currentTimeMillis();
            while (System.currentTimeMillis() - l < this.getConfig().getResolutionTimeout() && !this.isTerminating()) {
                try {
                    Thread.sleep(this.getConfig().getResolutionInterval());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((view = this.getViewManager().getCurrentView()).contains(memberID)) continue;
            }
        }
        if (view.contains(memberID) && !this.isTerminating()) {
            Vector vector = this.distributorsToBeRemoved_;
            synchronized (vector) {
                if (!this.distributorsToBeRemoved_.contains(memberID)) {
                    this.distributorsToBeRemoved_.addElement(memberID);
                }
            }
            this.getViewManager().removeMembers(this.membersToBeRemoved_, this.distributorsToBeRemoved_, this.getQueue(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Vector vector, EndPointConnection endPointConnection) {
        Vector vector2 = vector;
        synchronized (vector2) {
            for (int i = 0; i < vector.size(); ++i) {
                EndPointConnection endPointConnection2 = (EndPointConnection)vector.elementAt(i);
                if (endPointConnection2 == endPointConnection) continue;
                endPointConnection2.close();
                try {
                    endPointConnection2.join(this.getConfig().getDisconnectTimeout());
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    endPointConnection2.destroy();
                    if (!this.logger_.isLoggable(Level.WARNING)) continue;
                    this.logger_.log(Level.WARNING, "Ungraceful disconnection for " + endPointConnection2, interruptedException);
                }
            }
        }
        vector.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAsClosing(Vector vector, EndPointConnection endPointConnection) {
        Vector vector2 = vector;
        synchronized (vector2) {
            for (int i = 0; i < vector.size(); ++i) {
                EndPointConnection endPointConnection2 = (EndPointConnection)vector.elementAt(i);
                if (endPointConnection2 == endPointConnection) continue;
                endPointConnection2.toBeDisconnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPendingNewMember(RegistrationInfo registrationInfo) throws GroupException, IOException, CloneNotSupportedException {
        Vector vector = this.membersToBeAdded_;
        synchronized (vector) {
            this.membersToBeAdded_.addElement(registrationInfo);
        }
        this.getViewManager().addMembers(this.getMembersToBeAdded(), this.getDistributorsToBeRemoved(), this.getMembersToBeRemoved(), this.getQueue(1));
    }

    Vector getMembersToBeAdded() {
        return this.membersToBeAdded_;
    }

    Vector getDistributorsToBeRemoved() {
        return this.distributorsToBeRemoved_;
    }

    Vector getMembersToBeRemoved() {
        return this.membersToBeRemoved_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Address[] getDistributorAddresses() {
        Address[] addressArray = null;
        Hashtable hashtable = this.distributorsTable_;
        synchronized (hashtable) {
            if (this.distributorsTable_ != null && this.distributorsTable_.size() > 0) {
                addressArray = new Address[this.distributorsTable_.size()];
                this.distributorsTable_.keySet().toArray(addressArray);
            }
        }
        return addressArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposeConnection(EndPointConnection endPointConnection) throws GroupException, CloneNotSupportedException, IOException {
        if (this.isTerminating()) {
            return;
        }
        switch (endPointConnection.getType()) {
            case 2: {
                this.doClientTermination(endPointConnection);
                break;
            }
            case 1: {
                this.removeDistributorEp(endPointConnection);
                try {
                    this.getViewMonitor().toPause(true);
                    this.doDistributorTermination(endPointConnection);
                    break;
                }
                finally {
                    this.getViewMonitor().reset();
                    this.getViewMonitor().toPause(false);
                }
            }
            case 0: {
                try {
                    this.getViewMonitor().toPause(true);
                    this.doCoordinatorTermination(endPointConnection);
                    break;
                }
                finally {
                    this.getViewMonitor().reset();
                    this.getViewMonitor().toPause(false);
                }
            }
        }
    }

    Vector getNonExistClients() throws GroupException {
        View view = this.getViewManager().getCurrentView();
        MemberID[] memberIDArray = view.getAllMembersOf(this.getID());
        Vector<MemberID> vector = new Vector<MemberID>();
        if (memberIDArray != null) {
            for (int i = 0; i < memberIDArray.length; ++i) {
                if (this.clientsTable_.containsKey(memberIDArray[i])) continue;
                vector.addElement(memberIDArray[i]);
            }
        }
        return vector;
    }

    Vector getNonExistDistributors() throws GroupException {
        View view = this.getViewManager().getCurrentView();
        Vector<MemberID> vector = new Vector<MemberID>();
        MemberID[] memberIDArray = view.getDistributorIDs();
        if (memberIDArray != null) {
            for (int i = 0; i < memberIDArray.length; ++i) {
                if (this.distributorIDTable_.containsKey(memberIDArray[i]) || memberIDArray[i].equals(this.getID())) continue;
                vector.addElement(memberIDArray[i]);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector getInvalidClientEps() throws GroupException {
        Vector vector = new Vector();
        Hashtable hashtable = this.clientsTable_;
        synchronized (hashtable) {
            Set set = this.clientsTable_.keySet();
            if (set != null) {
                View view = this.getViewManager().getCurrentView();
                MemberID[] memberIDArray = new MemberID[set.size()];
                set.toArray(memberIDArray);
                for (int i = 0; i < memberIDArray.length; ++i) {
                    if (view.contains(memberIDArray[i])) continue;
                    vector.addElement(this.clientsTable_.get(memberIDArray[i]));
                }
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector getInvalidDistributorEps() throws GroupException {
        Vector vector = new Vector();
        Hashtable hashtable = this.distributorIDTable_;
        synchronized (hashtable) {
            Set set = this.distributorIDTable_.keySet();
            if (set != null) {
                View view = this.getViewManager().getCurrentView();
                MemberID[] memberIDArray = new MemberID[set.size()];
                set.toArray(memberIDArray);
                for (int i = 0; i < memberIDArray.length; ++i) {
                    if (view.contains(memberIDArray[i])) continue;
                    vector.addElement(this.distributorIDTable_.get(memberIDArray[i]));
                }
            }
        }
        return vector;
    }

    ViewMonitor getViewMonitor() {
        return this.vMon_;
    }

    boolean isTerminated() {
        return this.terminated_;
    }

    boolean isACoordinator() {
        return this.role_.has(0);
    }

    boolean isARouter() {
        return this.role_.has(1);
    }

    void setRole(int n, boolean bl) {
        this.role_.set(n, bl);
        super.setPrefix(this.role_.toString());
        if (this.getID() != null && this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "Set new role " + this.getID());
        }
    }

    void setAsDedicatedCoordinator() throws GroupException {
        this.role_.set(0, true);
        super.setPrefix(this.role_.toString());
        try {
            Packet packet = new Packet(16, this.getID());
            packet.setBlockReceiver();
            this.forwardToCoordinator(packet);
            this.getViewManager().replaceCoordinator(this.getID(), true);
        }
        catch (Exception exception) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Unable to run as the dedicated coordinator", exception);
            }
            throw new GcommException(GcommException.REGISTRATION, (Throwable)exception);
        }
    }

    void mergeView(View[] viewArray) throws GroupException {
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "Merge views");
        }
        this.role_.set(0, true);
        super.setPrefix(this.role_.toString());
        try {
            Packet packet = new Packet(16, this.getID());
            packet.setBlockReceiver();
            for (int i = 0; i < viewArray.length; ++i) {
                this.sendPacketTo(this.getEndPointConnectionOf(viewArray[i].getCoordinatorID(), false), packet);
            }
            this.getViewManager().merge(viewArray, this.getID(), true);
        }
        catch (Exception exception) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Unable to run as the dedicated coordinator", exception);
            }
            throw new GcommException(GcommException.REGISTRATION, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(int n, PacketHolder packetHolder) {
        Vector vector;
        Vector vector2 = vector = this.getQueue(n);
        synchronized (vector2) {
            if (!this.getQueueStatus(n)) {
                return;
            }
            Packet packet = packetHolder.getPacket();
            vector.addElement(packetHolder);
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, QUEUE_TYPE_NAMES[n] + " put " + packet);
            }
            vector.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PacketHolder dequeue(int n, long l) {
        Vector vector;
        PacketHolder packetHolder = null;
        Vector vector2 = vector = this.getQueue(n);
        synchronized (vector2) {
            if (vector.size() == 0) {
                try {
                    vector.wait(l);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                Packet packet = null;
                if (n == 1 && this.isACoordinator() && this.getViewManager().isInProgress()) {
                    for (int i = 0; i < vector.size(); ++i) {
                        packetHolder = (PacketHolder)vector.elementAt(i);
                        packet = packetHolder.getPacket();
                        if (!packet.isAReply() || packet.getType() != 1 && packet.getType() != 10 && packet.getType() != 8) continue;
                        vector.removeElementAt(i);
                        if (this.logger_.isLoggable(Level.FINEST)) {
                            this.logger_.log(Level.FINEST, QUEUE_TYPE_NAMES[n] + " remove high priority" + packet);
                        }
                        return packetHolder;
                    }
                    packetHolder = (PacketHolder)vector.firstElement();
                    packet = packetHolder.getPacket();
                    if (packet.isARequest() && packet.getType() == 2) {
                        packetHolder = null;
                        if (this.logger_.isLoggable(Level.FINEST)) {
                            this.logger_.log(Level.FINEST, QUEUE_TYPE_NAMES[n] + " Viewchange in progress. Hold " + packet);
                        }
                        try {
                            vector.wait(l);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        vector.removeElementAt(0);
                        if (this.logger_.isLoggable(Level.FINEST)) {
                            this.logger_.log(Level.FINEST, QUEUE_TYPE_NAMES[n] + " remove " + packet);
                        }
                    }
                } else {
                    packetHolder = (PacketHolder)vector.firstElement();
                    packet = packetHolder.getPacket();
                    vector.removeElementAt(0);
                    if (this.logger_.isLoggable(Level.FINEST)) {
                        this.logger_.log(Level.FINEST, QUEUE_TYPE_NAMES[n] + " remove " + packet);
                    }
                }
            }
        }
        return packetHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        MemberID memberID;
        int n;
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isTerminating()) {
            stringBuffer.append("is being terminated, ");
        }
        if (this.isACoordinator()) {
            stringBuffer.append("is the coordinator");
        }
        if (this.listeners_ != null && this.listeners_.length > 0) {
            stringBuffer.append("\r\nListeners:");
            for (int i = 0; i < this.listeners_.length; ++i) {
                stringBuffer.append("\r\n#");
                stringBuffer.append(i + 1);
                stringBuffer.append(". ");
                stringBuffer.append(this.listeners_[i]);
            }
        }
        if (this.coordinatorEp_ != null) {
            stringBuffer.append("\r\nCoordinator Connection=[");
            stringBuffer.append(this.coordinatorEp_);
            stringBuffer.append("]");
        }
        stringBuffer.append("\r\nClient Connections:\r\n");
        if (this.clientsTable_ != null) {
            Hashtable hashtable = this.clientsTable_;
            synchronized (hashtable) {
                enumeration = this.clientsTable_.keys();
                n = 0;
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        memberID = (MemberID)enumeration.nextElement();
                        stringBuffer.append("#");
                        stringBuffer.append(++n);
                        stringBuffer.append(". ");
                        stringBuffer.append(memberID);
                        stringBuffer.append(", ");
                        stringBuffer.append(this.clientsTable_.get(memberID));
                    }
                }
            }
        }
        if (this.clientEps_ != null) {
            stringBuffer.append("\r\nClient Connection Endpoints:");
            Vector vector = this.clientEps_;
            synchronized (vector) {
                for (int i = 0; i < this.clientEps_.size(); ++i) {
                    stringBuffer.append("\r\n#");
                    stringBuffer.append(i + 1);
                    stringBuffer.append(". ");
                    stringBuffer.append(this.clientEps_.elementAt(i));
                }
            }
        }
        if (this.distributorEps_ != null) {
            stringBuffer.append("\r\nDistributor Connection Endpoints:");
            Vector vector = this.distributorEps_;
            synchronized (vector) {
                for (int i = 0; i < this.distributorEps_.size(); ++i) {
                    stringBuffer.append("\r\n#");
                    stringBuffer.append(i + 1);
                    stringBuffer.append(". ");
                    stringBuffer.append(this.distributorEps_.elementAt(i));
                }
            }
        }
        stringBuffer.append("\r\nDistributor Connections:\r\n");
        if (this.distributorIDTable_ != null) {
            Hashtable hashtable = this.distributorIDTable_;
            synchronized (hashtable) {
                enumeration = this.distributorIDTable_.keys();
                n = 0;
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        memberID = (MemberID)enumeration.nextElement();
                        stringBuffer.append("\r\n#");
                        stringBuffer.append(++n);
                        stringBuffer.append(". ");
                        stringBuffer.append(this.distributorIDTable_.get(memberID));
                    }
                }
            }
        }
        if (this.membersToBeRemoved_ != null) {
            stringBuffer.append("\r\nPending members to be removed:");
            Vector vector = this.membersToBeRemoved_;
            synchronized (vector) {
                for (int i = 0; i < this.membersToBeRemoved_.size(); ++i) {
                    stringBuffer.append(this.membersToBeRemoved_.elementAt(i));
                }
                stringBuffer.append(", ");
            }
        }
        if (this.distributorsToBeRemoved_ != null) {
            stringBuffer.append("\r\nDistributors to be added:");
            Vector vector = this.distributorsToBeRemoved_;
            synchronized (vector) {
                for (int i = 0; i < this.distributorsToBeRemoved_.size(); ++i) {
                    stringBuffer.append(this.distributorsToBeRemoved_.elementAt(i));
                }
                stringBuffer.append(", ");
            }
        }
        if (this.membersToBeAdded_ != null) {
            stringBuffer.append("\r\nPending members to be added:");
            Vector vector = this.membersToBeAdded_;
            synchronized (vector) {
                for (int i = 0; i < this.membersToBeAdded_.size(); ++i) {
                    stringBuffer.append(this.membersToBeAdded_.elementAt(i));
                }
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append("\r\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

