/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.Distributor;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.PacketHolder;

class CoordinatorResolver
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.CoordinatorResolver";
    private Distributor parent_;
    private MulticastSocket mSocket_;
    private boolean terminate_;
    private boolean conflict_;
    private boolean useMulticast_;
    private Address confirmedNormineeAddress_;
    private boolean onLink_;
    private HashSet norminees_;
    private int maxExpectedNorminee_;
    private long timeout_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.CoordinatorResolver");

    CoordinatorResolver(Distributor distributor, MulticastSocket multicastSocket, boolean bl, long l, int n) {
        this(distributor, bl, l, n);
        this.useMulticast_ = true;
        this.mSocket_ = multicastSocket;
    }

    CoordinatorResolver(Distributor distributor, boolean bl, long l, int n) {
        this.parent_ = distributor;
        this.onLink_ = bl;
        this.timeout_ = l;
        this.maxExpectedNorminee_ = n;
        this.norminees_ = new HashSet();
        this.setDaemon(true);
        this.setName("Coordinator Resolver");
        this.parent_.cleanQueue(3);
        this.parent_.setEnableQueue(3, true);
    }

    boolean hasConflict(Packet packet) {
        if (packet == null) {
            return false;
        }
        MemberID memberID = MemberID.parse(packet.getOrigin());
        boolean bl = packet.getFlag().contains(3);
        long l = packet.getViewId();
        long l2 = this.parent_.getViewManager().getCurrentView().getViewID();
        MemberID memberID2 = this.parent_.getID();
        if (bl && !memberID2.equals(memberID)) {
            if (packet.getData() != null) {
                try {
                    this.confirmedNormineeAddress_ = Address.parse(packet.getData());
                }
                catch (GroupException groupException) {
                    this.logger_.log(Level.WARNING, "Unable to identify election winner's  remote address");
                }
            }
            return true;
        }
        return l > l2 || memberID.compareTo(memberID2) < 0;
    }

    void shutdown() {
        if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, "Shutting down " + this.getName());
        }
        this.terminate_ = true;
        if (!this.useMulticast_) {
            this.parent_.setEnableQueue(3, false);
            this.parent_.cleanQueue(3);
        }
    }

    boolean canBeCoordinator() {
        return !this.conflict_;
    }

    Address getConfirmedNormineeAddress() {
        return this.confirmedNormineeAddress_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Packet getAnElectionVote() {
        Object object;
        Object object2;
        Packet packet = null;
        if (this.useMulticast_) {
            object2 = null;
            try {
                byte[] byArray;
                object = new byte[1024];
                object2 = new DatagramPacket((byte[])object, ((byte[])object).length);
                this.mSocket_.receive((DatagramPacket)object2);
                if (object2 != null && !this.terminate_ && (byArray = ((DatagramPacket)object2).getData()) != null) {
                    packet = Packet.parse(byArray);
                }
            }
            catch (Exception exception) {}
        } else {
            object2 = this.parent_.dequeue(3, this.parent_.getConfig().getResolutionInterval());
            if (object2 != null) {
                packet = ((PacketHolder)object2).getPacket();
            }
        }
        if (packet != null) {
            object2 = MemberID.parse(packet.getOrigin());
            HashSet hashSet = this.norminees_;
            object = hashSet;
            // MONITORENTER : hashSet
            this.norminees_.add(object2);
            // MONITOREXIT : object
        }
        if (this.terminate_) return packet;
        if (packet == null) return packet;
        if (!this.logger_.isLoggable(Level.FINEST)) return packet;
        this.logger_.log(Level.FINEST, "Retrieved an election vote:" + packet);
        return packet;
    }

    public void run() {
        if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, this.getName() + " is running for at most " + this.timeout_ + " msec and expects no more than " + this.maxExpectedNorminee_ + " norminees");
        }
        long l = System.currentTimeMillis();
        long l2 = 0L;
        while (!this.terminate_) {
            Packet packet = this.getAnElectionVote();
            this.conflict_ = this.hasConflict(packet);
            if (this.conflict_) {
                if (!this.logger_.isLoggable(Level.FINEST)) break;
                this.logger_.log(Level.FINEST, "Lost election by vote: " + packet.toString(true));
                break;
            }
            l2 = System.currentTimeMillis() - l;
            if (l2 < this.timeout_ && this.norminees_.size() != this.maxExpectedNorminee_) continue;
            if (!this.logger_.isLoggable(Level.FINEST)) break;
            this.logger_.log(Level.FINEST, "No more election vote to be resolved");
            break;
        }
        if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, this.getName() + " is terminated.");
        }
    }
}

