/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.MessageQueue;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.Configuration;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.EndPointConnection;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.GcommReplyInfo;
import oracle.ias.cache.groupv2.GcommSerializable;
import oracle.ias.cache.groupv2.GroupMember;
import oracle.ias.cache.groupv2.GroupMessage;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.PacketHolder;
import oracle.ias.cache.groupv2.PacketProcessorFactory;
import oracle.ias.cache.groupv2.ReceiptHolder;
import oracle.ias.cache.groupv2.RegistrationInfo;
import oracle.ias.cache.groupv2.View;
import oracle.ias.cache.groupv2.ViewChange;

class Client
extends ConnectionOwner {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.Client";
    private static String PREFIX = "CL";
    private Socket socket_;
    private EndPointConnection connection_;
    private GroupMember member_;
    private boolean isRegistered_;
    private boolean enableFailover_;
    private Object userContext_;
    private MessageQueue userMsgQueue_;
    private Logger logger_;

    Client(GroupMember groupMember, Configuration configuration) throws GroupException {
        this(groupMember, configuration, null, null);
    }

    Client(GroupMember groupMember, Configuration configuration, MessageQueue messageQueue, Object object) throws GroupException {
        super(configuration, PREFIX);
        this.member_ = groupMember;
        this.isRegistered_ = false;
        this.enableFailover_ = true;
        this.userMsgQueue_ = messageQueue;
        this.userContext_ = object;
        this.logger_ = Logger.getLogger(LOGGER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() throws GroupException {
        Object object;
        try {
            this.socket_ = this.getConfig().isSSLEnabled() ? this.getSSLManager().createSSLSocket() : new Socket();
            this.socket_.setSoLinger(false, 0);
            object = this.getConfig().getDistributorAddress();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(((Address)object).getHostName(), ((Address)object).getPort());
            if (this.logger_.isLoggable(Level.INFO)) {
                this.logger_.log(Level.INFO, "Connecting to " + inetSocketAddress);
            }
            this.socket_.connect(inetSocketAddress, this.getConfig().getConnectTimeout());
            this.setID(MemberID.generate(this.socket_.getLocalPort()));
            this.createViewManager();
            this.connection_ = new EndPointConnection(super.getEpThreadGroup(), this.socket_, ((Address)object).getNetworkId(), this);
            this.connection_.setRemoteAddress(new Address(this.getConfig().getDistributorHostName(), this.getConfig().getPortForClients(), false, 0));
            this.register(false);
        }
        catch (IOException iOException) {
            if (this.connection_ != null) {
                this.connection_.close();
            }
            throw new GcommException(GcommException.CLIENTINITFAILURE, (Throwable)iOException);
        }
        this.packetProcessor_ = PacketProcessorFactory.createAPacketProcessorOf(this);
        this.packetProcessor_.start();
        object = this.connection_;
        synchronized (object) {
            this.connection_.start();
            try {
                this.connection_.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.isRegistered_ = true;
    }

    private void connect(boolean bl) throws SocketException, IOException, GroupException {
        this.socket_ = this.getConfig().isSSLEnabled() ? this.getSSLManager().createSSLSocket() : new Socket();
        this.socket_.setSoLinger(false, 0);
        Address address = this.getConfig().getDistributorAddress();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(address.getHostName(), address.getPort());
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "Connecting to " + inetSocketAddress);
        }
        this.socket_.connect(inetSocketAddress, this.getConfig().getConnectTimeout());
        if (!bl) {
            this.setID(MemberID.generate(this.socket_.getLocalPort()));
        }
        this.createViewManager();
        this.connection_ = new EndPointConnection(super.getEpThreadGroup(), this.socket_, address.getNetworkId(), this);
        this.connection_.setRemoteAddress(new Address(this.getConfig().getDistributorHostName(), this.getConfig().getPortForClients(), false, 0));
    }

    private void register(boolean bl) throws GroupException, IOException {
        int n = (int)this.getConfig().getResolutionTimeout() * this.getConfig().getMaxSystemInitRetry() * 2;
        long l = System.currentTimeMillis();
        this.connection_.setTimeout(n);
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Set registration timeout=" + n + " for " + this.getID());
        }
        Packet packet = null;
        packet = new Packet(3, this.getID());
        boolean bl2 = this.member_.isACoordinator() | this.member_.isADistributor();
        String string = null;
        if (this.getConfig().getTag() != null) {
            string = GcommSerializable.bytesToString((byte[])this.getConfig().getTag());
        }
        RegistrationInfo registrationInfo = RegistrationInfo.wrap(this.getID(), null, null, bl2, ConnectionOwner.getVMId(), this.getConfig().getCacheName(), string);
        packet.setData(registrationInfo.toBytes());
        this.connection_.send(packet);
        Packet packet2 = null;
        while ((packet2 = this.connection_.read()).getType() != 1) {
            this.enqueue(1, PacketHolder.wrap(packet2, this.connection_));
            if (System.currentTimeMillis() - l <= (long)n) continue;
            throw new GroupException(GcommException.REGISTRATION);
        }
        this.connection_.setTightlyBound(true);
        this.connection_.setRemoteMemberID(MemberID.parse(packet2.getOrigin()));
        View view = View.parse(packet2.getData());
        try {
            if (this.connection_.getRemoteMemberID().equals(view.getCoordinatorID())) {
                this.connection_.setType(0);
            } else {
                this.connection_.setType(1);
            }
        }
        catch (Exception exception) {
            this.logger_.log(Level.SEVERE, "Invalid view: " + view, exception);
            throw new GcommException(exception);
        }
        this.getViewManager().addView(view);
        if (!bl) {
            this.setIndex(view.indexOfMember(this.getID()));
        }
        this.getViewManager().updateToLatest(true);
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "Completed registeration for " + this.getID());
        }
    }

    void sendTo(View view, Packet packet, HashSet hashSet, HashSet hashSet2) throws GroupException, CloneNotSupportedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GcommReplyInfo send(MemberID memberID, Serializable serializable, InputStream inputStream, String string, boolean bl, long l, boolean bl2) throws GroupException {
        View view;
        ReceiptHolder receiptHolder;
        Packet packet;
        GcommReplyInfo gcommReplyInfo;
        block15: {
            GcommReplyInfo gcommReplyInfo2;
            gcommReplyInfo = null;
            packet = null;
            long l2 = 0L;
            receiptHolder = null;
            view = null;
            if (bl2) {
                l2 = this.acquireTotalOrderToken(this.getConfig().getMaxSendRetry(), l);
            }
            this.getViewManager().lock(0, 0);
            try {
                view = this.getViewManager().getCurrentView();
                packet = this.preparePacketToSend(memberID, view, serializable, inputStream, string, bl2, l2);
                if (view.getSize() > 1) break block15;
                if (bl2) {
                    this.sendTotalOrderPacketToMyself(packet);
                }
                gcommReplyInfo2 = new GcommReplyInfo(view, view.indexOfMember(this.getID()));
                Object var17_15 = null;
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                this.getViewManager().unlock(0, 0);
                if (bl2) {
                    this.releaseTotalOrderToken();
                }
                throw throwable;
            }
            this.getViewManager().unlock(0, 0);
            if (bl2) {
                this.releaseTotalOrderToken();
            }
            return gcommReplyInfo2;
        }
        if (packet.getType() == 6) {
            receiptHolder = this.addReciptHolder(packet);
        } else {
            HashSet<MemberID> hashSet = new HashSet<MemberID>(0);
            hashSet.add(this.getID());
            receiptHolder = this.addReciptHolder(view, packet, hashSet, null);
        }
        Object var17_16 = null;
        this.getViewManager().unlock(0, 0);
        if (bl2) {
            this.releaseTotalOrderToken();
        }
        try {
            this.sendToDistributor(packet, this.getConfig().getMaxSendRetry());
            this.waitForConfirmation(packet, view, this.getConfig().getMaxSendRetry(), l, receiptHolder);
            if (bl2) {
                this.sendTotalOrderPacketToMyself(packet);
            }
        }
        finally {
            if (bl2) {
                this.releaseTotalOrderToken();
            }
        }
        gcommReplyInfo = new GcommReplyInfo(view, view.indexOfMember(this.getID()));
        return gcommReplyInfo;
    }

    private void sendTotalOrderPacketToMyself(Packet packet) throws GroupException {
        if (packet.getType() == 5 && this.userMsgQueue_ != null) {
            packet.setFromMyself();
            this.enqueueUserMessage(PacketHolder.wrap(packet, null));
        }
    }

    private Packet preparePacketToSend(MemberID memberID, View view, Serializable serializable, InputStream inputStream, String string, boolean bl, long l) throws GroupException {
        Packet packet = null;
        if (memberID != null) {
            packet = new Packet(6, this.getID());
            packet.setDestination(memberID);
            if (memberID.equals(this.getID())) {
                packet.setFromMyself();
            }
        } else {
            packet = new Packet(5, this.getID());
        }
        if (serializable instanceof byte[]) {
            packet.setData((byte[])serializable);
        } else {
            try {
                byte[] byArray = null;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(serializable);
                byArray = byteArrayOutputStream.toByteArray();
                packet.getFlag().set(11);
                packet.setData(byArray);
            }
            catch (IOException iOException) {
                throw new GcommException("Unable to serialize message", (Throwable)iOException);
            }
        }
        packet.setViewId(view.getViewID());
        packet.setForRegistered();
        if (bl) {
            packet.getFlag().set(10);
            packet.setTotalSequence(l);
        }
        if (inputStream != null) {
            packet.setInputStream(inputStream);
        } else if (string != null) {
            packet.setAttachedFilename(string);
        }
        return packet;
    }

    private void sendToDistributor(Packet packet, int n) throws GroupException {
        int n2 = 0;
        while (n2++ <= n) {
            try {
                this.connection_.send(packet);
                break;
            }
            catch (Exception exception) {
                if (n2 > n) {
                    if (this.logger_.isLoggable(Level.WARNING)) {
                        this.logger_.log(Level.WARNING, "Reached max send retry " + n);
                    }
                    throw new GroupException("Unable to send packet to distributor");
                }
                try {
                    this.connection_.join(this.getConfig().getMaxInitRetryDelay());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.logger_.isLoggable(Level.WARNING)) continue;
                this.logger_.log(Level.WARNING, "Send retry " + n2 + " of " + n + " Packet=" + packet);
            }
        }
    }

    private Packet[] waitForConfirmation(Packet packet, View view, int n, long l, ReceiptHolder receiptHolder) throws GroupException {
        int n2 = 0;
        Packet[] packetArray = null;
        while (n2++ <= this.getConfig().getMaxSendRetry()) {
            try {
                packetArray = super.waitForReply(packet.getSequence(), l);
                break;
            }
            catch (GroupException groupException) {
                MemberID[] memberIDArray;
                if (n2 > n) {
                    receiptHolder.clear();
                    super.clearReciptHolder(packet.getSequence());
                    if (this.logger_.isLoggable(Level.WARNING)) {
                        this.logger_.log(Level.WARNING, "Reached max wait ACK retry " + n);
                    }
                    throw groupException;
                }
                receiptHolder.logExpiredRecipients();
                if (packet.getType() == 5) {
                    packet.setType(6);
                }
                if ((memberIDArray = receiptHolder.getPendingMembers()) == null) continue;
                for (int i = 0; i < memberIDArray.length; ++i) {
                    packet.setDestination(memberIDArray[i]);
                    if (this.logger_.isLoggable(Level.WARNING)) {
                        this.logger_.log(Level.WARNING, "Resend " + n2 + " of " + n + " Packet=" + packet);
                    }
                    this.sendToDistributor(packet, 1);
                }
            }
        }
        return packetArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long acquireTotalOrderToken(int n, long l) throws GroupException {
        View view = null;
        long l2 = -1L;
        ReceiptHolder receiptHolder = null;
        Packet packet = new Packet(19, this.getID());
        packet.setForRegistered();
        this.getViewManager().lock(0, 0);
        try {
            view = this.getViewManager().getCurrentView();
            packet.setDestination(view.getCoordinatorID());
            receiptHolder = this.addReciptHolder(packet);
        }
        finally {
            this.getViewManager().unlock(0, 0);
        }
        this.sendToDistributor(packet, n);
        try {
            Packet[] packetArray = this.waitForConfirmation(packet, view, n, l, receiptHolder);
            if (packetArray != null) {
                Packet packet2 = packetArray[0];
                l2 = packet2.getTotalSequence();
            }
        }
        catch (Exception exception) {
            this.releaseTotalOrderToken();
            throw new GcommException(exception);
        }
        return l2;
    }

    private void releaseTotalOrderToken() {
        try {
            Packet packet = new Packet(20, this.getID());
            packet.setBlockReceiver();
            this.connection_.send(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() throws GroupException {
        block12: {
            block11: {
                block10: {
                    super.shutdown();
                    Packet packet = new Packet(2, this.getID());
                    packet.setBlockReceiver();
                    packet.setData(this.getID().toBytes());
                    try {
                        this.connection_.send(packet);
                    }
                    catch (IOException iOException) {
                        this.connection_.close();
                        if (!this.logger_.isLoggable(Level.WARNING)) break block10;
                        this.logger_.log(Level.WARNING, "Ungraceful disconnection", iOException);
                    }
                }
                this.connection_.toBeDisconnected();
                this.waitForEmptyQueue(1, this.getConfig().getDisconnectTimeout());
                this.waitForEmptyQueue(0, this.getConfig().getDisconnectTimeout());
                try {
                    this.connection_.join(this.getConfig().getDisconnectTimeout());
                }
                catch (InterruptedException interruptedException) {
                    if (!this.logger_.isLoggable(Level.FINE)) break block11;
                    this.logger_.log(Level.FINE, "Close connection: ", interruptedException);
                }
            }
            try {
                if (this.packetProcessor_ != null) {
                    this.packetProcessor_.shutdown();
                    this.packetProcessor_.join(this.getConfig().getDisconnectTimeout());
                }
            }
            catch (InterruptedException interruptedException) {
                if (!this.logger_.isLoggable(Level.WARNING)) break block12;
                this.logger_.log(Level.WARNING, "Packet Processor shutdown failure: ", interruptedException);
            }
        }
        this.cleanup();
        Client client = this;
        synchronized (client) {
            this.notifyAll();
        }
    }

    MemberID[] getMemberList() throws GroupException {
        return this.getViewManager().getCurrentView().getMemberIDs();
    }

    void cleanup() {
        super.cleanup();
        this.isRegistered_ = false;
    }

    synchronized void disposeConnection(EndPointConnection endPointConnection) {
        if (this.isTerminating()) {
            return;
        }
        MemberID memberID = endPointConnection.getRemoteMemberID();
        if (this.logger_.isLoggable(Level.SEVERE)) {
            this.logger_.log(Level.SEVERE, "Lost connection to " + memberID + " " + endPointConnection);
        }
        int n = 0;
        View view = null;
        while (n++ < this.getConfig().getMaxSystemInitRetry() && !this.isTerminating()) {
            block15: {
                block14: {
                    if (this.logger_.isLoggable(Level.INFO) && n > 1) {
                        this.logger_.log(Level.INFO, "Retry (" + n + ") GroupMember initialization");
                    }
                    if (this.enableFailover_) {
                        try {
                            if (view == null) {
                                view = this.getViewManager().getCurrentView();
                            }
                            if (this.logger_.isLoggable(Level.INFO)) {
                                this.logger_.log(Level.INFO, "Launch Distributor");
                            }
                            this.member_.startDistributor(true, view, memberID, this.getSequenceToken());
                        }
                        catch (Exception exception) {
                            if (!this.logger_.isLoggable(Level.INFO)) break block14;
                            this.logger_.log(Level.INFO, "Unable to launch Distributor", exception);
                        }
                    }
                }
                try {
                    this.wait(this.getConfig().getMaxInitRetryDelay());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isTerminating()) {
                    try {
                        this.connect(true);
                        this.register(true);
                        this.connection_.start();
                        break;
                    }
                    catch (Exception exception) {
                        if (!this.logger_.isLoggable(Level.SEVERE)) break block15;
                        this.logger_.log(Level.SEVERE, "Unable to re-register to distributor ", exception);
                    }
                }
            }
            if (n < this.getConfig().getMaxSystemInitRetry() || this.isTerminating()) continue;
            if (!this.logger_.isLoggable(Level.SEVERE)) break;
            this.logger_.log(Level.SEVERE, "Unable to find or become a distributor after reaching retry limit:" + (n - 1));
            break;
        }
    }

    private void replyToSender(Packet packet, byte[] byArray) throws IOException, GroupException {
        packet.setAsReply();
        packet.setDestination(packet.getOrigin());
        packet.setOrigin(this.getID());
        packet.setAck(packet.getSequence());
        packet.setData(byArray);
        this.connection_.send(packet);
    }

    void addClient(MemberID memberID, EndPointConnection endPointConnection) throws GroupException {
    }

    void setEnableFailover(boolean bl) {
        this.enableFailover_ = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(int n, PacketHolder packetHolder) {
        Vector vector;
        if (n == 2 && this.userMsgQueue_ != null) {
            block8: {
                try {
                    this.enqueueUserMessage(packetHolder);
                }
                catch (GroupException groupException) {
                    if (!this.logger_.isLoggable(Level.SEVERE)) break block8;
                    this.logger_.log(Level.SEVERE, "Unable to enqueue user message " + packetHolder.getPacket());
                }
            }
            return;
        }
        Vector vector2 = vector = this.getQueue(n);
        synchronized (vector2) {
            if (!this.getQueueStatus(n)) {
                return;
            }
            Packet packet = packetHolder.getPacket();
            vector.addElement(packetHolder);
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, QUEUE_TYPE_NAMES[n] + " put " + packet);
            }
            vector.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PacketHolder dequeue(int n, long l) {
        Vector vector;
        PacketHolder packetHolder = null;
        Vector vector2 = vector = this.getQueue(n);
        synchronized (vector2) {
            if (vector.size() == 0) {
                try {
                    vector.wait(l);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                Packet packet = null;
                packetHolder = (PacketHolder)vector.firstElement();
                packet = packetHolder.getPacket();
                vector.removeElementAt(0);
                if (this.logger_.isLoggable(Level.FINEST)) {
                    this.logger_.log(Level.FINEST, QUEUE_TYPE_NAMES[n] + " remove " + packet);
                }
            }
        }
        return packetHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueUserMessage(PacketHolder packetHolder) throws GroupException {
        block10: {
            Packet packet = packetHolder.getPacket();
            EndPointConnection endPointConnection = packetHolder.getOrigin();
            this.getViewManager().lock(0, 0);
            try {
                if (packet.getViewId() > this.getViewManager().getCurrentView().getViewID()) {
                    this.enqueue(5, packetHolder);
                    return;
                }
            }
            finally {
                this.getViewManager().unlock(0, 0);
            }
            this.userMsgQueue_.enqueue(new GroupMessage(0, packetHolder.getPacket()), this.userContext_);
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Deliver " + packet);
            }
            if (packet.isARequest() && packet.isRegistered() && !packet.isFromMyself()) {
                if (this.logger_.isLoggable(Level.FINEST)) {
                    this.logger_.log(Level.FINEST, "Reply to sender " + packet);
                }
                try {
                    Packet packet2 = new Packet(packet.getType(), this.getID());
                    packet2.setDestination(packet.getOrigin());
                    packet2.setAck(packet.getSequence());
                    packet2.setAsReply();
                    packet2.setViewId(packet.getViewId());
                    packet2.setForRegistered();
                    packet2.setBlockReceiver();
                    this.enqueue(0, PacketHolder.wrap(packet2, endPointConnection));
                }
                catch (GroupException groupException) {
                    if (!this.logger_.isLoggable(Level.SEVERE)) break block10;
                    this.logger_.log(Level.SEVERE, "Unable to reply ACK to sender " + packet);
                }
            }
        }
    }

    void enqueueViewChangeEvent(View view, View view2) {
        if (this.userMsgQueue_ == null) {
            return;
        }
        ViewChange viewChange = new ViewChange(view, view2);
        this.userMsgQueue_.enqueue(new GroupMessage(1, viewChange), this.userContext_);
        PacketHolder packetHolder = null;
        while ((packetHolder = this.dequeue(5, 1L)) != null) {
            try {
                this.enqueueUserMessage(packetHolder);
            }
            catch (GroupException groupException) {
                if (!this.logger_.isLoggable(Level.SEVERE)) continue;
                this.logger_.log(Level.SEVERE, "Unable to flush onhold message " + packetHolder.getPacket());
            }
        }
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Deliver " + viewChange);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isRegistered_) {
            stringBuffer.append("Not registered yet, ");
        }
        stringBuffer.append(super.toString());
        if (this.connection_ != null) {
            stringBuffer.append(", connection=[");
            stringBuffer.append(this.connection_);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

