/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.NetworkAddress;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.GcommSerializable;
import oracle.ias.cache.groupv2.MemberID;

public class Address
extends GcommSerializable
implements Comparable,
Cloneable,
NetworkAddress {
    static final int LOOPBACK = 0;
    static final int PRIMARY = 1;
    static final int ALLNETWORK = -1;
    private String hostname_;
    private int port_;
    private MemberID id_;
    private boolean useSSL_;
    private int networkId_ = 1;
    private Serializable tag_;
    private transient int position_;
    private transient String userDefinedId_;

    public Address(String string, int n, boolean bl, int n2) {
        this.hostname_ = string;
        this.port_ = n;
        this.useSSL_ = bl;
        this.networkId_ = n2;
    }

    Address(Serializable serializable, int n, String string, Serializable serializable2) throws GroupException {
        if (serializable == null) {
            throw new GroupException("Invalid Member ID");
        }
        if (serializable instanceof byte[]) {
            this.id_ = MemberID.parse((byte[])serializable);
        } else if (serializable instanceof MemberID) {
            this.id_ = (MemberID)serializable;
        }
        this.position_ = n;
        this.userDefinedId_ = string;
        this.tag_ = serializable2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Address parse(byte[] byArray) throws GroupException {
        Address address = null;
        String string = null;
        int n = 0;
        MemberID memberID = null;
        int n2 = 0;
        boolean bl = false;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            try {
                string = GcommSerializable.readStringFrom(byteArrayInputStream);
                n = GcommSerializable.readIntFrom(byteArrayInputStream);
                memberID = GcommSerializable.readMemberIDFrom(byteArrayInputStream);
                n2 = GcommSerializable.readIntFrom(byteArrayInputStream);
                bl = GcommSerializable.readBooleanFrom(byteArrayInputStream);
            }
            catch (Exception exception) {
                throw new GcommException(GcommException.PARSEADDRESS, (Throwable)exception);
            }
            Object var10_8 = null;
            if (byteArrayInputStream == null) return new Address(string, n, bl, n2);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (byteArrayInputStream == null) throw throwable;
            try {
                byteArrayInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        byteArrayInputStream.close();
        return new Address(string, n, bl, n2);
    }

    public String getHostName() {
        return this.hostname_;
    }

    public int getPort() {
        return this.port_;
    }

    public void setPort(int n) {
        this.port_ = n;
    }

    public Object getMemberID() {
        return this.id_;
    }

    public boolean isUsingSSL() {
        return this.useSSL_;
    }

    public int getNetworkId() {
        return this.networkId_;
    }

    public void setNetworkId(int n) {
        this.networkId_ = n;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hostname_ != null) {
            stringBuffer.append("[");
            stringBuffer.append(this.hostname_);
            stringBuffer.append(":");
            stringBuffer.append(this.port_);
            stringBuffer.append("] n=");
            stringBuffer.append(this.networkId_);
            if (this.useSSL_) {
                stringBuffer.append(", SSL ");
            }
        } else if (this.id_ != null) {
            stringBuffer.append(this.id_);
            stringBuffer.append(this.position_);
        }
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        int n = 0;
        if (!this.equals(object)) {
            Address address = (Address)object;
            String string = address.getHostName();
            int n2 = address.getPort();
            n = this.getHostName().compareTo(string);
            if (n == 0) {
                n = this.getPort() - n2;
            }
        }
        return n;
    }

    public byte[] toBytes() throws GroupException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GcommSerializable.writeTo(byteArrayOutputStream, this.hostname_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.port_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.id_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.networkId_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.useSSL_);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        try {
            if (object instanceof Address) {
                Address address = (Address)object;
                if (this.hostname_ != null) {
                    if (this.networkId_ == address.getNetworkId() && this.port_ == address.getPort() && this.useSSL_ == address.isUsingSSL() && this.hostname_.equals(address.getHostName())) {
                        bl = true;
                    }
                } else if (this.id_ != null && address.getMemberID() != null && this.id_.equals(address.getMemberID())) {
                    bl = true;
                }
            } else {
                bl = object instanceof ServerSocket ? this.isListenedBy((ServerSocket)object) : super.equals(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isListenedBy(ServerSocket serverSocket) {
        boolean bl = false;
        if (serverSocket == null) {
            return false;
        }
        if (serverSocket.getLocalPort() != this.port_) {
            return false;
        }
        try {
            boolean bl2 = serverSocket.getInetAddress().isAnyLocalAddress();
            String string = InetAddress.getLocalHost().getHostName();
            InetAddress.getLocalHost();
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            InetAddress inetAddress = InetAddress.getByName(this.hostname_);
            for (int i = 0; i < inetAddressArray.length; ++i) {
                if (!inetAddress.isLoopbackAddress() && (!inetAddressArray[i].equals(inetAddress) || !bl2 && !serverSocket.getInetAddress().equals(inetAddress))) continue;
                bl = true;
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return bl;
    }

    public Object clone() throws CloneNotSupportedException {
        return (Address)super.clone();
    }

    static String getLocalPrimaryHostname() {
        String string = "127.0.0.1";
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return Address.getFullyQualifiedHostname(string);
    }

    static String getLocalPrimaryHostIP() {
        String string = "127.0.0.1";
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string;
    }

    static String getFullyQualifiedHostname(String string) {
        String string2 = string;
        try {
            string2 = InetAddress.getByName(string).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string2;
    }

    static Address[] parseMultiplAddresses(byte[] byArray) throws IOException, GroupException {
        Address[] addressArray = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        addressArray = GcommSerializable.readAddressesFrom(byteArrayInputStream);
        byteArrayInputStream.close();
        return addressArray;
    }

    static byte[] toBytes(Address[] addressArray) throws GroupException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GcommSerializable.writeTo(byteArrayOutputStream, addressArray);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    public int getPriorityOrder() {
        return 0;
    }

    public String getUserDefinedId() {
        return this.userDefinedId_;
    }

    public String getIPString() {
        return null;
    }

    public String getString() {
        return this.getHostName() + ":" + this.getPort();
    }

    public String getFullyQualifiedHostName() {
        return Address.getFullyQualifiedHostname(this.getHostName());
    }

    public String getCacheName() {
        return this.userDefinedId_;
    }

    public int getPosition() {
        return this.position_;
    }

    public long getUid() {
        return -1L;
    }

    public Serializable getTag() {
        return this.tag_;
    }

    public boolean isOriginal() {
        return false;
    }
}

