/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.Receiver;
import oracle.ias.cache.group.ServerSocketEndPoint;
import oracle.ias.cache.group.ServerSocketHandler;
import oracle.ias.cache.group.Transport;

class ServerSocketReceiver
extends Thread
implements ServerSocketHandler {
    static final String LOGGER_NAME = "oracle.ias.cache.group.ServerSocketReceiver";
    boolean run = true;
    ServerSocketEndPoint ssep;
    private GrpCommunication gcomm_;
    private Transport trans_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.ServerSocketReceiver");

    ServerSocketReceiver(GrpCommunication grpCommunication, Transport transport, ServerSocketEndPoint serverSocketEndPoint) {
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.ssep = serverSocketEndPoint;
        String string = null;
        if (this.ssep != null && this.ssep.ss != null) {
            string = this.ssep.ss.getInetAddress().getHostAddress() + ":" + this.ssep.ss.getLocalPort();
        }
        this.setName("Server Socket Receiver [" + string + "]");
        this.setDaemon(true);
    }

    public void run() {
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, this.getName() + " is started");
        }
        while (this.run) {
            try {
                if (this.ssep.ss == null) continue;
                Socket socket = this.ssep.ss.accept();
                if (this.trans_ != null && this.trans_.isDiscardIncomingConnection()) {
                    if (this.logger_.isLoggable(Level.FINE)) {
                        this.logger_.log(Level.FINE, "Discard " + socket);
                    }
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                Receiver receiver = new Receiver(this.gcomm_, this.trans_, socket);
                receiver.start();
            }
            catch (SocketException socketException) {
                try {
                    this.ssep.ss.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.gcomm_.isReady() || !this.logger_.isLoggable(Level.FINE)) break;
                this.logger_.log(Level.FINE, "ServerSocketReceiver is closed.", socketException);
                break;
            }
            catch (Exception exception) {
                if (!this.gcomm_.isReady() || !this.logger_.isLoggable(Level.SEVERE)) continue;
                this.logger_.log(Level.SEVERE, "accept failure.", exception);
            }
        }
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, this + " exited");
        }
    }

    public void stopit() {
        this.run = false;
        try {
            if (this.ssep.ss != null) {
                this.ssep.ss.close();
            }
            this.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

