/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.MessageQueue;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.EndPoint;
import oracle.ias.cache.group.GroupManager;
import oracle.ias.cache.group.GroupMessage;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.MessageBuffer;
import oracle.ias.cache.group.Monitor;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.PacketReceiver;
import oracle.ias.cache.group.TestCommand;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;

class Receiver
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.group.Receiver";
    static final int INCOMING = 0;
    static final int OUTGOING = 1;
    static final int OUTGOING_TO_COORD = 2;
    private boolean work = true;
    private EndPoint ep;
    private Socket acceptedSocket_;
    private boolean gracefulClosed_;
    private transient GrpCommunication gcomm_;
    private transient Transport trans_;
    private static Logger logger_ = Logger.getLogger("oracle.ias.cache.group.Receiver");
    private Address remoteAddress_;
    private Packet registerPacket_;
    private Hashtable registrationStatus_;
    private PacketReceiver puller_;
    private int type_;

    public Receiver(GrpCommunication grpCommunication, Transport transport, EndPoint endPoint) {
        super(transport.getRTG(), "receiver");
        this.type_ = 2;
        this.ep = endPoint;
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        if (endPoint != null && endPoint.addr != null) {
            this.setName("EndPoint Receiver [" + endPoint.getShortName() + "]");
        }
        this.setDaemon(true);
        this.puller_ = new PacketReceiver(endPoint, transport.getGroupManager());
    }

    public Receiver(GrpCommunication grpCommunication, Transport transport, Socket socket) throws GroupException, IOException {
        super(transport.getRTG(), "receiver");
        this.type_ = 0;
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.acceptedSocket_ = socket;
        this.setDaemon(true);
    }

    public Receiver(GrpCommunication grpCommunication, Transport transport, Address address, Packet packet, Hashtable hashtable) {
        super(transport.getRTG(), "receiver");
        this.type_ = 1;
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.remoteAddress_ = address;
        this.registerPacket_ = packet;
        this.registrationStatus_ = hashtable;
        this.setDaemon(true);
    }

    private void register(Address address, Packet packet) throws GroupException, IOException {
        if (logger_.isLoggable(Level.FINE)) {
            logger_.log(Level.FINE, "Register at " + address);
        }
        this.setName("EndPoint Receiver [connecting to " + address.ip + ":" + address.port + "]");
        Socket socket = this.trans_.createSocket(address.ip, address.port);
        this.ep = new EndPoint(this.gcomm_, address, socket);
        if (this.ep != null && this.ep.addr != null) {
            this.setName("EndPoint Receiver S[" + this.ep.getShortName() + "]");
        }
        socket.setSoTimeout(0);
        this.ep.write(packet);
        Packet packet2 = this.ep.read();
        this.ep.handler = this;
        this.trans_.endPointList.put(address, this.ep);
        this.puller_ = new PacketReceiver(this.ep, this.trans_.getGroupManager());
        this.puller_.start();
        if (logger_.isLoggable(Level.FINE)) {
            logger_.log(Level.FINE, "Added EndPoint Address: " + address);
        }
    }

    public void init() throws IOException, GroupException {
        Address address = new Address(this.acceptedSocket_.getInetAddress(), this.acceptedSocket_.getPort());
        this.ep = new EndPoint(this.gcomm_, address, this.acceptedSocket_);
        this.ep.handler = this;
        if (this.ep != null && this.ep.addr != null) {
            this.setName("EndPoint Receiver C[" + this.ep.getShortName() + "]");
        }
        this.puller_ = new PacketReceiver(this.ep, this.trans_.getGroupManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose(Exception exception) {
        this.trans_.incNumberOfClosingReceiver();
        try {
            Address address = this.remoteAddress_;
            if (this.ep != null) {
                address = this.ep.addr;
            }
            if (this.gracefulClosed_ && logger_.isLoggable(Level.FINE)) {
                logger_.log(Level.FINE, "Gracefully disconnected from " + address);
            } else if (this.ep != null && !this.gracefulClosed_ && logger_.isLoggable(Level.FINE)) {
                logger_.log(Level.FINE, "Ungracefully disconnected from " + address + ", " + exception);
            }
            Object object = this.trans_.getCoordinatorLock();
            synchronized (object) {
                try {
                    Monitor monitor = this.trans_.getMonitor();
                    if (monitor != null) {
                        monitor.toPause();
                    }
                    if (this.ep != null) {
                        this.trans_.getFailureDetector().failureDetected(this.ep.addr, this.trans_.getCoordinatorLock());
                    } else {
                        this.trans_.getFailureDetector().failureDetected(this.remoteAddress_, this.trans_.getCoordinatorLock());
                    }
                    Object var6_6 = null;
                    Monitor monitor2 = this.trans_.getMonitor();
                    if (monitor2 != null) {
                        monitor2.reset();
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    Monitor monitor = this.trans_.getMonitor();
                    if (monitor != null) {
                        monitor.reset();
                    }
                    throw throwable;
                }
            }
            this.ep.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.trans_.decNumberOfClosingReceiver();
        }
    }

    private void initCoordinatorEp() throws IOException, GroupException {
        this.init();
        this.puller_.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block170: {
            var1_1 = null;
            var2_2 = null;
            var3_3 = null;
            var11_4 = 0;
            var12_5 = this.trans_.getGroupManager();
            switch (this.type_) {
                case 2: {
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
            }
            try {
                if (this.type_ == 0) {
                    this.init();
                }
            }
            catch (Exception var13_6) {
                if (Receiver.logger_.isLoggable(Level.SEVERE) == false) return;
                Receiver.logger_.log(Level.SEVERE, "Unable to establish incoming connection.", var13_6);
                return;
            }
            if (this.puller_ != null) {
                this.puller_.start();
            }
            var13_7 = false;
            var14_8 = null;
            try {
                try {
                    if (this.type_ == 1) {
                        this.register(this.remoteAddress_, this.registerPacket_);
                    }
                    var13_7 = true;
                }
                catch (Exception var15_18) {
                    var13_7 = false;
                    var14_8 = var15_18;
                    if (Receiver.logger_.isLoggable(Level.FINER)) {
                        Receiver.logger_.log(Level.FINER, "Unable to connect to: " + this.remoteAddress_ + ", " + var15_18.getMessage());
                    }
                    var17_9 = null;
                    if (this.registrationStatus_ != null) {
                        var18_15 = this.registrationStatus_;
                        synchronized (var18_15) {
                            this.registrationStatus_.put(this.remoteAddress_, var13_7);
                            this.registrationStatus_.notifyAll();
                        }
                    }
                    break block170;
                }
                var17_9 = null;
                if (this.registrationStatus_ == null) break block170;
                var18_15 = this.registrationStatus_;
            }
            catch (Throwable var16_30) {
                var17_10 = null;
                if (this.registrationStatus_ == null) throw var16_30;
                var18_16 = this.registrationStatus_;
                synchronized (var18_16) {
                    this.registrationStatus_.put(this.remoteAddress_, var13_7);
                    this.registrationStatus_.notifyAll();
                    throw var16_30;
                }
            }
            synchronized (var18_15) {
                this.registrationStatus_.put(this.remoteAddress_, var13_7);
                this.registrationStatus_.notifyAll();
            }
        }
        if (this.type_ == 1) {
            this.trans_.waitForRegister();
            if (!this.trans_.getRegistrationStatus()) {
                if (Receiver.logger_.isLoggable(Level.FINE) == false) return;
                Receiver.logger_.log(Level.FINE, "Abort outgoing registration " + this.ep + ", receiver exits");
                return;
            }
            if (var14_8 != null) {
                this.dispose(var14_8);
                return;
            }
            if (!this.trans_.getRegistrationStatus()) {
                if (Receiver.logger_.isLoggable(Level.FINE) == false) return;
                Receiver.logger_.log(Level.FINE, "Abort outgoing connection " + this.ep + ", receiver exits");
                return;
            }
        } else if (this.type_ == 0) {
            var15_19 = null;
            try {
                var15_19 = this.puller_.waitForAPacket();
                if (var15_19.type == 8) {
                    if (!this.trans_.isMyself(this.trans_.getFailureDetector().getCoordinator())) {
                        return;
                    }
                    this.ep.addr = var15_19.source;
                    var16_31 = true;
                    var11_4 = 0;
                    var17_11 = System.currentTimeMillis();
                    var19_43 = this.trans_.getJoinGroupAllowance();
                    while (var16_31) {
                        if (this.trans_.getNumberOfClosingReceivers() != 0) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Exception var21_47) {}
                        } else {
                            var16_31 = false;
                        }
                        if (!var16_31 || System.currentTimeMillis() - var17_11 <= var19_43) continue;
                        if (Receiver.logger_.isLoggable(Level.SEVERE)) {
                            Receiver.logger_.log(Level.SEVERE, "There are " + this.trans_.getNumberOfClosingReceivers() + " stale receivers. ");
                        }
                        this.ep.close(false);
                        return;
                    }
                    this.trans_.waitForRegister();
                    var21_48 = true;
                    var11_4 = 0;
                    while (this.trans_.endPointList.containsKey(this.ep.addr) || var21_48) {
                        ++var11_4;
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Exception var22_55) {
                            // empty catch block
                        }
                        v0 = this.trans_.getGroupManager();
                        this.trans_.getGroupManager();
                        v0.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                        v1 = this.trans_.getGroupManager();
                        this.trans_.getGroupManager();
                        var10_53 = v1.getCurrentViewInfo(GroupManager.SYSTEM_GROUP);
                        v2 = this.trans_.getGroupManager();
                        this.trans_.getGroupManager();
                        v2.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                        var22_54 = var10_53.getView();
                        if (var22_54 != null && (var23_56 = var22_54.getMembers()) != null && var23_56.size() > 0) {
                            var21_48 = var23_56.contains(this.ep.addr);
                        }
                        if (var11_4 <= 10000) continue;
                        if (Receiver.logger_.isLoggable(Level.SEVERE)) {
                            Receiver.logger_.log(Level.SEVERE, "Duplicate EndPoint: " + this.ep);
                        }
                        this.ep.close(false);
                        return;
                    }
                    this.trans_.endPointList.put(this.ep.addr, this.ep);
                    var22_54 = this.trans_.getCoordinatorLock();
                    synchronized (var22_54) {
                        var23_56 = this.trans_.getAddrList();
                        synchronized (var23_56) {
                            var24_57 = this.trans_.findEmptySlot(this.trans_.getAddrList());
                            this.ep.addr.setPosition(var24_57);
                            this.trans_.incGUid();
                            this.ep.addr.setUid(this.trans_.getGUid());
                            this.ep.addr.setTimeStamp(System.currentTimeMillis());
                            this.trans_.addrList.addElement(this.ep.addr);
                            v3 = this.trans_.getGroupManager();
                            this.trans_.getGroupManager();
                            var4_58 = v3.currentAddrList(GroupManager.SYSTEM_GROUP);
                        }
                        var2_2 = var4_58 != null ? new Packet(4, 0, this.trans_.ssep.addr, var15_19.source, var4_58, 0L) : new Packet(21, 0, this.trans_.ssep.addr, var15_19.source, null, 0L);
                    }
                    this.trans_.send(var2_2);
                    if (Receiver.logger_.isLoggable(Level.FINEST)) {
                        Receiver.logger_.log(Level.FINEST, "Reply REG_WITH_COORD message to " + var15_19.source.toString(true) + ". View: " + var4_58);
                    }
                    ** break block171
                }
                if (var15_19.type != 3) {
                    if (Receiver.logger_.isLoggable(Level.SEVERE) == false) return;
                    Receiver.logger_.log(Level.SEVERE, "Unknown PACKET. Got packet: " + var15_19);
                    return;
                }
                if (this.trans_.isMyself(this.trans_.getFailureDetector().getCoordinator())) {
                    return;
                }
                this.ep.addr = var15_19.source;
                this.trans_.endPointList.put(this.ep.addr, this.ep);
                var2_2 = new Packet(21, 0, this.trans_.ssep.addr, var15_19.source, null, 0L);
                var16_32 = this.ep.lock;
                synchronized (this.ep.lock) {
                    this.ep.write(var2_2);
                    // ** MonitorExit[var16_32] (shouldn't be in output)
                    this.trans_.waitForRegister();
                    if (!this.trans_.getRegistrationStatus()) {
                        if (Receiver.logger_.isLoggable(Level.FINE) == false) return;
                        Receiver.logger_.log(Level.FINE, "Abort incoming connection " + this.ep + ", receiver exits.");
                        return;
                    }
                }
            }
            catch (Exception var16_33) {
                if (Receiver.logger_.isLoggable(Level.FINE)) {
                    Receiver.logger_.log(Level.FINE, "Can't reply REGISTER message to " + this.ep.addr, var16_33);
                }
                if (var15_19 != null && var15_19.type == 8) {
                    this.dispose(var16_33);
                    return;
                }
                this.trans_.addrList.removeElement(this.ep.addr);
                this.trans_.endPointList.remove(this.ep.addr);
                this.ep.close(false);
                return;
            }
        }
lbl-1000:
        // 5 sources

        {
            if (Receiver.logger_.isLoggable(Level.FINEST)) {
                Receiver.logger_.log(Level.FINEST, "Ready to process packets");
            }
lbl189:
            // 61 sources

            block100: while (this.work) {
                try {
                    if (this.puller_ != null) {
                        var1_1 = this.puller_.waitForAPacket();
                        if (var1_1 != null && (var1_1.type == 17 || var1_1.type == 14 || var1_1.type == 11 || var1_1.type == 10 || var1_1.type == 15 || var1_1.type == 13)) {
                            for (var15_20 = 0; var15_20 < 5 && !var12_5.shouldProcess(this.ep); ++var15_20) {
                                Thread.yield();
                            }
                        }
                    } else {
                        var1_1 = this.ep.read();
                    }
                    if (var1_1 == null) {
                        throw new GroupException(GrpCommunication.EXP_GRP_CON_TERMINATED);
                    }
                    var7_60 = this.trans_.getLocalAddress();
                    var1_1.fromMyself = var7_60.equals(var1_1.source);
                    if (Receiver.logger_.isLoggable(Level.FINEST)) {
                        Receiver.logger_.log(Level.FINEST, "Received: " + var1_1);
                    }
                }
                catch (Throwable var15_21) {
                    if (Receiver.logger_.isLoggable(Level.FINEST)) {
                        Receiver.logger_.log(Level.FINEST, "Receiver clean up. ready=" + this.gcomm_.isReady() + ", work=" + this.work, var15_21);
                    }
                    this.trans_.incNumberOfClosingReceiver();
                    try {
                        block172: {
                            if (this.gcomm_.isReady() && this.work) {
                                var16_34 = this.remoteAddress_;
                                if (this.ep != null) {
                                    var16_34 = this.ep.addr;
                                }
                                if (this.gracefulClosed_ && Receiver.logger_.isLoggable(Level.INFO)) {
                                    Receiver.logger_.log(Level.INFO, "Gracefully disconnected from " + var16_34);
                                } else if (this.ep != null && !this.gracefulClosed_ && Receiver.logger_.isLoggable(Level.FINE)) {
                                    Receiver.logger_.log(Level.FINE, "Ungracefully disconnected from " + var16_34 + ", " + var15_21);
                                }
                                var17_12 = this.trans_.getCoordinatorLock();
                                synchronized (var17_12) {
                                    try {
                                        this.trans_.getMonitor().toPause();
                                        if (!this.trans_.isReady()) break block172;
                                        if (this.ep != null) {
                                            this.trans_.getFailureDetector().failureDetected(this.ep.addr, this.trans_.getCoordinatorLock());
                                        } else {
                                            this.trans_.getFailureDetector().failureDetected(this.remoteAddress_, this.trans_.getCoordinatorLock());
                                        }
                                    }
                                    finally {
                                        this.trans_.getMonitor().reset();
                                    }
                                }
                            }
                        }
                        this.ep.close();
                        break;
                    }
                    catch (Throwable var16_35) {
                        if (!Receiver.logger_.isLoggable(Level.FINEST)) break;
                        Receiver.logger_.log(Level.FINEST, "Internal receiver error", var16_35);
                        break;
                    }
                    finally {
                        this.trans_.decNumberOfClosingReceiver();
                    }
                }
                try {
                    block174: {
                        block173: {
                            switch (var1_1.type) {
                                case 21: {
                                    if (!Receiver.logger_.isLoggable(Level.INFO)) continue block100;
                                    Receiver.logger_.log(Level.INFO, "Late connection establishment at " + this.ep.addr);
                                    continue block100;
                                }
                                case 5: {
                                    var15_22 = this.trans_.getCoordinatorLock();
                                    synchronized (var15_22) {
                                        try {
                                            v4 = this.trans_.getGroupManager();
                                            this.trans_.getGroupManager();
                                            v4.joinGroup(GroupManager.SYSTEM_GROUP, var1_1);
                                        }
                                        catch (Exception var16_36) {
                                            if (!Receiver.logger_.isLoggable(Level.FINE)) ** GOTO lbl189
                                            Receiver.logger_.log(Level.FINE, "Can't reply READY message to " + this.ep.addr, var16_36);
                                        }
                                        continue block100;
                                    }
                                }
                                case 4: {
                                    var15_23 = this.trans_.getMemberLock();
                                    synchronized (var15_23) {
                                        try {
                                            this.trans_.getMonitor().toPause();
                                            var4_58 = (View)var1_1.message;
                                            var16_37 = var4_58.getCid();
                                            if (!var4_58.getBitMap().testBit(var16_37) && Receiver.logger_.isLoggable(Level.SEVERE)) {
                                                Receiver.logger_.log(Level.SEVERE, "Invalid coordinator index. View: " + var4_58);
                                            }
                                            var17_13 = ((View)var1_1.message).getMembers();
                                            this.trans_.setAddrList(var17_13);
                                            var18_15 = (Address)var17_13.lastElement();
                                            if (var18_15.getUid() > this.trans_.getGUid()) {
                                                this.trans_.setGUid(var18_15.getUid());
                                            }
                                            this.trans_.getGroupManager().setView((View)var1_1.message);
                                            this.trans_.getGroupManager().flush(var1_1);
                                            ** GOTO lbl189
                                        }
                                        catch (Exception var16_38) {
                                            if (!this.trans_.terminated && Receiver.logger_.isLoggable(Level.SEVERE)) {
                                                Receiver.logger_.log(Level.SEVERE, "Can't handle a NEW_VIEW message. Got packet: " + var1_1, var16_38);
                                            }
                                            ** GOTO lbl189
                                        }
                                        finally {
                                            this.trans_.getMonitor().reset();
                                        }
                                        continue block100;
                                    }
                                }
                                case 20: {
                                    this.gracefulClosed_ = true;
                                    var15_24 = this.trans_.getCoordinatorLock();
                                    synchronized (var15_24) {
                                        try {
                                            this.ep.close(true);
                                        }
                                        catch (Exception var16_39) {
                                            if (!Receiver.logger_.isLoggable(Level.SEVERE)) ** GOTO lbl189
                                            Receiver.logger_.log(Level.SEVERE, "Can't handle TERM system message.", var16_39);
                                        }
                                        continue block100;
                                    }
                                }
                                case 10: {
                                    try {
                                        this.trans_.getMonitor().gotPinged();
                                        v5 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        var10_53 = v5.getViewInfo(GroupManager.SYSTEM_GROUP, var1_1.getVid());
                                        if (var10_53 != null && (var8_61 = var10_53.getMessageBuffer()) != null) {
                                            var8_61.cleanup((long[])var1_1.getReceiptTracker());
                                            var8_61.update(var1_1);
                                        }
                                        var2_2 = new Packet(11, 0, this.trans_.getLocalAddress(), (Address)var1_1.getSourceAddress(), null, 0L);
                                        v6 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        v6.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                                        v7 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        var10_53 = v7.getCurrentViewInfo(GroupManager.SYSTEM_GROUP);
                                        v8 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        v8.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                                        var8_61 = var10_53.getMessageBuffer();
                                        var2_2.setReceiveArray(var8_61.getReceiveVector());
                                        var2_2.setReceivedTONumber(this.trans_.getReceivedTONumber());
                                        this.trans_.send(var2_2);
                                    }
                                    catch (Exception var15_25) {
                                        if (this.trans_.terminated || !Receiver.logger_.isLoggable(Level.SEVERE)) continue block100;
                                        Receiver.logger_.log(Level.SEVERE, "Unable to handle PING request. Got packet: " + var1_1, var15_25);
                                    }
                                    catch (Error var15_26) {
                                        if (!Receiver.logger_.isLoggable(Level.SEVERE)) continue block100;
                                        Receiver.logger_.log(Level.SEVERE, "Ping error", var15_26);
                                    }
                                    continue block100;
                                }
                                case 11: {
                                    try {
                                        this.trans_.getMonitor().gotReply((Address)var1_1.getSourceAddress());
                                        v9 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        var10_53 = v9.getViewInfo(GroupManager.SYSTEM_GROUP, var1_1.getVid());
                                        if (var10_53 == null || (var8_61 = var10_53.getMessageBuffer()) == null) continue block100;
                                        var8_61.update((long[])var1_1.getReceiptTracker(), var1_1.getSenderIndex());
                                        var8_61.update(var1_1);
                                    }
                                    catch (Exception var15_27) {
                                        if (!Receiver.logger_.isLoggable(Level.SEVERE)) continue block100;
                                        Receiver.logger_.log(Level.SEVERE, "Ping_ACK exception", var15_27);
                                    }
                                    continue block100;
                                }
                                case 22: {
                                    var15_28 = (Address)var1_1.message;
                                    if (var15_28 != null) {
                                        if (this.trans_.isMyself(var15_28)) {
                                            if (Receiver.logger_.isLoggable(Level.SEVERE)) {
                                                Receiver.logger_.log(Level.SEVERE, "Got KILL Message from " + var1_1.source + ", shutting down group communication layer.");
                                            }
                                            this.gcomm_.term();
                                            continue block100;
                                        }
                                        var16_40 = (EndPoint)this.trans_.getEndPointList().get(var15_28);
                                        if (var16_40 == null) continue block100;
                                        var16_40.close(true);
                                        continue block100;
                                    }
                                    if (!Receiver.logger_.isLoggable(Level.SEVERE)) continue block100;
                                    Receiver.logger_.log(Level.SEVERE, "Invalid KILL message " + var1_1);
                                    continue block100;
                                }
                                case 13: {
                                    try {
                                        v10 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        v10.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                                        v11 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        var10_53 = v11.getCurrentViewInfo(GroupManager.SYSTEM_GROUP);
                                        v12 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        v12.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                                        var4_58 = var10_53.getView();
                                        var8_61 = var10_53.getMessageBuffer();
                                        var3_3 = (Packet)var1_1.getMessage();
                                        if (var3_3.getVid() == var4_58.getVid()) {
                                            Receiver.deliver(this.gcomm_, this.trans_, var3_3, var8_61);
                                            ** break;
                                        }
                                        if (var3_3.getVid() <= var4_58.getVid()) continue block100;
                                        v13 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        var10_53 = v13.getViewInfo(GroupManager.SYSTEM_GROUP, var3_3.getVid());
                                        var8_61 = var10_53.getMessageBuffer();
                                        if (var8_61 == null) throw new GroupException(GrpCommunication.EXP_GRP_INTERNAL + GrpCommunication.EXP_GRP_VIEWINFOEMPTY);
                                        var8_61.hold(var3_3);
                                        ** break;
lbl393:
                                        // 2 sources

                                    }
                                    catch (Exception var16_41) {
                                        if (!Receiver.logger_.isLoggable(Level.SEVERE)) continue block100;
                                        Receiver.logger_.log(Level.SEVERE, "Unable to forward packet: " + var1_1, var16_41);
                                    }
                                    continue block100;
                                }
                                case 15: {
                                    var16_42 = 0;
                                    var17_14 = 0;
                                    var18_15 = this.trans_.getCoordinatorLock();
                                    synchronized (var18_15) {
                                        try {
                                            v14 = this.trans_.getGroupManager();
                                            this.trans_.getGroupManager();
                                            v14.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                                            v15 = this.trans_.getGroupManager();
                                            this.trans_.getGroupManager();
                                            var4_58 = v15.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
                                            v16 = this.trans_.getGroupManager();
                                            this.trans_.getGroupManager();
                                            v16.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                                            if (var4_58 == null) {
                                                continue block100;
                                            }
                                            var16_42 = var4_58.getVid();
                                            var17_14 = var1_1.getVid();
                                            if (var17_14 == var16_42) {
                                                this.trans_.getGroupManager().endFlush(this, var1_1);
                                            }
                                        }
                                        catch (Exception var19_44) {
                                            if (!Receiver.logger_.isLoggable(Level.SEVERE)) ** GOTO lbl189
                                            Receiver.logger_.log(Level.SEVERE, "Unable to flush view from: " + var17_14 + " to " + var16_42, var19_44);
                                        }
                                        continue block100;
                                    }
                                }
                                case 14: {
                                    try {
                                        var3_3 = (Packet)var1_1.getMessage();
                                        v17 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        v17.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                                        v18 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        var10_53 = v18.getCurrentViewInfo(GroupManager.SYSTEM_GROUP);
                                        v19 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        v19.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                                        var4_58 = var10_53.getView();
                                        var8_61 = var10_53.getMessageBuffer();
                                        if (var3_3.getVid() == var4_58.getVid()) {
                                            Receiver.deliver(this.gcomm_, this.trans_, var3_3, var8_61);
                                            continue block100;
                                        }
                                        v20 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        var10_53 = v20.getViewInfo(GroupManager.SYSTEM_GROUP, var1_1.getVid());
                                        if (var10_53 == null) continue block100;
                                        var8_61 = var10_53.getMessageBuffer();
                                        var8_61.hold(var3_3);
                                    }
                                    catch (Exception var18_17) {
                                        if (!Receiver.logger_.isLoggable(Level.SEVERE)) continue block100;
                                        Receiver.logger_.log(Level.SEVERE, "Unable to handle DELIVER request. Got packet: " + var1_1, var18_17);
                                    }
                                    continue block100;
                                }
                                case 16: {
                                    var18_15 = this.trans_.getMemberLock();
                                    synchronized (var18_15) {
                                        try {
                                            v21 = this.trans_.getGroupManager();
                                            this.trans_.getGroupManager();
                                            v21.updateView(GroupManager.SYSTEM_GROUP);
                                        }
                                        catch (Exception var19_45) {
                                            if (this.trans_.terminated || !Receiver.logger_.isLoggable(Level.SEVERE)) ** GOTO lbl189
                                            Receiver.logger_.log(Level.SEVERE, "Unable to handle FLUSHOVER request: " + var1_1, var19_45);
                                        }
                                        continue block100;
                                    }
                                }
                                case 17: {
                                    var19_46 = false;
                                    var20_63 = false;
                                    if (var1_1.getMessage() instanceof TestCommand && ((var21_49 = (TestCommand)var1_1.getMessage()).getTarget() instanceof String || this.trans_.isMyself((Address)var21_49.getTarget()))) {
                                        switch (var21_49.getAction()) {
                                            case 1: {
                                                continue block100;
                                            }
                                        }
                                        continue block100;
                                    }
                                    if (var1_1.destination instanceof Address) {
                                        Receiver.process(this.gcomm_, this.trans_, var1_1);
                                        try {
                                            v22 = this.trans_.getGroupManager();
                                            this.trans_.getGroupManager();
                                            var10_53 = v22.getViewInfo(GroupManager.SYSTEM_GROUP, var1_1.getVid());
                                            if (var10_53 == null || (var18_15 = var10_53.getView()) == null) continue block100;
                                            var8_61 = var10_53.getMessageBuffer();
                                            var9_62 = (long[])var1_1.getReceiptTracker();
                                            if (var1_1.getReceivedTONumber() == -1L) continue block100;
                                            var8_61.update(var1_1);
                                        }
                                        catch (Exception var21_50) {
                                            if (!Receiver.logger_.isLoggable(Level.SEVERE)) continue block100;
                                            Receiver.logger_.log(Level.SEVERE, "Internal Error: Can't process USER MSG from " + var1_1.source.toString(true), var21_50);
                                        }
                                        continue block100;
                                    }
                                    try {
                                        try {
                                            v23 = this.trans_.getGroupManager();
                                            this.trans_.getGroupManager();
                                            v23.getDeliverRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                                            var20_63 = true;
                                            v24 = this.trans_.getGroupManager();
                                            this.trans_.getGroupManager();
                                            v24.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                                            var19_46 = true;
                                            v25 = this.trans_.getGroupManager();
                                            this.trans_.getGroupManager();
                                            var10_53 = v25.getCurrentViewInfo(GroupManager.SYSTEM_GROUP);
                                            var18_15 = var10_53.getView();
                                            var8_61 = var10_53.getMessageBuffer();
                                            if (var19_46) {
                                                v26 = this.trans_.getGroupManager();
                                                this.trans_.getGroupManager();
                                                v26.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                                                var19_46 = false;
                                            }
                                            if (var18_15 == null) {
                                                var38_59 = null;
                                                if (var19_46) {
                                                    v27 = this.trans_.getGroupManager();
                                                    this.trans_.getGroupManager();
                                                    break;
                                                }
                                                break block173;
                                            }
                                            if (var1_1.getSequenceNumber() > this.trans_.getSequencer()) {
                                                this.trans_.setSequencer(var1_1.getSequenceNumber());
                                            }
                                            if (var1_1.getVid() > var18_15.getVid()) {
                                                v28 = this.trans_.getGroupManager();
                                                this.trans_.getGroupManager();
                                                var10_53 = v28.getViewInfo(GroupManager.SYSTEM_GROUP, var1_1.getVid());
                                                if (var10_53 == null) break block174;
                                                var8_61 = var10_53.getMessageBuffer();
                                                if (Receiver.logger_.isLoggable(Level.FINEST)) {
                                                    Receiver.logger_.log(Level.FINEST, "Holding message: " + var1_1 + ", for current view: " + var18_15.getVid());
                                                }
                                                if (var8_61 == null) break block174;
                                                var8_61.hold(var1_1);
                                                break block174;
                                            }
                                            if (var1_1.getVid() < var18_15.getVid()) {
                                                if (var1_1.getSerialNumber() == 0L) {
                                                    Receiver.process(this.gcomm_, this.trans_, var1_1);
                                                }
                                                break block174;
                                            }
                                            try {
                                                var9_62 = (long[])var1_1.getReceiptTracker();
                                                if (var9_62 != null) {
                                                    var8_61.update(var9_62, var1_1.getSenderIndex());
                                                }
                                                if (var1_1.getReceivedTONumber() != -1L) {
                                                    var8_61.update(var1_1);
                                                }
                                                Receiver.deliver(this.gcomm_, this.trans_, var1_1, var8_61);
                                            }
                                            catch (Exception var21_51) {
                                                if (!Receiver.logger_.isLoggable(Level.SEVERE)) break block174;
                                                Receiver.logger_.log(Level.SEVERE, "User Message Exception:", var21_51);
                                            }
                                            break block174;
                                        }
                                        catch (Exception var21_52) {
                                            if (Receiver.logger_.isLoggable(Level.SEVERE)) {
                                                Receiver.logger_.log(Level.SEVERE, "Internal Error: Can't process USER MSG.", var21_52);
                                            }
                                            var38_59 = null;
                                            if (var19_46) {
                                                v29 = this.trans_.getGroupManager();
                                                this.trans_.getGroupManager();
                                                v29.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                                            }
                                            if (!var20_63) continue block100;
                                            v30 = this.trans_.getGroupManager();
                                            this.trans_.getGroupManager();
                                            v30.getDeliverRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                                            continue block100;
                                        }
                                    }
                                    catch (Throwable var37_67) {
                                        var38_59 = null;
                                        if (var19_46) {
                                            v31 = this.trans_.getGroupManager();
                                            this.trans_.getGroupManager();
                                            v31.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                                        }
                                        if (var20_63 == false) throw var37_67;
                                        v32 = this.trans_.getGroupManager();
                                        this.trans_.getGroupManager();
                                        v32.getDeliverRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                                        throw var37_67;
                                    }
                                }
                                default: {
                                    if (!Receiver.logger_.isLoggable(Level.SEVERE)) continue block100;
                                }
                            }
                            v27.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                        }
                        if (!var20_63) continue;
                        v33 = this.trans_.getGroupManager();
                        this.trans_.getGroupManager();
                        v33.getDeliverRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                        continue;
                    }
                    var38_59 = null;
                    if (var19_46) {
                        v34 = this.trans_.getGroupManager();
                        this.trans_.getGroupManager();
                        v34.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                    }
                    if (!var20_63) continue;
                    v35 = this.trans_.getGroupManager();
                    this.trans_.getGroupManager();
                    v35.getDeliverRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                    continue;
                    Receiver.logger_.log(Level.SEVERE, "Unknown PACKET. Got packet: " + var1_1);
                }
                catch (Throwable var15_29) {
                    if (!Receiver.logger_.isLoggable(Level.WARNING)) continue;
                    Receiver.logger_.log(Level.WARNING, "Discard unexpected packet: " + var1_1);
                }
            }
            if (this.ep != null && this.trans_.endPointList.containsValue(this.ep)) {
                if (this.puller_ != null && this.puller_.isTerminated()) {
                    this.dispose(new GroupException("Connection close"));
                } else {
                    this.trans_.removeAddress(this.ep.addr);
                }
            }
            if (Receiver.logger_.isLoggable(Level.FINEST) == false) return;
            Receiver.logger_.log(Level.FINEST, this + " exited. work=" + this.work);
            return;
        }
    }

    void stopit() {
        this.work = false;
        if (this.puller_ != null) {
            this.puller_.terminate();
        }
    }

    void resetRecentReadCounter() {
        if (this.puller_ != null) {
            this.puller_.resetRecentReadCounter();
        }
    }

    long getRecentReadCounter() {
        long l = 0L;
        if (this.puller_ != null) {
            return this.puller_.getRecentReadCounter();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deliver(GrpCommunication grpCommunication, Transport transport, Packet packet, MessageBuffer messageBuffer) {
        block15: {
            try {
                if (messageBuffer != null && messageBuffer.hasDelivered(packet)) {
                    return;
                }
                if (packet.isTotal() && packet.isFromMyself() && packet.getSequenceNumber() != -1L) {
                    Receiver.process(grpCommunication, transport, packet);
                    if (messageBuffer != null) {
                        messageBuffer.delivered(packet);
                        messageBuffer.replace(packet);
                    }
                    return;
                }
                if (packet.isTotal() && packet.getSequenceNumber() == -1L) {
                    Object object = transport.getTotalLock();
                    synchronized (object) {
                        if (!transport.isMyself(transport.getFailureDetector().getCoordinator()) && logger_.isLoggable(Level.WARNING)) {
                            logger_.log(Level.WARNING, "come back.");
                            if (packet != null) {
                                logger_.log(Level.WARNING, packet.toString());
                            }
                        }
                        transport.multicastTotalOrderedMsg(packet);
                        Receiver.process(grpCommunication, transport, packet);
                        if (messageBuffer != null) {
                            messageBuffer.delivered(packet);
                        }
                    }
                } else {
                    Receiver.process(grpCommunication, transport, packet);
                    if (messageBuffer != null) {
                        messageBuffer.delivered(packet);
                    }
                }
                if (logger_.isLoggable(Level.FINEST)) {
                    logger_.log(Level.FINEST, "Delivered packet: " + packet + ", to " + messageBuffer);
                }
            }
            catch (Exception exception) {
                if (!logger_.isLoggable(Level.SEVERE)) break block15;
                logger_.log(Level.SEVERE, "Deliver Error.", exception);
            }
        }
    }

    static void process(GrpCommunication grpCommunication, Transport transport, Packet packet) {
        Object object;
        Object object2;
        if (packet.getNodeCast()) {
            object2 = (Address)packet.getSourceAddress();
            object = transport.getLocalAddress();
            if (!((Address)object2).ip.equals(((Address)object).ip)) {
                return;
            }
        }
        object2 = transport.receivingQList.elements();
        while (object2.hasMoreElements()) {
            object = (MessageQueue)object2.nextElement();
            object.enqueue(new GroupMessage(0, packet), transport.ctx);
        }
        if (logger_.isLoggable(Level.FINEST)) {
            logger_.log(Level.FINEST, "Processed packet: " + packet);
        }
    }
}

