/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.group.EndPoint;
import oracle.ias.cache.group.GroupManager;
import oracle.ias.cache.group.Packet;

public class PacketReceiver
extends Thread {
    static final long QUEUE_LIMIT = 15000000L;
    static final int PAUSE_TIMEOUT = 500;
    static final String LOGGER_NAME = "oracle.ias.cache.group.PacketReceiver";
    static final int QUEUE_WAIT_TIMEOUT = 3000;
    private boolean keepRunning_ = true;
    private boolean terminated_ = false;
    private EndPoint ep_;
    private LinkedList queue_;
    private LinkedList sysQueue_;
    private GroupException gex_;
    private static Logger logger_ = Logger.getLogger("oracle.ias.cache.group.PacketReceiver");
    private byte[] pause_;
    private long queueSizeInBytes_ = 0L;
    private int sysQcnt;
    private int qcnt_;
    private long recentReads_;
    private GroupManager gMgr_;

    public PacketReceiver(EndPoint endPoint, GroupManager groupManager) {
        this.ep_ = endPoint;
        this.queue_ = new LinkedList();
        this.queue_.clear();
        this.sysQueue_ = new LinkedList();
        this.sysQueue_.clear();
        this.pause_ = new byte[0];
        this.setDaemon(true);
        this.setName("PacketReceiver for [" + endPoint.getShortName() + "]");
        this.sysQcnt = 0;
        this.qcnt_ = 0;
        this.gMgr_ = groupManager;
    }

    boolean isTerminated() {
        return this.terminated_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        this.keepRunning_ = false;
        LinkedList linkedList = this.queue_;
        synchronized (linkedList) {
            this.queue_.notifyAll();
        }
    }

    GroupException getLastException() {
        return this.gex_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Packet waitForAPacket() throws GroupException {
        Packet packet = null;
        try {
            Object object = this.queue_;
            synchronized (object) {
                while (this.gex_ == null && this.queueSizeInBytes_ <= 0L && this.keepRunning_) {
                    this.queue_.wait(3000L);
                }
                if (this.queue_.size() > 0) {
                    packet = (Packet)this.queue_.removeFirst();
                }
                if (packet != null && packet.type == 24) {
                    packet = (Packet)this.sysQueue_.removeFirst();
                    --this.sysQcnt;
                    if (this.sysQcnt == 0) {
                        this.gMgr_.removeFromSysMsgList(this.ep_);
                    }
                    if (logger_.isLoggable(Level.FINEST)) {
                        logger_.log(Level.FINEST, "reading sysMsg " + packet.getType() + ", count= " + this.qcnt_);
                    }
                }
                if (packet != null) {
                    this.queueSizeInBytes_ -= (long)packet.getTotalLength();
                    --this.qcnt_;
                    return packet;
                }
                if (this.gex_ != null) {
                    throw this.gex_;
                }
            }
            object = this.pause_;
            synchronized (this.pause_) {
                this.pause_.notifyAll();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        {
            return packet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        block25: {
            block24: {
                var1_1 = null;
                try {
                    ** try [egrp 1[TRYBLOCK] [4, 5, 6 : 2->320)] { 
lbl4:
                    // 1 sources

                    break block24;
lbl5:
                    // 1 sources

                    catch (IOException var2_3) {
                        this.gex_ = new GroupException(var2_3.getMessage(), var2_3);
                        var6_8 = null;
                        var7_13 = this.queue_;
                        // MONITORENTER : var7_13
                        this.terminated_ = true;
                        this.keepRunning_ = false;
                        this.queue_.notifyAll();
                        // MONITOREXIT : var7_13
                    }
                }
                catch (Throwable var5_17) {
                    var6_11 = null;
                    var7_16 = this.queue_;
                    // MONITORENTER : var7_16
                    this.terminated_ = true;
                    this.keepRunning_ = false;
                    this.queue_.notifyAll();
                    // MONITOREXIT : var7_16
                    throw var5_17;
                }
            }
            while (this.keepRunning_) {
                if (this.queueSizeInBytes_ >= 15000000L) {
                    if (PacketReceiver.logger_.isLoggable(Level.FINEST)) {
                        PacketReceiver.logger_.log(Level.FINEST, "Queue is full. size:" + this.queueSizeInBytes_ + ", count:" + this.queue_.size());
                    }
                    var2_2 /* !! */  = this.pause_;
                    // MONITORENTER : this.pause_
                    this.pause_.wait(500L);
                    // MONITOREXIT : var2_2 /* !! */ 
                    continue;
                }
                var1_1 = this.ep_.read();
                ++this.recentReads_;
                ++this.qcnt_;
                v0 = this.queue_;
                var2_2 /* !! */  = (byte[])v0;
                // MONITORENTER : v0
                if (var1_1 != null && var1_1.type != 17 && var1_1.type != 14 && var1_1.type != 11 && var1_1.type != 15 && var1_1.type != 10 && var1_1.type != 13) {
                    var3_6 = new Packet(24, 0, null, null, null, 0L);
                    this.sysQueue_.add(var1_1);
                    this.queue_.addFirst(var3_6);
                    if (this.sysQcnt == 0) {
                        this.gMgr_.addToSysMsgList(this.ep_);
                    }
                    ++this.sysQcnt;
                } else {
                    this.queue_.add(var1_1);
                }
                if (var1_1 == null) {
                    this.keepRunning_ = false;
                    this.terminated_ = true;
                } else {
                    this.queueSizeInBytes_ += (long)var1_1.getTotalLength();
                }
                this.queue_.notifyAll();
                // MONITOREXIT : var2_2 /* !! */ 
            }
            var6_7 = null;
            var7_12 = this.queue_;
            // MONITORENTER : var7_12
            this.terminated_ = true;
            this.keepRunning_ = false;
            this.queue_.notifyAll();
            // MONITOREXIT : var7_12
            break block25;
lbl69:
            // 1 sources

            catch (GroupException var2_4) {
                this.gex_ = var2_4;
                var6_9 = null;
                var7_14 = this.queue_;
                // MONITORENTER : var7_14
                this.terminated_ = true;
                this.keepRunning_ = false;
                this.queue_.notifyAll();
                // MONITOREXIT : var7_14
            }
lbl80:
            // 1 sources

            catch (Exception var2_5) {
                this.gex_ = new GroupException(var2_5.getMessage(), var2_5);
                var6_10 = null;
                var7_15 = this.queue_;
                // MONITORENTER : var7_15
                this.terminated_ = true;
                this.keepRunning_ = false;
                this.queue_.notifyAll();
                // MONITOREXIT : var7_15
            }
        }
        if (PacketReceiver.logger_.isLoggable(Level.FINEST) == false) return;
        PacketReceiver.logger_.log(Level.FINEST, this.getName() + " is terminated. Reason: " + this.gex_ + ", p=" + var1_1);
    }

    void resetRecentReadCounter() {
        this.recentReads_ = 0L;
    }

    long getRecentReadCounter() {
        return this.recentReads_;
    }
}

