/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.NodeListenerHandler;
import oracle.ias.cache.group.ServerSocketEndPoint;
import oracle.ias.cache.group.ServerSocketHandler;
import oracle.ias.cache.group.Transport;

class NodeListener
extends Thread
implements ServerSocketHandler {
    static final String LOGGER_NAME = "oracle.ias.cache.group.NodeListener";
    private boolean run = true;
    private ServerSocketEndPoint ssep;
    private GrpCommunication gcomm_;
    private Transport trans_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.NodeListener");

    NodeListener(GrpCommunication grpCommunication, Transport transport, ServerSocketEndPoint serverSocketEndPoint) {
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.ssep = serverSocketEndPoint;
        String string = null;
        if (this.ssep != null && this.ssep.ss != null) {
            string = this.ssep.ss.getInetAddress().getHostAddress() + ":" + this.ssep.ss.getLocalPort();
        }
        this.setName("Node Listener [" + string + "]");
        this.setDaemon(true);
    }

    public void run() {
        Socket socket = null;
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, this.getName() + " is started.");
        }
        while (this.run) {
            try {
                if (this.ssep.ss == null) continue;
                socket = this.ssep.ss.accept();
                NodeListenerHandler nodeListenerHandler = new NodeListenerHandler(this.gcomm_, this.trans_, socket);
                nodeListenerHandler.start();
            }
            catch (SocketException socketException) {
                if (!this.run || !this.gcomm_.isReady() || !this.logger_.isLoggable(Level.FINE)) continue;
                this.logger_.log(Level.FINE, "Got socket exception.", socketException);
            }
            catch (Exception exception) {
                if (!this.run || !this.gcomm_.isReady() || !this.logger_.isLoggable(Level.SEVERE)) continue;
                this.logger_.log(Level.SEVERE, "NodeListener exception.", exception);
            }
        }
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, this.getName() + " is terminated.");
        }
    }

    public void stopit() {
        this.run = false;
        try {
            this.ssep.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

