/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.Packet;

class HttpPacket {
    private Packet m_packet;
    private File m_attachedFile;
    private InputStream m_input_stream;
    private byte[] m_packet_buf;
    private long m_packet_size = 0L;
    private long m_file_size = 0L;
    private long m_stream_size = 0L;
    private transient GrpCommunication gcomm_;
    static final String s_crlf = new String("\r\n");
    static final String s_separator = new String(": ");
    static final int s_separator_length = 2;
    static final String s_request_line = new String("POST /cache HTTP/1.1");
    static final String s_version_header = new String("Version");
    static final String s_content_length_header = new String("Content-Length");
    static final String s_packet_length_header = new String("Packet-Length");
    static final String s_file_length_header = new String("File-Length");

    HttpPacket(GrpCommunication grpCommunication, Packet packet) throws IOException {
        this.gcomm_ = grpCommunication;
        this.m_packet = packet;
        String string = packet.getAttachedFileName();
        this.m_attachedFile = string != null ? new File(string) : null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.m_packet);
        this.m_packet_buf = byteArrayOutputStream.toByteArray();
        this.m_packet_size = this.m_packet_buf.length;
        if (this.m_attachedFile != null) {
            this.m_file_size = this.m_attachedFile.length();
        }
        this.m_input_stream = packet.getInputStream();
        this.m_stream_size = packet.getStreamSize();
    }

    byte[] getPacketBuffer() {
        return this.m_packet_buf;
    }

    Packet getPacket() {
        return this.m_packet;
    }

    boolean hasAttachedFile() {
        return this.m_attachedFile != null;
    }

    File getAttachedFile() {
        return this.m_attachedFile;
    }

    boolean hasInputStream() {
        return this.m_input_stream != null;
    }

    InputStream getInputStream() {
        return this.m_input_stream;
    }

    long getStreamSize() {
        return this.m_stream_size;
    }

    byte[] getHeaders() {
        StringBuffer stringBuffer = new StringBuffer(s_request_line);
        stringBuffer.append(s_crlf);
        stringBuffer.append(s_version_header);
        stringBuffer.append(s_separator);
        stringBuffer.append(this.gcomm_.getGroupConfig().getVersion());
        stringBuffer.append(s_crlf);
        stringBuffer.append(s_content_length_header);
        stringBuffer.append(s_separator);
        if (this.m_file_size != 0L) {
            stringBuffer.append(this.m_packet_size + this.m_file_size);
        } else if (this.m_stream_size != 0L) {
            stringBuffer.append(this.m_packet_size + this.m_stream_size);
        } else {
            stringBuffer.append(this.m_packet_size);
        }
        stringBuffer.append(s_crlf);
        stringBuffer.append(s_packet_length_header);
        stringBuffer.append(s_separator);
        stringBuffer.append(this.m_packet_size);
        stringBuffer.append(s_crlf);
        stringBuffer.append(s_file_length_header);
        stringBuffer.append(s_separator);
        if (this.m_file_size != 0L) {
            stringBuffer.append(this.m_file_size);
        } else if (this.m_stream_size != 0L) {
            stringBuffer.append(this.m_stream_size);
        } else {
            stringBuffer.append(0);
        }
        stringBuffer.append(s_crlf);
        stringBuffer.append(s_crlf);
        return stringBuffer.toString().getBytes();
    }
}

