/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Vector;
import oracle.ias.cache.commx.GroupCommunication;
import oracle.ias.cache.commx.GroupConfig;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.GrpCommunication;

public class GrpConfig
implements GroupConfig {
    private static final String GROUP_PROVIDER = "oracle.ias.cache.group.GrpCommunication";
    private String m_working_dir = ".";
    private int m_transport_mode = 1;
    private Vector m_listener_list = new Vector();
    private String m_version = "10.1.4";
    private int m_receive_buf_size = 4096;
    private int m_send_buf_size = 4096;
    private Serializable m_tag;
    private boolean m_ssl_enabled = false;
    private String m_cache_name = "";
    private String m_localAddress = null;
    private boolean m_nlDeathDetected = false;
    private int m_overrideNLPort = -1;
    private String multicastAddr = "228.6.8.9";
    private int multicastPort = 11111;
    private int multicastInterval = 300;
    private boolean useMulticast = false;
    private int multicastTTL = 0;
    private long resolutionTimeout = 5000L;
    private long resolutionInterval = 5000L;
    boolean usePriorityOrder = false;
    private int lowerPortBoundry = 0;
    private int upperPortBoundry = 0;
    private String m_keyStoreLocation;
    private String m_sslConfigFilePath;

    public void setWorkingDir(String string) {
        this.m_working_dir = string;
    }

    public void setMode(int n) {
        this.m_transport_mode = n;
    }

    public void setListenerList(Vector vector) {
        this.m_listener_list = vector;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public void setReceiveBufferSize(int n) {
        this.m_receive_buf_size = n;
    }

    public void setSendBufferSize(int n) {
        this.m_send_buf_size = n;
    }

    public void setTag(Serializable serializable) {
        this.m_tag = serializable;
    }

    public void setCacheName(String string) {
        this.m_cache_name = string;
    }

    public void setLocalAddress(String string) {
        this.m_localAddress = string;
    }

    public String getWorkingDir() {
        return this.m_working_dir;
    }

    public int getMode() {
        return this.m_transport_mode;
    }

    public Vector getListenerList() {
        return this.m_listener_list;
    }

    public String getVersion() {
        return this.m_version;
    }

    public int getReceiveBufferSize() {
        return this.m_receive_buf_size;
    }

    public int getSendBufferSize() {
        return this.m_send_buf_size;
    }

    public Serializable getTag() {
        return this.m_tag;
    }

    public void setSSLEnabled(boolean bl) {
        this.m_ssl_enabled = bl;
    }

    public boolean getSSLEnabled() {
        return this.m_ssl_enabled;
    }

    public String getCacheName() {
        return this.m_cache_name;
    }

    public String getLocalAddress() {
        return this.m_localAddress;
    }

    public void setNLDeathDetected(boolean bl) {
        this.m_nlDeathDetected = bl;
    }

    public boolean isNLDeathDetected() {
        return this.m_nlDeathDetected;
    }

    public void setOverrideNLPort(int n) {
        this.m_overrideNLPort = n;
    }

    public int getOverrideNLPort() {
        return this.m_overrideNLPort;
    }

    public String getMulticastAddress() {
        return this.multicastAddr;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public int getMulticastInterval() {
        return this.multicastInterval;
    }

    public int getMulticastTTL() {
        return this.multicastTTL;
    }

    public long getResolutionTimeout() {
        return this.resolutionTimeout;
    }

    public long getResolutionInterval() {
        return this.resolutionInterval;
    }

    public void setResolutionInterval(long l) {
        this.resolutionInterval = l;
    }

    public boolean isMulticast() {
        return this.useMulticast;
    }

    public void enablePriorityOrder(boolean bl) {
        this.usePriorityOrder = bl;
    }

    public boolean isPriorityOrderEnabled() {
        return this.usePriorityOrder;
    }

    public void setMulticastAddress(String string) {
        this.multicastAddr = string;
    }

    public void setMulticastPort(int n) {
        this.multicastPort = n;
    }

    public void setMulticastInterval(int n) {
        this.multicastInterval = n;
    }

    public void setMulticastTTL(int n) {
        this.multicastTTL = n;
    }

    public void setResolutionTimeout(long l) {
        this.resolutionTimeout = l;
    }

    public void setMulticast(boolean bl) {
        this.useMulticast = bl;
    }

    public int getLowerPortBoundry() {
        return this.lowerPortBoundry;
    }

    public int getUpperPortBoundry() {
        return this.upperPortBoundry;
    }

    public void setLowerPortBoundry(int n) {
        this.lowerPortBoundry = n;
    }

    public void setUpperPortBoundry(int n) {
        this.upperPortBoundry = n;
    }

    public boolean removeCacheAddr(InetAddress inetAddress, int n) {
        if (this.m_listener_list == null || this.m_listener_list.isEmpty()) {
            return false;
        }
        Address address = new Address(inetAddress, n, false, 0, null);
        for (int i = 0; i < this.m_listener_list.size(); ++i) {
            Address address2 = (Address)this.m_listener_list.elementAt(i);
            if (address2 == null || !address2.equals(address)) continue;
            this.m_listener_list.remove(i);
            return true;
        }
        return false;
    }

    public boolean addressIsOriginal(InetAddress inetAddress, int n) {
        Address address = null;
        Address address2 = null;
        if (this.m_listener_list == null) {
            this.m_listener_list = new Vector();
        }
        address = new Address(inetAddress, n);
        int n2 = this.m_listener_list.size();
        for (int i = 0; i < n2; ++i) {
            address2 = (Address)this.m_listener_list.elementAt(i);
            if (address2 == null || !address2.getString().equals(address.getString())) continue;
            return address2.isOriginal();
        }
        return false;
    }

    public void addPrimaryCacheAddr(InetAddress inetAddress, int n) {
        this.addPrimaryCacheAddr(inetAddress, n, false, 1);
    }

    public synchronized void addPrimaryCacheAddr(InetAddress inetAddress, int n, boolean bl, int n2) {
        Address address = null;
        Address address2 = null;
        if (this.m_listener_list == null) {
            this.m_listener_list = new Vector();
            address = new Address(inetAddress, n, false, 0, null);
            this.m_listener_list.addElement(address);
            return;
        }
        int n3 = this.m_listener_list.size();
        address = new Address(inetAddress, n, false, n3 - 1, null);
        Vector<Address> vector = new Vector<Address>();
        vector.addElement(address);
        for (int i = 0; i < n3; ++i) {
            address2 = (Address)this.m_listener_list.elementAt(i);
            if (address2 == null) continue;
            if (address2.getIPString().equals(address.getIPString()) && n == address2.getPort()) {
                if (!address2.isOriginal()) continue;
                int n4 = address2.getPriorityOrder();
                address = new Address(inetAddress, n, true, -1, n4);
                vector.setElementAt(address, 0);
                continue;
            }
            vector.addElement(address2);
        }
        this.m_listener_list = vector;
    }

    public void addCacheAddr(InetAddress inetAddress, int n, boolean bl, boolean bl2, int n2) {
        this.addCacheAddr(inetAddress, n, bl, bl2, n2, false, 1);
    }

    public void addCacheAddr(InetAddress inetAddress, int n, boolean bl, boolean bl2, int n2, boolean bl3, int n3) {
        Address address = null;
        Address address2 = null;
        if (this.m_listener_list == null) {
            this.m_listener_list = new Vector();
        }
        address = new Address(inetAddress, n, bl2, -1, n2);
        int n4 = this.m_listener_list.size();
        for (int i = 0; i < n4; ++i) {
            address2 = (Address)this.m_listener_list.elementAt(i);
            if (address2 == null || !address2.getIPString().equals(address.getIPString())) continue;
            if (bl) {
                this.m_listener_list.setElementAt(address, i);
                return;
            }
            if (n != address2.getPort()) continue;
            return;
        }
        this.m_listener_list.addElement(address);
    }

    public GroupCommunication createGroupCommunication() throws GroupException {
        GroupCommunication groupCommunication = null;
        try {
            Class<?> clazz = Class.forName(GROUP_PROVIDER);
            groupCommunication = (GroupCommunication)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new GroupException(GrpCommunication.EXP_GRP_BASE, exception);
        }
        return groupCommunication;
    }

    public void setKeyStore(String string) {
        this.m_keyStoreLocation = string;
    }

    public void setSSLConfigFile(String string) {
        this.m_sslConfigFilePath = string;
    }

    public String getKeyStore() {
        return this.m_keyStoreLocation;
    }

    public String getSSLConfigFile() {
        return this.m_sslConfigFilePath;
    }

    public boolean isSSLEnabled() {
        return this.m_ssl_enabled;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mode = ");
        stringBuffer.append(this.getMode());
        stringBuffer.append(", \nlocalAddress = ");
        stringBuffer.append(this.m_localAddress);
        stringBuffer.append(", \nisSSLEnabled = ");
        stringBuffer.append(this.m_ssl_enabled);
        stringBuffer.append(", \nm_sslConfigFilePath = ");
        stringBuffer.append(this.m_sslConfigFilePath);
        stringBuffer.append(", \nkeyStore = ");
        stringBuffer.append(this.m_keyStoreLocation);
        stringBuffer.append(", \nlDeathDetectable = ");
        stringBuffer.append(this.m_nlDeathDetected);
        stringBuffer.append(", \noverrideNLPort = ");
        stringBuffer.append(this.m_overrideNLPort);
        stringBuffer.append(", \nuseMulticast = ");
        stringBuffer.append(this.useMulticast);
        stringBuffer.append(", \nmulticastAddr = ");
        stringBuffer.append(this.multicastAddr);
        stringBuffer.append(", \nmulticastPort = ");
        stringBuffer.append(this.multicastPort);
        stringBuffer.append(", \nmulticastInterval = ");
        stringBuffer.append(this.multicastInterval);
        stringBuffer.append(", \nmulticastTTL = ");
        stringBuffer.append(this.multicastTTL);
        stringBuffer.append(", \nusePriorityOrder ");
        stringBuffer.append(this.usePriorityOrder);
        stringBuffer.append(", \nlowerPortBoundry ");
        stringBuffer.append(this.lowerPortBoundry);
        stringBuffer.append(", \nupperPortBoundry ");
        stringBuffer.append(this.upperPortBoundry);
        return stringBuffer.toString();
    }

    public void addListener(InetAddress inetAddress, int n, boolean bl, int n2) {
    }
}

