/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.Channel;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.GroupView;
import oracle.ias.cache.commx.MessageQueue;
import oracle.ias.cache.commx.NetworkAddress;
import oracle.ias.cache.commx.ReplyInfo;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.GrpReplyInfo;
import oracle.ias.cache.group.MessageBuffer;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;
import oracle.ias.cache.group.ViewInfo;

public class GrpChannel
implements Channel {
    static final String LOGGER_NAME = "oracle.ias.cache.group.GrpChannel";
    private static final char SEPARATOR = '_';
    private byte[] atomic_lock;
    private String grpName;
    private GrpCommunication gcomm_;
    private Transport trans_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.GrpChannel");

    public GrpChannel(GrpCommunication grpCommunication, Transport transport) {
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.atomic_lock = new byte[0];
    }

    public void close() {
        try {
            if (this.grpName != null) {
                this.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void connect(String string) throws GroupException {
        this.grpName = string;
    }

    public void disconnect() throws GroupException {
        this.grpName = null;
    }

    public void send(NetworkAddress networkAddress, Serializable serializable) throws GroupException {
        this.send(networkAddress, serializable, 0L, null, null, 0L);
    }

    public void send(NetworkAddress networkAddress, Serializable serializable, String string) throws GroupException {
        this.send(networkAddress, serializable, 0L, string, null, 0L);
    }

    public void send(NetworkAddress networkAddress, Serializable serializable, InputStream inputStream, long l) throws GroupException {
        this.send(networkAddress, serializable, 0L, null, inputStream, l);
    }

    public void send(NetworkAddress networkAddress, Serializable serializable, long l) throws GroupException {
        this.send(networkAddress, serializable, l, null, null, 0L);
    }

    public void send(NetworkAddress networkAddress, Serializable serializable, long l, String string) throws GroupException {
        this.send(networkAddress, serializable, l, string, null, 0L);
    }

    public void send(NetworkAddress networkAddress, Serializable serializable, long l, InputStream inputStream, long l2) throws GroupException {
        this.send(networkAddress, serializable, l, null, inputStream, l2);
    }

    private void send(NetworkAddress networkAddress, Serializable serializable, long l, String string, InputStream inputStream, long l2) throws GroupException {
        if (!this.gcomm_.isReady()) {
            throw new GroupException(GrpCommunication.EXP_GRP_NOTINITIALIZED);
        }
        if (this.gcomm_.getGroupConfig().getMode() != 1 && string != null) {
            throw new GroupException(GrpCommunication.EXP_GRP_WRONG_MODE);
        }
        if (!(networkAddress instanceof Address)) {
            throw new GroupException(GrpCommunication.EXP_GRP_INVALIDADDR);
        }
        try {
            Packet packet = new Packet(this.trans_.ssep.addr, networkAddress, serializable);
            if (l > 0L) {
                packet.setSize(l);
            }
            if (string != null) {
                packet.setAttachedFileName(string);
            }
            if (inputStream != null) {
                packet.setInputStream(inputStream);
                packet.setStreamSize(l2);
            }
            this.trans_.waitForSender();
            this.trans_.send(packet);
        }
        catch (Exception exception) {
            throw new GroupException(GrpCommunication.EXP_GRP_BASE + exception.toString(), exception);
        }
    }

    public ReplyInfo multicast(Serializable serializable) throws GroupException {
        return this.multicast(serializable, 0);
    }

    public ReplyInfo multicast(Serializable serializable, long l) throws GroupException {
        return this.multicast(serializable, 0, false, 0L, false);
    }

    public ReplyInfo multicast(Serializable serializable, int n) throws GroupException {
        return this.multicast(serializable, n, false, 0L, false);
    }

    public ReplyInfo multicast(Serializable serializable, int n, long l, long l2) throws GroupException {
        return this.multicast(serializable, n, false, l, false);
    }

    public ReplyInfo multicast(Serializable serializable, int n, long l, long l2, boolean bl) throws GroupException {
        return this.multicast(serializable, n, false, l, bl);
    }

    public ReplyInfo multicast(Serializable serializable, int n, boolean bl) throws GroupException {
        return this.multicast(serializable, n, bl, 0L);
    }

    public ReplyInfo multicast(Serializable serializable, int n, boolean bl, long l) throws GroupException {
        return this.multicast(serializable, n, bl, l, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReplyInfo multicast(Serializable serializable, int n, boolean bl, long l, boolean bl2) throws GroupException {
        GrpReplyInfo grpReplyInfo = null;
        if (!this.gcomm_.isReady()) {
            throw new GroupException(GrpCommunication.EXP_GRP_NOTINITIALIZED);
        }
        if ((n & 2) != 0) {
            n = 2;
        }
        this.trans_.waitForSender();
        try {
            if ((n & 1) != 0) {
                byte[] byArray = this.atomic_lock;
                synchronized (this.atomic_lock) {
                    Packet packet = new Packet(n, this.trans_.ssep.addr, this.grpName, serializable, this.trans_.getPacketSerial(n));
                    if (bl) {
                        packet.setNodeCast(true);
                    }
                    if (l <= 0L) return this.trans_.multicast(packet, false, bl2);
                    packet.setSize(l);
                    return this.trans_.multicast(packet, false, bl2);
                }
            }
            Packet packet = new Packet(n, this.trans_.ssep.addr, this.grpName, serializable, this.trans_.getPacketSerial(n));
            if (bl) {
                packet.setNodeCast(true);
            }
            if (l > 0L) {
                packet.setSize(l);
            }
            if ((n & 2) == 0) {
                return this.trans_.multicast(packet, false, bl2);
            }
            if (!this.trans_.isMyself(this.trans_.getFailureDetector().getCoordinator())) return this.trans_.sendTotalOrderedMsg(packet);
            return this.trans_.multicastTotalOrderedMsg(packet);
        }
        catch (Exception exception) {
            throw new GroupException(GrpCommunication.EXP_GRP_BASE + exception.toString(), exception);
        }
    }

    public ReplyInfo nodecast(Serializable serializable) throws GroupException {
        return this.multicast(serializable, 0, true);
    }

    public ReplyInfo nodecast(Serializable serializable, long l) throws GroupException {
        return this.multicast(serializable, 0, true, l);
    }

    public ReplyInfo nodecast(Serializable serializable, int n) throws GroupException {
        return this.multicast(serializable, n, true);
    }

    public ReplyInfo nodecast(Serializable serializable, int n, long l) throws GroupException {
        return this.multicast(serializable, n, true, l);
    }

    public Object receive(long l) throws GroupException {
        throw new GroupException("Not Implemented Yet.");
    }

    public void registerReceivingQueue(MessageQueue messageQueue, Object object) {
        this.trans_.registerReceivingQueue(this.grpName, messageQueue, object);
    }

    public void deregisterReceivingQueue(MessageQueue messageQueue) {
        this.trans_.deregisterReceivingQueue(this.grpName, messageQueue);
    }

    public GroupView getView() throws GroupException {
        View view = null;
        boolean bl = false;
        try {
            try {
                this.trans_.getGroupManager().getCurrentViewInfoRWLock(this.grpName).acquireReadLock();
                bl = true;
                ViewInfo viewInfo = this.trans_.getGroupManager().getCurrentViewInfo(this.grpName);
                view = viewInfo.getView();
            }
            catch (Exception exception) {
                throw new GroupException(GrpCommunication.EXP_GRP_BASE + exception.toString(), exception);
            }
            Object var5_5 = null;
            if (bl) {
                this.trans_.getGroupManager().releaseCurrentViewLock(this.grpName, true);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bl) {
                this.trans_.getGroupManager().releaseCurrentViewLock(this.grpName, true);
            }
            throw throwable;
        }
        if (view == null) {
            throw new GroupException(GrpCommunication.EXP_GRP_INTERNAL + GrpCommunication.EXP_GRP_VIEWNULL);
        }
        return view;
    }

    public NetworkAddress getLocalAddress() {
        return this.trans_.getLocalAddress();
    }

    public int getGlobalPosition() {
        return this.trans_.getLocalAddress().getPosition();
    }

    public String getGlobalUid() {
        StringBuffer stringBuffer = new StringBuffer();
        Address address = this.trans_.getLocalAddress();
        stringBuffer.append(address.getUid());
        stringBuffer.append('_');
        stringBuffer.append(address.getTimeStamp());
        return stringBuffer.toString();
    }

    public Object getGroupAddress() throws GroupException {
        if (this.grpName == null) {
            throw new GroupException(GrpCommunication.EXP_GRP_INVALIDCHANNEL);
        }
        return this.grpName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive(String string) {
        boolean bl = false;
        boolean bl2 = false;
        int n = string.indexOf(95);
        long l = -1L;
        long l2 = -1L;
        if (n != -1) {
            l = Long.parseLong(string.substring(0, n));
            l2 = Long.parseLong(string.substring(n + 1, string.length()));
        }
        try {
            try {
                this.trans_.getGroupManager().getCurrentViewInfoRWLock(this.grpName).acquireReadLock();
                bl2 = true;
                ViewInfo viewInfo = this.trans_.getGroupManager().getCurrentViewInfo(this.grpName);
                View view = viewInfo.getView();
                if (view != null) {
                    Vector vector = view.getMembers();
                    for (int i = 0; i < vector.size(); ++i) {
                        Address address = (Address)vector.elementAt(i);
                        if (address.getUid() != l || address.getTimeStamp() != l2 && l2 != 0L) continue;
                        bl = true;
                        break;
                    }
                }
                Object var15_13 = null;
                if (bl2) {
                    this.trans_.getGroupManager().releaseCurrentViewLock(this.grpName, true);
                }
            }
            catch (Exception exception) {
                if (this.logger_.isLoggable(Level.WARNING)) {
                    this.logger_.log(Level.WARNING, "Unable to detect uid: " + l + ". Ingored Exception: ", exception);
                }
                Object var15_14 = null;
                if (bl2) {
                    this.trans_.getGroupManager().releaseCurrentViewLock(this.grpName, true);
                }
            }
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (bl2) {
                this.trans_.getGroupManager().releaseCurrentViewLock(this.grpName, true);
            }
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasReceivedAll(Object object) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            block8: {
                try {
                    this.trans_.getGroupManager().getCurrentViewInfoRWLock(this.grpName).acquireReadLock();
                    bl2 = true;
                    ViewInfo viewInfo = this.trans_.getGroupManager().getCurrentViewInfo(this.grpName);
                    MessageBuffer messageBuffer = viewInfo.getMessageBuffer();
                    if (messageBuffer == null) break block8;
                    bl = messageBuffer.hasReceivedAll(object);
                }
                catch (Exception exception) {
                    if (this.logger_.isLoggable(Level.WARNING)) {
                        this.logger_.log(Level.WARNING, "Ingored Exception: ", exception);
                    }
                    Object var7_8 = null;
                    if (bl2) {
                        this.trans_.getGroupManager().releaseCurrentViewLock(this.grpName, true);
                    }
                }
            }
            Object var7_7 = null;
            if (bl2) {
                this.trans_.getGroupManager().releaseCurrentViewLock(this.grpName, true);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (bl2) {
                this.trans_.getGroupManager().releaseCurrentViewLock(this.grpName, true);
            }
            throw throwable;
        }
        return bl;
    }

    private void waitForSender() {
        if (!this.gcomm_.isReady()) {
            this.trans_.waitForSender();
        }
    }

    public long[][] getIOCounters(boolean bl) {
        return this.trans_.getIOCounters(bl);
    }

    public String[] getPacketTypeNames() {
        return Packet.PACKET_NAMES;
    }
}

