/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.ElectionNotification;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.Transport;

class CoordinatorResolver
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.group.CoordinatorResolver";
    private MulticastSocket mSocket_ = null;
    private Address myAddress_ = null;
    private int myPort_ = 0;
    private boolean terminate_ = false;
    private int myAddressPosition_ = 0;
    private Address[] nlAddresses_ = null;
    private boolean conflict_ = false;
    private boolean useMulticast_ = false;
    private boolean localConflict_ = false;
    private GrpCommunication gcomm_ = null;
    private Transport trans_ = null;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.CoordinatorResolver");

    CoordinatorResolver(GrpCommunication grpCommunication, Transport transport, Address[] addressArray, Address address, MulticastSocket multicastSocket) {
        this(grpCommunication, transport, addressArray, address);
        this.useMulticast_ = true;
        this.mSocket_ = multicastSocket;
        this.myPort_ = address.getPort();
    }

    CoordinatorResolver(GrpCommunication grpCommunication, Transport transport, Address[] addressArray, Address address) {
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.myAddress_ = address;
        this.nlAddresses_ = addressArray;
        this.myPort_ = address.getPort();
        this.myAddressPosition_ = this.getAddressPosition(address);
        this.setDaemon(true);
        this.setName("Coordinator Resolver");
        this.trans_.toEnableCollectingVotes(true);
    }

    boolean hasConflict(Address address, ElectionNotification electionNotification) {
        boolean bl = false;
        try {
            Address address2 = electionNotification.getNominee();
            boolean bl2 = electionNotification.istheWinner();
            if (bl2 && !address.equals(address2)) {
                if (address.getIPString().equals(address2.getIPString())) {
                    this.localConflict_ = true;
                }
                bl = true;
            } else {
                String string = address2.ip.getHostAddress();
                int n = address2.getPort();
                int n2 = this.getAddressPosition(address2);
                if (this.logger_.isLoggable(Level.FINEST)) {
                    this.logger_.log(Level.FINEST, "Norminee: [" + n2 + ":" + string + ":" + n + "]");
                    this.logger_.log(Level.FINEST, "MyAddress:[" + this.myAddressPosition_ + ":" + address.getIPString() + ":" + this.myPort_ + "]");
                }
                if (n2 < this.myAddressPosition_) {
                    bl = true;
                } else if (n2 == this.myAddressPosition_ && n < this.myPort_) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    boolean isLocalConflict() {
        return this.localConflict_;
    }

    private int getAddressPosition(Address address) {
        int n = -1;
        for (n = 0; n < this.nlAddresses_.length && !this.nlAddresses_[n].getIPString().equals(address.getIPString()); ++n) {
        }
        return n;
    }

    private Object byteToObject(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        return object;
    }

    void shutdown() {
        this.terminate_ = true;
        if (this.useMulticast_) {
            this.trans_.toEnableCollectingVotes(false);
            this.trans_.clearElectionVoteBuffer();
        }
    }

    boolean canBeCoordinator() {
        return !this.conflict_;
    }

    private ElectionNotification getAnElectionVote() {
        ElectionNotification electionNotification = null;
        if (this.useMulticast_) {
            DatagramPacket datagramPacket = null;
            try {
                byte[] byArray;
                byte[] byArray2 = new byte[1024];
                datagramPacket = new DatagramPacket(byArray2, byArray2.length);
                this.mSocket_.receive(datagramPacket);
                if (datagramPacket != null && !this.terminate_ && (byArray = datagramPacket.getData()) != null) {
                    electionNotification = (ElectionNotification)this.byteToObject(byArray);
                }
            }
            catch (Exception exception) {}
        } else {
            electionNotification = this.trans_.getACoordinatorVote();
        }
        if (!this.terminate_ && electionNotification != null && this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Retrieved an election vote:" + electionNotification);
        }
        return electionNotification;
    }

    public void run() {
        Serializable serializable;
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, this.getName() + " [" + this.myAddressPosition_ + ":" + this.myAddress_ + ":" + this.myPort_ + "] is started");
            serializable = new StringBuffer();
            for (int i = 0; i < this.nlAddresses_.length; ++i) {
                ((StringBuffer)serializable).append(i + ":");
                ((StringBuffer)serializable).append(this.nlAddresses_[i]);
                ((StringBuffer)serializable).append(", ");
            }
            this.logger_.log(Level.FINEST, "Sorted NL addresses: " + ((StringBuffer)serializable).toString());
        } else if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, this.getName() + " is started.");
        }
        while (!this.terminate_ && this.trans_.isNLStarted()) {
            serializable = this.getAnElectionVote();
            if (serializable != null) {
                this.conflict_ = this.hasConflict(this.myAddress_, (ElectionNotification)serializable);
            }
            if (!this.conflict_) continue;
            if (!this.logger_.isLoggable(Level.INFO)) break;
            this.logger_.log(Level.INFO, "Coordinator conflict is detected during election. Encountered a higher priority vote:" + serializable);
            break;
        }
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, this.getName() + " is terminated.");
        }
    }
}

