/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.InvalidArgumentException;
import oracle.ias.cache.TaskQ;
import oracle.ias.cache.WorkerThread;

class ThreadPool {
    static final String LOGGER_NAME = "oracle.ias.cache.ThreadPool";
    static final int DEFAULT_MIN = 5;
    static final int DEFAULT_MAX = 10;
    static final int LOW_PRIORITY = 0;
    static final int NORM_PRIORITY = 1;
    static final int HIGH_PRIORITY = 2;
    static final int IDLE_TIME = 5000;
    static final int JOIN_TIME = 2000;
    static int minThreads = 5;
    static int maxThreads = 10;
    static WorkerThread[] workers;
    static TaskQ taskQ;
    static boolean[] busy;
    static long[] time;
    static int busyThreads;
    static int runThreads;
    static boolean ready;
    static Logger logger;

    ThreadPool() {
    }

    static synchronized void init(int n, int n2, TaskQ taskQ) throws CacheException {
        if (ready) {
            return;
        }
        if (n > 0) {
            minThreads = n;
        }
        if (n2 > 0) {
            maxThreads = n2;
        }
        if (minThreads > maxThreads) {
            throw new InvalidArgumentException(CacheInternal.EXP_INVALARG + ": min, max");
        }
        ThreadPool.taskQ = taskQ;
        busyThreads = 0;
        runThreads = 0;
        workers = new WorkerThread[++maxThreads];
        busy = new boolean[maxThreads];
        time = new long[maxThreads];
        long l = System.currentTimeMillis();
        logger = Logger.getLogger(LOGGER_NAME);
        for (int i = 0; i < minThreads; ++i) {
            ThreadPool.workers[i] = new WorkerThread(i);
            ThreadPool.time[i] = l;
            ++runThreads;
            workers[i].start();
        }
        ready = true;
    }

    static void term() {
        int n;
        if (!ready) {
            return;
        }
        for (n = 0; n < maxThreads; ++n) {
            if (workers[n] == null) continue;
            workers[n].setShouldRun(false);
        }
        taskQ.wakeupAll();
        for (n = 0; n < maxThreads; ++n) {
            try {
                if (workers[n] == null) continue;
                workers[n].join(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ready = false;
    }

    static synchronized void setMaxThread(int n) {
        if (++n < minThreads) {
            return;
        }
        if (n > maxThreads) {
            WorkerThread[] workerThreadArray = new WorkerThread[n];
            boolean[] blArray = new boolean[n];
            long[] lArray = new long[n];
            for (int i = 0; i < maxThreads; ++i) {
                workerThreadArray[i] = workers[i];
                blArray[i] = busy[i];
                lArray[i] = time[i];
            }
            workers = workerThreadArray;
            busy = blArray;
            time = lArray;
        }
        maxThreads = n;
    }

    static int getMaxThread() {
        return maxThreads;
    }

    static synchronized void setBusy(int n, boolean bl) {
        if (bl) {
            ThreadPool.busy[n] = true;
            if (++busyThreads >= runThreads) {
                ThreadPool.startNewThread();
            }
        } else {
            ThreadPool.busy[n] = false;
            ThreadPool.time[n] = System.currentTimeMillis();
            if (runThreads > minThreads && runThreads > --busyThreads + 1) {
                ThreadPool.shrinkThread();
            }
        }
    }

    private static void startNewThread() {
        int n;
        if (!ready) {
            return;
        }
        for (n = 0; n < maxThreads; ++n) {
            if (workers[n] == null || workers[n].isShouldRun() || workers[n].isStop()) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "[Mem]  restart thread=" + n + " busy=" + busyThreads + " run=" + runThreads);
            }
            workers[n].setShouldRun(true);
            ThreadPool.time[n] = System.currentTimeMillis();
            ++runThreads;
            return;
        }
        for (n = 0; n < maxThreads; ++n) {
            if (workers[n] != null && !workers[n].isStop()) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "[Mem]  start thread=" + n + " busy=" + busyThreads + " run=" + runThreads);
            }
            ThreadPool.workers[n] = new WorkerThread(n);
            ThreadPool.time[n] = System.currentTimeMillis();
            ++runThreads;
            workers[n].start();
            return;
        }
    }

    private static void shrinkThread() {
        if (!ready) {
            return;
        }
        long l = System.currentTimeMillis();
        for (int i = 0; i < maxThreads; ++i) {
            if (workers[i] == null || busy[i] || !workers[i].isShouldRun() || l - time[i] <= 5000L) continue;
            workers[i].setShouldRun(false);
            --runThreads;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "[Mem]  shrink thread=" + i + " busy=" + busyThreads + " run=" + runThreads);
            }
            return;
        }
    }

    static synchronized int getAcceptPriority() {
        int n = busyThreads <= minThreads ? 0 : (busyThreads < maxThreads - 1 ? 1 : 2);
        return n;
    }

    static boolean isAlive() {
        if (workers == null) {
            return false;
        }
        for (int i = 0; i < maxThreads; ++i) {
            if (workers[i] == null || !workers[i].isAlive()) continue;
            return true;
        }
        return false;
    }

    static void interrupt() {
        if (workers == null) {
            return;
        }
        for (int i = 0; i < maxThreads; ++i) {
            if (workers[i] == null || !workers[i].isAlive()) continue;
            workers[i].interrupt();
        }
    }

    static {
        busyThreads = 0;
        runThreads = 0;
        ready = false;
    }
}

