/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ObjectExaminer {
    private static PrintStream out_ = null;
    private static int INC_INDENT = 3;
    private static final int OBJSHELL_SIZE = 8;
    private static final int OBJREF_SIZE = 4;
    public static final int LONG_FIELD_SIZE = 8;
    public static final int INT_FIELD_SIZE = 4;
    public static final int SHORT_FIELD_SIZE = 2;
    public static final int CHAR_FIELD_SIZE = 2;
    public static final int BYTE_FIELD_SIZE = 1;
    public static final int BOOLEAN_FIELD_SIZE = 1;
    public static final int DOUBLE_FIELD_SIZE = 8;
    public static final int FLOAT_FIELD_SIZE = 4;
    private long size_;
    private IdentityHashMap objRefMap_;

    public ObjectExaminer() {
        this.resetShareObjectRefs();
    }

    public Map getShareObjectRefs() {
        return this.objRefMap_;
    }

    public void resetShareObjectRefs() {
        this.objRefMap_ = new IdentityHashMap();
    }

    public long getSize(Object object, boolean bl, boolean bl2) throws IllegalAccessException {
        return this.getSize(object, bl, bl2, null);
    }

    long getSize(Object object, boolean bl, boolean bl2, String string) throws IllegalAccessException {
        long l = 0L;
        if (object == null) {
            return 0L;
        }
        WeakHashMap weakHashMap = new WeakHashMap();
        l = ObjectExaminer.calculateSize(object, this.objRefMap_, weakHashMap, bl, bl2, string);
        return l;
    }

    public static long getEntireObjectSize(Object object, boolean bl) {
        return ObjectExaminer.getEntireObjectSize(object, bl, null);
    }

    static long getEntireObjectSize(Object object, boolean bl, String string) {
        long l;
        block3: {
            l = 0L;
            if (object == null) {
                return l;
            }
            try {
                ObjectExaminer objectExaminer = new ObjectExaminer();
                l = objectExaminer.getSize(object, bl, false, string);
            }
            catch (Exception exception) {
                if (out_ == null) break block3;
                exception.printStackTrace(out_);
            }
        }
        return l;
    }

    public static Map getRefMap(Object object, boolean bl, boolean bl2) {
        Map map;
        block3: {
            map = null;
            if (object == null) {
                return null;
            }
            try {
                ObjectExaminer objectExaminer = new ObjectExaminer();
                objectExaminer.getSize(object, bl, bl2);
                map = objectExaminer.getShareObjectRefs();
            }
            catch (Exception exception) {
                if (out_ == null) break block3;
                exception.printStackTrace(out_);
            }
        }
        return map;
    }

    public static boolean isOverlapped(IdentityHashMap identityHashMap, IdentityHashMap identityHashMap2) {
        boolean bl = false;
        if (identityHashMap == null || identityHashMap2 == null || identityHashMap.size() == 0 || identityHashMap2.size() == 0) {
            return false;
        }
        Iterator iterator = identityHashMap2.keySet().iterator();
        Set set = identityHashMap.keySet();
        while (iterator.hasNext()) {
            if (!set.contains(iterator.next())) continue;
            return true;
        }
        return bl;
    }

    public static void setVerboseOutput(PrintStream printStream) {
        out_ = printStream;
    }

    public static void main(String[] stringArray) {
        System.out.println("Usage: java ObjectExaminer");
        try {
            long l = System.currentTimeMillis();
            long l2 = ObjectExaminer.getEntireObjectSize(System.getProperties(), true);
            long l3 = System.currentTimeMillis();
            System.out.println("Size: " + l2 + " bytes. Elasped: " + (l3 - l) + " msec.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String indent(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    private static int calculateSize(Object object, IdentityHashMap identityHashMap, Map map, boolean bl, boolean bl2, String string) {
        if (object == null) {
            return 0;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        identityHashMap.put(object, object);
        linkedList.add(object);
        int n = 0;
        ClassAccessPrivilegedAction classAccessPrivilegedAction = new ClassAccessPrivilegedAction();
        FieldAccessPrivilegedAction fieldAccessPrivilegedAction = new FieldAccessPrivilegedAction();
        while (!linkedList.isEmpty()) {
            int n2;
            Field[] fieldArray;
            object = linkedList.removeFirst();
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n3 = Array.getLength(object);
                fieldArray = clazz.getComponentType();
                if (string != null && string.equals(fieldArray.getName())) continue;
                n += ObjectExaminer.getArrayOverhead(n3, fieldArray);
                if (fieldArray.isPrimitive()) continue;
                for (n2 = 0; n2 < n3; ++n2) {
                    Object object2 = Array.get(object, n2);
                    if (object2 == null || identityHashMap.containsKey(object2)) continue;
                    identityHashMap.put(object2, object2);
                    linkedList.addFirst(object2);
                }
                continue;
            }
            if (string != null && string.equals(clazz.getName())) continue;
            Metadata metadata = ObjectExaminer.getMetadata(clazz, classAccessPrivilegedAction, fieldAccessPrivilegedAction, map, bl, bl2);
            fieldArray = metadata.fields_;
            n += metadata.overhead_;
            int n4 = fieldArray.length;
            for (n2 = 0; n2 < n4; ++n2) {
                Object object3;
                Field field = fieldArray[n2];
                try {
                    object3 = field.get(object);
                }
                catch (Exception exception) {
                    throw new RuntimeException("cannot get field[" + field.getName() + "] of class[" + field.getDeclaringClass().getName() + "]: " + exception.toString());
                }
                boolean bl3 = false;
                if ((8 & field.getModifiers()) != 0) {
                    bl3 = true;
                }
                if (bl3 || object3 == null || identityHashMap.containsKey(object3)) continue;
                try {
                    identityHashMap.put(object3, object3);
                    linkedList.addFirst(object3);
                    continue;
                }
                catch (ArrayStoreException arrayStoreException) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    private static int getArrayOverhead(int n, Class clazz) {
        int n2 = 0;
        int n3 = 0;
        n3 = clazz.isPrimitive() ? ObjectExaminer.getPrimitiveSize(clazz) : 4;
        n2 = n * n3 + 8 + 4 + 4;
        return n2;
    }

    private static int getPrimitiveSize(Class clazz) {
        int n = 0;
        if (clazz == Byte.TYPE) {
            n = 1;
        } else if (clazz == Boolean.TYPE) {
            n = 1;
        } else if (clazz == Integer.TYPE) {
            n = 4;
        } else if (clazz == Long.TYPE) {
            n = 8;
        } else if (clazz == Short.TYPE) {
            n = 2;
        } else if (clazz == Character.TYPE) {
            n = 2;
        } else if (clazz == Float.TYPE) {
            n = 4;
        } else if (clazz == Double.TYPE) {
            n = 8;
        } else {
            throw new IllegalArgumentException("Unknown primitive type: " + clazz);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Metadata getMetadata(Class clazz, ClassAccessPrivilegedAction classAccessPrivilegedAction, FieldAccessPrivilegedAction fieldAccessPrivilegedAction, Map map, boolean bl, boolean bl2) {
        Class<?> clazz2;
        Field[] fieldArray;
        Field[] fieldArray2;
        if (clazz == null) {
            return null;
        }
        Metadata metadata = null;
        Map map2 = map;
        synchronized (map2) {
            metadata = (Metadata)map.get(clazz);
        }
        if (metadata != null) {
            return metadata;
        }
        int n = 0;
        int n2 = 8;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            classAccessPrivilegedAction.setContext(clazz);
            fieldArray2 = (Field[])AccessController.doPrivileged(classAccessPrivilegedAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException("Field Access Error:" + clazz.getName() + ": " + privilegedActionException.getException());
        }
        for (int i = 0; i < fieldArray2.length; ++i) {
            fieldArray = fieldArray2[i];
            if ((8 & fieldArray.getModifiers()) != 0 && bl || (0x80 & fieldArray.getModifiers()) != 0 && bl2) continue;
            clazz2 = fieldArray.getType();
            if (clazz2.isPrimitive()) {
                ++n;
                n2 += ObjectExaminer.getPrimitiveSize(clazz2);
                continue;
            }
            if (!fieldArray.isAccessible()) {
                try {
                    fieldAccessPrivilegedAction.setContext((Field)fieldArray);
                    AccessController.doPrivileged(fieldAccessPrivilegedAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new RuntimeException("Field Access Error: " + fieldArray + ": " + privilegedActionException.getException());
                }
            }
            n2 += 4;
            linkedList.add(fieldArray);
        }
        Metadata metadata2 = ObjectExaminer.getMetadata(clazz.getSuperclass(), classAccessPrivilegedAction, fieldAccessPrivilegedAction, map, bl, bl2);
        if (metadata2 != null) {
            n += metadata2.nPrimitive_;
            n2 += metadata2.overhead_ - 8;
            linkedList.addAll(Arrays.asList(metadata2.fields_));
        }
        fieldArray = new Field[linkedList.size()];
        linkedList.toArray(fieldArray);
        metadata = new Metadata(fieldArray, n, n2);
        clazz2 = map;
        synchronized (clazz2) {
            map.put(clazz, metadata);
        }
        return metadata;
    }

    private static final class FieldAccessPrivilegedAction
    implements PrivilegedExceptionAction {
        private Field field_;

        private FieldAccessPrivilegedAction() {
        }

        public Object run() throws Exception {
            this.field_.setAccessible(true);
            return null;
        }

        void setContext(Field field) {
            this.field_ = field;
        }
    }

    private static final class ClassAccessPrivilegedAction
    implements PrivilegedExceptionAction {
        private Class jclass_;

        private ClassAccessPrivilegedAction() {
        }

        public Object run() throws Exception {
            return this.jclass_.getDeclaredFields();
        }

        void setContext(Class clazz) {
            this.jclass_ = clazz;
        }
    }

    private static final class Metadata {
        final Field[] fields_;
        final int nPrimitive_;
        final int overhead_;

        Metadata(Field[] fieldArray, int n, int n2) {
            this.fields_ = fieldArray;
            this.nPrimitive_ = n;
            this.overhead_ = n2;
        }
    }
}

