/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.CacheAccess;
import oracle.ias.cache.CacheAddress;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheHostInfo;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheNotAvailableException;
import oracle.ias.cache.DiskManager;
import oracle.ias.cache.NCListEnum;
import oracle.ias.cache.NamedCacheAttributes;
import oracle.ias.cache.Net;

public class NamedCache {
    static final String LOGGER_NAME = "oracle.ias.cache.NamedCache";
    private CacheCtx m_ctx;
    private String m_name;
    private NamedCacheAttributes m_attr;

    public NamedCache(CacheCtx cacheCtx, NamedCacheAttributes namedCacheAttributes) {
        this.m_ctx = cacheCtx;
        this.m_name = cacheCtx.getName();
        this.m_attr = (NamedCacheAttributes)namedCacheAttributes.clone();
    }

    public String getName() {
        return this.m_name;
    }

    public void close() {
        if (CacheInternal.getNamedCache(this.m_name) == null) {
            return;
        }
        try {
            this.destroy(true);
        }
        catch (Exception exception) {
            CacheInternal.logger.log(Level.SEVERE, " ", exception);
        }
    }

    public CacheAccess getAccess() throws CacheException {
        return CacheAccess.getAccess(this.m_name);
    }

    public NamedCacheAttributes getAttributes() throws CacheNotAvailableException {
        return this.m_attr;
    }

    public int getObjectCount() throws CacheNotAvailableException {
        int n = -1;
        CacheHandle cacheHandle = null;
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NCNA + " m_name");
        }
        cacheHandle = this.m_ctx.getHandle();
        n = cacheHandle.getRegionCount(this.m_name);
        try {
            this.m_ctx.releaseHandle(cacheHandle);
        }
        catch (CacheException cacheException) {
            Logger logger = Logger.getLogger("oracle.ias.cache.NamedCache." + this.getName());
            logger.log(Level.SEVERE, "NamedCache.getObjectCount", cacheException);
        }
        return n;
    }

    public int getDiskObjectCount() throws CacheNotAvailableException {
        int n = -1;
        CacheHandle cacheHandle = null;
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NCNA + " m_name");
        }
        cacheHandle = this.m_ctx.getHandle();
        n = cacheHandle.getRegionDiskCount(this.m_name);
        try {
            this.m_ctx.releaseHandle(cacheHandle);
        }
        catch (CacheException cacheException) {
            Logger logger = Logger.getLogger("oracle.ias.cache.NamedCache." + this.getName());
            logger.log(Level.SEVERE, "NamedCache.getObjectCount", cacheException);
        }
        return n;
    }

    public long getCacheSize() throws CacheNotAvailableException {
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NCNA + " m_name");
        }
        return this.m_ctx.getTotalSize();
    }

    public long getLocalDiskCacheSize() throws CacheNotAvailableException {
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NCNA + " m_name");
        }
        DiskManager diskManager = this.m_ctx.getDiskManager();
        if (diskManager != null) {
            return diskManager.getLocalDiskCacheSize();
        }
        return 0L;
    }

    public long getDistributedDiskCacheSize() throws CacheNotAvailableException {
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NCNA + " m_name");
        }
        DiskManager diskManager = this.m_ctx.getDiskManager();
        if (diskManager != null) {
            return diskManager.getDistributedDiskCacheSize();
        }
        return 0L;
    }

    public void resetAttributes(NamedCacheAttributes namedCacheAttributes) throws CacheNotAvailableException, CacheException, IOException {
        boolean bl = false;
        Attributes attributes = new Attributes();
        boolean bl2 = false;
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NCNA + " m_name");
        }
        if (namedCacheAttributes.logSeveritySet) {
            this.m_attr.logSeverity = namedCacheAttributes.logSeverity;
        }
        if (namedCacheAttributes.diskSizeSet) {
            attributes.setMaxDiskSize(namedCacheAttributes.diskSize * 1024 * 1024);
            bl = true;
        }
        if (namedCacheAttributes.diskCountSet) {
            attributes.setMaxDiskCount(namedCacheAttributes.diskCount);
            bl = true;
        }
        if (namedCacheAttributes.maxObjectsSet) {
            attributes.setMaxCount(namedCacheAttributes.maxObjects);
            bl = true;
        }
        if (namedCacheAttributes.maxSizeSet) {
            attributes.setMaxSize(namedCacheAttributes.maxSize);
            bl = true;
        }
        if (bl) {
            CacheHandle cacheHandle = this.m_ctx.getHandle();
            cacheHandle.resetAttributes(this.m_name, this.m_name, attributes);
            this.m_ctx.releaseHandle(cacheHandle);
        }
    }

    public void invalidate() throws CacheException {
        this.invalidate(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invalidate(boolean bl) throws CacheException {
        CacheHandle cacheHandle = null;
        try {
            try {
                if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
                    throw new CacheNotAvailableException(CacheInternal.EXP_NCNA + " m_name");
                }
                cacheHandle = this.m_ctx.getHandle();
                cacheHandle.invalidate(this.m_name, this.m_name, bl);
            }
            catch (Exception exception) {
                throw this.exceptionHandler("NamedCache.invalidate", exception);
            }
            Object var5_3 = null;
            if (cacheHandle == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (cacheHandle == null) throw throwable;
            this.m_ctx.releaseHandle(cacheHandle);
            throw throwable;
        }
        this.m_ctx.releaseHandle(cacheHandle);
    }

    public void destroy() throws CacheException {
        this.destroy(false);
    }

    public void destroy(boolean bl) throws CacheException {
        CacheHandle cacheHandle = null;
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NCNA + " m_name");
        }
        try {
            cacheHandle = this.m_ctx.getHandle();
            cacheHandle.destroy(this.m_name, this.m_name, bl);
            this.m_ctx = null;
            this.m_name = null;
        }
        catch (Exception exception) {
            throw this.exceptionHandler(CacheInternal.EXP_NAMEDCACHEDEST + " m_name", exception);
        }
    }

    public void dump() {
        Object var1_1 = null;
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            return;
        }
        CacheInternal.dump(this.m_ctx);
    }

    public boolean isDistributed() {
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            return false;
        }
        return this.m_ctx.isDistributed();
    }

    public Enumeration listCacheObjects() {
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            return null;
        }
        return new NCListEnum(this.m_ctx, this.m_name);
    }

    public Enumeration listCacheObjects(String string) {
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            return null;
        }
        String string2 = this.m_name + "/" + string;
        return CacheInternal.listCacheObjects(string2);
    }

    public void setLogSeverity(int n) {
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            return;
        }
    }

    public int getCacheId() {
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            return -1;
        }
        return this.m_ctx.getCacheId();
    }

    public String getCacheAddress() throws CacheException {
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            return null;
        }
        Net net = this.m_ctx.getNet();
        if (net == null) {
            return null;
        }
        return net.getLocalAddress();
    }

    public CacheAddress getCacheAddressObject() throws CacheException {
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            return null;
        }
        return CacheInternal.getLocalAddressObject(this.m_ctx);
    }

    public CacheHostInfo[] getActiveHostInfo() throws CacheException {
        if (CacheInternal.getNamedCache(this.m_name) == null || this.m_ctx == null) {
            return new CacheHostInfo[0];
        }
        return CacheInternal.getActiveHostInfo(this.m_ctx);
    }

    private CacheException exceptionHandler(String string, Exception exception) {
        return CacheInternal.exceptionHandler(this.m_ctx, CacheInternal.EXP_EXCEPTIONIN + " " + string, exception);
    }
}

