/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

class DiskFileLock {
    private boolean m_local;
    static final String LOCK_NAME = "_lck_";
    File m_file;
    FileChannel m_channel;
    FileLock m_lock;

    DiskFileLock(boolean bl) {
        this.m_local = bl;
    }

    DiskFileLock() {
        this.m_local = false;
    }

    DiskFileLock(String string, boolean bl) {
        this.m_file = new File(string, LOCK_NAME);
        this.m_local = bl;
    }

    void getLock(RandomAccessFile randomAccessFile) throws IOException {
        if (this.m_local) {
            return;
        }
        this.m_channel = randomAccessFile.getChannel();
        this.m_lock = this.m_channel.lock();
    }

    void getLock() throws IOException {
        if (this.m_local) {
            return;
        }
        this.m_channel = new RandomAccessFile(this.m_file, "rw").getChannel();
        this.m_lock = this.m_channel.lock();
    }

    void releaseLock() {
        if (this.m_local) {
            return;
        }
        try {
            if (this.m_lock != null) {
                this.m_lock.release();
            }
            if (this.m_channel != null) {
                this.m_channel.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[0]);
        DiskFileLock diskFileLock = new DiskFileLock(false);
        RandomAccessFile randomAccessFile = new RandomAccessFile("ylocktest", "rw");
        System.err.println("try to get lock " + n);
        diskFileLock.getLock(randomAccessFile);
        int n2 = 0;
        try {
            n2 = randomAccessFile.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.currentThread();
        Thread.sleep(500L);
        randomAccessFile.seek(0L);
        randomAccessFile.writeInt(++n2);
        System.err.println("write seq=" + n2 + " @ " + n);
        diskFileLock.releaseLock();
        randomAccessFile.close();
    }
}

