/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.AggregateStatus;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.BitMap;
import oracle.ias.cache.Bucket;
import oracle.ias.cache.CacheAccess;
import oracle.ias.cache.CacheAddress;
import oracle.ias.cache.CacheAttributes;
import oracle.ias.cache.CacheCleaner;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.CacheDms;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheHostInfo;
import oracle.ias.cache.CacheLogManager;
import oracle.ias.cache.CacheNotAvailableException;
import oracle.ias.cache.CacheObjectInfo;
import oracle.ias.cache.CapacityPolicy;
import oracle.ias.cache.Configurator;
import oracle.ias.cache.DefaultPolicy;
import oracle.ias.cache.DiskCacheException;
import oracle.ias.cache.DiskManager;
import oracle.ias.cache.ListEnumeration;
import oracle.ias.cache.Mdslot;
import oracle.ias.cache.Message;
import oracle.ias.cache.NamedCache;
import oracle.ias.cache.NamedCacheAttributes;
import oracle.ias.cache.NamedCacheException;
import oracle.ias.cache.Net;
import oracle.ias.cache.NetworkException;
import oracle.ias.cache.NullObj;
import oracle.ias.cache.NullObjectException;
import oracle.ias.cache.NullObjectNameException;
import oracle.ias.cache.ObjectExistsException;
import oracle.ias.cache.ObjectNotFoundException;
import oracle.ias.cache.RegionTable;
import oracle.ias.cache.ResponseQ;
import oracle.ias.cache.Task;
import oracle.ias.cache.TaskQ;
import oracle.ias.cache.ThreadPool;
import oracle.ias.cache.TimeQ;
import oracle.ias.cache.commx.Channel;
import oracle.ias.cache.commx.GroupConfig;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.GroupView;
import oracle.ias.cache.commx.NetworkAddress;

public class CacheInternal {
    static final String DESTROYED = "000DESTROYED$$";
    static final String DEFAULTCONTEXT = "000DEFAULT_CONTEXT$$";
    static final NullObj NULL_OBJECT = new NullObj();
    static final int V900 = 90000;
    static final int V904 = 90400;
    static final int BASEVERSION = 100000;
    static final int V1013 = 101300;
    public static final int[] VERSIONS = new int[]{90000, 90400, 100000, 101300};
    static final long OBJECT_FREE = 1L;
    static final long OBJECT_LOADED = 2L;
    static final long OBJECT_LOADING = 4L;
    static final long OBJECT_NEEDLOAD = 8L;
    static final long OBJECT_VALID = 16L;
    static final long OBJECT_UPDATEALL = 32L;
    static final long OBJECT_INMEMORY = 64L;
    static final long OBJECT_GROUP = 128L;
    static final long OBJECT_ONDISK = 256L;
    static final long OBJECT_DISTRIBUTE = 512L;
    static final long OBJECT_NEEDVERIFY = 1024L;
    static final long OBJECT_REPLY = 2048L;
    static final long OBJECT_DISKONLY = 4096L;
    static final long OBJECT_DISKABLE = 8192L;
    static final long OBJECT_MEMORY = 16384L;
    static final long OBJECT_REPLACE = 32768L;
    static final long OBJECT_ORIGINAL = 65536L;
    static final long OBJECT_SYNCUP = 131072L;
    static final long OBJECT_FINDONLY = 262144L;
    static final long OBJECT_ATTRSET = 524288L;
    static final long OBJECT_SYNCDEF = 0x100000L;
    static final long OBJECT_NOWAIT = 0x200000L;
    static final long OBJECT_TTLDESTROY = 0x400000L;
    static final long OBJECT_WRITEONLY = 0x800000L;
    static final long OBJECT_LOADER = 0x1000000L;
    static final long OBJECT_STREAM = 0x2000000L;
    static final long OBJECT_REMOTELOAD = 0x4000000L;
    static final long OBJECT_NOTDEFINED = 0x8000000L;
    static final long OBJECT_REGION = 0x10000000L;
    static final long OBJECT_DISABLED = 0x20000000L;
    static final long OBJECT_ALLOWNULL = 0x40000000L;
    static final long OBJECT_MEASURESIZE = 0x80000000L;
    static final long OBJECT_LISTLOAD = 0x100000000L;
    static final long EVENT_INV_TIMEOUT = 0x200000000L;
    static final long OBJECT_NO_LOCK = 0x400000000L;
    static final long OBJECT_LOADERSET = 0x800000000L;
    static final long OBJECT_ISFILE = 0x1000000000L;
    static final long OBJECT_SPOOLING = 0x2000000000L;
    static final long OBJECT_TIMEINV_LOCALONLY = 0x4000000000L;
    static final long LOAD_MASK = 14L;
    static final long OBJECT_TYPES = 20608L;
    static final long OBJECT_ATTRIBUTES = 278104582656L;
    static String EXP_LOAD;
    static String EXP_VERIFY;
    static String EXP_INTERNAL;
    static String EXP_DISKCACHE;
    static String EXP_DISKLOCK;
    static String EXP_DISKMDFILE;
    static String EXP_BADID;
    static String EXP_BADHANDLE;
    static String EXP_INVALID;
    static String EXP_NEGATIVE;
    static String EXP_NEGREFCNT;
    static String EXP_GRPLOOP;
    static String EXP_NOLOAD;
    static String EXP_CONWAIT;
    static String EXP_NOTIMPEVENT;
    static String EXP_BADADDR;
    static String EXP_INVALID_SSLCONF;
    static String EXP_FULL;
    static String EXP_RFULL;
    static String EXP_NA;
    static String EXP_NCNA;
    static String EXP_DISKNA;
    static String EXP_PRIV;
    static String EXP_GUSE;
    static String EXP_INVALARG;
    static String EXP_INVALGRP;
    static String EXP_INVALHDL;
    static String EXP_INVALOBJ;
    static String EXP_LDCONFL;
    static String EXP_NETOFF;
    static String EXP_NOTPOOL;
    static String EXP_POOLEMPTY;
    static String EXP_NORETROBJ;
    static String EXP_NOIMPL;
    static String EXP_NULLOBJ;
    static String EXP_NULLOBJNAM;
    static String EXP_OBJEXISTS;
    static String EXP_OBJNFOUND;
    static String EXP_OBJNOSYNC;
    static String EXP_NOREGION;
    static String EXP_NOGROUP;
    static String EXP_RESPFAIL;
    static String EXP_CANTCREATE;
    static String EXP_BASEEXCEPT;
    static String EXP_EXCEPTIONIN;
    static String EXP_ATTRSET;
    static String EXP_INVALUPDATE;
    static String EXP_NOTOWNER;
    static String EXP_SYNCDESTROYED;
    static String EXP_REDEFINELOCAL;
    static String EXP_REMCACHENFOUND;
    static String EXP_NAMEDCACHEDEST;
    static String EXP_BADNAME;
    static final int CACHE_READY = 1;
    static final int CACHE_ONNET = 2;
    static final int CACHE_FLUSH = 4;
    static final int CACHE_NOAUTOINIT = 8;
    static final int CACHE_NAMEDINIT = 16;
    static final int HASHSIZE = 523;
    static final int TP_MIN = 3;
    static final int TP_MAX = 10;
    static final int TJ_TIMEOUT = 2000;
    static final int STREAMBUFDEFAULT = 10240;
    static final float WATERMARGIN = 0.03f;
    public static final String GROUP = "[Grp] ";
    static final String NET = "[Net] ";
    static final String DISK = "[Dsk] ";
    static final String MEM = "[Mem] ";
    static final String LOADER = "[Ldr] ";
    static final String CACHEMGR = "[CMg] ";
    static final String DISKMGR = "[DMg] ";
    static final String CACHEACC = "[Acc] ";
    static final String LOGGER_NAME = "oracle.ias.cache.CacheInternal";
    static final String LIFECYCLE_LOGGER_NAME = "oracle.ias.cache.Lifecycle";
    static int nextbuck;
    static long interval;
    static int intvllen;
    static Bucket[] hashtab;
    static int loadId;
    static String workingDir;
    static TaskQ asyncTaskQ;
    static TimeQ ttlQ;
    static ResponseQ respQ;
    static boolean distributed;
    static boolean session;
    static Thread cleanerThr;
    static Thread diskThr;
    static int objectMax;
    static long cacheMaxSize;
    static int curObjCnt;
    static long curCacheSize;
    static int regionNumber;
    static int severity;
    static Vector addrList;
    static int streamBufSize;
    static CacheAttributes cAttr;
    public static Logger logger;
    static DiskManager diskManager;
    static boolean haveInvalidation;
    static int haveDiskCache;
    static int detectInterval;
    static int pingInterval;
    static float capacityBuffer;
    static float highWater;
    static float lowWater;
    private static long seqId;
    static int cacheId;
    static int flags;
    static String cacheAddress;
    static byte[] bootlock;
    static CapacityPolicy capacityPolicy;
    static AggregateStatus aggStatus;
    static AggregateStatus aggDiskStatus;
    static boolean updatingStats;
    static String cacheHostName;
    static int transport;
    static int cacheInstance;
    public static final String RESOURCES = "oracle.ias.cache.messages.Translation";
    static CacheCtx defaultCtx;
    static RegionTable ctxTable;
    static HashMap namedCacheList;
    static BitMap namedCacheMap;

    public static void init(CacheAttributes cacheAttributes) throws CacheException, IOException, InterruptedException, NetworkException {
        CacheInternal.init(cacheAttributes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(CacheAttributes cacheAttributes, boolean bl) throws CacheException, IOException, InterruptedException, NetworkException {
        byte[] byArray = bootlock;
        synchronized (bootlock) {
            boolean bl2 = false;
            int n = -1;
            Net net = null;
            GroupView groupView = null;
            if ((flags & 0x11) == 1) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if ((flags & 1) != 0 && bl) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if ((flags & 1) != 0 && !bl) {
                if (cacheAttributes == null) {
                    flags &= 0xFFFFFFEF;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                bl2 = true;
            }
            cAttr = cacheAttributes == null ? new CacheAttributes() : (CacheAttributes)cacheAttributes.clone();
            CacheInternal.initExceptionLocale();
            distributed = CacheInternal.cAttr.distribute;
            objectMax = CacheInternal.cAttr.maxObjects;
            cacheMaxSize = CacheInternal.cAttr.maxSize * 1024 * 1024;
            capacityBuffer = (float)((double)CacheInternal.cAttr.capacityBuffer * 0.01);
            intvllen = CacheInternal.cAttr.cleanInterval * 1000;
            pingInterval = CacheInternal.cAttr.pingInterval * 1000;
            detectInterval = pingInterval * 10;
            cacheHostName = CacheInternal.cAttr.cacheName;
            addrList = cAttr.getAddrList();
            if (!CacheInternal.cAttr.autoInit) {
                flags |= 8;
            }
            if (capacityBuffer < 0.03f) {
                highWater = 1.0f;
                lowWater = 1.0f - 2.0f * capacityBuffer;
            } else {
                highWater = 1.0f - capacityBuffer + 0.03f;
                lowWater = 1.0f - capacityBuffer - 0.03f;
            }
            try {
                CacheCtx cacheCtx;
                int n2;
                if (!bl2) {
                    logger = Logger.getLogger("oracle.ias.cache");
                    if (cAttr.isOverrideLogconfiguration()) {
                        try {
                            CacheLogManager cacheLogManager = new CacheLogManager();
                            cacheLogManager.init(logger, cAttr);
                        }
                        catch (Throwable throwable) {
                            FileHandler fileHandler = null;
                            for (n2 = 0; n2 < 3; ++n2) {
                                try {
                                    fileHandler = new FileHandler(CacheInternal.cAttr.logFileName, true);
                                    logger.addHandler(fileHandler);
                                    logger.setLevel(cAttr.getLogLevel());
                                    break;
                                }
                                catch (IOException iOException) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    continue;
                                }
                            }
                        }
                    }
                    logger.setUseParentHandlers(false);
                    if (logger.isLoggable(Level.INFO)) {
                        logger.log(Level.INFO, "Initializing...");
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Using CacheAttributes:\n" + cAttr);
                    }
                }
                if (CacheInternal.cAttr.capacityPolicy == null) {
                    if (!bl2) {
                        capacityPolicy = new DefaultPolicy();
                    }
                } else {
                    Class<?> clazz = Class.forName(CacheInternal.cAttr.capacityPolicy);
                    capacityPolicy = (CapacityPolicy)clazz.newInstance();
                }
                if (!bl2) {
                    aggStatus = new AggregateStatus();
                    aggDiskStatus = new AggregateStatus();
                    curObjCnt = 0;
                    curCacheSize = 0L;
                    regionNumber = 0;
                    namedCacheMap = new BitMap();
                    namedCacheMap.initMap(1);
                    namedCacheMap.clearBit(0);
                    int n3 = 20;
                    ThreadPool.interrupt();
                    for (int i = 0; i < n3 && ThreadPool.isAlive(); ++i) {
                        try {
                            Thread.sleep(3000L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ctxTable = new RegionTable();
                    namedCacheList = new HashMap();
                    hashtab = new Bucket[523];
                    for (n2 = 0; n2 < 523; ++n2) {
                        CacheInternal.hashtab[n2] = new Bucket(n2, distributed);
                    }
                    nextbuck = 0;
                    asyncTaskQ = TaskQ.getInstance();
                    ttlQ = new TimeQ();
                }
                streamBufSize = cacheMaxSize > 0L && objectMax > 0 ? 2 * (int)(cacheMaxSize / (long)objectMax) : 10240;
                flags |= 1;
                interval = System.currentTimeMillis();
                if (CacheInternal.cAttr.diskPath != null) {
                    n = 0;
                    diskManager = new DiskManager(cAttr, n, highWater, lowWater);
                    workingDir = diskManager.getWorkingDir();
                    ++haveDiskCache;
                } else {
                    diskManager = null;
                    workingDir = null;
                }
                defaultCtx = cacheCtx = new CacheCtx(DEFAULTCONTEXT, null, n, false, distributed, diskManager);
                ctxTable.setDefaultCtx(cacheCtx);
                cacheCtx.setCacheDumpPath(cAttr.getCacheDumpFilePath() + "-" + DEFAULTCONTEXT + ".dump");
                if (CacheInternal.cAttr.dms) {
                    CacheDms.createDmsCache(DEFAULTCONTEXT);
                    cacheCtx.setDms(true);
                }
                int n4 = 0;
                if (distributed) {
                    CacheInternal.initNet(cAttr, cacheCtx);
                    net = cacheCtx.getNet();
                    net.isDefault = true;
                    respQ = cacheCtx.getResponseQ();
                    cacheId = cacheCtx.getCacheId();
                    cacheAddress = net.getLocalAddress();
                    GroupView groupView2 = net.getView();
                    if (groupView2 != null) {
                        n4 = groupView2.size();
                        groupView = groupView2;
                    }
                }
                if (!bl2) {
                    ThreadPool.init(3, Math.max(10, n4), asyncTaskQ);
                }
                if (diskManager != null) {
                    diskManager.setCacheCtx(cacheCtx);
                    diskManager.setDiskLocks();
                    if (distributed && diskManager.setDiskLeader(null, net.getView())) {
                        diskManager.cleanLock();
                    }
                    CacheInternal.initFromDisk(diskManager.getGlobalPath(), diskManager.getLocalPath(), defaultCtx);
                    diskManager.writeOurTimeStamp(distributed);
                }
                if (!bl2) {
                    cleanerThr = new CacheCleaner();
                    cleanerThr.start();
                    CacheInternal.logLifecycleEvent(true, groupView);
                }
                CacheHandle cacheHandle = defaultCtx.getHandle();
                String string = CacheAccess.getDefRegionName();
                if (bl2) {
                    cacheHandle.destroy(string, string);
                }
                cacheHandle.locateGroup(string, string, null);
                cacheHandle.setRegionNumber();
                Mdslot mdslot = cacheHandle.getRegionSlot(string);
                mdslot.cacheCtx = defaultCtx;
                if (CacheInternal.cAttr.dms) {
                    CacheDms.createDmsRegion(string, mdslot, diskManager != null);
                }
                defaultCtx.releaseHandle(cacheHandle);
            }
            catch (Exception exception) {
                CacheInternal.close();
                throw CacheInternal.exceptionHandler(exception);
            }
            if (bl2) {
                flags &= 0xFFFFFFEF;
            } else if (bl) {
                flags |= 0x10;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static void declarativeConfig(String string) throws CacheException {
        if (string == null) {
            return;
        }
    }

    static void open(String string) throws CacheException {
        if ((flags & 1) != 0) {
            return;
        }
        try {
            CacheAttributes cacheAttributes = new CacheAttributes();
            Configurator configurator = null;
            try {
                configurator = new Configurator(string);
                cacheAttributes = configurator.getCacheAttributes();
            }
            catch (Exception exception) {
                try {
                    cacheAttributes.readConfig(string, false);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            CacheInternal.init(cacheAttributes);
            if (configurator != null) {
                configurator.defineDeclarable();
            }
        }
        catch (Exception exception) {
            throw CacheInternal.exceptionHandler(exception);
        }
    }

    public static ResourceBundle initExceptionLocale() {
        ResourceBundle resourceBundle = null;
        String string = System.getProperty("user.language");
        if (string == null) {
            string = "en";
        }
        Locale locale = new Locale(string, "");
        try {
            resourceBundle = ResourceBundle.getBundle(RESOURCES, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                resourceBundle = ResourceBundle.getBundle(RESOURCES, new Locale("en", ""));
            }
            catch (MissingResourceException missingResourceException2) {
                // empty catch block
            }
        }
        EXP_LOAD = resourceBundle.getString("EXPLOAD");
        EXP_VERIFY = resourceBundle.getString("EXPVERIFY");
        EXP_INTERNAL = resourceBundle.getString("EXPINTERNAL");
        EXP_DISKCACHE = resourceBundle.getString("EXPDISKCACHE");
        EXP_DISKLOCK = resourceBundle.getString("EXPDISKLOCK");
        EXP_DISKMDFILE = resourceBundle.getString("EXPDISKMDFILE");
        EXP_BADID = resourceBundle.getString("EXPBADID");
        EXP_BADHANDLE = resourceBundle.getString("EXPBADHANDLE");
        EXP_INVALID = resourceBundle.getString("EXPINVALID");
        EXP_NEGATIVE = resourceBundle.getString("EXPNEGATIVE");
        EXP_NEGREFCNT = resourceBundle.getString("EXPNEGREFCNT");
        EXP_GRPLOOP = resourceBundle.getString("EXPGRPLOOP");
        EXP_NOLOAD = resourceBundle.getString("EXPNOLOAD");
        EXP_CONWAIT = resourceBundle.getString("EXPCONWAIT");
        EXP_NOTIMPEVENT = resourceBundle.getString("EXPNOTIMPEVENT");
        EXP_INVALID_SSLCONF = resourceBundle.getString("EXP_INVALID_SSLCONF");
        EXP_FULL = resourceBundle.getString("EXPFULL");
        EXP_RFULL = resourceBundle.getString("EXPRFULL");
        EXP_NA = resourceBundle.getString("EXPNA");
        EXP_NCNA = resourceBundle.getString("EXPNCNA");
        EXP_DISKNA = resourceBundle.getString("EXPDISKNA");
        EXP_PRIV = resourceBundle.getString("EXPPRIV");
        EXP_GUSE = resourceBundle.getString("EXPGUSE");
        EXP_INVALARG = resourceBundle.getString("EXPINVALARG");
        EXP_INVALGRP = resourceBundle.getString("EXPINVALGRP");
        EXP_INVALHDL = resourceBundle.getString("EXPINVALHDL");
        EXP_INVALOBJ = resourceBundle.getString("EXPINVALOBJ");
        EXP_LDCONFL = resourceBundle.getString("EXPLDCONFL");
        EXP_NETOFF = resourceBundle.getString("EXPNETOFF");
        EXP_NOTPOOL = resourceBundle.getString("EXPNOTPOOL");
        EXP_POOLEMPTY = resourceBundle.getString("EXPPOOLEMPTY");
        EXP_NORETROBJ = resourceBundle.getString("EXPNORETROBJ");
        EXP_NOIMPL = resourceBundle.getString("EXPNOIMPL");
        EXP_NULLOBJ = resourceBundle.getString("EXPNULLOBJ");
        EXP_NULLOBJNAM = resourceBundle.getString("EXPNULLOBJNAM");
        EXP_OBJEXISTS = resourceBundle.getString("EXPOBJEXISTS");
        EXP_OBJNFOUND = resourceBundle.getString("EXPOBJNFOUND");
        EXP_OBJNOSYNC = resourceBundle.getString("EXPOBJNOSYNC");
        EXP_NOREGION = resourceBundle.getString("EXPNOREGION");
        EXP_NOGROUP = resourceBundle.getString("EXPNOGROUP");
        EXP_RESPFAIL = resourceBundle.getString("EXPRESPFAIL");
        EXP_CANTCREATE = resourceBundle.getString("EXPCANTCREATE");
        EXP_BASEEXCEPT = resourceBundle.getString("EXPBASEEXCEPT");
        EXP_EXCEPTIONIN = resourceBundle.getString("EXPEXCEPTIONIN");
        EXP_ATTRSET = resourceBundle.getString("EXPATTRSET");
        EXP_INVALUPDATE = resourceBundle.getString("EXPINVALUPDATE");
        EXP_NOTOWNER = resourceBundle.getString("EXPNOTOWNER");
        EXP_SYNCDESTROYED = resourceBundle.getString("EXPSYNCDESTROYED");
        EXP_REDEFINELOCAL = resourceBundle.getString("EXPREDEFINELOCAL");
        EXP_REMCACHENFOUND = resourceBundle.getString("EXPREMCACHENFOUND");
        EXP_NAMEDCACHEDEST = resourceBundle.getString("EXPNAMEDCACHEDEST");
        EXP_BADNAME = resourceBundle.getString("EXPBADNAME");
        return resourceBundle;
    }

    static CacheAttributes getAttributes() throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        return (CacheAttributes)cAttr.clone();
    }

    static int getObjectCount() throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        return curObjCnt;
    }

    static long getCacheSize() throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        return curCacheSize;
    }

    static long getLocalDiskCacheSize() throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        return CacheInternal.getLocalDiskCacheSize(DEFAULTCONTEXT);
    }

    static long getLocalDiskCacheSize(String string) throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        CacheCtx cacheCtx = CacheInternal.getCacheCtx(string);
        DiskManager diskManager = cacheCtx.getDiskManager();
        return diskManager.getLocalDiskCacheSize();
    }

    static String getDiskCacheRootPath() {
        if ((flags & 1) == 0) {
            return "";
        }
        CacheCtx cacheCtx = CacheInternal.getCacheCtx();
        DiskManager diskManager = cacheCtx.getDiskManager();
        if (diskManager == null) {
            return "";
        }
        return diskManager.getRootDiskPath();
    }

    static String getDiskCacheRootPath(String string) throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        CacheCtx cacheCtx = CacheInternal.getCacheCtx(string);
        DiskManager diskManager = cacheCtx.getDiskManager();
        if (diskManager == null) {
            return "";
        }
        return diskManager.getRootDiskPath();
    }

    static long getDistributedDiskCacheSize() throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        return CacheInternal.getDistributedDiskCacheSize(DEFAULTCONTEXT);
    }

    static long getDistributedDiskCacheSize(String string) throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        CacheCtx cacheCtx = CacheInternal.getCacheCtx(string);
        DiskManager diskManager = cacheCtx.getDiskManager();
        return diskManager.getDistributedDiskCacheSize();
    }

    static void resetAttributes(CacheAttributes cacheAttributes) throws CacheNotAvailableException {
        boolean bl = false;
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        if (cacheAttributes.capacityBufferSet) {
            CacheInternal.cAttr.capacityBuffer = cacheAttributes.capacityBuffer;
            capacityBuffer = (float)((double)cacheAttributes.capacityBuffer * 0.01);
            if (capacityBuffer < 0.03f) {
                highWater = 1.0f;
                lowWater = 1.0f - 2.0f * capacityBuffer;
            } else {
                highWater = 1.0f - capacityBuffer + 0.03f;
                lowWater = 1.0f - capacityBuffer - 0.03f;
            }
        }
        if (cacheAttributes.maxObjectsSet) {
            objectMax = cacheAttributes.maxObjects;
            CacheInternal.cAttr.maxObjects = cacheAttributes.maxObjects;
            if (curObjCnt > (int)((float)objectMax * highWater)) {
                bl = true;
            }
        }
        if (cacheAttributes.maxSizeSet) {
            cacheMaxSize = cacheAttributes.maxSize * 1024 * 1024;
            CacheInternal.cAttr.maxSize = cacheAttributes.maxSize;
            if (curCacheSize > (long)((int)((float)cacheMaxSize * highWater))) {
                bl = true;
            }
        }
        if (cacheAttributes.diskSizeSet || cacheAttributes.capacityBufferSet || cacheAttributes.diskCountSet) {
            if (cacheAttributes.diskSizeSet) {
                CacheInternal.cAttr.diskSize = cacheAttributes.diskSize;
            }
            if (cacheAttributes.diskCountSet) {
                CacheInternal.cAttr.diskCount = cacheAttributes.diskCount;
            }
            DiskManager diskManager = defaultCtx.getDiskManager();
            boolean bl2 = diskManager.resetAttributes(cacheAttributes);
            if (!bl) {
                bl = bl2;
            }
        }
        if (cacheAttributes.logSeveritySet) {
            CacheInternal.cAttr.logSeverity = cacheAttributes.logSeverity;
            logger.setLevel(cacheAttributes.getLogLevel());
        }
        if (cacheAttributes.cleanIntervalSet) {
            CacheInternal.cAttr.cleanInterval = cacheAttributes.cleanInterval;
            intvllen = cacheAttributes.cleanInterval * 1000;
            bl = true;
        }
        if (cacheAttributes.nameSet) {
            CacheInternal.cAttr.cacheName = cacheAttributes.cacheName;
            cacheHostName = cacheAttributes.cacheName;
        }
        if (cacheAttributes.autoInitSet) {
            CacheInternal.cAttr.autoInit = cacheAttributes.autoInit;
            flags = cacheAttributes.autoInit ? (flags &= 0xFFFFFFF7) : (flags |= 8);
        }
        if (bl) {
            ttlQ.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        GroupView groupView = null;
        byte[] byArray = bootlock;
        synchronized (bootlock) {
            try {
                Object object;
                if ((flags & 1) == 0) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                flags &= 0xFFFFFFFE;
                ++cacheInstance;
                CacheInternal.closeNamedCaches();
                ttlQ.rest();
                if (ttlQ != null) {
                    ttlQ.wakeup();
                }
                if (cleanerThr != null) {
                    cleanerThr.join(2000L);
                }
                if (asyncTaskQ != null) {
                    asyncTaskQ.rest();
                    asyncTaskQ.wakeupAll();
                }
                ThreadPool.term();
                CacheInternal.removeLocalCache();
                CacheInternal.cleanDiskCache();
                if (distributed && (object = defaultCtx.getNet()) != null) {
                    Channel channel = ((Net)object).chan;
                    if (channel != null) {
                        groupView = channel.getView();
                    }
                    ((Net)object).close();
                }
                if (workingDir != null) {
                    object = new File(workingDir);
                    CacheInternal.removeAll((File)object);
                }
                CacheInternal.logLifecycleEvent(false, groupView);
                ctxTable = null;
            }
            catch (Exception exception) {
                CacheInternal.exceptionLog(MEM, exception);
            }
            return;
        }
    }

    static Hashtable listCacheRegions() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = CacheInternal.listCacheObjects();
        while (enumeration.hasMoreElements()) {
            CacheObjectInfo cacheObjectInfo = (CacheObjectInfo)enumeration.nextElement();
            if (hashtable.containsKey(cacheObjectInfo.region)) continue;
            hashtable.put(cacheObjectInfo.region, cacheObjectInfo.region);
        }
        return hashtable;
    }

    public static void globalInvalidate(boolean bl) throws IOException, CacheException, InterruptedException {
        Object object;
        Serializable serializable;
        CacheHandle cacheHandle = defaultCtx.getHandle();
        if (bl && distributed) {
            serializable = new Message("invalidate", null, null, 0L, false);
            object = new Task(15, (Object)serializable, defaultCtx);
            Net net = defaultCtx.getNet();
            net.broadcast((Task)object, cacheHandle, 1);
        }
        serializable = CacheInternal.listCacheRegions();
        object = serializable.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            cacheHandle.invalidate(string, string, true);
        }
        defaultCtx.releaseHandle(cacheHandle);
        for (int i = 0; i < 523; ++i) {
            Bucket bucket = hashtab[i];
            bucket.clearBucket(false);
        }
        System.gc();
    }

    public static void globalDestroy(boolean bl) throws IOException, CacheException, InterruptedException {
        Object object;
        Serializable serializable;
        CacheHandle cacheHandle = defaultCtx.getHandle();
        if (bl && distributed) {
            serializable = new Message("destroy", null, null, 0L, false);
            object = new Task(15, (Object)serializable, defaultCtx);
            Net net = defaultCtx.getNet();
            net.broadcast((Task)object, cacheHandle, 1);
        }
        serializable = CacheInternal.listCacheRegions();
        object = serializable.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            cacheHandle.destroy(string, string, true);
        }
        defaultCtx.releaseHandle(cacheHandle);
        for (int i = 0; i < 523; ++i) {
            Bucket bucket = hashtab[i];
            bucket.clearBucket(true);
        }
        System.gc();
    }

    static boolean newInterval() {
        long l = System.currentTimeMillis();
        long l2 = l - interval;
        if (l2 < (long)intvllen) {
            return false;
        }
        interval = l;
        return true;
    }

    static synchronized int getNextBucket() {
        int n = nextbuck++;
        nextbuck %= 523;
        return n;
    }

    static synchronized int getRegionNumber() {
        return ++regionNumber;
    }

    static synchronized int getCacheCtxIndex() {
        int n = namedCacheMap.nextBit(0);
        if (n == -1) {
            namedCacheMap.growMap(namedCacheMap.getCapacity() + 1, 1);
            n = namedCacheMap.nextBit(0);
        }
        namedCacheMap.clearBit(n);
        return n;
    }

    static int getFlags() {
        return flags;
    }

    static int hashName(String string, Object object) throws NullObjectNameException {
        int n = 0;
        if (object == null || string == null) {
            throw new NullObjectNameException(EXP_NULLOBJNAM);
        }
        int n2 = object.hashCode();
        n = string.hashCode();
        return (n &= Integer.MAX_VALUE) + (n2 &= Integer.MAX_VALUE) & Integer.MAX_VALUE;
    }

    public static String getVersion() {
        if (cAttr == null) {
            try {
                CacheAttributes cacheAttributes = new CacheAttributes();
                return cacheAttributes.version;
            }
            catch (CacheException cacheException) {
                return cacheException.getLocalizedMessage();
            }
        }
        return CacheInternal.cAttr.version;
    }

    static int getInternalVersion() {
        if (cAttr == null) {
            try {
                CacheAttributes cacheAttributes = new CacheAttributes();
                return cacheAttributes.internalVersion;
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
        return CacheInternal.cAttr.internalVersion;
    }

    static long setFlags(Attributes attributes) {
        long l = 0L;
        if (attributes.flags != 0L) {
            if ((attributes.flags & 1L) != 0L) {
                l |= 0x200L;
            }
            if ((attributes.flags & 2L) != 0L) {
                l |= 0x800L;
            }
            if ((attributes.flags & 4L) != 0L) {
                l |= 0x20000L;
            } else if ((attributes.flags & 0x40L) != 0L) {
                l |= 0x100000L;
            }
            if ((attributes.flags & 8L) != 0L) {
                l |= 0x2000L;
            }
            if ((attributes.flags & 0x10L) != 0L) {
                l |= 0x400000L;
            }
            if ((attributes.flags & 0x20L) != 0L) {
                l |= 0x10000L;
            }
            if ((attributes.flags & 0x100L) != 0L) {
                l |= 0x20000000L;
            }
            if ((attributes.flags & 0x200L) != 0L) {
                l |= 0x40000000L;
            }
            if ((attributes.flags & 0x400L) != 0L) {
                l |= 0x80000000L;
            }
            if ((attributes.flags & 0x800L) != 0L) {
                l |= 0x4000000000L;
            }
        }
        return l;
    }

    static boolean incrCurCnt(Mdslot mdslot) {
        int n = 5;
        while (!CacheInternal.incrCnt(mdslot)) {
            if (--n < 0) {
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    private static synchronized boolean incrCnt(Mdslot mdslot) {
        if (mdslot.wasCounted) {
            return true;
        }
        if (mdslot.cacheCtx != null && mdslot.cacheCtx.isPrivate()) {
            mdslot.cacheCtx.updateSize(mdslot.objStatus.size, true);
            mdslot.wasCounted = true;
            return true;
        }
        if (curObjCnt > (int)((float)objectMax * highWater) || curCacheSize > (long)((int)((float)cacheMaxSize * highWater))) {
            ttlQ.wakeup();
        }
        if (curObjCnt >= objectMax || cacheMaxSize > 0L && curCacheSize >= cacheMaxSize) {
            return false;
        }
        ++curObjCnt;
        curCacheSize += mdslot.objStatus.size;
        if (mdslot.cacheCtx != null) {
            mdslot.cacheCtx.updateSize(mdslot.objStatus.size, true);
        }
        mdslot.wasCounted = true;
        return true;
    }

    static synchronized void decCurCnt(Mdslot mdslot) {
        if (mdslot.wasCounted) {
            if (mdslot.cacheCtx != null) {
                mdslot.cacheCtx.updateSize(mdslot.objStatus.size, false);
                if (mdslot.cacheCtx.isPrivate()) {
                    mdslot.wasCounted = false;
                    return;
                }
            }
            --curObjCnt;
            curCacheSize -= mdslot.objStatus.size;
            mdslot.wasCounted = false;
        }
    }

    static synchronized void setInvalidationList(DiskManager diskManager, boolean bl) {
        if (diskManager == null) {
            haveInvalidation = bl;
        } else if (!haveInvalidation) {
            haveInvalidation = diskManager.haveInvalidation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanCache(boolean bl) {
        Bucket bucket;
        int n;
        int n2 = (int)((double)((float)objectMax * highWater) + 0.5);
        int n3 = (int)((double)((float)cacheMaxSize * highWater) + 0.5);
        for (n = 0; n < 523; ++n) {
            bucket = hashtab[n];
            bucket.cleanTtl();
        }
        if (curObjCnt > n2 || curCacheSize > (long)n3) {
            CacheInternal.cleanMemoryCache();
        }
        CacheInternal.cleanDiskCache();
        if (bl) {
            n = -1;
            AggregateStatus aggregateStatus = aggStatus;
            synchronized (aggregateStatus) {
                if (!updatingStats) {
                    updatingStats = true;
                    n = CacheInternal.aggStatus.pass;
                    ++n;
                }
            }
            for (int i = 0; i < 523; ++i) {
                bucket = hashtab[i];
                if (n >= 0) {
                    bucket.aggStats(n);
                }
                bucket.resetmaps();
            }
            if (n >= 0) {
                aggStatus.getNewStats().clone(aggStatus);
                CacheInternal.aggStatus.pass = n;
                aggStatus.getNewStats().reset();
                aggDiskStatus.getNewStats().clone(aggDiskStatus);
                CacheInternal.aggDiskStatus.pass = n;
                aggDiskStatus.getNewStats().reset();
                AggregateStatus aggregateStatus2 = aggStatus;
                synchronized (aggregateStatus2) {
                    updatingStats = false;
                    aggStatus.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateStats() {
        int n;
        AggregateStatus aggregateStatus = aggStatus;
        synchronized (aggregateStatus) {
            if (updatingStats) {
                try {
                    while (updatingStats) {
                        aggStatus.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            updatingStats = true;
            n = CacheInternal.aggStatus.pass;
            ++n;
        }
        for (int i = 0; i < 523; ++i) {
            Bucket bucket = hashtab[i];
            bucket.aggStats(n);
        }
        CacheInternal.aggStatus.newStats.clone(aggStatus);
        CacheInternal.aggStatus.pass = n;
        CacheInternal.aggStatus.newStats.reset();
        CacheInternal.aggDiskStatus.newStats.clone(aggDiskStatus);
        CacheInternal.aggDiskStatus.pass = n;
        CacheInternal.aggDiskStatus.newStats.reset();
        AggregateStatus aggregateStatus2 = aggStatus;
        synchronized (aggregateStatus2) {
            updatingStats = false;
            aggStatus.notifyAll();
        }
    }

    static void cleanMemoryCache() {
        long l = aggStatus.getPriority(2);
        long l2 = aggStatus.getPriority(0);
        int n = (int)((double)((float)objectMax * lowWater) + 0.5);
        int n2 = (int)((double)((float)cacheMaxSize * lowWater) + 0.5);
        if (l < l2) {
            l = Long.MAX_VALUE;
            l2 = Long.MAX_VALUE;
        }
        long l3 = (long)((double)(l - l2) / 10.0);
        for (int i = 1; i <= 10 && (curObjCnt > n || cacheMaxSize > 0L && curCacheSize > (long)n2); ++i) {
            long l4 = l2 + l3 * (long)i;
            for (int j = 0; j < 523 && (curObjCnt > n || cacheMaxSize > 0L && curCacheSize > (long)n2); ++j) {
                int n3 = curObjCnt - n;
                long l5 = cacheMaxSize == 0L ? 0L : curCacheSize - (long)n2;
                int n4 = CacheInternal.getNextBucket();
                Bucket bucket = hashtab[n4];
                bucket.clean(l4, aggStatus, n3, l5);
            }
            if (l4 >= l) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanDiskCache() {
        CacheCtx[] cacheCtxArray = ctxTable.getCtxList();
        byte[] byArray = bootlock;
        synchronized (bootlock) {
            if ((flags & 1) != 0) {
                for (int i = 0; i < cacheCtxArray.length; ++i) {
                    DiskManager diskManager;
                    CacheCtx cacheCtx = cacheCtxArray[i];
                    if (cacheCtx == null || (diskManager = cacheCtx.getDiskManager()) == null) continue;
                    diskManager.cleanDiskCache();
                }
            }
            // ** MonitorExit[var3_1] (shouldn't be in output)
            return;
        }
    }

    static void cleanIdle() {
        for (int i = 0; i < 523; ++i) {
            Bucket bucket = hashtab[i];
            bucket.cleanIdle();
        }
    }

    static void writeOurTimeStamp(boolean bl) {
        CacheCtx[] cacheCtxArray = ctxTable.getCtxList();
        for (int i = 0; i < cacheCtxArray.length; ++i) {
            DiskManager diskManager;
            CacheCtx cacheCtx = cacheCtxArray[i];
            if (cacheCtx == null || (diskManager = cacheCtx.getDiskManager()) == null) continue;
            diskManager.writeOurTimeStamp(bl);
        }
    }

    static void deathDetect() {
        if (!CacheInternal.isReady()) {
            return;
        }
        CacheCtx[] cacheCtxArray = ctxTable.getCtxList();
        for (int i = 0; i < cacheCtxArray.length; ++i) {
            DiskManager diskManager;
            CacheCtx cacheCtx = cacheCtxArray[i];
            if (cacheCtx == null || (diskManager = cacheCtx.getDiskManager()) == null) continue;
            diskManager.deathDetect();
        }
    }

    static void addInvalidation(Mdslot mdslot, boolean bl) {
        CacheCtx cacheCtx = CacheInternal.getCacheCtx(mdslot.qualifier);
        DiskManager diskManager = cacheCtx.getDiskManager();
        diskManager.addInvalidation(mdslot, bl);
        CacheInternal.setInvalidationList(null, true);
    }

    static void freeDisk() {
        if (ctxTable == null) {
            return;
        }
        CacheCtx[] cacheCtxArray = ctxTable.getCtxList();
        CacheInternal.setInvalidationList(null, false);
        for (int i = 0; i < cacheCtxArray.length; ++i) {
            DiskManager diskManager;
            CacheCtx cacheCtx = cacheCtxArray[i];
            if (cacheCtx == null || (diskManager = cacheCtx.getDiskManager()) == null) continue;
            diskManager.freeDisk();
            CacheInternal.setInvalidationList(diskManager, true);
        }
    }

    static boolean setDiskLeader(GroupView groupView, GroupView groupView2) {
        boolean bl = false;
        CacheCtx[] cacheCtxArray = ctxTable.getCtxList();
        for (int i = 0; i < cacheCtxArray.length; ++i) {
            DiskManager diskManager;
            CacheCtx cacheCtx = cacheCtxArray[i];
            if (cacheCtx == null || (diskManager = cacheCtx.getDiskManager()) == null || !diskManager.setDiskLeader(groupView, groupView2)) continue;
            bl = true;
        }
        return bl;
    }

    private static void removeLocalCache() {
        CacheCtx[] cacheCtxArray = ctxTable.getCtxList();
        for (int i = 0; i < cacheCtxArray.length; ++i) {
            DiskManager diskManager;
            CacheCtx cacheCtx = cacheCtxArray[i];
            if (cacheCtx == null || (diskManager = cacheCtx.getDiskManager()) == null) continue;
            diskManager.removeLocalCache();
        }
    }

    private static void removeAll(File file) {
        String[] stringArray;
        if (file.isDirectory() && (stringArray = file.list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                CacheInternal.removeAll(new File(file, stringArray[i]));
            }
        }
        if (!file.delete() && logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "removeAll can't delete file " + file);
        }
    }

    static void updateLocalDisk(long l, boolean bl, CacheCtx cacheCtx) throws DiskCacheException {
        if (l == 0L) {
            return;
        }
        if (cacheCtx == null) {
            cacheCtx = defaultCtx;
        }
        DiskManager diskManager = cacheCtx.getDiskManager();
        diskManager.updateLocalDisk(l, bl);
    }

    static void updateGlobalDisk(long l, boolean bl, CacheCtx cacheCtx) throws DiskCacheException {
        if (l == 0L) {
            return;
        }
        if (cacheCtx == null) {
            cacheCtx = defaultCtx;
        }
        DiskManager diskManager = cacheCtx.getDiskManager();
        diskManager.updateGlobalDisk(l, 1L, bl);
    }

    public static void trace(String string) {
        logger.log(Level.SEVERE, string);
    }

    public static synchronized void dump(CacheCtx cacheCtx) {
        block5: {
            if (!CacheInternal.isReady()) {
                return;
            }
            try {
                String string = null;
                string = cacheCtx != null ? cacheCtx.getCacheDumpPath() : defaultCtx.getCacheDumpPath();
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.ALL, "Dumping Cache contents to " + string);
                }
                FileWriter fileWriter = new FileWriter(string, true);
                for (int i = 0; i < 523; ++i) {
                    Bucket bucket = hashtab[i];
                    if (bucket == null) continue;
                    bucket.dump(cacheCtx, fileWriter);
                    fileWriter.flush();
                }
                fileWriter.close();
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Level.SEVERE)) break block5;
                logger.log(Level.SEVERE, "Unable to dump cache contents.", exception);
            }
        }
    }

    public static boolean isReady() {
        return (flags & 1) != 0;
    }

    public static boolean autoInit() {
        return (flags & 8) == 0;
    }

    public static boolean isDistributed() {
        return distributed;
    }

    static boolean isDistributedObject(Mdslot mdslot) {
        return CacheInternal.isDistributedObject(mdslot, mdslot.qualifier);
    }

    static boolean isDistributedObject(Mdslot mdslot, String string) {
        if (mdslot == null || mdslot.cacheCtx == null) {
            CacheCtx cacheCtx = CacheInternal.getCacheCtx(string);
            return cacheCtx.isDistributed();
        }
        if ((mdslot.state & 0x1000000L) != 0L) {
            return mdslot.cacheCtx.isDistributed() && (((Attributes)mdslot.object).flags & 1L) != 0L;
        }
        return mdslot.cacheCtx.isDistributed() && (mdslot.state & 0x200L) != 0L;
    }

    public static Enumeration listCacheObjects() {
        return new ListEnumeration();
    }

    public static String dumpToString(String string) {
        Enumeration enumeration = null;
        StringBuffer stringBuffer = new StringBuffer().append(cacheId + "@" + cacheAddress + "\n");
        try {
            enumeration = CacheInternal.listCacheObjects(string);
            while (enumeration.hasMoreElements()) {
                CacheObjectInfo cacheObjectInfo = (CacheObjectInfo)enumeration.nextElement();
                stringBuffer.append(cacheObjectInfo.region).append("|").append(cacheObjectInfo.name).append("|");
                stringBuffer.append(cacheObjectInfo.group).append("|").append(cacheObjectInfo.type).append("|");
                stringBuffer.append(cacheObjectInfo.expire).append("|").append(cacheObjectInfo.valid).append("|");
                stringBuffer.append(cacheObjectInfo.ownerInfo).append("|");
                stringBuffer.append(cacheObjectInfo.refcount).append("|").append(cacheObjectInfo.accesses).append("\n");
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "listCacheObjects error", exception);
        }
        return stringBuffer.toString();
    }

    public static String getConfig() {
        StringBuffer stringBuffer = new StringBuffer().append("At " + cacheAddress + "\n");
        stringBuffer.append(cAttr.toString());
        return stringBuffer.toString();
    }

    public static Enumeration listCacheObjects(String string) {
        return new ListEnumeration(string);
    }

    static void exceptionLog(String string, Exception exception) {
        CacheInternal.exceptionLog(null, string, exception);
    }

    static void exceptionLog(CacheCtx cacheCtx, String string, Exception exception) {
        Logger logger = null;
        Exception exception2 = null;
        logger = cacheCtx != null ? cacheCtx.getLogger(LOGGER_NAME) : CacheInternal.logger;
        if (logger != null && logger.isLoggable(Level.SEVERE)) {
            if (exception instanceof CacheException) {
                if ((exception instanceof ObjectNotFoundException || exception instanceof ObjectExistsException || exception instanceof NullObjectException) && !logger.isLoggable(Level.FINEST)) {
                    return;
                }
                if (((CacheException)exception).logged()) {
                    return;
                }
                ((CacheException)exception).setLogged();
                exception2 = ((CacheException)exception).getBaseException();
            }
            if (exception2 == null) {
                logger.log(Level.SEVERE, "", exception);
            } else {
                logger.log(Level.SEVERE, "", exception2);
            }
        }
    }

    static CacheException exceptionHandler(Exception exception) {
        return CacheInternal.exceptionHandler((CacheCtx)null, exception);
    }

    static CacheException exceptionHandler(CacheCtx cacheCtx, Exception exception) {
        CacheInternal.exceptionLog(cacheCtx, MEM, exception);
        if (exception instanceof CacheException) {
            return (CacheException)exception;
        }
        CacheException cacheException = new CacheException(null, exception);
        cacheException.setLogged();
        return cacheException;
    }

    static CacheException exceptionHandler(String string, Exception exception) {
        return CacheInternal.exceptionHandler(null, string, exception);
    }

    static CacheException exceptionHandler(CacheCtx cacheCtx, String string, Exception exception) {
        CacheInternal.exceptionLog(cacheCtx, MEM, exception);
        if (exception instanceof CacheException) {
            ((CacheException)exception).setInfoMsg(string);
            return (CacheException)exception;
        }
        CacheException cacheException = new CacheException(string, exception);
        cacheException.setLogged();
        return cacheException;
    }

    public static synchronized long getSeqId() {
        return ++seqId;
    }

    static CacheAddress getLocalAddressObject(CacheCtx cacheCtx) throws CacheException {
        NetworkAddress networkAddress;
        Net net;
        CacheAddress cacheAddress = null;
        if (cacheCtx == null) {
            cacheCtx = defaultCtx;
        }
        if ((net = cacheCtx.getNet()) != null && (networkAddress = net.getLocalAddressObject()) != null) {
            cacheAddress = new CacheAddress(networkAddress);
        }
        return cacheAddress;
    }

    static void saveCacheCtx(String string, CacheCtx cacheCtx) {
        ctxTable.setCtx(string, cacheCtx);
    }

    static boolean checkCacheCtx(String string) {
        return ctxTable.getCtx(string) != null;
    }

    static CacheCtx getCacheCtx() {
        return defaultCtx;
    }

    static CacheCtx getCacheCtx(String string) {
        CacheCtx cacheCtx = ctxTable.getCtx(string);
        if (cacheCtx == null) {
            return defaultCtx;
        }
        return cacheCtx;
    }

    static void closeNamedCaches() throws CacheException, IOException, InterruptedException {
        if (ctxTable == null) {
            return;
        }
        CacheCtx[] cacheCtxArray = ctxTable.getCtxList();
        for (int i = 0; i < cacheCtxArray.length; ++i) {
            CacheCtx cacheCtx = cacheCtxArray[i];
            if (cacheCtx == null) continue;
            String string = cacheCtx.getName();
            CacheHandle cacheHandle = cacheCtx.getHandle();
            cacheHandle.destroy(string, string, true);
        }
    }

    static void removeCacheCtx(String string, int n) {
        CacheCtx cacheCtx = ctxTable.removeCtx(string);
        if (cacheCtx == null) {
            return;
        }
        Long[] longArray = cacheCtx.getNotDefinedList(string);
        try {
            if (longArray != null && longArray.length > 0) {
                CacheHandle cacheHandle = cacheCtx.getHandle();
                cacheHandle.freeNotDefined(longArray, n);
            }
        }
        catch (CacheException cacheException) {
            logger.log(Level.SEVERE, "close named cache error", cacheException);
        }
        if (!string.equals(cacheCtx.getName())) {
            if (cacheCtx.useDms()) {
                CacheDms.destroyDmsRegion(string, cacheCtx.getName());
            }
            return;
        }
        if (cacheCtx.useDms()) {
            CacheDms.destroyDmsCache(string);
        }
        if (cacheCtx != null && string.equals(cacheCtx.getName())) {
            Net net;
            CacheInternal.ctxCleanup(cacheCtx);
            DiskManager diskManager = cacheCtx.getDiskManager();
            if (diskManager != null && diskManager.isDiskCacheConfigured()) {
                int n2 = cacheCtx.getIndex();
                diskManager.freeDisk();
                CacheInternal.setInvalidationList(diskManager, true);
                diskManager.removeLocalCache();
                --haveDiskCache;
                for (int i = 0; i < 523; ++i) {
                    hashtab[i].freeDiskCache(n2);
                }
            }
            if ((net = cacheCtx.getNet()) != null && !net.isDefault) {
                net.close();
            }
        }
    }

    static synchronized void ctxCleanup(CacheCtx cacheCtx) {
        namedCacheList.remove(cacheCtx.getName());
        int n = cacheCtx.getIndex();
        if (n >= 0) {
            namedCacheMap.setBit(n);
        }
    }

    static CacheHostInfo[] getActiveHostInfo(CacheCtx cacheCtx) throws CacheException {
        Vector vector;
        try {
            if (cacheCtx == null) {
                cacheCtx = defaultCtx;
            }
            if (!cacheCtx.isDistributed()) {
                return new CacheHostInfo[0];
            }
            Net net = cacheCtx.getNet();
            vector = net.chan.getView().getMembers();
        }
        catch (GroupException groupException) {
            throw CacheInternal.exceptionHandler(groupException);
        }
        CacheHostInfo[] cacheHostInfoArray = new CacheHostInfo[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            cacheHostInfoArray[i] = new CacheHostInfo((NetworkAddress)vector.get(i));
        }
        return cacheHostInfoArray;
    }

    static NamedCache[] getNamedCaches() {
        Collection collection = namedCacheList.values();
        int n = collection.size();
        NamedCache[] namedCacheArray = new NamedCache[n];
        namedCacheArray = collection.toArray(namedCacheArray);
        return namedCacheArray;
    }

    static NamedCache getNamedCache(String string) {
        NamedCache namedCache = (NamedCache)namedCacheList.get(string);
        return namedCache;
    }

    static boolean createNamedCache(String string, NamedCacheAttributes namedCacheAttributes, Attributes attributes, boolean bl) throws CacheException {
        DiskManager diskManager = null;
        Net net = null;
        int n = -1;
        if (string.indexOf("/") >= 0) {
            throw new NamedCacheException(EXP_BADNAME + "\" " + "/" + " \"");
        }
        byte[] byArray = bootlock;
        synchronized (bootlock) {
            try {
                CacheInternal.init(new CacheAttributes(), true);
            }
            catch (Exception exception) {
                throw CacheInternal.exceptionHandler(exception);
            }
            if (CacheInternal.checkCacheCtx(string)) {
                // ** MonitorExit[var13_7] (shouldn't be in output)
                return false;
            }
            try {
                long l;
                Object object;
                if (namedCacheAttributes.diskPath != null) {
                    CacheInternal.checkDiskPath(namedCacheAttributes.diskPath);
                    n = CacheInternal.getCacheCtxIndex();
                    diskManager = new DiskManager(namedCacheAttributes, n, 1.0f, 0.0f);
                    ++haveDiskCache;
                }
                if (namedCacheAttributes.isLogLevelSet()) {
                    object = Logger.getLogger("oracle.ias.cache.CacheInternal." + string);
                    ((Logger)object).setLevel(namedCacheAttributes.getLogLevel());
                }
                CacheCtx cacheCtx = new CacheCtx(string, attributes.getClassLoader(), n, bl, namedCacheAttributes.distribute, diskManager);
                cacheCtx.setCacheDumpPath(namedCacheAttributes.getCacheDumpFilePath() + "-" + string + ".dump");
                if (namedCacheAttributes.dms) {
                    CacheDms.createDmsCache(string);
                    cacheCtx.setDms(true);
                }
                if (namedCacheAttributes.distribute) {
                    CacheInternal.initNet(namedCacheAttributes, cacheCtx);
                }
                if (namedCacheAttributes.diskPath != null) {
                    diskManager.setCacheCtx(cacheCtx);
                    diskManager.setDiskLocks();
                    if (namedCacheAttributes.distribute && diskManager.setDiskLeader(null, (net = cacheCtx.getNet()).getView())) {
                        diskManager.cleanLock();
                    }
                    CacheInternal.initFromDisk(diskManager.getGlobalPath(), diskManager.getLocalPath(), cacheCtx);
                    diskManager.writeOurTimeStamp(namedCacheAttributes.distribute);
                }
                CacheHandle cacheHandle = cacheCtx.getHandle();
                Attributes attributes2 = (Attributes)attributes.clone();
                if (namedCacheAttributes.maxObjectsSet && namedCacheAttributes.maxObjects > attributes2.maxCount) {
                    attributes2.setMaxCount(namedCacheAttributes.maxObjects);
                }
                if (namedCacheAttributes.maxSizeSet && (l = (long)(namedCacheAttributes.maxSize * 0x100000)) > attributes2.maxSize) {
                    attributes2.setMaxSize(l);
                }
                if (namedCacheAttributes.diskCountSet && namedCacheAttributes.diskCount > attributes2.maxDiskCount) {
                    attributes2.setMaxDiskCount(namedCacheAttributes.diskCount);
                }
                if (namedCacheAttributes.diskSizeSet && (l = (long)(namedCacheAttributes.diskSize * 0x100000)) > attributes2.maxDiskSize) {
                    attributes2.setMaxDiskSize(l);
                }
                cacheHandle.createRegion(string, null, attributes2, cacheCtx);
                cacheHandle.setRegionNumber();
                cacheCtx.releaseHandle(cacheHandle);
                object = new NamedCache(cacheCtx, namedCacheAttributes);
                namedCacheList.put(string, object);
                CacheInternal.saveCacheCtx(string, cacheCtx);
                // ** MonitorExit[var13_7] (shouldn't be in output)
                return true;
            }
            catch (CacheException cacheException) {
                throw cacheException;
            }
            catch (Exception exception) {
                throw CacheInternal.exceptionHandler(exception);
            }
        }
    }

    static void cleanLock() {
        CacheCtx[] cacheCtxArray = ctxTable.getCtxList();
        for (int i = 0; i < cacheCtxArray.length; ++i) {
            DiskManager diskManager;
            CacheCtx cacheCtx = cacheCtxArray[i];
            if (cacheCtx == null || (diskManager = cacheCtx.getDiskManager()) == null) continue;
            diskManager.cleanLock();
        }
    }

    static boolean checkDiskUid(byte[] byArray) {
        CacheCtx[] cacheCtxArray = ctxTable.getCtxList();
        for (int i = 0; i < cacheCtxArray.length; ++i) {
            DiskManager diskManager;
            CacheCtx cacheCtx = cacheCtxArray[i];
            if (cacheCtx == null || (diskManager = cacheCtx.getDiskManager()) == null || !diskManager.checkUid(byArray)) continue;
            return true;
        }
        return false;
    }

    static boolean checkDiskCapacity() {
        CacheCtx[] cacheCtxArray = ctxTable.getCtxList();
        for (int i = 0; i < cacheCtxArray.length; ++i) {
            DiskManager diskManager;
            CacheCtx cacheCtx = cacheCtxArray[i];
            if (cacheCtx == null || (diskManager = cacheCtx.getDiskManager()) == null || !diskManager.checkCapacity()) continue;
            return true;
        }
        return false;
    }

    private static boolean checkDiskPath(String string) {
        return true;
    }

    static void initRegionFromDisk(String string, String string2, String string3, CacheCtx cacheCtx) throws DiskCacheException, NullObjectNameException, CacheException {
        DiskManager diskManager = cacheCtx.getDiskManager();
        if (diskManager.shouldMigrate()) {
            CacheInternal.migrateDiskCache(string, diskManager.getMigrationPath(), string2, cacheCtx, diskManager.getMigrationVersion());
        }
        for (int i = 0; i < 523; ++i) {
            hashtab[i].initRegionFromDisk(string, string2, string3, cacheCtx);
        }
    }

    static void initFromDisk(String string, String string2, CacheCtx cacheCtx) throws CacheException, NullObjectNameException {
        DiskManager diskManager = cacheCtx.getDiskManager();
        if (diskManager.shouldMigrate()) {
            CacheInternal.migrateDiskCache(null, diskManager.getMigrationPath(), string, cacheCtx, diskManager.getMigrationVersion());
        }
        for (int i = 0; i < 523; ++i) {
            hashtab[i].initFromDisk(null, string, string2, cacheCtx);
        }
    }

    static void migrateDiskCache(String string, String string2, String string3, CacheCtx cacheCtx, int n) throws CacheException {
        for (int i = 0; i < 523; ++i) {
            Bucket bucket = new Bucket(i, distributed);
            bucket.migrateDiskCache(string, string2, string3, cacheCtx, n);
        }
    }

    private static void initNet(NamedCacheAttributes namedCacheAttributes, CacheCtx cacheCtx) throws NetworkException {
        String string;
        Net net = new Net();
        if (namedCacheAttributes instanceof CacheAttributes) {
            cacheHostName = ((CacheAttributes)namedCacheAttributes).cacheName;
        }
        GroupConfig groupConfig = namedCacheAttributes.getGroupConfig();
        DiskManager diskManager = cacheCtx.getDiskManager();
        if (diskManager != null) {
            groupConfig.setTag((Serializable)diskManager.getDiskUid());
            groupConfig.setWorkingDir(diskManager.getWorkingDir());
        } else {
            groupConfig.setTag(null);
        }
        if (namedCacheAttributes instanceof CacheAttributes) {
            string = ((CacheAttributes)namedCacheAttributes).cacheName;
            if (string == null) {
                string = cacheHostName;
            }
        } else {
            string = cacheHostName;
        }
        groupConfig.setCacheName(string);
        int n = net.init(groupConfig, cacheCtx);
        flags |= 2;
        cacheCtx.setNet(net, n);
    }

    public static void log(String string) {
        logger.log(Level.SEVERE, string);
    }

    static int getGroupLeaderID() throws CacheException {
        Net net = defaultCtx.getNet();
        if (net == null) {
            throw new CacheException(EXP_NETOFF);
        }
        return net.getGroupLeaderID();
    }

    static void logLifecycleEvent(boolean bl, GroupView groupView) {
        int n = 0;
        String string = "";
        if (groupView != null) {
            n = groupView.getVid();
            int n2 = groupView.getCoordinatorPosition();
            Vector vector = groupView.getMembers();
            for (int i = 0; i < vector.size(); ++i) {
                NetworkAddress networkAddress = (NetworkAddress)vector.get(i);
                if (networkAddress.getPosition() != n2) continue;
                string = networkAddress.toString();
            }
        }
        try {
            Logger logger = Logger.getLogger(LIFECYCLE_LOGGER_NAME);
            logger.setLevel(Level.INFO);
            if (bl) {
                logger.log(Level.INFO, "JOC is initialized. ver=" + CacheInternal.cAttr.version + ", distribute=" + CacheInternal.cAttr.distribute + ", vid=" + n + ", coordinator=" + string + ", discover list=" + cAttr.getAddrList());
            } else {
                logger.log(Level.INFO, "JOC is shutdown. vid=" + n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        workingDir = null;
        diskManager = null;
        haveInvalidation = false;
        haveDiskCache = 0;
        cacheId = -1;
        flags = 0;
        cacheAddress = null;
        bootlock = new byte[0];
        updatingStats = false;
        cacheHostName = null;
        transport = 0;
        cacheInstance = 0;
        flags = 0;
    }
}

