/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.Random;
import java.util.logging.Level;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;

class CacheHandleQ {
    private static final String LOGGER_NAME = "oracle.ias.cache.CacheHandleQ";
    private static final int ALLOC_SIZE = 2;
    private static final int QCOUNT = 16;
    private CacheHandle[] freelist;
    private CacheCtx cacheCtx;
    private Object[] lock;
    private Random getRand;
    private Random putRand;

    CacheHandleQ(CacheCtx cacheCtx) {
        long l = System.currentTimeMillis();
        this.getRand = new Random(l);
        this.putRand = new Random(l);
        this.freelist = new CacheHandle[16];
        this.lock = new Object[16];
        this.cacheCtx = cacheCtx;
        for (int i = 0; i < 16; ++i) {
            this.freelist[i] = null;
            this.lock[i] = new Object();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheHandle getHandle() {
        CacheHandle cacheHandle;
        int n = this.getQue(this.getRand);
        Object object = this.lock[n];
        synchronized (object) {
            if (this.freelist[n] == null) {
                this.growCacheHandleList(n);
            }
            cacheHandle = this.freelist[n];
            this.freelist[n] = cacheHandle.next;
        }
        cacheHandle.free = false;
        return cacheHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseHandle(CacheHandle cacheHandle) throws CacheException {
        if (cacheHandle.free) {
            return;
        }
        cacheHandle.releaseHandle();
        cacheHandle.free = true;
        int n = this.getQue(this.putRand);
        Object object = this.lock[n];
        synchronized (object) {
            cacheHandle.next = this.freelist[n];
            this.freelist[n] = cacheHandle;
        }
    }

    private void growCacheHandleList(int n) {
        CacheHandle cacheHandle = new CacheHandle(this.cacheCtx);
        cacheHandle.free = true;
        this.freelist[n] = cacheHandle;
        for (int i = 1; i < 2; ++i) {
            CacheHandle cacheHandle2 = new CacheHandle(this.cacheCtx);
            cacheHandle2.free = true;
            cacheHandle.next = cacheHandle2;
            cacheHandle = cacheHandle2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        for (int i = 0; i < 16; ++i) {
            Object object = this.lock[i];
            synchronized (object) {
                CacheHandle cacheHandle = this.freelist[i];
                while (cacheHandle != null) {
                    CacheHandle cacheHandle2 = cacheHandle.next;
                    cacheHandle.next = null;
                    cacheHandle = cacheHandle2;
                }
                this.freelist[i] = null;
                continue;
            }
        }
    }

    private int getQue(Random random) {
        int n = (random.nextInt() & Integer.MAX_VALUE) % 16;
        return n;
    }

    public synchronized void dump() {
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            n = 0;
            CacheHandle cacheHandle = this.freelist[i];
            while (cacheHandle != null) {
                ++n;
                cacheHandle = cacheHandle.next;
            }
            this.cacheCtx.getLogger(LOGGER_NAME).log(Level.INFO, "Queue " + i + " size = " + n);
        }
    }
}

