/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Refresh;
import oracle.dms.instrument.State;
import oracle.ias.cache.CacheDmsRefresh;
import oracle.ias.cache.Mdslot;

class CacheDms {
    private static Noun m_root = null;
    private static HashMap m_regions;
    private static HashMap m_ctx;
    static final String ROOTNAME = "/JOC";
    static final String ROOTTYPE = "joc";
    static final String REGIONTYPE = "java_cache_region";
    static final String ST_SIZE = "memory_size";
    static final String ST_COUNT = "memory_object_count";
    static final String ST_DISKSIZE = "disk_Size";
    static final String ST_DISKCOUNT = "disk_Count";
    static final String ST_ALOADTIME = "memory_average_load_time";
    static final String ST_DLOADTIME = "disk_average_load_time";
    static final String ST_WKTHREADCOUNT = "worker_thread_count";
    static final String ST_TASKCOUNT = "task_count";
    static final String ST_RESPQSIZE = "response_q_size";
    static final String ST_TIMEQSIZE = "time_q_size";
    static final String ST_ACCESSCOUNT = "memory_object_access_count";

    CacheDms() {
    }

    static synchronized void createRoot() {
        m_root = Noun.create((String)ROOTNAME, (String)ROOTTYPE);
        m_regions = new HashMap();
        m_ctx = new HashMap();
        ArrayList arrayList = new ArrayList();
        m_ctx.put("000DEFAULT_CONTEXT$$", arrayList);
        CacheDmsRefresh cacheDmsRefresh = new CacheDmsRefresh(m_root);
        State state = State.create((Noun)m_root, (String)ST_SIZE, (byte)2, (String)"bytes", (String)"total number of bytes of memory consumed by objects in the cache");
        State state2 = State.create((Noun)m_root, (String)ST_COUNT, (byte)2, (String)"bytes", (String)"total number of objects in the cache");
        State state3 = State.create((Noun)m_root, (String)ST_DISKSIZE, (byte)2, (String)"bytes", (String)"total number of bytes of disk consumed by objects in the cache");
        State state4 = State.create((Noun)m_root, (String)ST_WKTHREADCOUNT, (byte)2, (String)"threads", (String)"total number of worker threads");
        State state5 = State.create((Noun)m_root, (String)ST_TASKCOUNT, (byte)2, (String)"", (String)"total number of async tasks");
        State state6 = State.create((Noun)m_root, (String)ST_RESPQSIZE, (byte)2, (String)"", (String)"Response Queue size");
        State state7 = State.create((Noun)m_root, (String)ST_TIMEQSIZE, (byte)2, (String)"", (String)"Time Queue size");
        state.update(0);
        state2.update(0);
        state3.update(0);
        state4.update(0);
        state5.update(0);
        state6.update(0);
        state7.update(0);
        state.setRefresh((Refresh)cacheDmsRefresh);
        state2.setRefresh((Refresh)cacheDmsRefresh);
        state3.setRefresh((Refresh)cacheDmsRefresh);
        state4.setRefresh((Refresh)cacheDmsRefresh);
        state5.setRefresh((Refresh)cacheDmsRefresh);
        state6.setRefresh((Refresh)cacheDmsRefresh);
        state7.setRefresh((Refresh)cacheDmsRefresh);
    }

    static synchronized void createDmsCache(String string) {
        if (m_root == null) {
            CacheDms.createRoot();
        }
        ArrayList arrayList = new ArrayList();
        m_ctx.put(string, arrayList);
    }

    static synchronized void createDmsRegion(String string, Mdslot mdslot, boolean bl) {
        if (m_root == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)m_ctx.get(mdslot.cacheCtx.getName());
        arrayList.add(string);
        Noun noun = mdslot.groupInfo.parent == null ? m_root : (Noun)m_regions.get(mdslot.groupInfo.parent);
        String string2 = CacheDms.removeWhiteSpace(string);
        Noun noun2 = Noun.create((Noun)noun, (String)string2, (String)REGIONTYPE);
        m_regions.put(string, noun2);
        CacheDmsRefresh cacheDmsRefresh = new CacheDmsRefresh(noun2, mdslot, bl);
        State state = State.create((Noun)noun2, (String)ST_SIZE, (byte)2, (String)"bytes", (String)"total number of bytes of memory consumed by objects in the region");
        State state2 = State.create((Noun)noun2, (String)ST_COUNT, (byte)2, (String)"bytes", (String)"total number of objects in the region");
        State state3 = State.create((Noun)noun2, (String)ST_ALOADTIME, (byte)2, (String)"milliseconds", (String)"the average load time for objects in the region");
        State state4 = State.create((Noun)noun2, (String)ST_ACCESSCOUNT, (byte)2, (String)"", (String)"total number of access of objects in the region");
        if (bl) {
            State state5 = State.create((Noun)noun2, (String)ST_DISKSIZE, (byte)2, (String)"bytes", (String)"total number of bytes of disk consumed by objects in the region");
            State state6 = State.create((Noun)noun2, (String)ST_DISKCOUNT, (byte)2, (String)"bytes", (String)"total number of objects in the region on disk");
            State state7 = State.create((Noun)noun2, (String)ST_DLOADTIME, (byte)2, (String)"milliseconds", (String)"the average load time for objects in the region");
            state5.update(0);
            state6.update(0);
            state7.update(0);
            state5.setRefresh((Refresh)cacheDmsRefresh);
            state6.setRefresh((Refresh)cacheDmsRefresh);
            state7.setRefresh((Refresh)cacheDmsRefresh);
        }
        state.update(0);
        state2.update(0);
        state3.update(0);
        state4.update(0);
        state.setRefresh((Refresh)cacheDmsRefresh);
        state2.setRefresh((Refresh)cacheDmsRefresh);
        state3.setRefresh((Refresh)cacheDmsRefresh);
        state4.setRefresh((Refresh)cacheDmsRefresh);
    }

    static synchronized void destroy() {
        if (m_root == null) {
            return;
        }
        m_root.destroy();
        m_root = null;
        m_regions = null;
        m_ctx = null;
    }

    static synchronized void destroyDmsRegion(String string, String string2) {
        ArrayList arrayList;
        if (m_root == null || m_ctx == null) {
            return;
        }
        Noun noun = (Noun)m_regions.remove(string);
        if (noun != null) {
            noun.destroy();
        }
        if ((arrayList = (ArrayList)m_ctx.get(string2)) == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!string.equals(arrayList.get(i))) continue;
            arrayList.remove(i);
        }
    }

    static synchronized void destroyDmsCache(String string) {
        if (m_root == null || m_ctx == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)m_ctx.remove(string);
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Noun noun = (Noun)m_regions.remove(arrayList.get(i));
            if (noun == null) continue;
            noun.destroy();
        }
    }

    private static String removeWhiteSpace(String string) {
        String string2 = string.replace(' ', '_');
        string2 = string2.replaceAll("/t", "_");
        string2 = string2.replaceAll("/n", "_");
        return string2;
    }
}

