/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.DiskManager;
import oracle.ias.cache.Task;
import oracle.ias.cache.TimeElement;

class CacheCleaner
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.CacheCleaner";
    static final int MAXWAIT = 5000;

    public CacheCleaner() {
        this.setName("CacheCleaner");
        this.setDaemon(true);
    }

    public void run() {
        int n;
        long l = 0L;
        long l2 = 0L;
        int n2 = n = CacheInternal.intvllen < 5000 ? CacheInternal.intvllen : 5000;
        while (CacheInternal.ttlQ.isWorking()) {
            CacheCtx cacheCtx;
            long l3;
            int n3;
            boolean bl = CacheInternal.newInterval();
            if (bl || CacheInternal.curObjCnt > (int)((float)CacheInternal.objectMax * CacheInternal.highWater) || CacheInternal.curCacheSize > (long)((int)((float)CacheInternal.cacheMaxSize * CacheInternal.highWater)) || CacheInternal.checkDiskCapacity()) {
                CacheInternal.cleanCache(bl);
            }
            CacheInternal.cleanIdle();
            CacheCtx[] cacheCtxArray = CacheInternal.ctxTable != null ? CacheInternal.ctxTable.getCtxList() : new CacheCtx[]{};
            long l4 = CacheInternal.ttlQ.getNextTime();
            if (l4 == 0L) {
                n3 = n;
            } else {
                l3 = System.currentTimeMillis();
                n3 = (int)(l4 - l3);
                if (n3 <= 0) {
                    n3 = 1;
                }
                if (n3 > n) {
                    n3 = n;
                }
            }
            CacheInternal.ttlQ.waitForWork(n3);
            l3 = System.currentTimeMillis();
            if (CacheInternal.haveDiskCache > 0) {
                boolean bl2 = false;
                if (l3 - l2 > (long)CacheInternal.pingInterval) {
                    bl2 = true;
                    l2 = l3;
                }
                for (int i = 0; i < cacheCtxArray.length; ++i) {
                    DiskManager diskManager;
                    cacheCtx = cacheCtxArray[i];
                    if (cacheCtx == null || (diskManager = cacheCtx.getDiskManager()) == null) continue;
                    if (!cacheCtx.isDistributed() && bl2) {
                        diskManager.writeOurTimeStamp(false);
                    }
                    if (l3 - l > (long)CacheInternal.detectInterval) {
                        CacheInternal.asyncTaskQ.putTask(new Task(51, null, cacheCtx));
                        if (diskManager.haveInvalidation()) {
                            CacheInternal.asyncTaskQ.putTask(new Task(52, null, cacheCtx));
                        }
                        l = l3;
                    }
                    l3 = System.currentTimeMillis();
                }
            }
            l4 = CacheInternal.ttlQ.getNextTime();
            while (l4 > 0L && l3 >= l4) {
                TimeElement timeElement = CacheInternal.ttlQ.getNext();
                try {
                    if (timeElement.slot.timeToLive == timeElement.expireTime) {
                        cacheCtx = timeElement.slot.cacheCtx;
                        CacheHandle cacheHandle = cacheCtx.getHandle();
                        cacheHandle.invalidate(timeElement.objid, false, timeElement.destroy, false, 4);
                        cacheCtx.releaseHandle(cacheHandle);
                    }
                }
                catch (Exception exception) {
                    CacheInternal.exceptionLog("[CMg] ", exception);
                }
                l4 = CacheInternal.ttlQ.getNextTime();
                l3 = System.currentTimeMillis();
            }
        }
        CacheInternal.cleanerThr = null;
    }
}

