/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.Serializable;
import java.net.InetAddress;
import oracle.ias.cache.commx.NetworkAddress;
import oracle.ias.cache.group.Address;

public class CacheAddress
implements Serializable {
    static final long serialVersionUID = 6964399405782999165L;
    Address addr;
    Serializable rawMemberId_;

    public CacheAddress(InetAddress inetAddress, int n, int n2) {
        this.addr = new Address(inetAddress, n, n2);
    }

    public CacheAddress(String string, int n, int n2) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addr = new Address(inetAddress, n, n2);
    }

    public CacheAddress(InetAddress inetAddress, int n) {
        this.addr = new Address(inetAddress, n);
    }

    CacheAddress(Address address) {
        this.addr = address;
    }

    CacheAddress(NetworkAddress networkAddress) {
        try {
            Address address;
            this.addr = address = new Address(InetAddress.getByName(networkAddress.getIPString()), networkAddress.getPort(), networkAddress.isOriginal(), networkAddress.getPosition(), networkAddress.getTag());
            this.rawMemberId_ = (Serializable)networkAddress.getMemberID();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Address getAddress() {
        return this.addr;
    }

    public String getString() {
        return this.addr.getString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (!(object instanceof CacheAddress)) {
            return false;
        }
        Address address = ((CacheAddress)object).getAddress();
        bl = this.addr.getMemberID() != null ? this.addr.getMemberID().equals(address.getMemberID()) : this.addr.equals(address);
        return bl;
    }

    public boolean equals(InetAddress inetAddress, int n) {
        return this.addr.equals(inetAddress, n);
    }

    public boolean isOriginal() {
        return this.addr.isOriginal();
    }

    public String toString() {
        return this.addr.toString();
    }

    public String getIPString() {
        return this.addr.getIPString();
    }

    public int getPort() {
        return this.addr.getPort();
    }

    public int getPosition() {
        return this.addr.getPosition();
    }

    public Serializable getMemberID() {
        Serializable serializable = null;
        serializable = this.rawMemberId_ == null ? this.addr.getTag() : this.rawMemberId_;
        return serializable;
    }
}

